% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na.R
\name{replace_na}
\alias{replace_na}
\title{Replace missing values}
\usage{
replace_na(data, replace, ...)
}
\arguments{
\item{data}{A data frame or vector.}

\item{replace}{If \code{data} is a data frame, a named list giving the value to
replace \code{NA} with for each column. If \code{data} is a vector, a single value
used for replacement.}

\item{...}{Additional arguments for methods. Currently unused.}
}
\description{
Replace missing values
}
\examples{
library(dplyr)
df <- tibble(x = c(1, 2, NA), y = c("a", NA, "b"), z = list(1:5, NULL, 10:20))
df \%>\% replace_na(list(x = 0, y = "unknown"))
df \%>\% mutate(x = replace_na(x, 0))

# NULL are the list-col equivalent of NAs
df \%>\% replace_na(list(z = list(5)))

df$x \%>\% replace_na(0)
df$y \%>\% replace_na("unknown")
}
\seealso{
\code{\link[dplyr]{na_if}} to replace specified values with a \code{NA}.
\code{\link[dplyr]{coalesce}} to replace missing values with a specified
value.
\code{\link[dplyr]{recode}} to more generally replace values.
}
