% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationProfiling.R
\name{slideWindowSeq}
\alias{slideWindowSeq}
\title{Sliding window approach towards filtering a single sequence}
\usage{
slideWindowSeq(inputSeq, germlineSeq, mutThresh, windowSize)
}
\arguments{
\item{inputSeq}{input sequence.}

\item{germlineSeq}{germline sequence.}

\item{mutThresh}{threshold on the number of mutations in \code{windowSize} 
consecutive nucleotides. Must be between 1 and \code{windowSize} 
inclusive.}

\item{windowSize}{length of consecutive nucleotides. Must be at least 2.}
}
\value{
\code{TRUE} if there are equal to or more than \code{mutThresh} number of mutations
         in any window of \code{windowSize} consecutive nucleotides (i.e. the sequence should
         be filtered); \code{FALSE} if otherwise.
}
\description{
\code{slideWindowSeq} determines whether an input sequence contains equal to or more than 
a given number of mutations in a given length of consecutive nucleotides (a "window") 
when compared to a germline sequence.
}
\examples{
# Use an entry in the example data for input and germline sequence
data(ExampleDb, package="alakazam")
in_seq <- ExampleDb[100, "SEQUENCE_IMGT"]
germ_seq <-  ExampleDb[100, "GERMLINE_IMGT_D_MASK"]

# Determine if in_seq has 6 or more mutations in 10 consecutive nucleotides
slideWindowSeq(inputSeq=in_seq, germlineSeq=germ_seq, mutThresh=6, windowSize=10)
                                
}
\seealso{
\link{calcObservedMutations} is called by \code{slideWindowSeq} to identify observed 
          mutations. See \link{slideWindowDb} for applying the sliding window approach on a 
          \code{data.frame}. See \link{slideWindowTune} for parameter tuning for \code{mutThresh}
          and \code{windowSize}.
}
