% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatter.r
\name{date_format}
\alias{date_format}
\alias{time_format}
\title{Formatted dates and times.}
\usage{
date_format(format = "\%Y-\%m-\%d", tz = "UTC")

time_format(format = "\%H:\%M:\%S", tz = "UTC")
}
\arguments{
\item{format}{Date/time format using standard POSIX specification.  See
\code{\link[=strptime]{strptime()}} for possible formats.}

\item{tz}{a time zone name, see \code{\link[=timezones]{timezones()}}. Defaults
to UTC}
}
\description{
Formatted dates and times.
}
\examples{
a_time <- ISOdatetime(2012, 1, 1, 11, 30, 0, tz = "UTC")
a_date <- as.Date(a_time)

date_format()(a_date)
date_format(format = "\%A")(a_date)

time_format()(a_time)
time_format(tz = "Europe/Berlin")(a_time)

a_hms <- hms::as.hms(a_time, tz = "UTC")
time_format(format = "\%H:\%M")(a_hms)
}
