% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{getDateOrigin}
\alias{getDateOrigin}
\title{Get the date origin an xlsx file is using}
\usage{
getDateOrigin(xlsxFile)
}
\arguments{
\item{xlsxFile}{An xlsx or xlsm file.}
}
\value{
One of "1900-01-01" or "1904-01-01".
}
\description{
Return the date origin used internally by an xlsx or xlsm file
}
\details{
Excel stores dates as the number of days from either 1904-01-01 or 1900-01-01. This function
checks the date origin being used in an Excel file and returns is so it can be used in \code{\link{convertToDate}}
}
\examples{

## create a file with some dates
write.xlsx(as.Date("2015-01-10") - (0:4), file = "getDateOriginExample.xlsx")
m <- read.xlsx("getDateOriginExample.xlsx")

## convert to dates
do <- getDateOrigin(system.file("readTest.xlsx", package = "openxlsx"))
convertToDate(m[[1]], do)

}
\seealso{
\code{\link{convertToDate}}
}
\author{
Alexander Walker
}
