% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aggregation.R
\name{makeAggregation}
\alias{makeAggregation}
\title{Specify your own aggregation of measures.}
\usage{
makeAggregation(id, name = id, properties, fun)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Name of the aggregation method (preferably the same name as the generated function).}

\item{name}{(\code{character(1)})\cr
Long name of the aggregation method. Default is \code{id}.}

\item{properties}{(\link{character})\cr
Set of aggregation properties.
\describe{
\item{req.train}{Are prediction or train sets required to calculate the aggregation?}
\item{req.test}{Are prediction or test sets required to calculate the aggregation?}
}}

\item{fun}{(\code{function(task, perf.test, perf.train, measure, group, pred)})\cr
Calculates the aggregated performance. In most cases you will only need the performances
\code{perf.test} and optionally \code{perf.train} on the test and training data sets.
\describe{
\item{\code{task} (\link{Task})}{The task.}
\item{\code{perf.test} (\link{numeric})}{
\link{performance} results on the test data sets.}
\item{\code{perf.train} (\link{numeric})}{
\link{performance} results on the training data sets.}
\item{\code{measure} (\link{Measure})}{
Performance measure.}
\item{\code{group} (\link{factor})}{
Grouping of resampling iterations. This encodes whether specific iterations
'belong together' (e.g. repeated CV).}
\item{\code{pred} (\link{Prediction})}{
Prediction object.}
}}
}
\value{
(\link{Aggregation}).
}
\description{
This is an advanced feature of mlr. It gives access to some
inner workings so the result might not be compatible with everything!
}
\examples{
# computes the interquartile range on all performance values
test.iqr = makeAggregation(id = "test.iqr", name = "Test set interquartile range",
  properties = "req.test",
  fun = function (task, perf.test, perf.train, measure, group, pred) IQR(perf.test))
}
\seealso{
\link{aggregations}, \link{setAggregation}
}
