% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{eafs}
\alias{eafs}
\title{Exact computation of the EAF}
\usage{
eafs(points, sets, groups = NULL, percentiles = NULL)
}
\arguments{
\item{points}{Either a matrix or a data frame of numerical values, where
each row gives the coordinates of a point.}

\item{sets}{A vector indicating which set each point belongs to.}

\item{groups}{Indicates that the EAF must be computed separately for data
belonging to different groups.}

\item{percentiles}{The percentiles of the EAF of each side that will be
plotted as attainment surfaces. \code{NA} does not plot any. See
\code{\link{eafplot.default}}.}
}
\value{
A data frame (\code{data.frame}) containing the exact representation
 of EAF. The last column gives the percentile that corresponds to each
 point. If groups is not \code{NULL}, then an additional column
 indicates to which group the point belongs.
}
\description{
This function computes the EAF given a set of points and a vector \code{set}
that indicates to which set each point belongs.
}
\note{
There are several examples of data sets in \code{file.path(system.file(package="eaf"),"extdata")}.
}
\examples{

eaf.path <- system.file(package="eaf")

x <- read.data.sets(file.path(eaf.path, "extdata","example1_dat"))
# Compute full EAF
eafs(x[,1:2], x[,3])

# Compute only best, median and worst
eafs(x[,1:2], x[,3], percentiles = c(0, 50, 100))

x <- read.data.sets(file.path(eaf.path,"extdata","spherical-250-10-3d.txt"))
y <- read.data.sets(file.path(eaf.path,"extdata","uniform-250-10-3d.txt"))
x <- data.frame(x, group = "spherical")
x <- rbind(x, data.frame(y, group = "uniform"))

# Compute only median separately for each group
eafs(x[,1:3], sets = x[,4], groups = x[,5], percentiles = 50)

}
\seealso{
\code{\link{read.data.sets}}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
