% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBit.R
\name{checkBit}
\alias{checkBit}
\alias{check_bit}
\alias{assertBit}
\alias{assert_bit}
\alias{testBit}
\alias{test_bit}
\alias{expect_bit}
\title{Check if an argument is a bit vector}
\usage{
checkBit(x, len = NULL, min.len = NULL, max.len = NULL,
  min.0 = NULL, min.1 = NULL, null.ok = FALSE)

check_bit(x, len = NULL, min.len = NULL, max.len = NULL,
  min.0 = NULL, min.1 = NULL, null.ok = FALSE)

assertBit(x, len = NULL, min.len = NULL, max.len = NULL,
  min.0 = NULL, min.1 = NULL, null.ok = FALSE,
  .var.name = vname(x), add = NULL)

assert_bit(x, len = NULL, min.len = NULL, max.len = NULL,
  min.0 = NULL, min.1 = NULL, null.ok = FALSE,
  .var.name = vname(x), add = NULL)

testBit(x, len = NULL, min.len = NULL, max.len = NULL,
  min.0 = NULL, min.1 = NULL, null.ok = FALSE)

test_bit(x, len = NULL, min.len = NULL, max.len = NULL,
  min.0 = NULL, min.1 = NULL, null.ok = FALSE)

expect_bit(x, len = NULL, min.len = NULL, max.len = NULL,
  min.0 = NULL, min.1 = NULL, null.ok = FALSE, info = NULL,
  label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{min.0}{[\code{integer(1)}]\cr
Minimum number of elements being \dQuote{0}/\code{FALSE}/off.}

\item{min.1}{[\code{integer(1)}]\cr
Minimum number of elements being \dQuote{1}/\code{TRUE}/on.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertBit}/\code{assert_bit} return 
 \code{x} invisibly, whereas
 \code{checkBit}/\code{check_bit} and 
 \code{testBit}/\code{test_bit} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertBit}/\code{assert_bit}
 throws an error message, 
 \code{testBit}/\code{test_bit}
 returns \code{FALSE},
 and \code{checkBit} returns a string with the error message.
 The function \code{expect_bit} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a bit vector
}
\examples{
library(bit)
x = as.bit(replace(logical(10), sample(10, 5), TRUE))
testBit(x, len = 10, min.0 = 1)
}
