% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-addr.R
\name{cell_addr}
\alias{cell_addr}
\title{cell_addr class}
\usage{
cell_addr(row, col)
}
\arguments{
\item{row}{integer. Must be the same length as \code{col} or of length one,
which will be recycled to the length of \code{col}.}

\item{col}{integer. Same deal as for \code{row}.}
}
\value{
a \code{cell_addr} object
}
\description{
The \code{cell_addr} class is used to hold the absolute row and column
location for one or more cells. An object of class \code{cell_addr} is a list
with two components of equal length, named \code{row} and \code{col},
consisting of integers greater than or equal to one or \code{NA}. This is in
contrast to the \code{\link{ra_ref}} class, which holds a representation of a
single absolute, relative, or mixed cell reference from, e.g., a formula.
}
\section{Reference}{


Spreadsheet Implementation Technology: Basics and Extensions
Peter Sestoft
MIT Press 2014
}
\examples{
cell_addr(4, 3)
(ca <- cell_addr(1:4, 3))
ca[2:3]
ca[[4]]
length(ca)
}

