% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R, R/functions-utils.R
\docType{methods}
\name{proteins,EnsDb-method}
\alias{proteins,EnsDb-method}
\alias{proteins}
\alias{listUniprotDbs,EnsDb-method}
\alias{listUniprotDbs}
\alias{listUniprotMappingTypes,EnsDb-method}
\alias{listUniprotMappingTypes}
\alias{listProteinColumns}
\title{Protein related functionality}
\usage{
\S4method{proteins}{EnsDb}(object, columns = listColumns(object,
  "protein"), filter = AnnotationFilterList(), order.by = "",
  order.type = "asc", return.type = "DataFrame")

\S4method{listUniprotDbs}{EnsDb}(object)

\S4method{listUniprotMappingTypes}{EnsDb}(object)

listProteinColumns(object)
}
\arguments{
\item{object}{The \code{\linkS4class{EnsDb}} object.}

\item{columns}{For \code{proteins}: character vector defining the columns to
be extracted from the database. Can be any column(s) listed by the
\code{\link{listColumns}} method.}

\item{filter}{For \code{proteins}: A filter object extending
\code{AnnotationFilter} or a list of such objects to select
specific entries from the database. See \code{\link{Filter-classes}} for
a documentation of available filters and use
\code{\link{supportedFilters}} to get the full list of supported filters.}

\item{order.by}{For \code{proteins}: a character vector specifying the
column(s) by which the result should be ordered.}

\item{order.type}{For \code{proteins}: if the results should be ordered
ascending (\code{order.type = "asc"}) or descending
(\code{order.type = "desc"})}

\item{return.type}{For \code{proteins}: character of lenght one specifying
the type of the returned object. Can be either \code{"DataFrame"},
\code{"data.frame"} or \code{"AAStringSet"}.}
}
\value{
The \code{proteins} method returns protein related annotations from
    an \code{\linkS4class{EnsDb}} object with its \code{return.type} argument
    allowing to define the type of the returned object. Note that if
    \code{return.type = "AAStringSet"} additional annotation columns are
    stored in a \code{DataFrame} that can be accessed with the \code{mcols}
    method on the returned object.

The \code{listProteinColumns} function returns a character vector
    with the column names containing protein annotations or throws an error
    if no such annotations are available.
}
\description{
This help page provides information about most of the
    functionality related to protein annotations in \code{ensembldb}.

    The \code{proteins} method retrieves protein related annotations from
    an \code{\linkS4class{EnsDb}} database.

The \code{listUniprotDbs} method lists all Uniprot database
    names in the \code{EnsDb}.

The \code{listUniprotMappingTypes} method lists all methods
    that were used for the mapping of Uniprot IDs to Ensembl protein IDs.

The \code{listProteinColumns} function allows to conveniently
    extract all database columns containing protein annotations from
    an \code{\linkS4class{EnsDb}} database.
}
\details{
The \code{proteins} method performs the query starting from the
    \code{protein} tables and can hence return all annotations from the
    database that are related to proteins and transcripts encoding these
    proteins from the database. Since \code{proteins} does thus only query
    annotations for protein coding transcripts, the \code{\link{genes}} or
    \code{\link{transcripts}} methods have to be used to retrieve annotations
    for non-coding transcripts.
}
\examples{
library(ensembldb)
library(EnsDb.Hsapiens.v86)
edb <- EnsDb.Hsapiens.v86
## Get all proteins from tha database for the gene ZBTB16, if protein
## annotations are available
if (hasProteinData(edb))
    proteins(edb, filter = GeneNameFilter("ZBTB16"))

## List the names of all Uniprot databases from which Uniprot IDs are
## available in the EnsDb
if (hasProteinData(edb))
    listUniprotDbs(edb)


## List the type of all methods that were used to map Uniprot IDs to Ensembl
## protein IDs
if (hasProteinData(edb))
    listUniprotMappingTypes(edb)


## List all columns containing protein annotations
library(EnsDb.Hsapiens.v86)
edb <- EnsDb.Hsapiens.v86
if (hasProteinData(edb))
    listProteinColumns(edb)
}
\author{
Johannes Rainer
}
