/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2018 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "sampledCuttingSurface.H"

// * * * * * * * * * * * * * Private Member Functions  * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::Field<Type>>
Foam::sampledCuttingSurface::sampleOnFaces
(
    const interpolation<Type>& sampler
) const
{
    return sampledSurface::sampleOnFaces
    (
        sampler,
        meshCells(),
        faces(),
        points()
    );
}


template<class Type>
Foam::tmp<Foam::Field<Type>>
Foam::sampledCuttingSurface::sampleOnPoints
(
    const interpolation<Type>& interpolator
) const
{
    // elements to sample
    const labelList& elements = meshCells();

    // One value per point.
    // Initialize with Zero to handle missed/degenerate faces

    auto tvalues = tmp<Field<Type>>::New(points().size(), Zero);
    auto& values = tvalues.ref();

    bitSet pointDone(points().size());

    const faceList& fcs = faces();

    forAll(fcs, facei)
    {
        const face& f = fcs[facei];
        const label celli = elements[facei];

        for (const label pointi : f)
        {
            if (pointDone.set(pointi))
            {
                values[pointi] = interpolator.interpolate
                (
                    points()[pointi],
                    celli
                );
            }
        }
    }

    return tvalues;
}


// ************************************************************************* //
