/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.chefproject.convert.MessageContextConverter;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageChannelEdit;
import org.chefproject.core.MessageEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseDbDoubleStorage;
import org.chefproject.service.component.BaseDiscussionService;
import org.chefproject.service.component.BaseMessageService;

public class DbCachedDiscussionService
extends BaseDiscussionService {
    protected String m_channelTableName = "DISCUSSION_CHANNEL";
    protected String m_messageTableName = "DISCUSSION_MESSAGE";
    protected boolean m_locksInDb = true;
    protected static final String[] FIELDS = new String[]{"MESSAGE_DATE"};

    public void init() throws InitializationException {
        this.m_channelTableName = this.getProperties().getProperty("channelTable", this.m_channelTableName);
        this.m_messageTableName = this.getProperties().getProperty("messageTable", this.m_messageTableName);
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        boolean contextConversion = new Boolean(this.getProperties().getProperty("contextConversion", "false"));
        super.init();
        if (contextConversion) {
            MessageContextConverter.convert(this.m_channelTableName, this.m_messageTableName, this);
        }
        Log.info("chef", this + ".init(): channel table: " + this.m_channelTableName + " message table: " + this.m_messageTableName);
    }

    protected BaseMessageService.Storage newStorage() {
        return new DbStorage(this);
    }

    protected class DbStorage
    extends BaseDbDoubleStorage
    implements BaseMessageService.Storage {
        public DbStorage(StorageUser user) {
            super(DbCachedDiscussionService.this.m_channelTableName, "CHANNEL_ID", DbCachedDiscussionService.this.m_messageTableName, "MESSAGE_ID", "CHANNEL_ID", "MESSAGE_DATE", FIELDS, DbCachedDiscussionService.this.m_locksInDb, "channel", "message", user);
        }

        public boolean checkChannel(String ref) {
            return super.getContainer(ref) != null;
        }

        public MessageChannel getChannel(String ref) {
            return (MessageChannel)super.getContainer(ref);
        }

        public List getChannels() {
            return super.getAllContainers();
        }

        public MessageChannelEdit putChannel(String ref) {
            return (MessageChannelEdit)super.putContainer(ref);
        }

        public MessageChannelEdit editChannel(String ref) {
            return (MessageChannelEdit)super.editContainer(ref);
        }

        public void commitChannel(MessageChannelEdit edit) {
            super.commitContainer(edit);
        }

        public void cancelChannel(MessageChannelEdit edit) {
            super.cancelContainer(edit);
        }

        public void removeChannel(MessageChannelEdit edit) {
            super.removeContainer(edit);
        }

        public boolean checkMessage(MessageChannel channel, String id) {
            return super.checkResource(channel, id);
        }

        public Message getMessage(MessageChannel channel, String id) {
            return (Message)super.getResource(channel, id);
        }

        public List getMessages(MessageChannel channel) {
            return super.getAllResources(channel);
        }

        public MessageEdit putMessage(MessageChannel channel, String id) {
            return (MessageEdit)super.putResource(channel, id, null);
        }

        public MessageEdit editMessage(MessageChannel channel, String id) {
            return (MessageEdit)super.editResource(channel, id);
        }

        public void commitMessage(MessageChannel channel, MessageEdit edit) {
            super.commitResource(channel, edit);
        }

        public void cancelMessage(MessageChannel channel, MessageEdit edit) {
            super.cancelResource(channel, edit);
        }

        public void removeMessage(MessageChannel channel, MessageEdit edit) {
            super.removeResource(channel, edit);
        }
    }
}

