/**************************************************************************
/* This class adds all the GM methods to an Operation.
/*
/* Copyright (c) 2009 by Bernhard Bablok (mail@bablokb.de)
/*
/* This program is free software; you can redistribute it and/or modify
/* it under the terms of the GNU Library General Public License as published
/* by  the Free Software Foundation; either version 2 of the License or
/* (at your option) any later version.
/*
/* This program is distributed in the hope that it will be useful, but
/* WITHOUT ANY WARRANTY; without even the implied warranty of
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/* GNU Library General Public License for more details.
/*
/* You should have received a copy of the GNU Library General Public License
/* along with this program; see the file COPYING.LIB.  If not, write to
/* the Free Software Foundation Inc., 59 Temple Place - Suite 330,
/* Boston, MA  02111-1307 USA
/**************************************************************************/

package org.im4java.core;

/**
   This class subclasses Operation and adds methods for all commandline
   options of GraphicsMagick.

   <p>This class is automatically generated by the source-code generator of
   im4java.</p>

   @version $Revision: 1.14 $
   @author  $Author: bablokb, Bruno Mascret (warnings) $
*/

public class GMOps extends Operation {

  //////////////////////////////////////////////////////////////////////////////

  /**
     The protected Constructor. You should only use subclasses of GMOps.
  */

  protected GMOps() {
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -adjoin to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps adjoin() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-adjoin");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +adjoin to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_adjoin() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+adjoin");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    buf.append(",");
    if (rx != null) {
      buf.append(rx.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    buf.append(",");
    if (rx != null) {
      buf.append(rx.toString());
    }
    buf.append(",");
    if (ry != null) {
      buf.append(ry.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry, Double sy) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    buf.append(",");
    if (rx != null) {
      buf.append(rx.toString());
    }
    buf.append(",");
    if (ry != null) {
      buf.append(ry.toString());
    }
    buf.append(",");
    if (sy != null) {
      buf.append(sy.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry, Double sy, Double tx) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    buf.append(",");
    if (rx != null) {
      buf.append(rx.toString());
    }
    buf.append(",");
    if (ry != null) {
      buf.append(ry.toString());
    }
    buf.append(",");
    if (sy != null) {
      buf.append(sy.toString());
    }
    buf.append(",");
    if (tx != null) {
      buf.append(tx.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -affine to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps affine(Double sx, Double rx, Double ry, Double sy, Double tx, Double ty) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-affine");

    if (sx != null) {
      buf.append(sx.toString());
    }
    buf.append(",");
    if (rx != null) {
      buf.append(rx.toString());
    }
    buf.append(",");
    if (ry != null) {
      buf.append(ry.toString());
    }
    buf.append(",");
    if (sy != null) {
      buf.append(sy.toString());
    }
    buf.append(",");
    if (tx != null) {
      buf.append(tx.toString());
    }
    buf.append(",");
    if (ty != null) {
      buf.append(ty.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -antialias to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps antialias() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-antialias");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +antialias to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_antialias() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+antialias");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -append to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps append() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-append");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +append to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_append() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+append");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -authenticate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps authenticate() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-authenticate");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -authenticate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps authenticate(String password) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-authenticate");

    if (password != null) {
      buf.append(password.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -average to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps average() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-average");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -backdrop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps backdrop() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-backdrop");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -background to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps background() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-background");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -background to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps background(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-background");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -black-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blackThreshold() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-black-threshold");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -black-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blackThreshold(Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-black-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -black-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blackThreshold(Double threshold, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-black-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blue-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bluePrimary() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blue-primary");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blue-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bluePrimary(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blue-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blue-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bluePrimary(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blue-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    buf.append(",");
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blur() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blur");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blur(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps blur(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -bordercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bordercolor() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-bordercolor");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -bordercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps bordercolor(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-bordercolor");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps borderwidth(Integer width, Integer height, Integer x, Integer y, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-borderwidth");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +borderwidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_borderwidth() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+borderwidth");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -border to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps border(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-border");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -border to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps border(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-border");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -box to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps box() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-box");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -box to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps box(String pColor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-box");

    if (pColor != null) {
      buf.append(pColor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -channel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps channel() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-channel");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -channel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps channel(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-channel");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -charcoal to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps charcoal() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-charcoal");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -charcoal to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps charcoal(Integer factor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-charcoal");

    if (factor != null) {
      buf.append(factor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -chop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps chop(Integer width, Integer height, Integer x, Integer y, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-chop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -clip to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps clip() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-clip");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -clippath to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps clippath() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-clippath");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -coalesce to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps coalesce() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-coalesce");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorize");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize(Integer red) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorize");

    if (red != null) {
      buf.append(red.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize(Integer red, Integer blue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorize");

    if (red != null) {
      buf.append(red.toString());
    }
    buf.append("/");
    if (blue != null) {
      buf.append(blue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorize(Integer red, Integer blue, Integer green) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorize");

    if (red != null) {
      buf.append(red.toString());
    }
    buf.append("/");
    if (blue != null) {
      buf.append(blue.toString());
    }
    buf.append("/");
    if (green != null) {
      buf.append(green.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colors to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colors() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colors");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colors to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colors(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colors");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorspace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorspace() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorspace");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -colorspace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps colorspace(String value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-colorspace");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -comment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps comment() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-comment");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -comment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps comment(String text) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-comment");

    if (text != null) {
      buf.append(text.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +compress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_compress() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+compress");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -compress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps compress() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-compress");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -compress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps compress(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-compress");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -contrast to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps contrast() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-contrast");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +contrast to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_contrast() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+contrast");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    buf.append(",");
    if (k10 != null) {
      buf.append(k10.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    buf.append(",");
    if (k10 != null) {
      buf.append(k10.toString());
    }
    buf.append(",");
    if (k11 != null) {
      buf.append(k11.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    buf.append(",");
    if (k10 != null) {
      buf.append(k10.toString());
    }
    buf.append(",");
    if (k11 != null) {
      buf.append(k11.toString());
    }
    buf.append(",");
    if (k12 != null) {
      buf.append(k12.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    buf.append(",");
    if (k10 != null) {
      buf.append(k10.toString());
    }
    buf.append(",");
    if (k11 != null) {
      buf.append(k11.toString());
    }
    buf.append(",");
    if (k12 != null) {
      buf.append(k12.toString());
    }
    buf.append(",");
    if (k13 != null) {
      buf.append(k13.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    buf.append(",");
    if (k10 != null) {
      buf.append(k10.toString());
    }
    buf.append(",");
    if (k11 != null) {
      buf.append(k11.toString());
    }
    buf.append(",");
    if (k12 != null) {
      buf.append(k12.toString());
    }
    buf.append(",");
    if (k13 != null) {
      buf.append(k13.toString());
    }
    buf.append(",");
    if (k14 != null) {
      buf.append(k14.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14, Integer k15) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    buf.append(",");
    if (k10 != null) {
      buf.append(k10.toString());
    }
    buf.append(",");
    if (k11 != null) {
      buf.append(k11.toString());
    }
    buf.append(",");
    if (k12 != null) {
      buf.append(k12.toString());
    }
    buf.append(",");
    if (k13 != null) {
      buf.append(k13.toString());
    }
    buf.append(",");
    if (k14 != null) {
      buf.append(k14.toString());
    }
    buf.append(",");
    if (k15 != null) {
      buf.append(k15.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -convolve to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps convolve(Integer k1, Integer k2, Integer k3, Integer k4, Integer k5, Integer k6, Integer k7, Integer k8, Integer k9, Integer k10, Integer k11, Integer k12, Integer k13, Integer k14, Integer k15, Integer k16) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-convolve");

    if (k1 != null) {
      buf.append(k1.toString());
    }
    buf.append(",");
    if (k2 != null) {
      buf.append(k2.toString());
    }
    buf.append(",");
    if (k3 != null) {
      buf.append(k3.toString());
    }
    buf.append(",");
    if (k4 != null) {
      buf.append(k4.toString());
    }
    buf.append(",");
    if (k5 != null) {
      buf.append(k5.toString());
    }
    buf.append(",");
    if (k6 != null) {
      buf.append(k6.toString());
    }
    buf.append(",");
    if (k7 != null) {
      buf.append(k7.toString());
    }
    buf.append(",");
    if (k8 != null) {
      buf.append(k8.toString());
    }
    buf.append(",");
    if (k9 != null) {
      buf.append(k9.toString());
    }
    buf.append(",");
    if (k10 != null) {
      buf.append(k10.toString());
    }
    buf.append(",");
    if (k11 != null) {
      buf.append(k11.toString());
    }
    buf.append(",");
    if (k12 != null) {
      buf.append(k12.toString());
    }
    buf.append(",");
    if (k13 != null) {
      buf.append(k13.toString());
    }
    buf.append(",");
    if (k14 != null) {
      buf.append(k14.toString());
    }
    buf.append(",");
    if (k15 != null) {
      buf.append(k15.toString());
    }
    buf.append(",");
    if (k16 != null) {
      buf.append(k16.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -crop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps crop(Integer width, Integer height, Integer x, Integer y, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-crop");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -cycle to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps cycle() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-cycle");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -cycle to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps cycle(Integer amount) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-cycle");

    if (amount != null) {
      buf.append(amount.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +debug to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_debug() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+debug");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -debug to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps debug() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-debug");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -debug to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps debug(String events) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-debug");

    if (events != null) {
      buf.append(events.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -deconstruct to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps deconstruct() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-deconstruct");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps define() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-define");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps define(String keyValue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-define");

    if (keyValue != null) {
      buf.append(keyValue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_define() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+define");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +define to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_define(String keyValue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+define");

    if (keyValue != null) {
      buf.append(keyValue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-delay");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay(Integer ticks) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-delay");

    if (ticks != null) {
      buf.append(ticks.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay(Integer ticks, Integer ticksPerSecond) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-delay");

    if (ticks != null) {
      buf.append(ticks.toString());
    }
    buf.append("x");
    if (ticksPerSecond != null) {
      buf.append(ticksPerSecond.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -delay to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps delay(Integer ticks, Integer ticksPerSecond, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-delay");

    if (ticks != null) {
      buf.append(ticks.toString());
    }
    buf.append("x");
    if (ticksPerSecond != null) {
      buf.append(ticksPerSecond.toString());
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -density to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps density() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-density");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -density to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps density(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-density");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -density to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps density(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-density");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -depth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps depth() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-depth");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -depth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps depth(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-depth");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -despeckle to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps despeckle() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-despeckle");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-display");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display(String host) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-display");

    if (host != null) {
      buf.append(host.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display(String host, Integer display) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-display");

    if (host != null) {
      buf.append(host.toString());
    }
    buf.append(":");
    if (display != null) {
      buf.append(display.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -display to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps display(String host, Integer display, Integer screen) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-display");

    if (host != null) {
      buf.append(host.toString());
    }
    buf.append(":");
    if (display != null) {
      buf.append(display.toString());
    }
    buf.append(".");
    if (screen != null) {
      buf.append(screen.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dispose to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dispose() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-dispose");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dispose to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dispose(String method) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-dispose");

    if (method != null) {
      buf.append(method.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_dither() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+dither");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dither() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-dither");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps dither(String method) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-dither");

    if (method != null) {
      buf.append(method.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -draw to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps draw() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-draw");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -draw to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps draw(String string) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-draw");

    if (string != null) {
      buf.append(string.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -edge to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps edge() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-edge");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -edge to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps edge(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-edge");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -emboss to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps emboss() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-emboss");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -emboss to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps emboss(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-emboss");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -encoding to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps encoding() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-encoding");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -encoding to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps encoding(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-encoding");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +endian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_endian() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+endian");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -endian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps endian() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-endian");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -endian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps endian(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-endian");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -enhance to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps enhance() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-enhance");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -equalize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps equalize() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-equalize");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fill to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fill() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fill");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fill to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fill(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fill");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -filter to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps filter() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-filter");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -filter to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps filter(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-filter");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -flatten to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps flatten() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-flatten");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -flip to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps flip() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-flip");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -flop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps flop() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-flop");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -font to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps font() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-font");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -font to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps font(String name) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-font");

    if (name != null) {
      buf.append(name.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width, Integer height, Integer outerBevelWidth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (outerBevelWidth.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (outerBevelWidth != null) {
      buf.append(outerBevelWidth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps frame(Integer width, Integer height, Integer outerBevelWidth, Integer innerBevelWidth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-frame");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (outerBevelWidth.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (outerBevelWidth != null) {
      buf.append(outerBevelWidth.toString());
    }
    oper="+";
    if (innerBevelWidth.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (innerBevelWidth != null) {
      buf.append(innerBevelWidth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +frame to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_frame() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+frame");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fuzz to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fuzz() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fuzz");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fuzz to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fuzz(Double distance) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fuzz");

    if (distance != null) {
      buf.append(distance.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -fuzz to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps fuzz(Double distance, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-fuzz");

    if (distance != null) {
      buf.append(distance.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gamma() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gamma");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gamma(Double value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gamma");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_gamma() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+gamma");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +gamma to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_gamma(Double value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+gamma");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gaussian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gaussian() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gaussian");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gaussian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gaussian(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gaussian");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gaussian to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gaussian(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gaussian");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -geometry to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps geometry(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-geometry");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gravity to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gravity() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gravity");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -gravity to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps gravity(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-gravity");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -green-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps greenPrimary() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-green-primary");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -green-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps greenPrimary(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-green-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -green-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps greenPrimary(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-green-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    buf.append(",");
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -help to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps help() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-help");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -implode to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps implode() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-implode");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -implode to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps implode(Double factor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-implode");

    if (factor != null) {
      buf.append(factor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -intent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps intent() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-intent");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -intent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps intent(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-intent");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -interlace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps interlace() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-interlace");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -interlace to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps interlace(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-interlace");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +label to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_label() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+label");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -label to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps label() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-label");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -label to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps label(String name) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-label");

    if (name != null) {
      buf.append(name.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width, Integer height, Integer offset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (offset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (offset != null) {
      buf.append(offset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -lat to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps lat(Integer width, Integer height, Integer offset, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-lat");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (offset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (offset != null) {
      buf.append(offset.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point, Double white_point) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    buf.append(",");
    if (white_point != null) {
      buf.append(white_point.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point, Double white_point, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    buf.append(",");
    if (white_point != null) {
      buf.append(white_point.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -level to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps level(Double black_point, Double white_point, Boolean percent, Double gamma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-level");

    if (black_point != null) {
      buf.append(black_point.toString());
    }
    buf.append(",");
    if (white_point != null) {
      buf.append(white_point.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    buf.append(",");
    if (gamma != null) {
      buf.append(gamma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -limit to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps limit() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-limit");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -limit to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps limit(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-limit");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -list to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps list() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-list");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -list to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps list(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-list");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -log to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps log() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-log");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -log to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps log(String text) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-log");

    if (text != null) {
      buf.append(text.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -loop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps loop() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-loop");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -loop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps loop(Integer iterations) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-loop");

    if (iterations != null) {
      buf.append(iterations.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +map to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_map() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+map");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -map to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps map() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-map");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -map to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps map(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-map");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +mask to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_mask() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+mask");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -mask to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps mask() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-mask");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -mask to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps mask(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-mask");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -matte to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps matte() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-matte");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +matte to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_matte() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+matte");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -median to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps median() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-median");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -median to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps median(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-median");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-modulate");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate(Double brightness) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-modulate");

    if (brightness != null) {
      buf.append(brightness.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate(Double brightness, Double saturation) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-modulate");

    if (brightness != null) {
      buf.append(brightness.toString());
    }
    buf.append(",");
    if (saturation != null) {
      buf.append(saturation.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -modulate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps modulate(Double brightness, Double saturation, Double hue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-modulate");

    if (brightness != null) {
      buf.append(brightness.toString());
    }
    buf.append(",");
    if (saturation != null) {
      buf.append(saturation.toString());
    }
    buf.append(",");
    if (hue != null) {
      buf.append(hue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -monitor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps monitor() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-monitor");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -monochrome to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps monochrome() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-monochrome");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -morph to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps morph() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-morph");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -morph to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps morph(Integer frames) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-morph");

    if (frames != null) {
      buf.append(frames.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -mosaic to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps mosaic() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-mosaic");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-motion-blur");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-motion-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-motion-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -motion-blur to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps motionBlur(Double radius, Double sigma, Double angle) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-motion-blur");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    oper="+";
    if (angle.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (angle != null) {
      buf.append(angle.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -negate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps negate() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-negate");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +negate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_negate() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+negate");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps noise() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-noise");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps noise(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-noise");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_noise() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+noise");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +noise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_noise(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+noise");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -noop to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps noop() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-noop");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -normalize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps normalize() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-normalize");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -opaque to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps opaque() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-opaque");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -opaque to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps opaque(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-opaque");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel, String operator) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (operator != null) {
      buf.append(operator.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel, String operator, Double rvalue) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (operator != null) {
      buf.append(operator.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (rvalue != null) {
      buf.append(rvalue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -operator to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps operator(String channel, String operator, Double rvalue, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-operator");

    if (channel != null) {
      buf.append(channel.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (operator != null) {
      buf.append(operator.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (rvalue != null) {
      buf.append(rvalue.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ordered-dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps orderedDither() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-ordered-dither");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ordered-dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps orderedDither(String channelType) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-ordered-dither");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ordered-dither to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps orderedDither(String channelType, Integer N) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-ordered-dither");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (N != null) {
      buf.append(N.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -output-directory to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps outputDirectory() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-output-directory");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -output-directory to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps outputDirectory(String pDirectory) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-output-directory");

    if (pDirectory != null) {
      buf.append(pDirectory.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_page() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+page");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -page to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps page(Integer width, Integer height, Integer x, Integer y, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-page");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -paint to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps paint() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-paint");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -paint to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps paint(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-paint");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pause to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pause() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pause");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pause to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pause(Integer pSeconds) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pause");

    if (pSeconds != null) {
      buf.append(pSeconds.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pen() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pen");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pen(String pColor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pen");

    if (pColor != null) {
      buf.append(pColor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -ping to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps ping() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-ping");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +ping to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_ping() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+ping");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pointsize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pointsize() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pointsize");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -pointsize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps pointsize(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-pointsize");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -preview to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps preview() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-preview");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -preview to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps preview(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-preview");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -process to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps process() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-process");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -process to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps process(String pCommand) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-process");

    if (pCommand != null) {
      buf.append(pCommand.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps profile() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-profile");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps profile(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-profile");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_profile() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+profile");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +profile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_profile(String profileName) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+profile");

    if (profileName != null) {
      buf.append(profileName.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +progress to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_progress() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+progress");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -quality to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps quality() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-quality");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -quality to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps quality(Double value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-quality");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps raise() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-raise");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps raise(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-raise");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps raise(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-raise");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_raise() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+raise");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_raise(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+raise");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +raise to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_raise(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+raise");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-random-threshold");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold(String channelType) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-random-threshold");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold(String channelType, Double low) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-random-threshold");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (low != null) {
      buf.append(low.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -random-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps randomThreshold(String channelType, Double low, Double high) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-random-threshold");

    if (channelType != null) {
      buf.append(channelType.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (low != null) {
      buf.append(low.toString());
    }
    buf.append("x");
    if (high != null) {
      buf.append(high.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -red-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps redPrimary() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-red-primary");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -red-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps redPrimary(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-red-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -red-primary to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps redPrimary(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-red-primary");

    if (x != null) {
      buf.append(x.toString());
    }
    buf.append(",");
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width, Integer height, Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -region to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps region(Integer width, Integer height, Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-region");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (x.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +remap to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_remap() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+remap");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -render to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps render() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-render");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +render to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_render() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+render");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resample() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resample");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resample(Integer horizontal) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resample");

    if (horizontal != null) {
      buf.append(horizontal.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resample(Integer horizontal, Integer vertical) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resample");

    if (horizontal != null) {
      buf.append(horizontal.toString());
    }
    buf.append("x");
    if (vertical != null) {
      buf.append(vertical.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resize");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resize");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resize");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -resize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps resize(Integer width, Integer height, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-resize");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -roll to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps roll() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-roll");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -roll to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps roll(Integer x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-roll");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -roll to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps roll(Integer x, Integer y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-roll");

    if (x != null) {
      buf.append(x.toString());
    }
    oper="+";
    if (y.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -rotate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps rotate() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-rotate");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -rotate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps rotate(Double degrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-rotate");

    if (degrees != null) {
      buf.append(degrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -rotate to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps rotate(Double degrees, Character special) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-rotate");

    if (degrees != null) {
      buf.append(degrees.toString());
    }
    if (special != null) {
      buf.append(special.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width, Integer height, Integer xOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (xOffset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sample to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sample(Integer width, Integer height, Integer xOffset, Integer yOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sample");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (xOffset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    oper="+";
    if (yOffset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (yOffset != null) {
      buf.append(yOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sampling-factor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps samplingFactor() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sampling-factor");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sampling-factor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps samplingFactor(Double horizontalFactor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sampling-factor");

    if (horizontalFactor != null) {
      buf.append(horizontalFactor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sampling-factor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps samplingFactor(Double horizontalFactor, Double verticalFactor) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sampling-factor");

    if (horizontalFactor != null) {
      buf.append(horizontalFactor.toString());
    }
    buf.append("x");
    if (verticalFactor != null) {
      buf.append(verticalFactor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width, Integer height, Integer xOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (xOffset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scale to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scale(Integer width, Integer height, Integer xOffset, Integer yOffset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scale");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (xOffset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (xOffset != null) {
      buf.append(xOffset.toString());
    }
    oper="+";
    if (yOffset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (yOffset != null) {
      buf.append(yOffset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scene to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scene() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scene");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -scene to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps scene(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-scene");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -seed to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps seed() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-seed");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -segment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps segment() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-segment");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -segment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps segment(Integer clusterThreshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-segment");

    if (clusterThreshold != null) {
      buf.append(clusterThreshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -segment to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps segment(Integer clusterThreshold, Double smoothingThreshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-segment");

    if (clusterThreshold != null) {
      buf.append(clusterThreshold.toString());
    }
    buf.append("x");
    if (smoothingThreshold != null) {
      buf.append(smoothingThreshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -set to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps set() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-set");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -set to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps set(String attribute) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-set");

    if (attribute != null) {
      buf.append(attribute.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -set to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps set(String attribute, String value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-set");

    if (attribute != null) {
      buf.append(attribute.toString());
    }
    iCmdArgs.add(buf.toString());
    buf.setLength(0);
    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shade() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shade");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shade(Double azimuth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shade(Double azimuth, Double elevation) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    buf.append("x");
    if (elevation != null) {
      buf.append(elevation.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_shade() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+shade");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_shade(Double azimuth) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +shade to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_shade(Double azimuth, Double elevation) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+shade");

    if (azimuth != null) {
      buf.append(azimuth.toString());
    }
    buf.append("x");
    if (elevation != null) {
      buf.append(elevation.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sharpen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sharpen() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sharpen");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sharpen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sharpen(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sharpen");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -sharpen to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps sharpen(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-sharpen");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shave");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shave");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shave");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shave(Integer width, Integer height, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shave");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shear to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shear() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shear");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shear to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shear(Double xDegrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shear");

    if (xDegrees != null) {
      buf.append(xDegrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -shear to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps shear(Double xDegrees, Double yDegrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-shear");

    if (xDegrees != null) {
      buf.append(xDegrees.toString());
    }
    buf.append("x");
    if (yDegrees != null) {
      buf.append(yDegrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-size");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size(Integer width) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-size");

    if (width != null) {
      buf.append(width.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size(Integer width, Integer height) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-size");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -size to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps size(Integer width, Integer height, Integer offset) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-size");

    if (width != null) {
      buf.append(width.toString());
    }
    buf.append("x");
    if (height != null) {
      buf.append(height.toString());
    }
    oper="+";
    if (offset.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (offset != null) {
      buf.append(offset.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -solarize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps solarize() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-solarize");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -solarize to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps solarize(Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-solarize");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -spread to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps spread() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-spread");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -spread to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps spread(Integer amount) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-spread");

    if (amount != null) {
      buf.append(amount.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -stroke to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps stroke() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-stroke");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -stroke to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps stroke(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-stroke");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -strokewidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps strokewidth() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-strokewidth");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -strokewidth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps strokewidth(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-strokewidth");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -swirl to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps swirl() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-swirl");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -swirl to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps swirl(Double degrees) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-swirl");

    if (degrees != null) {
      buf.append(degrees.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -texture to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps texture() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-texture");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -texture to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps texture(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-texture");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps threshold() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-threshold");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps threshold(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-threshold");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps threshold(Integer value, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-threshold");

    if (value != null) {
      buf.append(value.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -tile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps tile() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-tile");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -tile to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps tile(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-tile");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -transform to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps transform() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-transform");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -transparent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps transparent() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-transparent");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -transparent to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps transparent(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-transparent");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -treedepth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps treedepth() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-treedepth");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -treedepth to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps treedepth(Integer value) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-treedepth");

    if (value != null) {
      buf.append(value.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -trim to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps trim() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-trim");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -type to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps type() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-type");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -type to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps type(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-type");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -undercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps undercolor() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-undercolor");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -undercolor to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps undercolor(String color) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-undercolor");

    if (color != null) {
      buf.append(color.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -units to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps units() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-units");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -units to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps units(String type) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-units");

    if (type != null) {
      buf.append(type.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius, Double sigma) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius, Double sigma, Double amount) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    oper="+";
    if (amount.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (amount != null) {
      buf.append(amount.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -unsharp to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps unsharp(Double radius, Double sigma, Double amount, Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-unsharp");

    if (radius != null) {
      buf.append(radius.toString());
    }
    buf.append("x");
    if (sigma != null) {
      buf.append(sigma.toString());
    }
    oper="+";
    if (amount.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (amount != null) {
      buf.append(amount.toString());
    }
    oper="+";
    if (threshold.doubleValue() < 0)
      oper="";
    buf.append(oper);
    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -verbose to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps verbose() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-verbose");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -version to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps version() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-version");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -view to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps view() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-view");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -view to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps view(String text) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-view");

    if (text != null) {
      buf.append(text.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -virtual-pixel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps virtualPixel() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-virtual-pixel");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -virtual-pixel to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps virtualPixel(String method) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-virtual-pixel");

    if (method != null) {
      buf.append(method.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -wave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps wave() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-wave");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -wave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps wave(Double amplitude) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-wave");

    if (amplitude != null) {
      buf.append(amplitude.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -wave to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps wave(Double amplitude, Double wavelength) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-wave");

    if (amplitude != null) {
      buf.append(amplitude.toString());
    }
    buf.append("x");
    if (wavelength != null) {
      buf.append(wavelength.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-point to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whitePoint() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-point");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-point to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whitePoint(Double x) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-point");

    if (x != null) {
      buf.append(x.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-point to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whitePoint(Double x, Double y) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-point");

    if (x != null) {
      buf.append(x.toString());
    }
    buf.append(",");
    if (y != null) {
      buf.append(y.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whiteThreshold() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-threshold");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whiteThreshold(Double threshold) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -white-threshold to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps whiteThreshold(Double threshold, Boolean percent) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-white-threshold");

    if (threshold != null) {
      buf.append(threshold.toString());
    }
    if (percent != null) {
      if (percent.booleanValue())
        buf.append("%");
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps write() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-write");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option -write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps write(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-write");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_write() {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+write");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
     Add option +write to the GraphicsMagick commandline
     (see the documentation of GraphicsMagick for details).
  */

  public GMOps p_write(String filename) {

    String       oper;                      // only used in some methods
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+write");

    if (filename != null) {
      buf.append(filename.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }


}
