//
// lambda_ccsdpr12_t1.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/lambda_ccsdpr12_t1.h>
#include <chemistry/qc/ccr12/tensor.h>
using namespace sc;
  
  
LAMBDA_CCSDPR12_T1::LAMBDA_CCSDPR12_T1(CCR12_Info* info):z(info){};
LAMBDA_CCSDPR12_T1::~LAMBDA_CCSDPR12_T1(){};
  
  
  
void LAMBDA_CCSDPR12_T1::compute_amp(Ref<Tensor>& out){ //k_i0_offset,z->gt2(),z->f1(),z->in.at(0),z->lambda1(),z->lambda2(),z->glambda2(),z->ly(),z->qy(),z->t1(),z->t2(),z->v2(),z->vd2()=>z->vr2()
  
in.resize(8);
  
smith_0_1(out); //z->t1(),z->v2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_0",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->f1()=>in.at(1)
smith_1_5(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_9",z->mem());
offset_smith_1_9();
smith_2_9(); //z->t1(),z->v2()=>in.at(2)
smith_1_9(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_12(); //z->t2(),z->v2()=>in.at(1)
smith_1_15(); //z->gt2(),z->vr2()=>in.at(1)
smith_0_2(out); //z->lambda1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_1",z->mem());
offset_smith_0_3();
smith_0_3_0(); //z->f1()=>in.at(1)
smith_1_6(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_10",z->mem());
offset_smith_1_10();
smith_2_10(); //z->t1(),z->v2()=>in.at(2)
smith_1_10(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_3(out); //z->lambda1(),in.at(1)=>out
delete in.at(1);
smith_0_4(out); //z->lambda1(),z->v2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_2",z->mem());
offset_smith_0_7();
smith_1_7(); //z->t1(),z->lambda1()=>in.at(1)
smith_1_37(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_7(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_3",z->mem());
offset_smith_0_8();
smith_1_8(); //z->t1(),z->lambda1()=>in.at(1)
smith_1_38(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_8(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_4",z->mem());
offset_smith_0_11();
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_0",z->mem());
offset_smith_1_11();
smith_2_11(); //z->t1(),z->lambda1()=>in.at(2)
smith_2_57(); //z->t2(),z->lambda2()=>in.at(2)
smith_1_11(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_14(); //z->t2(),z->lambda1()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_56",z->mem());
offset_smith_1_56();
smith_2_56(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_56(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_11(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_5",z->mem());
offset_smith_0_13();
smith_1_13(); //z->t2(),z->lambda1()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_0",z->mem());
offset_smith_1_49();
in.at(3)=new Tensor("lambda_ccsdpr12_t1_3_49",z->mem());
offset_smith_2_49();
smith_3_49(); //z->t1(),z->lambda2()=>in.at(3)
smith_2_49(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_54(); //z->t2(),z->lambda2()=>in.at(2)
smith_1_49(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_53",z->mem());
offset_smith_1_53();
smith_2_53(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_53(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_55",z->mem());
offset_smith_1_55();
smith_2_55(); //z->t2(),z->lambda2()=>in.at(2)
smith_1_55(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_13(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_6",z->mem());
offset_smith_0_16();
smith_1_16(); //z->lambda1(),z->qy()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_61",z->mem());
offset_smith_1_61();
smith_2_61(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_61(); //z->qy(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_16(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_7",z->mem());
offset_smith_0_17();
smith_1_17(); //z->lambda1(),z->qy()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_62",z->mem());
offset_smith_1_62();
smith_2_62(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_62(); //z->qy(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_17(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_8",z->mem());
offset_smith_0_18();
smith_0_18_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_0",z->mem());
offset_smith_1_23();
smith_1_23_0(); //z->v2()=>in.at(2)
smith_2_30(); //z->t1(),z->v2()=>in.at(2)
smith_1_23(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_1",z->mem());
offset_smith_1_29();
in.at(3)=new Tensor("lambda_ccsdpr12_t1_3_0",z->mem());
offset_smith_2_29();
smith_2_29_0(); //z->v2()=>in.at(3)
smith_3_48(); //z->t1(),z->v2()=>in.at(3)
smith_2_29(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_50(); //z->t2(),z->v2()=>in.at(2)
smith_2_58(); //z->gt2(),z->vr2()=>in.at(2)
smith_1_29(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_2",z->mem());
offset_smith_1_33();
smith_1_33_0(); //z->v2()=>in.at(2)
smith_2_51(); //z->t1(),z->v2()=>in.at(2)
smith_1_33(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_34(); //z->t2(),z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_3",z->mem());
offset_smith_1_39();
smith_1_39_0(); //z->v2()=>in.at(2)
smith_2_59(); //z->t1(),z->v2()=>in.at(2)
smith_1_39(); //z->qy(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_40(); //z->gt2(),z->vr2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_52",z->mem());
offset_smith_1_52();
smith_2_52(); //z->t1(),z->v2()=>in.at(2)
smith_1_52(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_60",z->mem());
offset_smith_1_60();
smith_2_60(); //z->t1(),z->v2()=>in.at(2)
smith_1_60(); //z->qy(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_18(out); //z->lambda2(),in.at(1)=>out
delete in.at(1);
smith_0_19(out); //z->lambda2(),z->v2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_9",z->mem());
offset_smith_0_20();
smith_0_20_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_0",z->mem());
offset_smith_1_26();
smith_1_26_0(); //z->v2()=>in.at(2)
smith_2_43(); //z->t1(),z->v2()=>in.at(2)
smith_1_26(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_45(); //z->t2(),z->v2()=>in.at(1)
smith_0_20(out); //z->ly(),in.at(1)=>out
delete in.at(1);
smith_0_21(out); //z->glambda2(),z->vd2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_22",z->mem());
offset_smith_0_22();
smith_1_22(); //z->t1(),z->lambda2()=>in.at(1)
smith_0_22(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_24",z->mem());
offset_smith_0_24();
smith_1_24(); //z->t1(),z->lambda2()=>in.at(1)
smith_0_24(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_25",z->mem());
offset_smith_0_25();
smith_1_25(); //z->t1(),z->lambda2()=>in.at(1)
smith_0_25(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_27",z->mem());
offset_smith_0_27();
smith_1_27(); //z->t1(),z->ly()=>in.at(1)
smith_0_27(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_28",z->mem());
offset_smith_0_28();
smith_1_28(); //z->t1(),z->glambda2()=>in.at(1)
smith_0_28(out); //z->vd2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_10",z->mem());
offset_smith_0_31();
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_31",z->mem());
offset_smith_1_31();
smith_2_31(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_31(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_35(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_31(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_11",z->mem());
offset_smith_0_32();
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_32",z->mem());
offset_smith_1_32();
smith_2_32(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_32(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_36(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_32(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_41",z->mem());
offset_smith_0_41();
smith_1_41(); //z->lambda2(),z->qy()=>in.at(1)
smith_0_41(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_42",z->mem());
offset_smith_0_42();
smith_1_42(); //z->lambda2(),z->qy()=>in.at(1)
smith_0_42(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_12",z->mem());
offset_smith_0_44();
in.at(2)=new Tensor("lambda_ccsdpr12_t1_2_44",z->mem());
offset_smith_1_44();
smith_2_44(); //z->t1(),z->ly()=>in.at(2)
smith_1_44(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_46(); //z->t2(),z->ly()=>in.at(1)
smith_0_44(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t1_1_47",z->mem());
offset_smith_0_47();
smith_1_47(); //z->t2(),z->ly()=>in.at(1)
smith_0_47(out); //z->v2(),in.at(1)=>out
delete in.at(1);
  
}
  
void LAMBDA_CCSDPR12_T1::smith_0_1(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
        if (z->get_spin(p3b)==z->get_spin(h4b)) { 
         if ((z->get_sym(p3b)^z->get_sym(h4b))==z->irrep_t()) { 
          long p3b_0,h4b_0; 
          z->restricted_2(p3b,h4b,p3b_0,h4b_0); 
          long h2b_1,h4b_1,p1b_1,p3b_1; 
          z->restricted_4(h2b,h4b,p1b,p3b,h2b_1,h4b_1,p1b_1,p3b_1); 
          long dim_common=z->get_range(h4b)*z->get_range(p3b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h4b_0+z->noab()*(p3b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(h4b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h2b<h4b && p1b<p3b) { 
            z->v2()->get_block(p3b_1+(z->nab())*(p1b_1+(z->nab())*(h4b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h4b),z->get_range(p1b),z->get_range(p3b),2,0,3,1,+1.0); 
           } 
           else if (h2b<h4b && p3b<=p1b) { 
            z->v2()->get_block(p1b_1+(z->nab())*(p3b_1+(z->nab())*(h4b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h4b),z->get_range(p3b),z->get_range(p1b),3,0,2,1,-1.0); 
           } 
           else if (h4b<=h2b && p1b<p3b) { 
            z->v2()->get_block(p3b_1+(z->nab())*(p1b_1+(z->nab())*(h2b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h2b),z->get_range(p1b),z->get_range(p3b),2,1,3,0,-1.0); 
           } 
           else if (h4b<=h2b && p3b<=p1b) { 
            z->v2()->get_block(p1b_1+(z->nab())*(p3b_1+(z->nab())*(h2b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h2b),z->get_range(p3b),z->get_range(p1b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_11(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        if (z->get_spin(h2b)+z->get_spin(h3b)==z->get_spin(p1b)+z->get_spin(p4b)) { 
         if ((z->get_sym(h2b)^(z->get_sym(h3b)^(z->get_sym(p1b)^z->get_sym(p4b))))==z->irrep_v()) { 
          long h2b_0,h3b_0,p1b_0,p4b_0; 
          z->restricted_4(h2b,h3b,p1b,p4b,h2b_0,h3b_0,p1b_0,p4b_0); 
          long p4b_1,h3b_1; 
          z->restricted_2(p4b,h3b,p4b_1,h3b_1); 
          long dim_common=z->get_range(h3b)*z->get_range(p4b); 
          long dima0_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           if (h2b<h3b && p1b<p4b) { 
            z->v2()->get_block(p4b_0+(z->nab())*(p1b_0+(z->nab())*(h3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),z->get_range(p1b),z->get_range(p4b),2,0,3,1,+1.0); 
           } 
           else if (h2b<h3b && p4b<=p1b) { 
            z->v2()->get_block(p1b_0+(z->nab())*(p4b_0+(z->nab())*(h3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),z->get_range(p4b),z->get_range(p1b),3,0,2,1,-1.0); 
           } 
           else if (h3b<=h2b && p1b<p4b) { 
            z->v2()->get_block(p4b_0+(z->nab())*(p1b_0+(z->nab())*(h2b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h2b),z->get_range(p1b),z->get_range(p4b),2,1,3,0,-1.0); 
           } 
           else if (h3b<=h2b && p4b<=p1b) { 
            z->v2()->get_block(p1b_0+(z->nab())*(p4b_0+(z->nab())*(h2b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h2b),z->get_range(p4b),z->get_range(p1b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[1]->get_block(h3b_1+z->noab()*(p4b_1-z->noab()),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(p4b),z->get_range(h3b),0,1,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_11(){ 
 
long size=0L; 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  if (z->get_spin(p4b)==z->get_spin(h3b)) { 
   if ((z->get_sym(p4b)^z->get_sym(h3b))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
    if (!z->restricted() || z->get_spin(p4b)+z->get_spin(h3b)!=4L) { 
     in[1]->input_offset(h3b+z->noab()*(p4b-z->noab()),size); 
     size+=z->get_range(p4b)*z->get_range(h3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_13(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_v()) { 
           long h3b_0,h4b_0,p1b_0,p5b_0; 
           z->restricted_4(h3b,h4b,p1b,p5b,h3b_0,h4b_0,p1b_0,p5b_0); 
           long h2b_1,p5b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,p5b,h3b,h4b,h2b_1,p5b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->v2()->get_block(p5b_0+(z->nab())*(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(p5b),2,3,1,0,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->v2()->get_block(p1b_0+(z->nab())*(p5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(p1b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(p5b_1-z->noab()+z->nvab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h3b),z->get_range(h4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h3b==h4b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_13(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_16(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_y()^z->irrep_e()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(q5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(q5b))))==z->irrep_v()) { 
           long h3b_0,h4b_0,p1b_0,q5b_0; 
           z->restricted_4(h3b,h4b,p1b,q5b,h3b_0,h4b_0,p1b_0,q5b_0); 
           long h2b_1,q5b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,q5b,h3b,h4b,h2b_1,q5b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(q5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->v2()->get_block(q5b_0+(z->nab())*(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(q5b),2,3,1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(h3b),z->get_range(h4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h3b==h4b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_16(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_y()^z->irrep_e())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_17(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_y()^z->irrep_e()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
        if (z->get_spin(h2b)+z->get_spin(h3b)==z->get_spin(p1b)+z->get_spin(q4b)) { 
         if ((z->get_sym(h2b)^(z->get_sym(h3b)^(z->get_sym(p1b)^z->get_sym(q4b))))==z->irrep_v()) { 
          long h2b_0,h3b_0,p1b_0,q4b_0; 
          z->restricted_4(h2b,h3b,p1b,q4b,h2b_0,h3b_0,p1b_0,q4b_0); 
          long q4b_1,h3b_1; 
          z->restricted_2(q4b,h3b,q4b_1,h3b_1); 
          long dim_common=z->get_range(h3b)*z->get_range(q4b); 
          long dima0_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           if (h2b<h3b) { 
            z->v2()->get_block(q4b_0+(z->nab())*(p1b_0+(z->nab())*(h3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),z->get_range(p1b),z->get_range(q4b),2,0,3,1,+1.0); 
           } 
           else if (h3b<=h2b) { 
            z->v2()->get_block(q4b_0+(z->nab())*(p1b_0+(z->nab())*(h2b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h2b),z->get_range(p1b),z->get_range(q4b),2,1,3,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[1]->get_block(h3b_1+z->noab()*(q4b_1-z->noab()-z->nvab()),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(q4b),z->get_range(h3b),0,1,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_17(){ 
 
long size=0L; 
for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  if (z->get_spin(q4b)==z->get_spin(h3b)) { 
   if ((z->get_sym(q4b)^z->get_sym(h3b))==(z->irrep_y()^z->irrep_e())) { 
    if (!z->restricted() || z->get_spin(q4b)+z->get_spin(h3b)!=4L) { 
     in[1]->input_offset(h3b+z->noab()*(q4b-z->noab()-z->nvab()),size); 
     size+=z->get_range(q4b)*z->get_range(h3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_18(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_y()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_y()) { 
           long h3b_0,h4b_0,p1b_0,p5b_0; 
           z->restricted_4(h3b,h4b,p1b,p5b,h3b_0,h4b_0,p1b_0,p5b_0); 
           long h2b_1,p5b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,p5b,h3b,h4b,h2b_1,p5b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->lambda2()->get_block(p5b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(p5b),2,3,1,0,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->lambda2()->get_block(p1b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(p1b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(p5b_1-z->noab()+z->nvab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h3b),z->get_range(h4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h3b==h4b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_18_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_v()) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        long h2b_0,p5b_0,h3b_0,h4b_0; 
        z->restricted_4(h2b,p5b,h3b,h4b,h2b_0,p5b_0,h3b_0,h4b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(h4b_0+(z->nab())*(h3b_0+(z->nab())*(p5b_0+(z->nab())*(h2b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h2b),z->get_range(p5b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,-1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_18(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_19(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_y()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h2b)+z->get_spin(h3b)==z->get_spin(p4b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h2b)^(z->get_sym(h3b)^(z->get_sym(p4b)^z->get_sym(p5b))))==z->irrep_y()) { 
           long h2b_0,h3b_0,p4b_0,p5b_0; 
           z->restricted_4(h2b,h3b,p4b,p5b,h2b_0,h3b_0,p4b_0,p5b_0); 
           long p4b_1,p5b_1,h3b_1,p1b_1; 
           z->restricted_4(p4b,p5b,h3b,p1b,p4b_1,p5b_1,h3b_1,p1b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(p4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p1b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h2b<h3b) { 
             z->lambda2()->get_block(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(h3b_0+z->noab()*(h2b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),z->get_range(p4b),z->get_range(p5b),0,3,2,1,+1.0); 
            } 
            else if (h3b<=h2b) { 
             z->lambda2()->get_block(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(h2b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h2b),z->get_range(p4b),z->get_range(p5b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->v2()->get_block(p1b_1+(z->nab())*(h3b_1+(z->nab())*(p5b_1+(z->nab())*(p4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h3b),z->get_range(p1b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p4b==p5b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,-0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_2(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_y()^z->irrep_f())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       if (z->get_spin(h3b)==z->get_spin(p1b)) { 
        if ((z->get_sym(h3b)^z->get_sym(p1b))==z->irrep_y()) { 
         long h3b_0,p1b_0; 
         z->restricted_2(h3b,p1b,h3b_0,p1b_0); 
         long h2b_1,h3b_1; 
         z->restricted_2(h2b,h3b,h2b_1,h3b_1); 
         long dim_common=z->get_range(h3b); 
         long dima0_sort=z->get_range(p1b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h2b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->lambda1()->get_block(p1b_0-z->noab()+z->nvab()*(h3b_0),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p1b),1,0,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          in[1]->get_block(h3b_1+z->noab()*(h2b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h3b),0,1,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_20(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_y()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(q5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(q5b))))==z->irrep_y()) { 
           long h3b_0,h4b_0,p1b_0,q5b_0; 
           z->restricted_4(h3b,h4b,p1b,q5b,h3b_0,h4b_0,p1b_0,q5b_0); 
           long h2b_1,q5b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,q5b,h3b,h4b,h2b_1,q5b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(q5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->ly()->get_block(q5b_0-z->noab()-z->nvab()+z->ncab()*(p1b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(q5b),2,3,1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(h3b),z->get_range(h4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h3b==h4b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_20_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_v()) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
        long h2b_0,q5b_0,h3b_0,h4b_0; 
        z->restricted_4(h2b,q5b,h3b,h4b,h2b_0,q5b_0,h3b_0,h4b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(h4b_0+(z->nab())*(h3b_0+(z->nab())*(q5b_0+(z->nab())*(h2b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h2b),z->get_range(q5b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,-1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_20(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_21(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_y()^z->irrep_e())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        for (long h5b=h4b;h5b<z->noab();++h5b) { 
         if (z->get_spin(h2b)+z->get_spin(h3b)==z->get_spin(h4b)+z->get_spin(h5b)) { 
          if ((z->get_sym(h2b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(h5b))))==z->irrep_y()) { 
           long h2b_0,h3b_0,h4b_0,h5b_0; 
           z->restricted_4(h2b,h3b,h4b,h5b,h2b_0,h3b_0,h4b_0,h5b_0); 
           long h4b_1,h5b_1,h3b_1,p1b_1; 
           z->restricted_4(h4b,h5b,h3b,p1b,h4b_1,h5b_1,h3b_1,p1b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p1b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h2b<h3b) { 
             z->glambda2()->get_block(h5b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),0,3,2,1,+1.0); 
            } 
            else if (h3b<=h2b) { 
             z->glambda2()->get_block(h5b_0+z->noab()*(h4b_0+z->noab()*(h2b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h2b),z->get_range(h4b),z->get_range(h5b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->vd2()->get_block(p1b_1+(z->nab())*(h3b_1+(z->nab())*(h5b_1+z->noab()*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h3b),z->get_range(p1b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h4b==h5b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,-0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_22(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        for (long h5b=h4b;h5b<z->noab();++h5b) { 
         if (z->get_spin(h2b)+z->get_spin(h3b)==z->get_spin(h4b)+z->get_spin(h5b)) { 
          if ((z->get_sym(h2b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(h5b))))==z->irrep_v()) { 
           long h2b_0,h3b_0,h4b_0,h5b_0; 
           z->restricted_4(h2b,h3b,h4b,h5b,h2b_0,h3b_0,h4b_0,h5b_0); 
           long h4b_1,h5b_1,h3b_1,p1b_1; 
           z->restricted_4(h4b,h5b,h3b,p1b,h4b_1,h5b_1,h3b_1,p1b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p1b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h2b<h3b) { 
             z->v2()->get_block(h5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0+(z->nab())*(h2b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),0,3,2,1,+1.0); 
            } 
            else if (h3b<=h2b) { 
             z->v2()->get_block(h5b_0+(z->nab())*(h4b_0+(z->nab())*(h2b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h2b),z->get_range(h4b),z->get_range(h5b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p1b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h5b_1+z->noab()*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h3b),z->get_range(p1b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h4b==h5b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_22(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
    if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(p1b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(p1b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(p1b)!=8L) { 
       in[1]->input_offset(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h5b+z->noab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(p1b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_24(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h5b=0L;h5b<z->noab();++h5b) { 
        for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
         if (z->get_spin(h3b)+z->get_spin(p4b)==z->get_spin(h5b)+z->get_spin(p1b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(p4b)^(z->get_sym(h5b)^z->get_sym(p1b))))==z->irrep_v()) { 
           long h3b_0,p4b_0,h5b_0,p1b_0; 
           z->restricted_4(h3b,p4b,h5b,p1b,h3b_0,p4b_0,h5b_0,p1b_0); 
           long h2b_1,h5b_1,h3b_1,p4b_1; 
           z->restricted_4(h2b,h5b,h3b,p4b,h2b_1,h5b_1,h3b_1,p4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h5b)*z->get_range(p4b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->v2()->get_block(p1b_0+(z->nab())*(h5b_0+(z->nab())*(p4b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p4b),z->get_range(h5b),z->get_range(p1b),3,1,2,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h5b) { 
             in[1]->get_block(p4b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(h3b),z->get_range(p4b),0,3,1,2,+1.0); 
            } 
            else if (h5b<=h2b) { 
             in[1]->get_block(p4b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),z->get_range(p4b),1,3,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_24(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
       in[1]->input_offset(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(h5b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(p4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_25(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
       for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_v()) { 
           long p3b_0,p4b_0,p1b_0,p5b_0; 
           z->restricted_4(p3b,p4b,p1b,p5b,p3b_0,p4b_0,p1b_0,p5b_0); 
           long h2b_1,p5b_1,p3b_1,p4b_1; 
           z->restricted_4(h2b,p5b,p3b,p4b,h2b_1,p5b_1,p3b_1,p4b_1); 
           long dim_common=z->get_range(p3b)*z->get_range(p4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->v2()->get_block(p5b_0+(z->nab())*(p1b_0+(z->nab())*(p4b_0+(z->nab())*(p3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p1b),z->get_range(p5b),2,3,1,0,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->v2()->get_block(p1b_0+(z->nab())*(p5b_0+(z->nab())*(p4b_0+(z->nab())*(p3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(p1b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p4b_1-z->noab()+z->nvab()*(p3b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(p3b),z->get_range(p4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p3b==p4b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_25(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
   for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
    if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(p3b)+z->get_spin(p4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(p3b)^z->get_sym(p4b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(p3b)+z->get_spin(p4b)!=8L) { 
       in[1]->input_offset(p4b-z->noab()+z->nvab()*(p3b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(p5b)*z->get_range(p3b)*z->get_range(p4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_27(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h5b=0L;h5b<z->noab();++h5b) { 
        for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
         if (z->get_spin(h3b)+z->get_spin(q4b)==z->get_spin(h5b)+z->get_spin(p1b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(q4b)^(z->get_sym(h5b)^z->get_sym(p1b))))==z->irrep_v()) { 
           long h3b_0,q4b_0,h5b_0,p1b_0; 
           z->restricted_4(h3b,q4b,h5b,p1b,h3b_0,q4b_0,h5b_0,p1b_0); 
           long h2b_1,h5b_1,h3b_1,q4b_1; 
           z->restricted_4(h2b,h5b,h3b,q4b,h2b_1,h5b_1,h3b_1,q4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h5b)*z->get_range(q4b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->v2()->get_block(p1b_0+(z->nab())*(h5b_0+(z->nab())*(q4b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(q4b),z->get_range(h5b),z->get_range(p1b),3,1,2,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h5b) { 
             in[1]->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(h3b_1+z->noab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(h3b),z->get_range(q4b),0,3,1,2,+1.0); 
            } 
            else if (h5b<=h2b) { 
             in[1]->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),z->get_range(q4b),1,3,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_27(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
    if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(q4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(q4b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(q4b)!=8L) { 
       in[1]->input_offset(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(h5b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(q4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_28(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_e()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_e()) { 
           long h3b_0,h4b_0,p1b_0,p5b_0; 
           z->restricted_4(h3b,h4b,p1b,p5b,h3b_0,h4b_0,p1b_0,p5b_0); 
           long h2b_1,p5b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,p5b,h3b,h4b,h2b_1,p5b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->vd2()->get_block(p5b_0+(z->nab())*(p1b_0+(z->nab())*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(p5b),2,3,1,0,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->vd2()->get_block(p1b_0+(z->nab())*(p5b_0+(z->nab())*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(p1b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(p5b_1-z->noab()+z->nvab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h3b),z->get_range(h4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h3b==h4b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_28(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_2_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h2b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h2b)^z->get_sym(h3b))==z->irrep_f()) { 
      long dimc=z->get_range(h2b)*z->get_range(h3b); 
      long h2b_0,h3b_0; 
      z->restricted_2(h2b,h3b,h2b_0,h3b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h2b)*z->get_range(h3b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(h3b_0+(z->nab())*(h2b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(h2b),z->get_range(h3b),0,1,-1.0); 
       in[1]->add_block(h3b+z->noab()*(h2b),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_2(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  if (z->get_spin(h2b)==z->get_spin(h3b)) { 
   if ((z->get_sym(h2b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h3b)!=4L) { 
     in[1]->input_offset(h3b+z->noab()*(h2b),size); 
     size+=z->get_range(h2b)*z->get_range(h3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_3(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_y()^z->irrep_f())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
       if (z->get_spin(h2b)==z->get_spin(p3b)) { 
        if ((z->get_sym(h2b)^z->get_sym(p3b))==z->irrep_y()) { 
         long h2b_0,p3b_0; 
         z->restricted_2(h2b,p3b,h2b_0,p3b_0); 
         long p3b_1,p1b_1; 
         z->restricted_2(p3b,p1b,p3b_1,p1b_1); 
         long dim_common=z->get_range(p3b); 
         long dima0_sort=z->get_range(h2b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(p1b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->lambda1()->get_block(p3b_0-z->noab()+z->nvab()*(h2b_0),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(p3b),0,1,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          in[1]->get_block(p1b_1-z->noab()+z->nvab()*(p3b_1-z->noab()),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(p3b),z->get_range(p1b),1,0,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_31(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p1b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p1b))))==z->irrep_v()) { 
           long h3b_0,h4b_0,h5b_0,p1b_0; 
           z->restricted_4(h3b,h4b,h5b,p1b,h3b_0,h4b_0,h5b_0,p1b_0); 
           long h2b_1,h5b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,h5b,h3b,h4b,h2b_1,h5b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->v2()->get_block(p1b_0+(z->nab())*(h5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(p1b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h5b) { 
             in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(h3b),z->get_range(h4b),0,1,3,2,+1.0); 
            } 
            else if (h5b<=h2b) { 
             in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h3b==h4b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+0.5/0.5); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_31(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h5b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_32(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)+z->get_spin(p4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(p4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_v()) { 
           long h3b_0,p4b_0,p1b_0,p5b_0; 
           z->restricted_4(h3b,p4b,p1b,p5b,h3b_0,p4b_0,p1b_0,p5b_0); 
           long h2b_1,p5b_1,h3b_1,p4b_1; 
           z->restricted_4(h2b,p5b,h3b,p4b,h2b_1,p5b_1,h3b_1,p4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(p4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->v2()->get_block(p5b_0+(z->nab())*(p1b_0+(z->nab())*(p4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p4b),z->get_range(p1b),z->get_range(p5b),2,3,1,0,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->v2()->get_block(p1b_0+(z->nab())*(p5b_0+(z->nab())*(p4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p4b),z->get_range(p5b),z->get_range(p1b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p4b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p5b_1-z->noab()+z->nvab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h3b),z->get_range(p4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_32(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
       in[1]->input_offset(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(p4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_3_0(){ 
      
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(p3b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(p3b)==z->get_spin(p1b)) { 
     if ((z->get_sym(p3b)^z->get_sym(p1b))==z->irrep_f()) { 
      long dimc=z->get_range(p3b)*z->get_range(p1b); 
      long p3b_0,p1b_0; 
      z->restricted_2(p3b,p1b,p3b_0,p1b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(p3b)*z->get_range(p1b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(p1b_0+(z->nab())*(p3b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p1b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(p3b),z->get_range(p1b),0,1,+1.0); 
       in[1]->add_block(p1b-z->noab()+z->nvab()*(p3b-z->noab()),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_3(){ 
 
long size=0L; 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  if (z->get_spin(p3b)==z->get_spin(p1b)) { 
   if ((z->get_sym(p3b)^z->get_sym(p1b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p1b)!=4L) { 
     in[1]->input_offset(p1b-z->noab()+z->nvab()*(p3b-z->noab()),size); 
     size+=z->get_range(p3b)*z->get_range(p1b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_4(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_y()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        if (z->get_spin(h3b)==z->get_spin(p4b)) { 
         if ((z->get_sym(h3b)^z->get_sym(p4b))==z->irrep_y()) { 
          long h3b_0,p4b_0; 
          z->restricted_2(h3b,p4b,h3b_0,p4b_0); 
          long h2b_1,p4b_1,h3b_1,p1b_1; 
          z->restricted_4(h2b,p4b,h3b,p1b,h2b_1,p4b_1,h3b_1,p1b_1); 
          long dim_common=z->get_range(h3b)*z->get_range(p4b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->lambda1()->get_block(p4b_0-z->noab()+z->nvab()*(h3b_0),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p4b),1,0,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           z->v2()->get_block(p1b_1+(z->nab())*(h3b_1+(z->nab())*(p4b_1+(z->nab())*(h2b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p4b),z->get_range(h3b),z->get_range(p1b),3,0,1,2,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,-1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_41(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_y()^z->irrep_e()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
         if (z->get_spin(h3b)+z->get_spin(p4b)==z->get_spin(p1b)+z->get_spin(q5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(p4b)^(z->get_sym(p1b)^z->get_sym(q5b))))==z->irrep_v()) { 
           long h3b_0,p4b_0,p1b_0,q5b_0; 
           z->restricted_4(h3b,p4b,p1b,q5b,h3b_0,p4b_0,p1b_0,q5b_0); 
           long h2b_1,q5b_1,h3b_1,p4b_1; 
           z->restricted_4(h2b,q5b,h3b,p4b,h2b_1,q5b_1,h3b_1,p4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(p4b)*z->get_range(q5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->v2()->get_block(q5b_0+(z->nab())*(p1b_0+(z->nab())*(p4b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p4b),z->get_range(p1b),z->get_range(q5b),2,3,1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p4b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(h3b),z->get_range(p4b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_41(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_y()^z->irrep_e())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
       in[1]->input_offset(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(p4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_42(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_y()^z->irrep_e()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
       for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
        if (z->get_spin(h2b)+z->get_spin(p3b)==z->get_spin(p1b)+z->get_spin(q4b)) { 
         if ((z->get_sym(h2b)^(z->get_sym(p3b)^(z->get_sym(p1b)^z->get_sym(q4b))))==z->irrep_v()) { 
          long h2b_0,p3b_0,p1b_0,q4b_0; 
          z->restricted_4(h2b,p3b,p1b,q4b,h2b_0,p3b_0,p1b_0,q4b_0); 
          long q4b_1,p3b_1; 
          z->restricted_2(q4b,p3b,q4b_1,p3b_1); 
          long dim_common=z->get_range(p3b)*z->get_range(q4b); 
          long dima0_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->v2()->get_block(q4b_0+(z->nab())*(p1b_0+(z->nab())*(p3b_0+(z->nab())*(h2b_0))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(p3b),z->get_range(p1b),z->get_range(q4b),2,0,3,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[1]->get_block(p3b_1-z->noab()+z->nvab()*(q4b_1-z->noab()-z->nvab()),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(q4b),z->get_range(p3b),0,1,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_42(){ 
 
long size=0L; 
for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  if (z->get_spin(q4b)==z->get_spin(p3b)) { 
   if ((z->get_sym(q4b)^z->get_sym(p3b))==(z->irrep_y()^z->irrep_e())) { 
    if (!z->restricted() || z->get_spin(q4b)+z->get_spin(p3b)!=4L) { 
     in[1]->input_offset(p3b-z->noab()+z->nvab()*(q4b-z->noab()-z->nvab()),size); 
     size+=z->get_range(q4b)*z->get_range(p3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_44(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
         if (z->get_spin(h3b)+z->get_spin(q4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(q4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_v()) { 
           long h3b_0,q4b_0,p1b_0,p5b_0; 
           z->restricted_4(h3b,q4b,p1b,p5b,h3b_0,q4b_0,p1b_0,p5b_0); 
           long h2b_1,p5b_1,h3b_1,q4b_1; 
           z->restricted_4(h2b,p5b,h3b,q4b,h2b_1,p5b_1,h3b_1,q4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(p5b)*z->get_range(q4b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->v2()->get_block(p5b_0+(z->nab())*(p1b_0+(z->nab())*(q4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(q4b),z->get_range(p1b),z->get_range(p5b),2,1,3,0,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->v2()->get_block(p1b_0+(z->nab())*(p5b_0+(z->nab())*(q4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(q4b),z->get_range(p5b),z->get_range(p1b),3,1,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(h3b_1+z->noab()*(p5b_1-z->noab()+z->nvab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h3b),z->get_range(q4b),0,3,1,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(p1b),0,1,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_44(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
    if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(q4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(q4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(q4b)!=8L) { 
       in[1]->input_offset(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(q4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_47(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
       for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
        if (z->get_spin(h2b)+z->get_spin(q3b)==z->get_spin(p1b)+z->get_spin(p4b)) { 
         if ((z->get_sym(h2b)^(z->get_sym(q3b)^(z->get_sym(p1b)^z->get_sym(p4b))))==z->irrep_v()) { 
          long h2b_0,q3b_0,p1b_0,p4b_0; 
          z->restricted_4(h2b,q3b,p1b,p4b,h2b_0,q3b_0,p1b_0,p4b_0); 
          long p4b_1,q3b_1; 
          z->restricted_2(p4b,q3b,p4b_1,q3b_1); 
          long dim_common=z->get_range(p4b)*z->get_range(q3b); 
          long dima0_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           if (p1b<p4b) { 
            z->v2()->get_block(p4b_0+(z->nab())*(p1b_0+(z->nab())*(q3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(q3b),z->get_range(p1b),z->get_range(p4b),2,0,1,3,+1.0); 
           } 
           else if (p4b<=p1b) { 
            z->v2()->get_block(p1b_0+(z->nab())*(p4b_0+(z->nab())*(q3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(q3b),z->get_range(p4b),z->get_range(p1b),3,0,1,2,-1.0); 
           } 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[1]->get_block(q3b_1-z->noab()-z->nvab()+z->ncab()*(p4b_1-z->noab()),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(p4b),z->get_range(q3b),1,0,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_47(){ 
 
long size=0L; 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
  if (z->get_spin(p4b)==z->get_spin(q3b)) { 
   if ((z->get_sym(p4b)^z->get_sym(q3b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(p4b)+z->get_spin(q3b)!=4L) { 
     in[1]->input_offset(q3b-z->noab()-z->nvab()+z->ncab()*(p4b-z->noab()),size); 
     size+=z->get_range(p4b)*z->get_range(q3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_7(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        if (z->get_spin(h2b)+z->get_spin(h3b)==z->get_spin(h4b)+z->get_spin(p1b)) { 
         if ((z->get_sym(h2b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p1b))))==z->irrep_v()) { 
          long h2b_0,h3b_0,h4b_0,p1b_0; 
          z->restricted_4(h2b,h3b,h4b,p1b,h2b_0,h3b_0,h4b_0,p1b_0); 
          long h4b_1,h3b_1; 
          z->restricted_2(h4b,h3b,h4b_1,h3b_1); 
          long dim_common=z->get_range(h3b)*z->get_range(h4b); 
          long dima0_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           if (h2b<h3b) { 
            z->v2()->get_block(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),3,0,2,1,+1.0); 
           } 
           else if (h3b<=h2b) { 
            z->v2()->get_block(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h2b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h2b),z->get_range(h4b),z->get_range(p1b),3,1,2,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[1]->get_block(h3b_1+z->noab()*(h4b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h3b),0,1,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_7(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  if (z->get_spin(h4b)==z->get_spin(h3b)) { 
   if ((z->get_sym(h4b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h3b)!=4L) { 
     in[1]->input_offset(h3b+z->noab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(h3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_0_8(Ref<Tensor>& out){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h2b)); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p1b))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(h2b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        if (z->get_spin(h2b)+z->get_spin(p3b)==z->get_spin(p1b)+z->get_spin(p4b)) { 
         if ((z->get_sym(h2b)^(z->get_sym(p3b)^(z->get_sym(p1b)^z->get_sym(p4b))))==z->irrep_v()) { 
          long h2b_0,p3b_0,p1b_0,p4b_0; 
          z->restricted_4(h2b,p3b,p1b,p4b,h2b_0,p3b_0,p1b_0,p4b_0); 
          long p4b_1,p3b_1; 
          z->restricted_2(p4b,p3b,p4b_1,p3b_1); 
          long dim_common=z->get_range(p3b)*z->get_range(p4b); 
          long dima0_sort=z->get_range(h2b)*z->get_range(p1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           if (p1b<p4b) { 
            z->v2()->get_block(p4b_0+(z->nab())*(p1b_0+(z->nab())*(p3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(p3b),z->get_range(p1b),z->get_range(p4b),2,0,3,1,+1.0); 
           } 
           else if (p4b<=p1b) { 
            z->v2()->get_block(p1b_0+(z->nab())*(p4b_0+(z->nab())*(p3b_0+(z->nab())*(h2b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(p3b),z->get_range(p4b),z->get_range(p1b),3,0,2,1,-1.0); 
           } 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[1]->get_block(p3b_1-z->noab()+z->nvab()*(p4b_1-z->noab()),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(p4b),z->get_range(p3b),0,1,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h2b),1,0,+1.0); 
      out->add_block(p1b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_0_8(){ 
 
long size=0L; 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  if (z->get_spin(p4b)==z->get_spin(p3b)) { 
   if ((z->get_sym(p4b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p3b)!=4L) { 
     in[1]->input_offset(p3b-z->noab()+z->nvab()*(p4b-z->noab()),size); 
     size+=z->get_range(p4b)*z->get_range(p3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_10(){ 
      
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(p3b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(p3b)==z->get_spin(p1b)) { 
     if ((z->get_sym(p3b)^z->get_sym(p1b))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
      long dimc=z->get_range(p3b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       if (z->get_spin(p3b)==z->get_spin(h4b)) { 
        if ((z->get_sym(p3b)^z->get_sym(h4b))==z->irrep_t()) { 
         long p3b_0,h4b_0; 
         z->restricted_2(p3b,h4b,p3b_0,h4b_0); 
         long h4b_1,p1b_1; 
         z->restricted_2(h4b,p1b,h4b_1,p1b_1); 
         long dim_common=z->get_range(h4b); 
         long dima0_sort=z->get_range(p3b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(p1b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h4b_0+z->noab()*(p3b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(h4b),0,1,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          in[2]->get_block(p1b_1-z->noab()+z->nvab()*(h4b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p1b),1,0,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(p3b),1,0,+1.0); 
      in[1]->add_block(p1b-z->noab()+z->nvab()*(p3b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_10(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  if (z->get_spin(h4b)==z->get_spin(p1b)) { 
   if ((z->get_sym(h4b)^z->get_sym(p1b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p1b)!=4L) { 
     in[2]->input_offset(p1b-z->noab()+z->nvab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(p1b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_11(){ 
      
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(h3b)) { 
     if ((z->get_sym(p4b)^z->get_sym(h3b))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(p4b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       if (z->get_spin(p4b)==z->get_spin(h5b)) { 
        if ((z->get_sym(p4b)^z->get_sym(h5b))==z->irrep_t()) { 
         long p4b_0,h5b_0; 
         z->restricted_2(p4b,h5b,p4b_0,h5b_0); 
         long h5b_1,h3b_1; 
         z->restricted_2(h5b,h3b,h5b_1,h3b_1); 
         long dim_common=z->get_range(h5b); 
         long dima0_sort=z->get_range(p4b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h3b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h5b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h5b),0,1,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          in[2]->get_block(h3b_1+z->noab()*(h5b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h3b),1,0,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(p4b),1,0,+1.0); 
      in[1]->add_block(h3b+z->noab()*(p4b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_11(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  if (z->get_spin(h5b)==z->get_spin(h3b)) { 
   if ((z->get_sym(h5b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h3b)!=4L) { 
     in[2]->input_offset(h3b+z->noab()*(h5b),size); 
     size+=z->get_range(h5b)*z->get_range(h3b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_12(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h2b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h2b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h6b)) { 
          if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h6b))))==z->irrep_t()) { 
           long p4b_0,p5b_0,h3b_0,h6b_0; 
           z->restricted_4(p4b,p5b,h3b,h6b,p4b_0,p5b_0,h3b_0,h6b_0); 
           long h2b_1,h6b_1,p4b_1,p5b_1; 
           z->restricted_4(h2b,h6b,p4b,p5b,h2b_1,h6b_1,p4b_1,p5b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(p4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h3b<h6b) { 
             z->t2()->get_block(h6b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h3b),z->get_range(h6b),2,1,0,3,+1.0); 
            } 
            else if (h6b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h3b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p4b),z->get_range(p5b),0,3,2,1,+1.0); 
            } 
            else if (h6b<=h2b) { 
             z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h2b_1+(z->nab())*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(p4b),z->get_range(p5b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p4b==p5b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(h3b),0,1,-0.5/0.5); 
      in[1]->add_block(h3b+z->noab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_13(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
           long p5b_0,p6b_0,h3b_0,h4b_0; 
           z->restricted_4(p5b,p6b,h3b,h4b,p5b_0,p6b_0,h3b_0,h4b_0); 
           long h2b_1,p6b_1; 
           z->restricted_2(h2b,p6b,h2b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p5b<p6b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
            } 
            else if (p6b<=p5b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->lambda1()->get_block(p6b_1-z->noab()+z->nvab()*(h2b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),z->get_range(p5b),0,3,2,1,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_14(){ 
      
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(h3b)) { 
     if ((z->get_sym(p4b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(p4b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h6b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h6b))))==z->irrep_t()) { 
          long p4b_0,p5b_0,h3b_0,h6b_0; 
          z->restricted_4(p4b,p5b,h3b,h6b,p4b_0,p5b_0,h3b_0,h6b_0); 
          long h6b_1,p5b_1; 
          z->restricted_2(h6b,p5b,h6b_1,p5b_1); 
          long dim_common=z->get_range(h6b)*z->get_range(p5b); 
          long dima0_sort=z->get_range(p4b)*z->get_range(h3b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           if (p4b<p5b && h3b<h6b) { 
            z->t2()->get_block(h6b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h3b),z->get_range(h6b),2,0,1,3,+1.0); 
           } 
           else if (p4b<p5b && h6b<=h3b) { 
            z->t2()->get_block(h3b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h3b),3,0,1,2,-1.0); 
           } 
           else if (p5b<=p4b && h3b<h6b) { 
            z->t2()->get_block(h6b_0+z->noab()*(h3b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p4b),z->get_range(h3b),z->get_range(h6b),2,1,0,3,-1.0); 
           } 
           else if (p5b<=p4b && h6b<=h3b) { 
            z->t2()->get_block(h3b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h3b),3,1,0,2,+1.0); 
           } 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           z->lambda1()->get_block(p5b_1-z->noab()+z->nvab()*(h6b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p5b),1,0,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(p4b),1,0,+1.0); 
      in[1]->add_block(h3b+z->noab()*(p4b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_15(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h2b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h2b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_e())) { 
      long dimc=z->get_range(h2b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long h5b=h4b;h5b<z->noab();++h5b) { 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(h6b)) { 
          if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(h6b))))==z->irrep_t()) { 
           long h4b_0,h5b_0,h3b_0,h6b_0; 
           z->restricted_4(h4b,h5b,h3b,h6b,h4b_0,h5b_0,h3b_0,h6b_0); 
           long h2b_1,h6b_1,h4b_1,h5b_1; 
           z->restricted_4(h2b,h6b,h4b,h5b,h2b_1,h6b_1,h4b_1,h5b_1); 
           long dim_common=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h3b<h6b) { 
             z->gt2()->get_block(h6b_0+z->noab()*(h3b_0+z->noab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h3b),z->get_range(h6b),2,3,1,0,+1.0); 
            } 
            else if (h6b<=h3b) { 
             z->gt2()->get_block(h3b_0+z->noab()*(h6b_0+z->noab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),z->get_range(h3b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             z->vr2()->get_block(h5b_1+z->noab()*(h4b_1+z->noab()*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h4b),z->get_range(h5b),0,1,3,2,+1.0); 
            } 
            else if (h6b<=h2b) { 
             z->vr2()->get_block(h5b_1+z->noab()*(h4b_1+z->noab()*(h2b_1+(z->nab())*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(h4b),z->get_range(h5b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h4b==h5b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(h3b),0,1,-0.5/0.5); 
      in[1]->add_block(h3b+z->noab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_16(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_y()^z->irrep_e())) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(h2b)==z->get_spin(p6b)) { 
          if ((z->get_sym(h2b)^z->get_sym(p6b))==z->irrep_y()) { 
           long h2b_0,p6b_0; 
           z->restricted_2(h2b,p6b,h2b_0,p6b_0); 
           long p6b_1,q5b_1,h3b_1,h4b_1; 
           z->restricted_4(p6b,q5b,h3b,h4b,p6b_1,q5b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->lambda1()->get_block(p6b_0-z->noab()+z->nvab()*(h2b_0),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(p6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->qy()->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(p6b_1-z->noab()))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p6b),z->get_range(q5b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(q5b),z->get_range(h2b),3,2,1,0,-1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_17(){ 
      
for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(q4b-z->noab()-z->nvab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(q4b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(q4b)==z->get_spin(h3b)) { 
     if ((z->get_sym(q4b)^z->get_sym(h3b))==(z->irrep_y()^z->irrep_e())) { 
      long dimc=z->get_range(q4b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        if (z->get_spin(h5b)==z->get_spin(p6b)) { 
         if ((z->get_sym(h5b)^z->get_sym(p6b))==z->irrep_y()) { 
          long h5b_0,p6b_0; 
          z->restricted_2(h5b,p6b,h5b_0,p6b_0); 
          long p6b_1,q4b_1,h3b_1,h5b_1; 
          z->restricted_4(p6b,q4b,h3b,h5b,p6b_1,q4b_1,h3b_1,h5b_1); 
          long dim_common=z->get_range(h5b)*z->get_range(p6b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(q4b)*z->get_range(h3b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->lambda1()->get_block(p6b_0-z->noab()+z->nvab()*(h5b_0),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p6b),1,0,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h3b<h5b) { 
            z->qy()->get_block(h5b_1+z->noab()*(h3b_1+z->noab()*(q4b_1-z->noab()-z->nvab()+z->ncab()*(p6b_1-z->noab()))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p6b),z->get_range(q4b),z->get_range(h3b),z->get_range(h5b),2,1,0,3,+1.0); 
           } 
           else if (h5b<=h3b) { 
            z->qy()->get_block(h3b_1+z->noab()*(h5b_1+z->noab()*(q4b_1-z->noab()-z->nvab()+z->ncab()*(p6b_1-z->noab()))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p6b),z->get_range(q4b),z->get_range(h5b),z->get_range(h3b),3,1,0,2,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(q4b),1,0,-1.0); 
      in[1]->add_block(h3b+z->noab()*(q4b-z->noab()-z->nvab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_22(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
    long tileoffset; 
    tileoffset=(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h5b+z->noab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(p1b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(p1b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(p1b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(p1b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p6b_0,h3b_0; 
           z->restricted_2(p6b,h3b,p6b_0,h3b_0); 
           long h4b_1,h5b_1,p1b_1,p6b_1; 
           z->restricted_4(h4b,h5b,p1b,p6b,h4b_1,h5b_1,p1b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(p1b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p1b<p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p1b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p1b),z->get_range(p6b),2,1,0,3,+1.0); 
            } 
            else if (p6b<=p1b) { 
             z->lambda2()->get_block(p1b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),z->get_range(p1b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p1b),z->get_range(h5b),z->get_range(h4b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[1]->add_block(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h5b+z->noab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_23(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p6b_0,h3b_0; 
           z->restricted_2(p6b,h3b,p6b_0,h3b_0); 
           long h2b_1,p5b_1,h4b_1,p6b_1; 
           z->restricted_4(h2b,p5b,h4b,p6b,h2b_1,p5b_1,h4b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(p5b_1-z->noab()+z->nvab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h4b),z->get_range(p6b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p5b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p5b),z->get_range(h2b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_23_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h4b)*z->get_range(p6b); 
        long h2b_0,p5b_0,h4b_0,p6b_0; 
        z->restricted_4(h2b,p5b,h4b,p6b,h2b_0,p5b_0,h4b_0,p6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h4b)*z->get_range(p6b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p6b_0+(z->nab())*(h4b_0+(z->nab())*(p5b_0+(z->nab())*(h2b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h4b),z->get_range(p6b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h2b),z->get_range(p5b),z->get_range(h4b),z->get_range(p6b),0,1,2,3,+1.0); 
         in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_23(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h4b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_24(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    long tileoffset; 
    tileoffset=(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(h5b+z->noab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(p4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p6b_0,h3b_0; 
           z->restricted_2(p6b,h3b,p6b_0,h3b_0); 
           long h2b_1,h5b_1,p4b_1,p6b_1; 
           z->restricted_4(h2b,h5b,p4b,p6b,h2b_1,h5b_1,p4b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h5b)*z->get_range(p4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p4b<p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p4b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(p4b),z->get_range(p6b),2,1,0,3,+1.0); 
            } 
            else if (p6b<=p4b) { 
             z->lambda2()->get_block(p4b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(p6b),z->get_range(p4b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,-1.0); 
        in[1]->add_block(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(h5b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_25(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
   for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
    long tileoffset; 
    tileoffset=(p4b-z->noab()+z->nvab()*(p3b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(p3b)+z->get_spin(p4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(p3b)+z->get_spin(p4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(p3b)^z->get_sym(p4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(p3b)*z->get_range(p4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(p5b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p5b_0,h6b_0; 
           z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
           long h2b_1,h6b_1,p3b_1,p4b_1; 
           z->restricted_4(h2b,h6b,p3b,p4b,h2b_1,h6b_1,p3b_1,p4b_1); 
           long dim_common=z->get_range(h6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(p3b)*z->get_range(p4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             z->lambda2()->get_block(p4b_1-z->noab()+z->nvab()*(p3b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p3b),z->get_range(p4b),3,2,0,1,+1.0); 
            } 
            else if (h6b<=h2b) { 
             z->lambda2()->get_block(p4b_1-z->noab()+z->nvab()*(p3b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(p3b),z->get_range(p4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(p3b),z->get_range(h2b),z->get_range(p5b),2,3,1,0,+1.0); 
        in[1]->add_block(p4b-z->noab()+z->nvab()*(p3b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_26(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p6b_0,h3b_0; 
           z->restricted_2(p6b,h3b,p6b_0,h3b_0); 
           long h2b_1,q5b_1,h4b_1,p6b_1; 
           z->restricted_4(h2b,q5b,h4b,p6b,h2b_1,q5b_1,h4b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(h4b),z->get_range(p6b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(q5b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(q5b),z->get_range(h2b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_26_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h4b)*z->get_range(p6b); 
        long h2b_0,q5b_0,h4b_0,p6b_0; 
        z->restricted_4(h2b,q5b,h4b,p6b,h2b_0,q5b_0,h4b_0,p6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h4b)*z->get_range(p6b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p6b_0+(z->nab())*(h4b_0+(z->nab())*(q5b_0+(z->nab())*(h2b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(h4b),z->get_range(p6b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h2b),z->get_range(q5b),z->get_range(h4b),z->get_range(p6b),0,1,2,3,+1.0); 
         in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_26(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h4b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_27(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
    long tileoffset; 
    tileoffset=(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(h5b+z->noab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(q4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(q4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(q4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(q4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p6b_0,h3b_0; 
           z->restricted_2(p6b,h3b,p6b_0,h3b_0); 
           long h2b_1,h5b_1,p6b_1,q4b_1; 
           z->restricted_4(h2b,h5b,p6b,q4b,h2b_1,h5b_1,p6b_1,q4b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h5b)*z->get_range(q4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->ly()->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(p6b),z->get_range(q4b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q4b),z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[1]->add_block(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(h5b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_28(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(p5b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p5b_0,h6b_0; 
           z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
           long h2b_1,h6b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,h6b,h3b,h4b,h2b_1,h6b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             z->glambda2()->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
            } 
            else if (h6b<=h2b) { 
             z->glambda2()->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p5b),2,3,1,0,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_29(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(p5b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p5b_0,h6b_0; 
           z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
           long h2b_1,h6b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,h6b,h3b,h4b,h2b_1,h6b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
            } 
            else if (h6b<=h2b) { 
             in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p5b),2,3,1,0,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_29(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[2]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_31(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h5b+z->noab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h5b+z->noab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p6b_0,h3b_0; 
           z->restricted_2(p6b,h3b,p6b_0,h3b_0); 
           long h2b_1,h5b_1,h4b_1,p6b_1; 
           z->restricted_4(h2b,h5b,h4b,p6b,h2b_1,h5b_1,h4b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(h4b),z->get_range(p6b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h5b+z->noab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h5b+z->noab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_31(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h5b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h4b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_32(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    long tileoffset; 
    tileoffset=(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(p4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(p5b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p5b_0,h6b_0; 
           z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
           long h2b_1,h6b_1,h3b_1,p4b_1; 
           z->restricted_4(h2b,h6b,h3b,p4b,h2b_1,h6b_1,h3b_1,p4b_1); 
           long dim_common=z->get_range(h6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h3b)*z->get_range(p4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             in[2]->get_block(p4b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h3b),z->get_range(p4b),3,2,0,1,+1.0); 
            } 
            else if (h6b<=h2b) { 
             in[2]->get_block(p4b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),z->get_range(p4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p5b),2,3,1,0,+1.0); 
        in[1]->add_block(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_32(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
       in[2]->input_offset(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(p4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_33(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(h7b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(h7b))))==z->irrep_t()) { 
            long p5b_0,p6b_0,h3b_0,h7b_0; 
            z->restricted_4(p5b,p6b,h3b,h7b,p5b_0,p6b_0,h3b_0,h7b_0); 
            long h2b_1,h7b_1,h4b_1,p6b_1; 
            z->restricted_4(h2b,h7b,h4b,p6b,h2b_1,h7b_1,h4b_1,p6b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p5b<p6b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h7b),2,0,1,3,+1.0); 
             } 
             else if (p5b<p6b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),3,0,1,2,-1.0); 
             } 
             else if (p6b<=p5b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h7b),2,1,0,3,-1.0); 
             } 
             else if (p6b<=p5b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h7b),z->get_range(h3b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h2b<h7b) { 
              in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(p6b),2,0,3,1,+1.0); 
             } 
             else if (h7b<=h2b) { 
              in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h2b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),z->get_range(p6b),2,1,3,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,0,2,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_33_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(p6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
        long h2b_0,h7b_0,h4b_0,p6b_0; 
        z->restricted_4(h2b,h7b,h4b,p6b,h2b_0,h7b_0,h4b_0,p6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p6b_0+(z->nab())*(h4b_0+(z->nab())*(h7b_0+(z->nab())*(h2b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(p6b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(p6b),0,1,2,3,+1.0); 
         in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_33(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_34(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
          if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p6b_0,p7b_0,h3b_0,h4b_0; 
            z->restricted_4(p6b,p7b,h3b,h4b,p6b_0,p7b_0,h3b_0,h4b_0); 
            long h2b_1,p5b_1,p6b_1,p7b_1; 
            z->restricted_4(h2b,p5b,p6b,p7b,h2b_1,p5b_1,p6b_1,p7b_1); 
            long dim_common=z->get_range(p6b)*z->get_range(p7b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(p5b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p6b==p7b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,-0.5/0.5); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_35(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h5b+z->noab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
          if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p6b_0,p7b_0,h3b_0,h4b_0; 
            z->restricted_4(p6b,p7b,h3b,h4b,p6b_0,p7b_0,h3b_0,h4b_0); 
            long h2b_1,h5b_1,p6b_1,p7b_1; 
            z->restricted_4(h2b,h5b,p6b,p7b,h2b_1,h5b_1,p6b_1,p7b_1); 
            long dim_common=z->get_range(p6b)*z->get_range(p7b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h5b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(p6b),z->get_range(p7b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p6b==p7b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h5b),z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,-0.5/0.5); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h5b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_36(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    long tileoffset; 
    tileoffset=(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(p4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(h7b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(h7b))))==z->irrep_t()) { 
            long p5b_0,p6b_0,h3b_0,h7b_0; 
            z->restricted_4(p5b,p6b,h3b,h7b,p5b_0,p6b_0,h3b_0,h7b_0); 
            long h2b_1,h7b_1,p4b_1,p6b_1; 
            z->restricted_4(h2b,h7b,p4b,p6b,h2b_1,h7b_1,p4b_1,p6b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(p4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p5b<p6b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h7b),2,0,1,3,+1.0); 
             } 
             else if (p5b<p6b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),3,0,1,2,-1.0); 
             } 
             else if (p6b<=p5b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h7b),2,1,0,3,-1.0); 
             } 
             else if (p6b<=p5b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h7b),z->get_range(h3b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h2b<h7b && p4b<p6b) { 
              z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p4b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p4b),z->get_range(p6b),2,0,3,1,+1.0); 
             } 
             else if (h2b<h7b && p6b<=p4b) { 
              z->lambda2()->get_block(p4b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p6b),z->get_range(p4b),3,0,2,1,-1.0); 
             } 
             else if (h7b<=h2b && p4b<p6b) { 
              z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p4b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h2b),z->get_range(p4b),z->get_range(p6b),2,1,3,0,-1.0); 
             } 
             else if (h7b<=h2b && p6b<=p4b) { 
              z->lambda2()->get_block(p4b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),z->get_range(p4b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,-1.0); 
        in[1]->add_block(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_37(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h4b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(h7b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(h7b))))==z->irrep_t()) { 
           long p5b_0,p6b_0,h3b_0,h7b_0; 
           z->restricted_4(p5b,p6b,h3b,h7b,p5b_0,p6b_0,h3b_0,h7b_0); 
           long h4b_1,h7b_1,p5b_1,p6b_1; 
           z->restricted_4(h4b,h7b,p5b,p6b,h4b_1,h7b_1,p5b_1,p6b_1); 
           long dim_common=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h3b<h7b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h7b),2,1,0,3,+1.0); 
            } 
            else if (h7b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h4b<h7b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h7b),z->get_range(p5b),z->get_range(p6b),0,3,2,1,+1.0); 
            } 
            else if (h7b<=h4b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h4b),z->get_range(p5b),z->get_range(p6b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p5b==p6b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),0,1,+0.5/0.5); 
      in[1]->add_block(h3b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_38(){ 
      
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(p3b)) { 
     if ((z->get_sym(p4b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(p4b)*z->get_range(p3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long h7b=h6b;h7b<z->noab();++h7b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h6b)+z->get_spin(h7b)) { 
          if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h6b)^z->get_sym(h7b))))==z->irrep_t()) { 
           long p4b_0,p5b_0,h6b_0,h7b_0; 
           z->restricted_4(p4b,p5b,h6b,h7b,p4b_0,p5b_0,h6b_0,h7b_0); 
           long h6b_1,h7b_1,p3b_1,p5b_1; 
           z->restricted_4(h6b,h7b,p3b,p5b,h6b_1,h7b_1,p3b_1,p5b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p4b<p5b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h7b),0,1,3,2,+1.0); 
            } 
            else if (p5b<=p4b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h7b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p3b<p5b) { 
             z->lambda2()->get_block(p5b_1-z->noab()+z->nvab()*(p3b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p3b),z->get_range(p5b),2,3,1,0,+1.0); 
            } 
            else if (p5b<=p3b) { 
             z->lambda2()->get_block(p3b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p5b),z->get_range(p3b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h6b==h7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p3b),z->get_range(p4b),1,0,+0.5/0.5); 
      in[1]->add_block(p3b-z->noab()+z->nvab()*(p4b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_39(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_e()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
          if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h3b)+z->get_spin(h7b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h3b)^z->get_sym(h7b))))==z->irrep_e()) { 
            long p5b_0,q6b_0,h3b_0,h7b_0; 
            z->restricted_4(p5b,q6b,h3b,h7b,p5b_0,q6b_0,h3b_0,h7b_0); 
            long h2b_1,h7b_1,h4b_1,q6b_1; 
            z->restricted_4(h2b,h7b,h4b,q6b,h2b_1,h7b_1,h4b_1,q6b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(q6b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h7b) { 
              z->qy()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(q6b_0-z->noab()-z->nvab()+z->ncab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q6b),z->get_range(h3b),z->get_range(h7b),2,0,1,3,+1.0); 
             } 
             else if (h7b<=h3b) { 
              z->qy()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(q6b_0-z->noab()-z->nvab()+z->ncab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q6b),z->get_range(h7b),z->get_range(h3b),3,0,1,2,-1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h2b<h7b) { 
              in[2]->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(h4b_1+z->noab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(q6b),2,0,3,1,+1.0); 
             } 
             else if (h7b<=h2b) { 
              in[2]->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(h4b_1+z->noab()*(h2b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),z->get_range(q6b),2,1,3,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,0,2,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_39_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h4b+z->noab()*(h7b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(q6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(q6b); 
        long h2b_0,h7b_0,h4b_0,q6b_0; 
        z->restricted_4(h2b,h7b,h4b,q6b,h2b_0,h7b_0,h4b_0,q6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(q6b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(q6b_0+(z->nab())*(h4b_0+(z->nab())*(h7b_0+(z->nab())*(h2b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(q6b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(q6b),0,1,2,3,+1.0); 
         in[2]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_39(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(q6b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(q6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(q6b)!=8L) { 
       in[2]->input_offset(q6b-z->noab()-z->nvab()+z->ncab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(q6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_40(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_e())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         for (long h7b=h6b;h7b<z->noab();++h7b) { 
          if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long h6b_0,h7b_0,h3b_0,h4b_0; 
            z->restricted_4(h6b,h7b,h3b,h4b,h6b_0,h7b_0,h3b_0,h4b_0); 
            long h2b_1,p5b_1,h6b_1,h7b_1; 
            z->restricted_4(h2b,p5b,h6b,h7b,h2b_1,p5b_1,h6b_1,h7b_1); 
            long dim_common=z->get_range(h6b)*z->get_range(h7b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(p5b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->gt2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h7b_0+z->noab()*(h6b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->vr2()->get_block(h7b_1+z->noab()*(h6b_1+z->noab()*(p5b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(h6b),z->get_range(h7b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h6b==h7b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,-0.5/0.5); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_41(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    long tileoffset; 
    tileoffset=(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_y()^z->irrep_e())) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(p4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
          if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(p4b)+z->get_spin(p7b)) { 
           if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(p4b)^z->get_sym(p7b))))==z->irrep_y()) { 
            long h2b_0,h6b_0,p4b_0,p7b_0; 
            z->restricted_4(h2b,h6b,p4b,p7b,h2b_0,h6b_0,p4b_0,p7b_0); 
            long p7b_1,q5b_1,h3b_1,h6b_1; 
            z->restricted_4(p7b,q5b,h3b,h6b,p7b_1,q5b_1,h3b_1,h6b_1); 
            long dim_common=z->get_range(h6b)*z->get_range(p7b); 
            long dima0_sort=z->get_range(h2b)*z->get_range(p4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(q5b)*z->get_range(h3b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h2b<h6b && p4b<p7b) { 
              z->lambda2()->get_block(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(h6b_0+z->noab()*(h2b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p4b),z->get_range(p7b),2,0,3,1,+1.0); 
             } 
             else if (h2b<h6b && p7b<=p4b) { 
              z->lambda2()->get_block(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(h6b_0+z->noab()*(h2b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p7b),z->get_range(p4b),3,0,2,1,-1.0); 
             } 
             else if (h6b<=h2b && p4b<p7b) { 
              z->lambda2()->get_block(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(h2b_0+z->noab()*(h6b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(p4b),z->get_range(p7b),2,1,3,0,-1.0); 
             } 
             else if (h6b<=h2b && p7b<=p4b) { 
              z->lambda2()->get_block(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(h2b_0+z->noab()*(h6b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(p7b),z->get_range(p4b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h3b<h6b) { 
              z->qy()->get_block(h6b_1+z->noab()*(h3b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(p7b_1-z->noab()))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(q5b),z->get_range(h3b),z->get_range(h6b),2,1,0,3,+1.0); 
             } 
             else if (h6b<=h3b) { 
              z->qy()->get_block(h3b_1+z->noab()*(h6b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(p7b_1-z->noab()))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(q5b),z->get_range(h6b),z->get_range(h3b),3,1,0,2,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(q5b),z->get_range(p4b),z->get_range(h2b),3,1,0,2,+1.0); 
        in[1]->add_block(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_42(){ 
      
for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(q4b-z->noab()-z->nvab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(q4b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(q4b)==z->get_spin(p3b)) { 
     if ((z->get_sym(q4b)^z->get_sym(p3b))==(z->irrep_y()^z->irrep_e())) { 
      long dimc=z->get_range(q4b)*z->get_range(p3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       for (long h6b=h5b;h6b<z->noab();++h6b) { 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p3b)+z->get_spin(p7b)) { 
          if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p3b)^z->get_sym(p7b))))==z->irrep_y()) { 
           long h5b_0,h6b_0,p3b_0,p7b_0; 
           z->restricted_4(h5b,h6b,p3b,p7b,h5b_0,h6b_0,p3b_0,p7b_0); 
           long p7b_1,q4b_1,h5b_1,h6b_1; 
           z->restricted_4(p7b,q4b,h5b,h6b,p7b_1,q4b_1,h5b_1,h6b_1); 
           long dim_common=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p7b); 
           long dima0_sort=z->get_range(p3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p3b<p7b) { 
             z->lambda2()->get_block(p7b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(h6b_0+z->noab()*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p3b),z->get_range(p7b),2,3,1,0,+1.0); 
            } 
            else if (p7b<=p3b) { 
             z->lambda2()->get_block(p3b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(h6b_0+z->noab()*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p7b),z->get_range(p3b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->qy()->get_block(h6b_1+z->noab()*(h5b_1+z->noab()*(q4b_1-z->noab()-z->nvab()+z->ncab()*(p7b_1-z->noab()))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(q4b),z->get_range(h5b),z->get_range(h6b),1,0,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h5b==h6b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q4b),z->get_range(p3b),0,1,-0.5/0.5); 
      in[1]->add_block(p3b-z->noab()+z->nvab()*(q4b-z->noab()-z->nvab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_44(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
    long tileoffset; 
    tileoffset=(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(q4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(q4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(q4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(q4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(p5b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p5b_0,h6b_0; 
           z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
           long h2b_1,h6b_1,h3b_1,q4b_1; 
           z->restricted_4(h2b,h6b,h3b,q4b,h2b_1,h6b_1,h3b_1,q4b_1); 
           long dim_common=z->get_range(h6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h3b)*z->get_range(q4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             in[2]->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(h3b_1+z->noab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h3b),z->get_range(q4b),3,2,0,1,+1.0); 
            } 
            else if (h6b<=h2b) { 
             in[2]->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),z->get_range(q4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p5b),2,3,1,0,+1.0); 
        in[1]->add_block(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_44(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
    if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(q4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(q4b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(q4b)!=8L) { 
       in[2]->input_offset(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(q4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_45(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
          if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p6b_0,p7b_0,h3b_0,h4b_0; 
            z->restricted_4(p6b,p7b,h3b,h4b,p6b_0,p7b_0,h3b_0,h4b_0); 
            long h2b_1,q5b_1,p6b_1,p7b_1; 
            z->restricted_4(h2b,q5b,p6b,p7b,h2b_1,q5b_1,p6b_1,p7b_1); 
            long dim_common=z->get_range(p6b)*z->get_range(p7b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(q5b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(q5b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(p6b),z->get_range(p7b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p6b==p7b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q5b),z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,-0.5/0.5); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_46(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
    long tileoffset; 
    tileoffset=(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(q4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(q4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(q4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(q4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(h7b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(h7b))))==z->irrep_t()) { 
            long p5b_0,p6b_0,h3b_0,h7b_0; 
            z->restricted_4(p5b,p6b,h3b,h7b,p5b_0,p6b_0,h3b_0,h7b_0); 
            long h2b_1,h7b_1,p6b_1,q4b_1; 
            z->restricted_4(h2b,h7b,p6b,q4b,h2b_1,h7b_1,p6b_1,q4b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(q4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p5b<p6b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h7b),2,0,1,3,+1.0); 
             } 
             else if (p5b<p6b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),3,0,1,2,-1.0); 
             } 
             else if (p6b<=p5b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h7b),2,1,0,3,-1.0); 
             } 
             else if (p6b<=p5b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h7b),z->get_range(h3b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h2b<h7b) { 
              z->ly()->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(p6b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p6b),z->get_range(q4b),3,0,2,1,+1.0); 
             } 
             else if (h7b<=h2b) { 
              z->ly()->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(p6b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),z->get_range(q4b),3,1,2,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,+1.0); 
        in[1]->add_block(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_47(){ 
      
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
  long tileoffset; 
  tileoffset=(q3b-z->noab()-z->nvab()+z->ncab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(q3b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(q3b)) { 
     if ((z->get_sym(p4b)^z->get_sym(q3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(p4b)*z->get_range(q3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long h7b=h6b;h7b<z->noab();++h7b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h6b)+z->get_spin(h7b)) { 
          if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h6b)^z->get_sym(h7b))))==z->irrep_t()) { 
           long p4b_0,p5b_0,h6b_0,h7b_0; 
           z->restricted_4(p4b,p5b,h6b,h7b,p4b_0,p5b_0,h6b_0,h7b_0); 
           long h6b_1,h7b_1,p5b_1,q3b_1; 
           z->restricted_4(h6b,h7b,p5b,q3b,h6b_1,h7b_1,p5b_1,q3b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p4b<p5b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h7b),0,1,3,2,+1.0); 
            } 
            else if (p5b<=p4b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h7b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->ly()->get_block(q3b_1-z->noab()-z->nvab()+z->ncab()*(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p5b),z->get_range(q3b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h6b==h7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q3b),z->get_range(p4b),1,0,-0.5/0.5); 
      in[1]->add_block(q3b-z->noab()-z->nvab()+z->ncab()*(p4b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_49(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(p5b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p5b_0,h6b_0; 
           z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
           long h2b_1,h6b_1,h3b_1,h4b_1; 
           z->restricted_4(h2b,h6b,h3b,h4b,h2b_1,h6b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h6b) { 
             in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
            } 
            else if (h6b<=h2b) { 
             in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p5b),2,3,1,0,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_49(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[2]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_5(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h2b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h2b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        if (z->get_spin(p4b)==z->get_spin(h5b)) { 
         if ((z->get_sym(p4b)^z->get_sym(h5b))==z->irrep_t()) { 
          long p4b_0,h5b_0; 
          z->restricted_2(p4b,h5b,p4b_0,h5b_0); 
          long h2b_1,h5b_1,h3b_1,p4b_1; 
          z->restricted_4(h2b,h5b,h3b,p4b,h2b_1,h5b_1,h3b_1,p4b_1); 
          long dim_common=z->get_range(h5b)*z->get_range(p4b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h2b)*z->get_range(h3b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h5b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h5b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h2b<h5b) { 
            z->v2()->get_block(p4b_1+(z->nab())*(h3b_1+(z->nab())*(h5b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(h3b),z->get_range(p4b),2,0,3,1,+1.0); 
           } 
           else if (h5b<=h2b) { 
            z->v2()->get_block(p4b_1+(z->nab())*(h3b_1+(z->nab())*(h2b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h2b),z->get_range(h3b),z->get_range(p4b),2,1,3,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),1,0,-1.0); 
      in[1]->add_block(h3b+z->noab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_52(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
           long p5b_0,p6b_0,h3b_0,h4b_0; 
           z->restricted_4(p5b,p6b,h3b,h4b,p5b_0,p6b_0,h3b_0,h4b_0); 
           long h2b_1,p6b_1; 
           z->restricted_2(h2b,p6b,h2b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p5b<p6b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
            } 
            else if (p6b<=p5b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h2b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),z->get_range(p5b),0,3,2,1,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_52(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  if (z->get_spin(h2b)==z->get_spin(p6b)) { 
   if ((z->get_sym(h2b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p6b)!=4L) { 
     in[2]->input_offset(p6b-z->noab()+z->nvab()*(h2b),size); 
     size+=z->get_range(h2b)*z->get_range(p6b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_53(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(h7b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(h7b))))==z->irrep_t()) { 
            long p5b_0,p6b_0,h3b_0,h7b_0; 
            z->restricted_4(p5b,p6b,h3b,h7b,p5b_0,p6b_0,h3b_0,h7b_0); 
            long h2b_1,h7b_1,h4b_1,p6b_1; 
            z->restricted_4(h2b,h7b,h4b,p6b,h2b_1,h7b_1,h4b_1,p6b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p5b<p6b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h7b),2,0,1,3,+1.0); 
             } 
             else if (p5b<p6b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),3,0,1,2,-1.0); 
             } 
             else if (p6b<=p5b && h3b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h7b),2,1,0,3,-1.0); 
             } 
             else if (p6b<=p5b && h7b<=h3b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h7b),z->get_range(h3b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h2b<h7b) { 
              in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(p6b),2,0,3,1,+1.0); 
             } 
             else if (h7b<=h2b) { 
              in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h2b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),z->get_range(p6b),2,1,3,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,0,2,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_53(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_55(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        if (z->get_spin(p5b)==z->get_spin(h3b)) { 
         if ((z->get_sym(p5b)^z->get_sym(h3b))==z->irrep_t()) { 
          long p5b_0,h3b_0; 
          z->restricted_2(p5b,h3b,p5b_0,h3b_0); 
          long h2b_1,h4b_1; 
          z->restricted_2(h2b,h4b,h2b_1,h4b_1); 
          long dim_common=1L; 
          long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h2b)*z->get_range(h4b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h3b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h3b),1,0,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[2]->get_block(h4b_1+z->noab()*(h2b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h4b),1,0,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(p5b),1,3,0,2,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_55(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  if (z->get_spin(h2b)==z->get_spin(h4b)) { 
   if ((z->get_sym(h2b)^z->get_sym(h4b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h4b)!=4L) { 
     in[2]->input_offset(h4b+z->noab()*(h2b),size); 
     size+=z->get_range(h2b)*z->get_range(h4b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_56(){ 
      
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(h3b)) { 
     if ((z->get_sym(p4b)^z->get_sym(h3b))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(p4b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long h7b=h6b;h7b<z->noab();++h7b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h6b)+z->get_spin(h7b)) { 
          if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h6b)^z->get_sym(h7b))))==z->irrep_t()) { 
           long p4b_0,p5b_0,h6b_0,h7b_0; 
           z->restricted_4(p4b,p5b,h6b,h7b,p4b_0,p5b_0,h6b_0,h7b_0); 
           long h6b_1,h7b_1,h3b_1,p5b_1; 
           z->restricted_4(h6b,h7b,h3b,p5b,h6b_1,h7b_1,h3b_1,p5b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(p4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p4b<p5b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h7b),0,1,3,2,+1.0); 
            } 
            else if (p5b<=p4b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h7b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p5b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(h3b),z->get_range(p5b),2,3,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h6b==h7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(p4b),1,0,+0.5/0.5); 
      in[1]->add_block(h3b+z->noab()*(p4b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_56(){ 
 
long size=0L; 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long h7b=h6b;h7b<z->noab();++h7b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h3b)+z->get_spin(p5b)) { 
     if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h3b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(h3b)+z->get_spin(p5b)!=8L) { 
       in[2]->input_offset(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h7b+z->noab()*(h6b))),size); 
       size+=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h3b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_6(){ 
      
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(p3b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(p3b)==z->get_spin(p1b)) { 
     if ((z->get_sym(p3b)^z->get_sym(p1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p3b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        if (z->get_spin(p4b)==z->get_spin(h5b)) { 
         if ((z->get_sym(p4b)^z->get_sym(h5b))==z->irrep_t()) { 
          long p4b_0,h5b_0; 
          z->restricted_2(p4b,h5b,p4b_0,h5b_0); 
          long h5b_1,p3b_1,p1b_1,p4b_1; 
          z->restricted_4(h5b,p3b,p1b,p4b,h5b_1,p3b_1,p1b_1,p4b_1); 
          long dim_common=z->get_range(h5b)*z->get_range(p4b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p3b)*z->get_range(p1b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h5b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h5b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (p1b<p4b) { 
            z->v2()->get_block(p4b_1+(z->nab())*(p1b_1+(z->nab())*(p3b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p3b),z->get_range(p1b),z->get_range(p4b),2,1,3,0,+1.0); 
           } 
           else if (p4b<=p1b) { 
            z->v2()->get_block(p1b_1+(z->nab())*(p4b_1+(z->nab())*(p3b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p3b),z->get_range(p4b),z->get_range(p1b),3,1,2,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(p3b),1,0,-1.0); 
      in[1]->add_block(p1b-z->noab()+z->nvab()*(p3b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_60(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_e()^(z->irrep_t()^z->irrep_v()))) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
         if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_e()) { 
           long p5b_0,q6b_0,h3b_0,h4b_0; 
           z->restricted_4(p5b,q6b,h3b,h4b,p5b_0,q6b_0,h3b_0,h4b_0); 
           long h2b_1,q6b_1; 
           z->restricted_2(h2b,q6b,h2b_1,q6b_1); 
           long dim_common=z->get_range(q6b); 
           long dima0_sort=z->get_range(p5b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->qy()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(q6b_0-z->noab()-z->nvab()+z->ncab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q6b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(h2b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),z->get_range(p5b),0,3,2,1,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_60(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  if (z->get_spin(h2b)==z->get_spin(q6b)) { 
   if ((z->get_sym(h2b)^z->get_sym(q6b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q6b)!=4L) { 
     in[2]->input_offset(q6b-z->noab()-z->nvab()+z->ncab()*(h2b),size); 
     size+=z->get_range(h2b)*z->get_range(q6b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_61(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_e()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(p6b)+z->get_spin(q5b)==z->get_spin(h3b)+z->get_spin(h7b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(q5b)^(z->get_sym(h3b)^z->get_sym(h7b))))==z->irrep_e()) { 
            long p6b_0,q5b_0,h3b_0,h7b_0; 
            z->restricted_4(p6b,q5b,h3b,h7b,p6b_0,q5b_0,h3b_0,h7b_0); 
            long h2b_1,h7b_1,h4b_1,p6b_1; 
            z->restricted_4(h2b,h7b,h4b,p6b,h2b_1,h7b_1,h4b_1,p6b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(q5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h7b) { 
              z->qy()->get_block(h7b_0+z->noab()*(h3b_0+z->noab()*(q5b_0-z->noab()-z->nvab()+z->ncab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(q5b),z->get_range(h3b),z->get_range(h7b),2,1,0,3,+1.0); 
             } 
             else if (h7b<=h3b) { 
              z->qy()->get_block(h3b_0+z->noab()*(h7b_0+z->noab()*(q5b_0-z->noab()-z->nvab()+z->ncab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(q5b),z->get_range(h7b),z->get_range(h3b),3,1,0,2,-1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h2b<h7b) { 
              in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(h4b),z->get_range(p6b),2,0,3,1,+1.0); 
             } 
             else if (h7b<=h2b) { 
              in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h2b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),z->get_range(p6b),2,1,3,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(q5b),1,3,2,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h3b),z->get_range(q5b),1,3,0,2,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_61(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_62(){ 
      
for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(q4b-z->noab()-z->nvab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(q4b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(q4b)==z->get_spin(h3b)) { 
     if ((z->get_sym(q4b)^z->get_sym(h3b))==(z->irrep_e()^(z->irrep_t()^z->irrep_y()))) { 
      long dimc=z->get_range(q4b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long h7b=h6b;h7b<z->noab();++h7b) { 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p5b)+z->get_spin(q4b)==z->get_spin(h6b)+z->get_spin(h7b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(q4b)^(z->get_sym(h6b)^z->get_sym(h7b))))==z->irrep_e()) { 
           long p5b_0,q4b_0,h6b_0,h7b_0; 
           z->restricted_4(p5b,q4b,h6b,h7b,p5b_0,q4b_0,h6b_0,h7b_0); 
           long h6b_1,h7b_1,h3b_1,p5b_1; 
           z->restricted_4(h6b,h7b,h3b,p5b,h6b_1,h7b_1,h3b_1,p5b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(q4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->qy()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(q4b_0-z->noab()-z->nvab()+z->ncab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q4b),z->get_range(h6b),z->get_range(h7b),1,0,3,2,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p5b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(h3b),z->get_range(p5b),2,3,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h6b==h7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(q4b),1,0,+0.5/0.5); 
      in[1]->add_block(h3b+z->noab()*(q4b-z->noab()-z->nvab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_62(){ 
 
long size=0L; 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long h7b=h6b;h7b<z->noab();++h7b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h3b)+z->get_spin(p5b)) { 
     if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h3b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(h3b)+z->get_spin(p5b)!=8L) { 
       in[2]->input_offset(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h7b+z->noab()*(h6b))),size); 
       size+=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h3b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_7(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h4b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
       if (z->get_spin(p5b)==z->get_spin(h3b)) { 
        if ((z->get_sym(p5b)^z->get_sym(h3b))==z->irrep_t()) { 
         long p5b_0,h3b_0; 
         z->restricted_2(p5b,h3b,p5b_0,h3b_0); 
         long h4b_1,p5b_1; 
         z->restricted_2(h4b,p5b,h4b_1,p5b_1); 
         long dim_common=z->get_range(p5b); 
         long dima0_sort=z->get_range(h3b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h4b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h3b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h3b),1,0,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          z->lambda1()->get_block(p5b_1-z->noab()+z->nvab()*(h4b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p5b),0,1,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),0,1,+1.0); 
      in[1]->add_block(h3b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_8(){ 
      
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(p3b)) { 
     if ((z->get_sym(p4b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(p4b)*z->get_range(p3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       if (z->get_spin(p4b)==z->get_spin(h5b)) { 
        if ((z->get_sym(p4b)^z->get_sym(h5b))==z->irrep_t()) { 
         long p4b_0,h5b_0; 
         z->restricted_2(p4b,h5b,p4b_0,h5b_0); 
         long h5b_1,p3b_1; 
         z->restricted_2(h5b,p3b,h5b_1,p3b_1); 
         long dim_common=z->get_range(h5b); 
         long dima0_sort=z->get_range(p4b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(p3b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h5b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h5b),0,1,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          z->lambda1()->get_block(p3b_1-z->noab()+z->nvab()*(h5b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p3b),1,0,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p3b),z->get_range(p4b),1,0,+1.0); 
      in[1]->add_block(p3b-z->noab()+z->nvab()*(p4b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_1_9(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h2b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h2b)^z->get_sym(h3b))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
      long dimc=z->get_range(h2b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
       if (z->get_spin(p4b)==z->get_spin(h3b)) { 
        if ((z->get_sym(p4b)^z->get_sym(h3b))==z->irrep_t()) { 
         long p4b_0,h3b_0; 
         z->restricted_2(p4b,h3b,p4b_0,h3b_0); 
         long h2b_1,p4b_1; 
         z->restricted_2(h2b,p4b,h2b_1,p4b_1); 
         long dim_common=z->get_range(p4b); 
         long dima0_sort=z->get_range(h3b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h2b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h3b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h3b),1,0,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          in[2]->get_block(p4b_1-z->noab()+z->nvab()*(h2b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p4b),0,1,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(h3b),0,1,+1.0); 
      in[1]->add_block(h3b+z->noab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_1_9(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  if (z->get_spin(h2b)==z->get_spin(p4b)) { 
   if ((z->get_sym(h2b)^z->get_sym(p4b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p4b)!=4L) { 
     in[2]->input_offset(p4b-z->noab()+z->nvab()*(h2b),size); 
     size+=z->get_range(h2b)*z->get_range(p4b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_10(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
  long tileoffset; 
  tileoffset=(p1b-z->noab()+z->nvab()*(h4b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p1b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(p1b)) { 
     if ((z->get_sym(h4b)^z->get_sym(p1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(p1b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        if (z->get_spin(p5b)==z->get_spin(h6b)) { 
         if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
          long p5b_0,h6b_0; 
          z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
          long h4b_1,h6b_1,p1b_1,p5b_1; 
          z->restricted_4(h4b,h6b,p1b,p5b,h4b_1,h6b_1,p1b_1,p5b_1); 
          long dim_common=z->get_range(h6b)*z->get_range(p5b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(p1b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h4b<h6b && p1b<p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p1b_1+(z->nab())*(h6b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p1b),z->get_range(p5b),2,0,3,1,+1.0); 
           } 
           else if (h4b<h6b && p5b<=p1b) { 
            z->v2()->get_block(p1b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p5b),z->get_range(p1b),3,0,2,1,-1.0); 
           } 
           else if (h6b<=h4b && p1b<p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p1b_1+(z->nab())*(h4b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(p1b),z->get_range(p5b),2,1,3,0,-1.0); 
           } 
           else if (h6b<=h4b && p5b<=p1b) { 
            z->v2()->get_block(p1b_1+(z->nab())*(p5b_1+(z->nab())*(h4b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(p5b),z->get_range(p1b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p1b),z->get_range(h4b),1,0,-1.0); 
      in[2]->add_block(p1b-z->noab()+z->nvab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_11(){ 
      
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h5b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h5b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h5b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
       if (z->get_spin(p6b)==z->get_spin(h3b)) { 
        if ((z->get_sym(p6b)^z->get_sym(h3b))==z->irrep_t()) { 
         long p6b_0,h3b_0; 
         z->restricted_2(p6b,h3b,p6b_0,h3b_0); 
         long h5b_1,p6b_1; 
         z->restricted_2(h5b,p6b,h5b_1,p6b_1); 
         long dim_common=z->get_range(p6b); 
         long dima0_sort=z->get_range(h3b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h5b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h3b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h3b),1,0,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          z->lambda1()->get_block(p6b_1-z->noab()+z->nvab()*(h5b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p6b),0,1,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h5b),z->get_range(h3b),0,1,-1.0); 
      in[2]->add_block(h3b+z->noab()*(h5b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_29(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h6b+z->noab()*(h2b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p7b_0,h3b_0; 
           z->restricted_2(p7b,h3b,p7b_0,h3b_0); 
           long h2b_1,h6b_1,h4b_1,p7b_1; 
           z->restricted_4(h2b,h6b,h4b,p7b,h2b_1,h6b_1,h4b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[3]->get_block(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h4b),z->get_range(p7b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[2]->add_block(h3b+z->noab()*(h4b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_29_0(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h4b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h4b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h4b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b)*z->get_range(p7b); 
        long h2b_0,h6b_0,h4b_0,p7b_0; 
        z->restricted_4(h2b,h6b,h4b,p7b,h2b_0,h6b_0,h4b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p7b_0+(z->nab())*(h4b_0+(z->nab())*(h6b_0+(z->nab())*(h2b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h4b),z->get_range(p7b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h2b),z->get_range(h6b),z->get_range(h4b),z->get_range(p7b),0,1,2,3,-1.0); 
         in[3]->add_block(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_2_29(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h4b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h4b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h4b)+z->get_spin(p7b)!=8L) { 
       in[3]->input_offset(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_30(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(p5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(p5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(p5b)*z->get_range(h4b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p7b_0,h4b_0; 
           z->restricted_2(p7b,h4b,p7b_0,h4b_0); 
           long h2b_1,p5b_1,p6b_1,p7b_1; 
           z->restricted_4(h2b,p5b,p6b,p7b,h2b_1,p5b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(p5b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p6b) { 
             z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(p5b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,-0.5); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(p5b-z->noab()+z->nvab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_31(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h5b=h2b;h5b<z->noab();++h5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h5b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h5b)*z->get_range(h4b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p7b_0,h4b_0; 
           z->restricted_2(p7b,h4b,p7b_0,h4b_0); 
           long h2b_1,h5b_1,p6b_1,p7b_1; 
           z->restricted_4(h2b,h5b,p6b,p7b,h2b_1,h5b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h5b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(p6b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h5b),z->get_range(p7b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h5b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,-0.5); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h5b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_32(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
    long tileoffset; 
    tileoffset=(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(p4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(p4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(p4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(p4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p7b_0,h3b_0; 
           z->restricted_2(p7b,h3b,p7b_0,h3b_0); 
           long h2b_1,h6b_1,p4b_1,p7b_1; 
           z->restricted_4(h2b,h6b,p4b,p7b,h2b_1,h6b_1,p4b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h6b)*z->get_range(p4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p4b<p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p4b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p4b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p4b) { 
             z->lambda2()->get_block(p4b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p7b),z->get_range(p4b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[2]->add_block(p4b-z->noab()+z->nvab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_43(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q5b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(q5b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(q5b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(q5b)*z->get_range(h4b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p7b_0,h4b_0; 
           z->restricted_2(p7b,h4b,p7b_0,h4b_0); 
           long h2b_1,q5b_1,p6b_1,p7b_1; 
           z->restricted_4(h2b,q5b,p6b,p7b,h2b_1,q5b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(q5b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(q5b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(p6b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p6b) { 
             z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(q5b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(q5b),z->get_range(p7b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(q5b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,-0.5); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(q5b-z->noab()-z->nvab()+z->ncab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_44(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long q4b=z->noab()+z->nvab();q4b<z->nab();++q4b) { 
    long tileoffset; 
    tileoffset=(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(q4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(q4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(q4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(q4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p7b_0,h3b_0; 
           z->restricted_2(p7b,h3b,p7b_0,h3b_0); 
           long h2b_1,h6b_1,p7b_1,q4b_1; 
           z->restricted_4(h2b,h6b,p7b,q4b,h2b_1,h6b_1,p7b_1,q4b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h6b)*z->get_range(q4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->ly()->get_block(q4b_1-z->noab()-z->nvab()+z->ncab()*(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p7b),z->get_range(q4b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q4b),z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,-1.0); 
        in[2]->add_block(q4b-z->noab()-z->nvab()+z->ncab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_49(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h6b+z->noab()*(h2b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p7b_0,h3b_0; 
           z->restricted_2(p7b,h3b,p7b_0,h3b_0); 
           long h2b_1,h6b_1,h4b_1,p7b_1; 
           z->restricted_4(h2b,h6b,h4b,p7b,h2b_1,h6b_1,h4b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[3]->get_block(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h4b),z->get_range(p7b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h6b),z->get_range(h2b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[2]->add_block(h3b+z->noab()*(h4b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::offset_smith_2_49(){ 
 
long size=0L; 
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h4b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h4b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h4b)+z->get_spin(p7b)!=8L) { 
       in[3]->input_offset(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b))),size); 
       size+=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_50(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h3b_0,h4b_0; 
            z->restricted_4(p7b,p8b,h3b,h4b,p7b_0,p8b_0,h3b_0,h4b_0); 
            long h2b_1,h6b_1,p7b_1,p8b_1; 
            z->restricted_4(h2b,h6b,p7b,p8b,h2b_1,h6b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(p7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h6b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p7b==p8b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_51(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p8b_0,h4b_0; 
           z->restricted_2(p8b,h4b,p8b_0,h4b_0); 
           long h2b_1,h7b_1,p6b_1,p8b_1; 
           z->restricted_4(h2b,h7b,p6b,p8b,h2b_1,h7b_1,p6b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h7b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p6b) { 
             z->v2()->get_block(p6b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p8b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,-1.0); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_52(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  long tileoffset; 
  tileoffset=(p6b-z->noab()+z->nvab()*(h2b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p6b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p6b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(p6b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h2b_1,h8b_1,p6b_1,p7b_1; 
          z->restricted_4(h2b,h8b,p6b,p7b,h2b_1,h8b_1,p6b_1,p7b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h2b)*z->get_range(p6b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h2b<h8b && p6b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),2,0,3,1,+1.0); 
           } 
           else if (h2b<h8b && p7b<=p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h8b),z->get_range(p7b),z->get_range(p6b),3,0,2,1,-1.0); 
           } 
           else if (h8b<=h2b && p6b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h2b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h2b),z->get_range(p6b),z->get_range(p7b),2,1,3,0,-1.0); 
           } 
           else if (h8b<=h2b && p7b<=p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h2b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h2b),z->get_range(p7b),z->get_range(p6b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p6b),z->get_range(h2b),1,0,+1.0); 
      in[2]->add_block(p6b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_53(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p8b_0,h4b_0; 
           z->restricted_2(p8b,h4b,p8b_0,h4b_0); 
           long h2b_1,h7b_1,p6b_1,p8b_1; 
           z->restricted_4(h2b,h7b,p6b,p8b,h2b_1,h7b_1,p6b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h7b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p8b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,-1.0); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_54(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h3b_0,h4b_0; 
            z->restricted_4(p7b,p8b,h3b,h4b,p7b_0,p8b_0,h3b_0,h4b_0); 
            long h2b_1,h6b_1,p7b_1,p8b_1; 
            z->restricted_4(h2b,h6b,p7b,p8b,h2b_1,h6b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(p7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h6b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p7b==p8b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_55(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  long tileoffset; 
  tileoffset=(h4b+z->noab()*(h2b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h4b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(h4b)) { 
     if ((z->get_sym(h2b)^z->get_sym(h4b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h2b)*z->get_range(h4b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h4b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h4b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p6b_0,p7b_0,h4b_0,h8b_0; 
           z->restricted_4(p6b,p7b,h4b,h8b,p6b_0,p7b_0,h4b_0,h8b_0); 
           long h2b_1,h8b_1,p6b_1,p7b_1; 
           z->restricted_4(h2b,h8b,p6b,p7b,h2b_1,h8b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h4b<h8b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h4b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h4b),z->get_range(h8b),2,1,0,3,+1.0); 
            } 
            else if (h8b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h4b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h2b<h8b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),0,3,2,1,+1.0); 
            } 
            else if (h8b<=h2b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h2b),z->get_range(p6b),z->get_range(p7b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p6b==p7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(h4b),0,1,+0.5/0.5); 
      in[2]->add_block(h4b+z->noab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_56(){ 
      
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long h7b=h6b;h7b<z->noab();++h7b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h7b+z->noab()*(h6b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(h3b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h3b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h3b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h3b)*z->get_range(p5b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p8b_0,h3b_0; 
           z->restricted_2(p8b,h3b,p8b_0,h3b_0); 
           long h6b_1,h7b_1,p5b_1,p8b_1; 
           z->restricted_4(h6b,h7b,p5b,p8b,h6b_1,h7b_1,p5b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p5b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p5b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p5b) { 
             z->lambda2()->get_block(p5b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p8b),z->get_range(p5b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h7b),z->get_range(h6b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[2]->add_block(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h7b+z->noab()*(h6b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_57(){ 
      
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h5b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h5b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h5b)*z->get_range(h3b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h3b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h3b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p6b_0,p7b_0,h3b_0,h8b_0; 
           z->restricted_4(p6b,p7b,h3b,h8b,p6b_0,p7b_0,h3b_0,h8b_0); 
           long h5b_1,h8b_1,p6b_1,p7b_1; 
           z->restricted_4(h5b,h8b,p6b,p7b,h5b_1,h8b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h3b<h8b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h3b),z->get_range(h8b),2,1,0,3,+1.0); 
            } 
            else if (h8b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h3b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h5b<h8b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),0,3,2,1,+1.0); 
            } 
            else if (h8b<=h5b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h5b),z->get_range(p6b),z->get_range(p7b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p6b==p7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h5b),z->get_range(h3b),0,1,-0.5/0.5); 
      in[2]->add_block(h3b+z->noab()*(h5b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_58(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_e())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long h8b=h7b;h8b<z->noab();++h8b) { 
          if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long h7b_0,h8b_0,h3b_0,h4b_0; 
            z->restricted_4(h7b,h8b,h3b,h4b,h7b_0,h8b_0,h3b_0,h4b_0); 
            long h2b_1,h6b_1,h7b_1,h8b_1; 
            z->restricted_4(h2b,h6b,h7b,h8b,h2b_1,h6b_1,h7b_1,h8b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(h8b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h2b)*z->get_range(h6b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->gt2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h8b_0+z->noab()*(h7b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->vr2()->get_block(h8b_1+z->noab()*(h7b_1+z->noab()*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(h7b),z->get_range(h8b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h7b==h8b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h2b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_59(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h4b+z->noab()*(h7b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(q6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(q6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p8b_0,h4b_0; 
           z->restricted_2(p8b,h4b,p8b_0,h4b_0); 
           long h2b_1,h7b_1,p8b_1,q6b_1; 
           z->restricted_4(h2b,h7b,p8b,q6b,h2b_1,h7b_1,p8b_1,q6b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h7b)*z->get_range(q6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->v2()->get_block(q6b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p8b),z->get_range(q6b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[2]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_60(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  long tileoffset; 
  tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h2b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(q6b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(q6b)) { 
     if ((z->get_sym(h2b)^z->get_sym(q6b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(q6b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h2b_1,h8b_1,p7b_1,q6b_1; 
          z->restricted_4(h2b,h8b,p7b,q6b,h2b_1,h8b_1,p7b_1,q6b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h2b)*z->get_range(q6b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h2b<h8b) { 
            z->v2()->get_block(q6b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h8b),z->get_range(p7b),z->get_range(q6b),3,0,2,1,+1.0); 
           } 
           else if (h8b<=h2b) { 
            z->v2()->get_block(q6b_1+(z->nab())*(p7b_1+(z->nab())*(h2b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h2b),z->get_range(p7b),z->get_range(q6b),3,1,2,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q6b),z->get_range(h2b),1,0,-1.0); 
      in[2]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_61(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h7b=h2b;h7b<z->noab();++h7b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h7b)+z->get_spin(h4b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h7b)==z->get_spin(h4b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h7b)^(z->get_sym(h4b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h7b)*z->get_range(h4b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p8b_0,h4b_0; 
           z->restricted_2(p8b,h4b,p8b_0,h4b_0); 
           long h2b_1,h7b_1,p6b_1,p8b_1; 
           z->restricted_4(h2b,h7b,p6b,p8b,h2b_1,h7b_1,p6b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h7b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h7b),z->get_range(p8b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b+z->noab()*(h7b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_62(){ 
      
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long h7b=h6b;h7b<z->noab();++h7b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h7b+z->noab()*(h6b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(h3b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h3b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h3b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h3b)*z->get_range(p5b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p8b_0,h3b_0; 
           z->restricted_2(p8b,h3b,p8b_0,h3b_0); 
           long h6b_1,h7b_1,p5b_1,p8b_1; 
           z->restricted_4(h6b,h7b,p5b,p8b,h6b_1,h7b_1,p5b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p5b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p5b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p5b) { 
             z->lambda2()->get_block(p5b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p8b),z->get_range(p5b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h7b),z->get_range(h6b),z->get_range(h3b),2,1,3,0,-1.0); 
        in[2]->add_block(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h7b+z->noab()*(h6b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_2_9(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  long tileoffset; 
  tileoffset=(p4b-z->noab()+z->nvab()*(h2b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h2b)+z->get_spin(p4b)!=4L) { 
    if (z->get_spin(h2b)==z->get_spin(p4b)) { 
     if ((z->get_sym(h2b)^z->get_sym(p4b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h2b)*z->get_range(p4b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        if (z->get_spin(p5b)==z->get_spin(h6b)) { 
         if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
          long p5b_0,h6b_0; 
          z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
          long h2b_1,h6b_1,p4b_1,p5b_1; 
          z->restricted_4(h2b,h6b,p4b,p5b,h2b_1,h6b_1,p4b_1,p5b_1); 
          long dim_common=z->get_range(h6b)*z->get_range(p5b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h2b)*z->get_range(p4b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h2b<h6b && p4b<p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p4b),z->get_range(p5b),2,0,3,1,+1.0); 
           } 
           else if (h2b<h6b && p5b<=p4b) { 
            z->v2()->get_block(p4b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p5b),z->get_range(p4b),3,0,2,1,-1.0); 
           } 
           else if (h6b<=h2b && p4b<p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h2b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(p4b),z->get_range(p5b),2,1,3,0,-1.0); 
           } 
           else if (h6b<=h2b && p5b<=p4b) { 
            z->v2()->get_block(p4b_1+(z->nab())*(p5b_1+(z->nab())*(h2b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h2b),z->get_range(p5b),z->get_range(p4b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p4b),z->get_range(h2b),1,0,-1.0); 
      in[2]->add_block(p4b-z->noab()+z->nvab()*(h2b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_3_48(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h4b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h4b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h4b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p8b_0,h4b_0; 
           z->restricted_2(p8b,h4b,p8b_0,h4b_0); 
           long h2b_1,h6b_1,p7b_1,p8b_1; 
           z->restricted_4(h2b,h6b,p7b,p8b,h2b_1,h6b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(h6b_1+(z->nab())*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h6b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,+0.5); 
        in[3]->add_block(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T1::smith_3_49(){ 
      
for (long h2b=0L;h2b<z->noab();++h2b) { 
 for (long h6b=h2b;h6b<z->noab();++h6b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h2b)+z->get_spin(h6b)+z->get_spin(h4b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h2b)+z->get_spin(h6b)==z->get_spin(h4b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h2b)^(z->get_sym(h6b)^(z->get_sym(h4b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h2b)*z->get_range(h6b)*z->get_range(h4b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p8b_0,h4b_0; 
           z->restricted_2(p8b,h4b,p8b_0,h4b_0); 
           long h2b_1,h6b_1,p7b_1,p8b_1; 
           z->restricted_4(h2b,h6b,p7b,p8b,h2b_1,h6b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b)*z->get_range(h6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h2b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h2b),z->get_range(h6b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h6b),z->get_range(h2b),z->get_range(h4b),2,1,3,0,+0.5); 
        in[3]->add_block(p7b-z->noab()+z->nvab()*(h4b+z->noab()*(h6b+z->noab()*(h2b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
