/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2015 CERN
 * @author Maciej Suminski <maciej.suminski@cern.ch>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <tool/zoom_menu.h>
#include <id.h>
#include <draw_frame.h>
#include <base_screen.h>
#include <tool/actions.h>
#include <bitmaps.h>

#include <functional>
using namespace std::placeholders;

ZOOM_MENU::ZOOM_MENU( EDA_DRAW_FRAME* aParent ) : m_parent( aParent )
{
    BASE_SCREEN* screen = aParent->GetScreen();

    SetTitle( _( "Zoom" ) );
    SetIcon( zoom_selection_xpm );

    //int zoom = screen->GetZoom();
    int maxZoomIds = std::min( ID_POPUP_ZOOM_LEVEL_END - ID_POPUP_ZOOM_LEVEL_START,
                               (int) screen->m_ZoomList.size() );

    for( int i = 0; i < maxZoomIds; ++i )
    {
        Append( ID_POPUP_ZOOM_LEVEL_START+1 + i,   // ID_POPUP_ZOOM_LEVEL_START == Auto
            wxString::Format( _( "Zoom: %.2f" ), aParent->GetZoomLevelCoeff() / screen->m_ZoomList[i] ),
            wxEmptyString, wxITEM_CHECK );
    }
}


OPT_TOOL_EVENT ZOOM_MENU::eventHandler( const wxMenuEvent& aEvent )
{
    OPT_TOOL_EVENT event( ACTIONS::zoomPreset.MakeEvent() );
    intptr_t idx = aEvent.GetId() - ID_POPUP_ZOOM_LEVEL_START;
    event->SetParameter( idx );

    return event;
}


void ZOOM_MENU::update()
{
    BASE_SCREEN* screen = m_parent->GetScreen();
    double zoom = screen->GetZoom();
    const std::vector<double>& zoomList = m_parent->GetScreen()->m_ZoomList;

    // Check the current zoom
    int maxZoomIds = std::min( ID_POPUP_ZOOM_LEVEL_END - ID_POPUP_ZOOM_LEVEL_START,
                               (int) screen->m_ZoomList.size() );

    for( int i = 0; i < maxZoomIds; ++i )
        Check( ID_POPUP_ZOOM_LEVEL_START+1 + i, std::fabs( zoomList[i] - zoom ) < 1e-6 );
}
