/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.FieldTokenizer;
import com.sqlmagic.tinysql.UtilString;
import com.sqlmagic.tinysql.tinySQL;
import com.sqlmagic.tinysql.tinySQLException;
import com.sqlmagic.tinysql.tinySQLGlobals;
import com.sqlmagic.tinysql.tinySQLTable;
import com.sqlmagic.tinysql.tinySQLWhere;
import com.sqlmagic.tinysql.tsColumn;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;

public class tinySQLParser {
    Vector columnList;
    Vector tableList;
    Vector actionList;
    Vector valueList;
    Vector contextList;
    Vector columnAliasList;
    Vector columns;
    Hashtable tables;
    tinySQL dbEngine;
    tinySQLWhere whereClause;
    String tableName;
    String tableAlias;
    String dataDir;
    String statementType = null;
    String lastKeyWord = null;
    String orderType = null;
    String oldColumnName = null;
    String newColumnName = null;
    String[] colTypeNames = new String[]{"INT", "FLOAT", "CHAR", "DATE"};
    int[] colTypes = new int[]{4, 6, 1, 91};
    boolean distinct = false;
    boolean defaultOrderBy = true;

    public tinySQLParser(InputStream inputStream, tinySQL tinySQL2) throws tinySQLException {
        String string = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.dbEngine = tinySQL2;
        this.actionList = new Vector();
        this.columnList = new Vector();
        this.columns = new Vector();
        this.columnAliasList = new Vector();
        this.contextList = new Vector();
        this.valueList = new Vector();
        this.tableName = null;
        this.whereClause = null;
        this.tableList = new Vector();
        this.tables = new Hashtable();
        this.tables.put("TABLE_SELECT_ORDER", this.tableList);
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.wordChars(39, 125);
            streamTokenizer.wordChars(63, 63);
            streamTokenizer.wordChars(34, 46);
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype != -3) continue;
                String string2 = streamTokenizer.sval.trim();
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(" ");
                }
                stringBuffer2.append(string2);
            }
            FieldTokenizer fieldTokenizer = new FieldTokenizer(stringBuffer2.toString(), ' ', false);
            while (fieldTokenizer.hasMoreFields()) {
                String string3 = fieldTokenizer.nextField();
                String string4 = string3.toUpperCase();
                if (this.statementType == (String)null) {
                    this.statementType = string4;
                    int n = this.getKeywordIndex(this.statementType, this.statementType);
                    if (n != 0) {
                        this.throwException(9);
                    }
                    string = this.statementType;
                    continue;
                }
                int n = this.getKeywordIndex(this.statementType, string4);
                if (n < 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                this.setPhrase(string, stringBuffer.toString());
                stringBuffer = new StringBuffer();
                string = string4;
                if (!tinySQLGlobals.PARSER_DEBUG) continue;
                System.out.println("Found keyword " + string);
            }
            if (string != (String)null) {
                this.setPhrase(string, stringBuffer.toString());
            }
            this.addAction();
            if (tinySQLGlobals.PARSER_DEBUG) {
                System.out.println("SQL:" + stringBuffer2.toString());
            }
        }
        catch (Exception exception) {
            if (tinySQLGlobals.DEBUG) {
                exception.printStackTrace(System.out);
            }
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void setPhrase(String string, String string2) throws tinySQLException {
        if (string2 == (String)null) {
            this.lastKeyWord = string;
            return;
        }
        if (string2.trim().length() == 0) {
            this.lastKeyWord = string;
            return;
        }
        if (tinySQLGlobals.PARSER_DEBUG) {
            System.out.println("setPhrase " + string2);
        }
        FieldTokenizer fieldTokenizer = new FieldTokenizer(string2, ',', false);
        while (fieldTokenizer.hasMoreFields()) {
            tsColumn tsColumn2;
            String string3;
            String string4;
            FieldTokenizer fieldTokenizer2;
            String string5 = fieldTokenizer.nextField().trim();
            if (tinySQLGlobals.PARSER_DEBUG) {
                System.out.println(string + " field is " + string5);
            }
            String string6 = string5.toUpperCase();
            if (string.equals("SELECT")) {
                if (string5.toUpperCase().startsWith("DISTINCT")) {
                    this.distinct = true;
                    string5 = string5.substring(9).trim();
                }
                fieldTokenizer2 = new FieldTokenizer(string5, ' ', false);
                String string7 = fieldTokenizer2.getField(0);
                String string8 = null;
                if (fieldTokenizer2.countFields() == 2) {
                    string8 = fieldTokenizer2.getField(1);
                } else if (fieldTokenizer2.countFields() == 3) {
                    string8 = fieldTokenizer2.getField(2);
                }
                fieldTokenizer2 = new FieldTokenizer(string7, '|', false);
                if (fieldTokenizer2.countFields() > 1) {
                    StringBuffer stringBuffer = new StringBuffer("CONCAT(");
                    while (fieldTokenizer2.hasMoreFields()) {
                        if (stringBuffer.length() > 7) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(fieldTokenizer2.nextField());
                    }
                    string7 = stringBuffer.toString() + ")";
                }
                this.columnList.addElement(string7);
                this.columnAliasList.addElement(string8);
                this.contextList.addElement(string);
                continue;
            }
            if (string.equals("TABLE")) {
                if (!this.statementType.equals("INSERT")) {
                    this.statementType = this.statementType + "_TABLE";
                }
                if (this.statementType.equals("CREATE_TABLE")) {
                    fieldTokenizer2 = new FieldTokenizer(string5, '(', false);
                    if (fieldTokenizer2.countFields() != 2) {
                        this.throwException(1);
                    }
                    this.tableName = fieldTokenizer2.getField(0);
                    string4 = fieldTokenizer2.getField(1);
                    fieldTokenizer2 = new FieldTokenizer(string4, ',', false);
                    while (fieldTokenizer2.hasMoreFields()) {
                        string3 = fieldTokenizer2.nextField();
                        tsColumn2 = this.parseColumnDefn(string3);
                        if (tsColumn2 == (tsColumn)null) continue;
                        this.columnList.addElement(tsColumn2);
                    }
                    continue;
                }
                if (this.statementType.equals("DROP_TABLE")) {
                    this.tableName = string6;
                    try {
                        this.validateTable(string6, true);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new tinySQLException("Table " + this.tableName + " does not exist.");
                    }
                }
                this.tableName = string6;
                this.validateTable(string6, true);
                continue;
            }
            if (string.equals("BY")) {
                if (this.lastKeyWord == (String)null) {
                    this.throwException(6);
                    continue;
                }
                FieldTokenizer fieldTokenizer3 = new FieldTokenizer(string6, ' ', false);
                this.columnList.addElement(fieldTokenizer3.getField(0));
                if (fieldTokenizer3.countFields() == 2) {
                    if (fieldTokenizer3.getField(1).startsWith("ASC") | fieldTokenizer3.getField(1).startsWith("DESC")) {
                        this.orderType = fieldTokenizer3.getField(1);
                    } else {
                        this.throwException(7);
                    }
                }
                if (this.lastKeyWord.equals("ORDER")) {
                    this.defaultOrderBy = false;
                }
                this.contextList.addElement(this.lastKeyWord);
                continue;
            }
            if (string.equals("DROP")) {
                this.statementType = "ALTER_DROP";
                fieldTokenizer2 = new FieldTokenizer(string6, ' ', false);
                while (fieldTokenizer2.hasMoreFields()) {
                    this.columnList.addElement(UtilString.removeQuotes(fieldTokenizer2.nextField()));
                }
                continue;
            }
            if (string.equals("RENAME")) {
                this.statementType = "ALTER_RENAME";
                fieldTokenizer2 = new FieldTokenizer(string6, ' ', false);
                this.oldColumnName = fieldTokenizer2.getField(0);
                this.newColumnName = fieldTokenizer2.getField(1);
                if (this.newColumnName.equals("TO") & fieldTokenizer2.countFields() == 3) {
                    this.newColumnName = fieldTokenizer2.getField(2);
                }
                if (this.newColumnName.length() <= 11) continue;
                this.newColumnName = tinySQLGlobals.getShortName(this.newColumnName);
                continue;
            }
            if (string.equals("ADD")) {
                this.statementType = "ALTER_ADD";
                tsColumn2 = this.parseColumnDefn(string5);
                if (tsColumn2 == (tsColumn)null) continue;
                this.columnList.addElement(tsColumn2);
                continue;
            }
            if (string.equals("FROM")) {
                this.tableName = string6;
                this.validateTable(this.tableName);
                continue;
            }
            if (string.equals("INTO")) {
                fieldTokenizer2 = new FieldTokenizer(string5, '(', false);
                if (fieldTokenizer2.countFields() != 2) {
                    this.throwException(3);
                }
                this.tableName = fieldTokenizer2.getField(0).toUpperCase();
                this.validateTable(this.tableName);
                string4 = fieldTokenizer2.getField(1).toUpperCase();
                fieldTokenizer2 = new FieldTokenizer(string4, ',', false);
                while (fieldTokenizer2.hasMoreFields()) {
                    string3 = UtilString.removeQuotes(fieldTokenizer2.nextField());
                    this.columnList.addElement(string3);
                    this.contextList.addElement(string);
                }
                continue;
            }
            if (string.equals("VALUES")) {
                fieldTokenizer2 = new FieldTokenizer(string5, '(', false);
                string4 = fieldTokenizer2.getField(0);
                fieldTokenizer2 = new FieldTokenizer(string4, ',', false);
                while (fieldTokenizer2.hasMoreFields()) {
                    string3 = UtilString.removeQuotes(fieldTokenizer2.nextField());
                    string3 = UtilString.replaceAll(string3, "''", "'");
                    this.valueList.addElement(string3);
                }
                continue;
            }
            if (string.equals("UPDATE")) {
                this.tableName = string5.toUpperCase();
                this.validateTable(this.tableName);
                continue;
            }
            if (string.equals("SET")) {
                fieldTokenizer2 = new FieldTokenizer(string5, '=', false);
                if (fieldTokenizer2.countFields() != 2) {
                    this.throwException(4);
                }
                this.columnList.addElement(fieldTokenizer2.getField(0));
                this.contextList.addElement(string);
                this.valueList.addElement(UtilString.removeQuotes(fieldTokenizer2.getField(1)));
                continue;
            }
            if (string.equals("WHERE")) {
                this.whereClause = new tinySQLWhere(string5, this.tables);
                continue;
            }
            if (string.equals("TABLE")) continue;
            this.throwException(10);
        }
        this.lastKeyWord = string;
    }

    public void validateTable(String string) throws tinySQLException {
        this.validateTable(string, false);
    }

    public void validateTable(String string, boolean bl) throws tinySQLException {
        int n;
        tinySQLTable tinySQLTable2;
        String string2;
        FieldTokenizer fieldTokenizer = new FieldTokenizer(string, ' ', false);
        String string3 = fieldTokenizer.getField(0);
        String string4 = fieldTokenizer.getField(1, string3).toUpperCase();
        String string5 = string3 + "->" + string4;
        tinySQLTable tinySQLTable3 = this.dbEngine.getTable(string5);
        tinySQLTable3.GoTop();
        int n2 = tinySQLTable3.GetRowCount();
        if (bl) {
            tinySQLTable3.close();
        }
        if (tinySQLGlobals.PARSER_DEBUG) {
            System.out.println("Add table " + string5 + " to tables");
        }
        this.tables.put(string5, tinySQLTable3);
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < this.tableList.size()) {
            string2 = (String)this.tableList.elementAt(n3);
            tinySQLTable2 = (tinySQLTable)this.tables.get(string2);
            n = tinySQLTable2.GetRowCount();
            if (n2 <= n) {
                this.tableList.insertElementAt(string5, n3);
                bl2 = true;
                break;
            }
            ++n3;
        }
        if (!bl2) {
            this.tableList.addElement(string5);
        }
        if (tinySQLGlobals.PARSER_DEBUG) {
            System.out.println("Table selection order");
            n3 = 0;
            while (n3 < this.tableList.size()) {
                string2 = (String)this.tableList.elementAt(n3);
                tinySQLTable2 = (tinySQLTable)this.tables.get(string2);
                n = tinySQLTable2.GetRowCount();
                System.out.println(string2 + " " + n);
                ++n3;
            }
        }
    }

    public void validateColumns() throws tinySQLException {
        String string;
        String string2;
        boolean bl = false;
        int n = 0;
        while (n < this.columnList.size()) {
            string2 = (String)this.columnList.elementAt(n);
            string = (String)this.contextList.elementAt(n);
            if (string2.equals("*")) {
                if (!string.equals("SELECT")) {
                    throw new tinySQLException("* must be a SELECT column.");
                }
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < this.columnList.size()) {
                string = (String)this.contextList.elementAt(n);
                if (string.equals("SELECT")) {
                    this.columnList.removeElementAt(n);
                    this.contextList.removeElementAt(n);
                    this.columnAliasList.removeElementAt(n);
                }
                ++n;
            }
            n = 0;
            while (n < this.tableList.size()) {
                tinySQLTable tinySQLTable2 = (tinySQLTable)this.tables.get((String)this.tableList.elementAt(n));
                int n2 = 0;
                while (n2 < tinySQLTable2.columnNameKeys.size()) {
                    string2 = (String)tinySQLTable2.columnNameKeys.elementAt(n2);
                    this.columnList.addElement(tinySQLTable2.table + "->" + tinySQLTable2.tableAlias + "." + string2);
                    this.columnAliasList.addElement(string2);
                    this.contextList.addElement("SELECT");
                    ++n2;
                }
                ++n;
            }
        }
        if (this.tables == (Hashtable)null) {
            System.out.println("*****Column validation - no tables defined.");
        }
        n = 0;
        while (n < this.columnList.size()) {
            string2 = (String)this.columnList.elementAt(n);
            string = (String)this.contextList.elementAt(n);
            String string3 = null;
            if (n < this.columnAliasList.size()) {
                string3 = (String)this.columnAliasList.elementAt(n);
            }
            tsColumn tsColumn2 = new tsColumn(string2, this.tables, string);
            tsColumn2.alias = UtilString.removeQuotes(string3);
            this.columns.addElement(tsColumn2);
            ++n;
        }
    }

    public tsColumn parseColumnDefn(String string) throws tinySQLException {
        String string2;
        String string3;
        FieldTokenizer fieldTokenizer = new FieldTokenizer(string.toUpperCase(), ' ', false);
        if (fieldTokenizer.countFields() < 2) {
            this.throwException(2);
        }
        if ((string3 = fieldTokenizer.getField(0)).charAt(0) == '\"' & string3.charAt(string3.length() - 1) == '\"') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (string3.length() > 11) {
            string3 = tinySQLGlobals.getShortName(string3);
        }
        tsColumn tsColumn2 = new tsColumn(string3);
        String string4 = "";
        int n = 1;
        while (n < fieldTokenizer.countFields()) {
            string4 = string4 + fieldTokenizer.getField(1);
            ++n;
        }
        fieldTokenizer = new FieldTokenizer(string4, '(', false);
        string4 = fieldTokenizer.getField(0);
        tsColumn2.size = 10;
        tsColumn2.decimalPlaces = 0;
        if (string4.equals("FLOAT")) {
            tsColumn2.size = 12;
            tsColumn2.decimalPlaces = 2;
        }
        if (!(string2 = fieldTokenizer.getField(1)).equals("NULL")) {
            fieldTokenizer = new FieldTokenizer(string2, ',', false);
            tsColumn2.size = fieldTokenizer.getInt(0, 8);
            tsColumn2.decimalPlaces = fieldTokenizer.getInt(1, 0);
        }
        tsColumn2.type = Integer.MIN_VALUE;
        n = 0;
        while (n < this.colTypeNames.length) {
            if (string4.equals(this.colTypeNames[n])) {
                tsColumn2.type = this.colTypes[n];
            }
            ++n;
        }
        if (tsColumn2.type == Integer.MIN_VALUE) {
            this.throwException(8);
        }
        if (tinySQLGlobals.PARSER_DEBUG) {
            System.out.println("Column " + tsColumn2.name + ", type is " + tsColumn2.type + ",size is " + tsColumn2.size + ",precision is " + tsColumn2.decimalPlaces);
        }
        return tsColumn2;
    }

    public int getKeywordIndex(String string, String string2) {
        String[][] stringArrayArray = new String[][]{{"SELECT", "FROM", "WHERE", "GROUP", "ORDER", "BY"}, {"INSERT", "INTO", "VALUES"}, {"DROP", "TABLE"}, {"DELETE", "FROM", "WHERE"}, {"CREATE", "TABLE"}, {"UPDATE", "SET", "WHERE"}, {"ALTER", "TABLE", "DROP", "MODIFY", "ADD", "RENAME"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            int n2 = 0;
            while (n2 < stringArrayArray[n].length) {
                if (stringArrayArray[n][0].equals(string) & stringArrayArray[n][n2].equals(string2)) {
                    return n2;
                }
                ++n2;
            }
            ++n;
        }
        return Integer.MIN_VALUE;
    }

    public void addAction() throws tinySQLException, CloneNotSupportedException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TYPE", this.statementType);
        if (this.statementType.equals("SELECT")) {
            hashtable.put("TABLES", this.tables);
            if (this.whereClause != (tinySQLWhere)null) {
                hashtable.put("WHERE", this.whereClause);
            }
            this.validateColumns();
            if (this.defaultOrderBy) {
                int n = this.columns.size();
                int n2 = 0;
                while (n2 < n) {
                    tsColumn tsColumn2 = (tsColumn)this.columns.elementAt(n2);
                    if (tsColumn2.getContext("SELECT")) {
                        tsColumn2.addContext("ORDER");
                    }
                    ++n2;
                }
            }
            hashtable.put("COLUMNS", this.columns);
            if (this.orderType != (String)null) {
                hashtable.put("ORDER_TYPE", this.orderType);
            }
            if (this.distinct) {
                hashtable.put("DISTINCT", "TRUE");
            }
        } else if (this.statementType.equals("DROP_TABLE")) {
            hashtable.put("TABLE", this.tableName);
        } else if (this.statementType.equals("CREATE_TABLE")) {
            hashtable.put("TABLE", this.tableName);
            hashtable.put("COLUMN_DEF", this.columnList);
        } else if (this.statementType.equals("ALTER_RENAME")) {
            hashtable.put("TABLE", this.tableName);
            hashtable.put("OLD_COLUMN", this.oldColumnName);
            hashtable.put("NEW_COLUMN", this.newColumnName);
        } else if (this.statementType.equals("ALTER_ADD")) {
            hashtable.put("TABLE", this.tableName);
            hashtable.put("COLUMN_DEF", this.columnList);
        } else if (this.statementType.equals("ALTER_DROP")) {
            hashtable.put("TABLE", this.tableName);
            hashtable.put("COLUMNS", this.columnList);
        } else if (this.statementType.equals("DELETE")) {
            hashtable.put("TABLE", this.tableName);
            if (this.whereClause != (tinySQLWhere)null) {
                hashtable.put("WHERE", this.whereClause);
            }
        } else if (this.statementType.equals("INSERT") | this.statementType.equals("UPDATE")) {
            hashtable.put("TABLE", this.tableName);
            if (this.columnList.size() != this.valueList.size()) {
                this.throwException(5);
            }
            hashtable.put("COLUMNS", this.columnList);
            hashtable.put("VALUES", this.valueList);
            if (this.whereClause != (tinySQLWhere)null) {
                hashtable.put("WHERE", this.whereClause);
            }
        }
        this.actionList.addElement(hashtable);
    }

    public void throwException(int n) throws tinySQLException {
        this.throwException(n, null);
    }

    public void throwException(int n, String string) throws tinySQLException {
        String string2 = null;
        if (n == 1) {
            string2 = "CREATE TABLE must be followed by a table name and a list of column specifications enclosed in brackets.";
        } else if (n == 2) {
            string2 = "A column specification must consist of a column name followed by a column type specification.";
        } else if (n == 3) {
            string2 = "INTO should be followed by a table name and a list of columns enclosed in backets.";
        } else if (n == 4) {
            string2 = "SET must be followed by assignments in the form <columnName>=<value>.";
        } else if (n == 5) {
            string2 = "INSERT statement number of columns and values provided do not match.";
        } else if (n == 6) {
            string2 = "BY cannot be the first keyword.";
        } else if (n == 7) {
            string2 = "ORDER BY can only be followed by the ASC or DESC directives";
        } else if (n == 8) {
            string2 = "Supported column types are INT,CHAR,FLOAT,DATE";
        } else if (n == 9) {
            string2 = "Expecting SELECT, INSERT, ALTER, etc. in " + this.statementType;
        } else if (n == 10) {
            string2 = "Unrecognized keyword ";
        }
        throw new tinySQLException(string2);
    }

    public Vector getActions() {
        return this.actionList;
    }
}

