package CParse::Parser::Token::Character;

use 5.6.0;
use strict;
use warnings;

use CParse::Char;
use CParse::String qw/escape unescape/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $str = shift;
    my $line = shift;
    my $pos = shift;

    my $wide;

    if ($str =~ s/^L//)
      {
        $wide = 1;
      }
    else
      {
        $wide = 0;
      }

    $str =~ /^L?'(.*)'$/ or die;
    my $char = unescape($1);

    if (length $char == 0)
      {
        die "Empty character constants not supported";
      }

    if (length $char > 1)
      {
        die "Multi-character constants not supported";
      }

    my $self = {value => $char,
                wide => $wide,
                line => $line,
                pos => $pos,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $value = escape($self->{value});

    return $self->{wide} ? "L'$value'" : "'$value'";
  }

sub process
  {
    my $self = shift;

    return new CParse::Char $self->{value}, $self->{wide};
  }

1;
