%{
#define YYSTYPE double
#include <stdio.h>
// yylex() is generated by flex 
int yylex(void);
// we have to define yyerror()
int yyerror (char const *);

%}
%token NUMBER

%left '+' '-'
%left '*' '/'
%right '('

%%
stmtlist: statement '\n' stmtlist {
	printf("done with statement equal to [%g]\n", $1);
	} | // EMPTY RULE i.e. stmtlist -> nil
	{ printf("DONE\n") ;};

statement:	expression { printf("VALUE=%g\n",$1); };

expression:	expression '+' expression { $$ = $1 + $3; } |
		expression '-' expression { $$ = $1 - $3; } |
		expression '*' expression { $$ = $1 * $3; } |
		expression '/' expression { 
			if($3 !=0) { $$ = $1 / $3; } else 
			{ printf("div by zero\n"); $$=0;} } |
		'(' expression ')' { $$ = $2; } |
		NUMBER { $$ = $1; } ;

%%
