/*
 * animation.h
 * This file is part of gtk-nodoka-engine
 *
 * Copyright (C) 2007, 2008 - Martin Sourada, Daniel Geiger
 *
 * gtk-nodoka-engine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtk-nodoka-engine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gtk-nodoka-engine; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */ 

#include "config.h"

#ifdef HAVE_ANIMATION
#include <gtk/gtk.h>

#define NDK_IS_PROGRESS_BAR(widget) GTK_IS_PROGRESS_BAR(widget) && widget->allocation.x != -1 && widget->allocation.y != -1
#define ANIMATION_DELAY 100
#define CHECK_ANIMATION_TIME 0.5

G_GNUC_INTERNAL void nodoka_animation_progressbar_add (GtkWidget * progressbar);
G_GNUC_INTERNAL void nodoka_animation_connect_checkbox (GtkWidget * widget);
G_GNUC_INTERNAL gboolean nodoka_animation_is_animated (GtkWidget * widget);
G_GNUC_INTERNAL gdouble nodoka_animation_elapsed (gpointer data);
G_GNUC_INTERNAL void nodoka_animation_cleanup ();
#endif /* HAVE_ANIMATION */
