/* grid.c generated by valac 0.41.91, the Vala compiler
 * generated from grid.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
 * Copyright (C) 2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;
typedef struct _GridPrivate GridPrivate;
enum  {
	GRID_0_PROPERTY,
	GRID_ROWS_PROPERTY,
	GRID_COLS_PROPERTY,
	GRID_TARGET_VALUE_PROPERTY,
	GRID_TARGET_VALUE_REACHED_PROPERTY,
	GRID_NUM_PROPERTIES
};
static GParamSpec* grid_properties[GRID_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TILE (tile_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _Tile Tile;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Grid {
	GObject parent_instance;
	GridPrivate * priv;
};

struct _GridClass {
	GObjectClass parent_class;
};

struct _GridPrivate {
	guint* _grid;
	gint _grid_length1;
	gint _grid_length2;
	gint _rows;
	gint _cols;
	guint _target_value;
	gboolean _target_value_reached;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};


static gint Grid_private_offset;
static gpointer grid_parent_class = NULL;

GType grid_get_type (void) G_GNUC_CONST;
Grid* grid_new (gint rows,
                gint cols);
Grid* grid_construct (GType object_type,
                      gint rows,
                      gint cols);
void grid_clear (Grid* self);
Grid* grid_clone (Grid* self);
static guint* _vala_array_dup1 (guint* self,
                         int length);
GType tile_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
gboolean grid_new_tile (Grid* self,
                        Tile* tile);
static gboolean _grid_grid_is_full (Grid* self);
static void _grid_random_position (Grid* self,
                            GridPosition* result);
static void _grid_check_target_value_reached (Grid* self,
                                       guint val);
GType tile_movement_get_type (void) G_GNUC_CONST;
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
void grid_move_down (Grid* self,
                     GeeLinkedList* to_move,
                     GeeLinkedList* to_hide,
                     GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
void grid_move_up (Grid* self,
                   GeeLinkedList* to_move,
                   GeeLinkedList* to_hide,
                   GeeLinkedList* to_show);
void grid_move_left (Grid* self,
                     GeeLinkedList* to_move,
                     GeeLinkedList* to_hide,
                     GeeLinkedList* to_show);
void grid_move_right (Grid* self,
                      GeeLinkedList* to_move,
                      GeeLinkedList* to_hide,
                      GeeLinkedList* to_show);
gboolean grid_is_finished (Grid* self);
guint grid_get (Grid* self,
                gint row,
                gint col);
gchar* grid_save (Grid* self);
static gchar* _grid_convert_to_string (Grid* self);
gboolean grid_load (Grid* self,
                    const gchar* content);
static gboolean _grid_load_from_string (Grid* self,
                                 const gchar* contents);
gchar* grid_to_string (Grid* self);
static guint* _vala_array_dup2 (guint* self,
                         int length);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self,
                                    gboolean value);
gint grid_get_rows (Grid* self);
void grid_set_rows (Grid* self,
                    gint value);
gint grid_get_cols (Grid* self);
void grid_set_cols (Grid* self,
                    gint value);
void grid_set_target_value (Grid* self,
                            guint value);
gboolean grid_get_target_value_reached (Grid* self);
static void grid_finalize (GObject * obj);
static void _vala_grid_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_grid_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static inline gpointer
grid_get_instance_private (Grid* self)
{
	return G_STRUCT_MEMBER_P (self, Grid_private_offset);
}


Grid*
grid_construct (GType object_type,
                gint rows,
                gint cols)
{
	Grid * self = NULL;
	guint* _tmp0_;
	self = (Grid*) g_object_new (object_type, "rows", rows, "cols", cols, NULL);
	_tmp0_ = g_new0 (guint, rows * cols);
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
	self->priv->_grid = _tmp0_;
	self->priv->_grid_length1 = rows;
	self->priv->_grid_length2 = cols;
	grid_clear (self);
	self->priv->_target_value = (guint) 0;
	return self;
}


Grid*
grid_new (gint rows,
          gint cols)
{
	return grid_construct (TYPE_GRID, rows, cols);
}


static guint*
_vala_array_dup1 (guint* self,
                  int length)
{
	return g_memdup (self, length * sizeof (guint));
}


Grid*
grid_clone (Grid* self)
{
	Grid* result = NULL;
	Grid* grid = NULL;
	gint _tmp0_;
	gint _tmp1_;
	Grid* _tmp2_;
	guint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	guint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	guint _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = grid_new (_tmp0_, _tmp1_);
	grid = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp3__length1 = self->priv->_grid_length1;
	_tmp3__length2 = self->priv->_grid_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	grid->priv->_grid = (g_free (grid->priv->_grid), NULL);
	grid->priv->_grid = _tmp4_;
	grid->priv->_grid_length1 = _tmp4__length1;
	grid->priv->_grid_length2 = _tmp4__length2;
	_tmp5_ = self->priv->_target_value;
	grid->priv->_target_value = _tmp5_;
	_tmp6_ = self->priv->_target_value_reached;
	grid->priv->_target_value_reached = _tmp6_;
	result = grid;
	return result;
}


void
grid_clear (Grid* self)
{
	g_return_if_fail (self != NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint* _tmp3_;
				gint _tmp3__length1;
				gint _tmp3__length2;
				gint _tmp4_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_grid;
				_tmp3__length1 = self->priv->_grid_length1;
				_tmp3__length2 = self->priv->_grid_length2;
				_tmp4_ = _tmp3__length1;
				if (!(_tmp2_ < ((guint) _tmp4_))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							guint _tmp7_;
							guint* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							guint* _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							guint _tmp11_;
							guint _tmp12_;
							guint _tmp13_;
							if (!_tmp5_) {
								guint _tmp6_;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = j;
							_tmp8_ = self->priv->_grid;
							_tmp8__length1 = self->priv->_grid_length1;
							_tmp8__length2 = self->priv->_grid_length2;
							_tmp9_ = _tmp8__length2;
							if (!(_tmp7_ < ((guint) _tmp9_))) {
								break;
							}
							_tmp10_ = self->priv->_grid;
							_tmp10__length1 = self->priv->_grid_length1;
							_tmp10__length2 = self->priv->_grid_length2;
							_tmp11_ = i;
							_tmp12_ = j;
							_tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_] = (guint) 0;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
						}
					}
				}
			}
		}
	}
}


gboolean
grid_new_tile (Grid* self,
               Tile* tile)
{
	Tile _vala_tile = {0};
	gboolean result = FALSE;
	GridPosition pos = {0};
	GridPosition _tmp0_ = {0};
	guint val = 0U;
	GridPosition _tmp1_;
	Tile _tmp2_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_.row = (guint) 0;
	_tmp0_.col = (guint) 0;
	pos = _tmp0_;
	_tmp1_ = pos;
	_tmp2_.pos = _tmp1_;
	_tmp2_.val = (guint) 0;
	_vala_tile = _tmp2_;
	if (_grid_grid_is_full (self)) {
		result = FALSE;
		if (tile) {
			*tile = _vala_tile;
		}
		return result;
	}
	val = (guint) 2;
	while (TRUE) {
		GridPosition _tmp3_ = {0};
		guint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		GridPosition _tmp5_;
		guint _tmp6_;
		GridPosition _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		_grid_random_position (self, &_tmp3_);
		pos = _tmp3_;
		_tmp4_ = self->priv->_grid;
		_tmp4__length1 = self->priv->_grid_length1;
		_tmp4__length2 = self->priv->_grid_length2;
		_tmp5_ = pos;
		_tmp6_ = _tmp5_.row;
		_tmp7_ = pos;
		_tmp8_ = _tmp7_.col;
		_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
		if (_tmp9_ == ((guint) 0)) {
			guint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp10__length2;
			GridPosition _tmp11_;
			guint _tmp12_;
			GridPosition _tmp13_;
			guint _tmp14_;
			guint _tmp15_;
			guint _tmp16_;
			guint _tmp17_;
			GridPosition _tmp18_;
			guint _tmp19_;
			Tile _tmp20_ = {0};
			_tmp10_ = self->priv->_grid;
			_tmp10__length1 = self->priv->_grid_length1;
			_tmp10__length2 = self->priv->_grid_length2;
			_tmp11_ = pos;
			_tmp12_ = _tmp11_.row;
			_tmp13_ = pos;
			_tmp14_ = _tmp13_.col;
			_tmp15_ = val;
			_tmp10_[(_tmp12_ * _tmp10__length2) + _tmp14_] = _tmp15_;
			_tmp16_ = _tmp10_[(_tmp12_ * _tmp10__length2) + _tmp14_];
			_tmp17_ = val;
			_grid_check_target_value_reached (self, _tmp17_);
			_tmp18_ = pos;
			_tmp19_ = val;
			_tmp20_.pos = _tmp18_;
			_tmp20_.val = _tmp19_;
			_vala_tile = _tmp20_;
			result = TRUE;
			if (tile) {
				*tile = _vala_tile;
			}
			return result;
		}
	}
	if (tile) {
		*tile = _vala_tile;
	}
}


void
grid_move_down (Grid* self,
                GeeLinkedList* to_move,
                GeeLinkedList* to_hide,
                GeeLinkedList* to_show)
{
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_move);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_hide);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_show);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GridPosition _tmp6_ = {0};
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_cols;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = self->priv->_rows;
				_tmp5_ = i;
				_tmp6_.row = (guint) _tmp4_;
				_tmp6_.col = (guint) _tmp5_;
				free = _tmp6_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							GridPosition _tmp15_ = {0};
							guint* _tmp16_;
							gint _tmp16__length1;
							gint _tmp16__length2;
							GridPosition _tmp17_;
							guint _tmp18_;
							GridPosition _tmp19_;
							guint _tmp20_;
							guint _tmp21_;
							guint _tmp22_;
							GridPosition _tmp27_ = {0};
							gboolean _tmp44_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = j;
							_tmp10_ = self->priv->_rows;
							if (!(_tmp9_ < _tmp10_)) {
								break;
							}
							_tmp11_ = self->priv->_rows;
							_tmp12_ = j;
							row = (_tmp11_ - _tmp12_) - 1;
							_tmp13_ = row;
							_tmp14_ = i;
							_tmp15_.row = (guint) _tmp13_;
							_tmp15_.col = (guint) _tmp14_;
							cur = _tmp15_;
							_tmp16_ = self->priv->_grid;
							_tmp16__length1 = self->priv->_grid_length1;
							_tmp16__length2 = self->priv->_grid_length2;
							_tmp17_ = cur;
							_tmp18_ = _tmp17_.row;
							_tmp19_ = cur;
							_tmp20_ = _tmp19_.col;
							_tmp21_ = _tmp16_[(_tmp18_ * _tmp16__length2) + _tmp20_];
							val = _tmp21_;
							_tmp22_ = val;
							if (_tmp22_ == ((guint) 0)) {
								GridPosition _tmp23_;
								guint _tmp24_;
								gint _tmp25_;
								_tmp23_ = free;
								_tmp24_ = _tmp23_.row;
								_tmp25_ = self->priv->_rows;
								if (_tmp24_ == ((guint) _tmp25_)) {
									gint _tmp26_;
									_tmp26_ = row;
									free.row = (guint) _tmp26_;
								}
								continue;
							}
							_tmp27_.row = (guint) 0;
							_tmp27_.col = (guint) 0;
							match = _tmp27_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp28_;
								_tmp28_ = row;
								k = _tmp28_ - 1;
								{
									gboolean _tmp29_ = FALSE;
									_tmp29_ = TRUE;
									while (TRUE) {
										gint _tmp31_;
										guint k_val = 0U;
										guint* _tmp32_;
										gint _tmp32__length1;
										gint _tmp32__length2;
										gint _tmp33_;
										GridPosition _tmp34_;
										guint _tmp35_;
										guint _tmp36_;
										guint _tmp37_;
										if (!_tmp29_) {
											gint _tmp30_;
											_tmp30_ = k;
											k = _tmp30_ - 1;
										}
										_tmp29_ = FALSE;
										_tmp31_ = k;
										if (!(_tmp31_ >= 0)) {
											break;
										}
										_tmp32_ = self->priv->_grid;
										_tmp32__length1 = self->priv->_grid_length1;
										_tmp32__length2 = self->priv->_grid_length2;
										_tmp33_ = k;
										_tmp34_ = cur;
										_tmp35_ = _tmp34_.col;
										_tmp36_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp35_];
										k_val = _tmp36_;
										_tmp37_ = k_val;
										if (_tmp37_ != ((guint) 0)) {
											guint _tmp38_;
											guint _tmp39_;
											_tmp38_ = k_val;
											_tmp39_ = val;
											if (_tmp38_ == _tmp39_) {
												gint _tmp40_;
												GridPosition _tmp41_;
												guint _tmp42_;
												GridPosition _tmp43_ = {0};
												has_match = TRUE;
												_tmp40_ = k;
												_tmp41_ = cur;
												_tmp42_ = _tmp41_.col;
												_tmp43_.row = (guint) _tmp40_;
												_tmp43_.col = _tmp42_;
												match = _tmp43_;
											}
											break;
										}
									}
								}
							}
							_tmp44_ = has_match;
							if (_tmp44_) {
								gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								GridPosition _tmp49_;
								guint _tmp50_;
								gint _tmp51_;
								GridPosition _tmp53_;
								GridPosition _tmp54_;
								TileMovement _tmp55_ = {0};
								TileMovement _tmp56_;
								GridPosition _tmp57_;
								GridPosition _tmp58_;
								TileMovement _tmp59_ = {0};
								TileMovement _tmp60_;
								GridPosition _tmp61_;
								guint _tmp62_;
								Tile _tmp63_ = {0};
								Tile _tmp64_;
								guint* _tmp65_;
								gint _tmp65__length1;
								gint _tmp65__length2;
								GridPosition _tmp66_;
								guint _tmp67_;
								GridPosition _tmp68_;
								guint _tmp69_;
								guint _tmp70_;
								guint* _tmp71_;
								gint _tmp71__length1;
								gint _tmp71__length2;
								GridPosition _tmp72_;
								guint _tmp73_;
								GridPosition _tmp74_;
								guint _tmp75_;
								guint _tmp76_;
								guint* _tmp77_;
								gint _tmp77__length1;
								gint _tmp77__length2;
								GridPosition _tmp78_;
								guint _tmp79_;
								GridPosition _tmp80_;
								guint _tmp81_;
								guint _tmp82_;
								guint _tmp83_;
								guint _tmp84_;
								guint _tmp85_;
								_tmp45_ = grid_position_to_string (&match);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strconcat ("matching tile found at ", _tmp46_, NULL);
								_tmp48_ = _tmp47_;
								g_debug ("grid.vala:145: %s", _tmp48_);
								_g_free0 (_tmp48_);
								_g_free0 (_tmp46_);
								_tmp49_ = free;
								_tmp50_ = _tmp49_.row;
								_tmp51_ = self->priv->_rows;
								if (_tmp50_ == ((guint) _tmp51_)) {
									gint _tmp52_;
									_tmp52_ = row;
									free.row = (guint) _tmp52_;
								}
								_tmp53_ = cur;
								_tmp54_ = free;
								_tmp55_.from = _tmp53_;
								_tmp55_.to = _tmp54_;
								mov = _tmp55_;
								_tmp56_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp56_);
								_tmp57_ = match;
								_tmp58_ = free;
								_tmp59_.from = _tmp57_;
								_tmp59_.to = _tmp58_;
								mov = _tmp59_;
								_tmp60_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp60_);
								_tmp61_ = free;
								_tmp62_ = val;
								_tmp63_.pos = _tmp61_;
								_tmp63_.val = _tmp62_ * 2;
								tile = _tmp63_;
								_tmp64_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_show, &_tmp64_);
								_tmp65_ = self->priv->_grid;
								_tmp65__length1 = self->priv->_grid_length1;
								_tmp65__length2 = self->priv->_grid_length2;
								_tmp66_ = cur;
								_tmp67_ = _tmp66_.row;
								_tmp68_ = cur;
								_tmp69_ = _tmp68_.col;
								_tmp65_[(_tmp67_ * _tmp65__length2) + _tmp69_] = (guint) 0;
								_tmp70_ = _tmp65_[(_tmp67_ * _tmp65__length2) + _tmp69_];
								_tmp71_ = self->priv->_grid;
								_tmp71__length1 = self->priv->_grid_length1;
								_tmp71__length2 = self->priv->_grid_length2;
								_tmp72_ = match;
								_tmp73_ = _tmp72_.row;
								_tmp74_ = match;
								_tmp75_ = _tmp74_.col;
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
								_tmp77_ = self->priv->_grid;
								_tmp77__length1 = self->priv->_grid_length1;
								_tmp77__length2 = self->priv->_grid_length2;
								_tmp78_ = free;
								_tmp79_ = _tmp78_.row;
								_tmp80_ = free;
								_tmp81_ = _tmp80_.col;
								_tmp82_ = val;
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = _tmp82_ * 2;
								_tmp83_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
								_tmp84_ = val;
								_grid_check_target_value_reached (self, _tmp84_ * 2);
								_tmp85_ = free.row;
								free.row = _tmp85_ - 1;
							} else {
								GridPosition _tmp86_;
								guint _tmp87_;
								gint _tmp88_;
								_tmp86_ = free;
								_tmp87_ = _tmp86_.row;
								_tmp88_ = self->priv->_rows;
								if (_tmp87_ != ((guint) _tmp88_)) {
									gchar* _tmp89_;
									gchar* _tmp90_;
									gchar* _tmp91_;
									gchar* _tmp92_;
									gchar* _tmp93_;
									gchar* _tmp94_;
									GridPosition _tmp95_;
									GridPosition _tmp96_;
									TileMovement _tmp97_ = {0};
									TileMovement _tmp98_;
									guint* _tmp99_;
									gint _tmp99__length1;
									gint _tmp99__length2;
									GridPosition _tmp100_;
									guint _tmp101_;
									GridPosition _tmp102_;
									guint _tmp103_;
									guint _tmp104_;
									guint* _tmp105_;
									gint _tmp105__length1;
									gint _tmp105__length2;
									GridPosition _tmp106_;
									guint _tmp107_;
									GridPosition _tmp108_;
									guint _tmp109_;
									guint _tmp110_;
									guint _tmp111_;
									guint _tmp112_;
									_tmp89_ = grid_position_to_string (&cur);
									_tmp90_ = _tmp89_;
									_tmp91_ = grid_position_to_string (&free);
									_tmp92_ = _tmp91_;
									_tmp93_ = g_strconcat ("moving ", _tmp90_, " to ", _tmp92_, NULL);
									_tmp94_ = _tmp93_;
									g_debug ("grid.vala:167: %s", _tmp94_);
									_g_free0 (_tmp94_);
									_g_free0 (_tmp92_);
									_g_free0 (_tmp90_);
									_tmp95_ = cur;
									_tmp96_ = free;
									_tmp97_.from = _tmp95_;
									_tmp97_.to = _tmp96_;
									mov = _tmp97_;
									_tmp98_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) to_move, &_tmp98_);
									_tmp99_ = self->priv->_grid;
									_tmp99__length1 = self->priv->_grid_length1;
									_tmp99__length2 = self->priv->_grid_length2;
									_tmp100_ = cur;
									_tmp101_ = _tmp100_.row;
									_tmp102_ = cur;
									_tmp103_ = _tmp102_.col;
									_tmp99_[(_tmp101_ * _tmp99__length2) + _tmp103_] = (guint) 0;
									_tmp104_ = _tmp99_[(_tmp101_ * _tmp99__length2) + _tmp103_];
									_tmp105_ = self->priv->_grid;
									_tmp105__length1 = self->priv->_grid_length1;
									_tmp105__length2 = self->priv->_grid_length2;
									_tmp106_ = free;
									_tmp107_ = _tmp106_.row;
									_tmp108_ = free;
									_tmp109_ = _tmp108_.col;
									_tmp110_ = val;
									_tmp105_[(_tmp107_ * _tmp105__length2) + _tmp109_] = _tmp110_;
									_tmp111_ = _tmp105_[(_tmp107_ * _tmp105__length2) + _tmp109_];
									_tmp112_ = free.row;
									free.row = _tmp112_ - 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


void
grid_move_up (Grid* self,
              GeeLinkedList* to_move,
              GeeLinkedList* to_hide,
              GeeLinkedList* to_show)
{
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_move);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_hide);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_show);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GridPosition _tmp5_ = {0};
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_cols;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_.row = (guint) -1;
				_tmp5_.col = (guint) _tmp4_;
				free = _tmp5_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							GridPosition _tmp13_ = {0};
							guint* _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							GridPosition _tmp15_;
							guint _tmp16_;
							GridPosition _tmp17_;
							guint _tmp18_;
							guint _tmp19_;
							guint _tmp20_;
							GridPosition _tmp24_ = {0};
							gboolean _tmp42_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = j;
							_tmp9_ = self->priv->_rows;
							if (!(_tmp8_ < _tmp9_)) {
								break;
							}
							_tmp10_ = j;
							row = _tmp10_;
							_tmp11_ = row;
							_tmp12_ = i;
							_tmp13_.row = (guint) _tmp11_;
							_tmp13_.col = (guint) _tmp12_;
							cur = _tmp13_;
							_tmp14_ = self->priv->_grid;
							_tmp14__length1 = self->priv->_grid_length1;
							_tmp14__length2 = self->priv->_grid_length2;
							_tmp15_ = cur;
							_tmp16_ = _tmp15_.row;
							_tmp17_ = cur;
							_tmp18_ = _tmp17_.col;
							_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
							val = _tmp19_;
							_tmp20_ = val;
							if (_tmp20_ == ((guint) 0)) {
								GridPosition _tmp21_;
								guint _tmp22_;
								_tmp21_ = free;
								_tmp22_ = _tmp21_.row;
								if (_tmp22_ == ((guint) -1)) {
									gint _tmp23_;
									_tmp23_ = row;
									free.row = (guint) _tmp23_;
								}
								continue;
							}
							_tmp24_.row = (guint) 0;
							_tmp24_.col = (guint) 0;
							match = _tmp24_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp25_;
								_tmp25_ = row;
								k = _tmp25_ + 1;
								{
									gboolean _tmp26_ = FALSE;
									_tmp26_ = TRUE;
									while (TRUE) {
										gint _tmp28_;
										gint _tmp29_;
										guint k_val = 0U;
										guint* _tmp30_;
										gint _tmp30__length1;
										gint _tmp30__length2;
										gint _tmp31_;
										GridPosition _tmp32_;
										guint _tmp33_;
										guint _tmp34_;
										guint _tmp35_;
										if (!_tmp26_) {
											gint _tmp27_;
											_tmp27_ = k;
											k = _tmp27_ + 1;
										}
										_tmp26_ = FALSE;
										_tmp28_ = k;
										_tmp29_ = self->priv->_rows;
										if (!(_tmp28_ < _tmp29_)) {
											break;
										}
										_tmp30_ = self->priv->_grid;
										_tmp30__length1 = self->priv->_grid_length1;
										_tmp30__length2 = self->priv->_grid_length2;
										_tmp31_ = k;
										_tmp32_ = cur;
										_tmp33_ = _tmp32_.col;
										_tmp34_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp33_];
										k_val = _tmp34_;
										_tmp35_ = k_val;
										if (_tmp35_ != ((guint) 0)) {
											guint _tmp36_;
											guint _tmp37_;
											_tmp36_ = k_val;
											_tmp37_ = val;
											if (_tmp36_ == _tmp37_) {
												gint _tmp38_;
												GridPosition _tmp39_;
												guint _tmp40_;
												GridPosition _tmp41_ = {0};
												has_match = TRUE;
												_tmp38_ = k;
												_tmp39_ = cur;
												_tmp40_ = _tmp39_.col;
												_tmp41_.row = (guint) _tmp38_;
												_tmp41_.col = _tmp40_;
												match = _tmp41_;
											}
											break;
										}
									}
								}
							}
							_tmp42_ = has_match;
							if (_tmp42_) {
								gchar* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
								gchar* _tmp46_;
								GridPosition _tmp47_;
								guint _tmp48_;
								GridPosition _tmp50_;
								GridPosition _tmp51_;
								TileMovement _tmp52_ = {0};
								TileMovement _tmp53_;
								GridPosition _tmp54_;
								GridPosition _tmp55_;
								TileMovement _tmp56_ = {0};
								TileMovement _tmp57_;
								GridPosition _tmp58_;
								guint _tmp59_;
								Tile _tmp60_ = {0};
								Tile _tmp61_;
								guint* _tmp62_;
								gint _tmp62__length1;
								gint _tmp62__length2;
								GridPosition _tmp63_;
								guint _tmp64_;
								GridPosition _tmp65_;
								guint _tmp66_;
								guint _tmp67_;
								guint* _tmp68_;
								gint _tmp68__length1;
								gint _tmp68__length2;
								GridPosition _tmp69_;
								guint _tmp70_;
								GridPosition _tmp71_;
								guint _tmp72_;
								guint _tmp73_;
								guint* _tmp74_;
								gint _tmp74__length1;
								gint _tmp74__length2;
								GridPosition _tmp75_;
								guint _tmp76_;
								GridPosition _tmp77_;
								guint _tmp78_;
								guint _tmp79_;
								guint _tmp80_;
								guint _tmp81_;
								guint _tmp82_;
								_tmp43_ = grid_position_to_string (&match);
								_tmp44_ = _tmp43_;
								_tmp45_ = g_strconcat ("matching tile found at ", _tmp44_, NULL);
								_tmp46_ = _tmp45_;
								g_debug ("grid.vala:235: %s", _tmp46_);
								_g_free0 (_tmp46_);
								_g_free0 (_tmp44_);
								_tmp47_ = free;
								_tmp48_ = _tmp47_.row;
								if (_tmp48_ == ((guint) -1)) {
									gint _tmp49_;
									_tmp49_ = row;
									free.row = (guint) _tmp49_;
								}
								_tmp50_ = cur;
								_tmp51_ = free;
								_tmp52_.from = _tmp50_;
								_tmp52_.to = _tmp51_;
								mov = _tmp52_;
								_tmp53_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp53_);
								_tmp54_ = match;
								_tmp55_ = free;
								_tmp56_.from = _tmp54_;
								_tmp56_.to = _tmp55_;
								mov = _tmp56_;
								_tmp57_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp57_);
								_tmp58_ = free;
								_tmp59_ = val;
								_tmp60_.pos = _tmp58_;
								_tmp60_.val = _tmp59_ * 2;
								tile = _tmp60_;
								_tmp61_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_show, &_tmp61_);
								_tmp62_ = self->priv->_grid;
								_tmp62__length1 = self->priv->_grid_length1;
								_tmp62__length2 = self->priv->_grid_length2;
								_tmp63_ = cur;
								_tmp64_ = _tmp63_.row;
								_tmp65_ = cur;
								_tmp66_ = _tmp65_.col;
								_tmp62_[(_tmp64_ * _tmp62__length2) + _tmp66_] = (guint) 0;
								_tmp67_ = _tmp62_[(_tmp64_ * _tmp62__length2) + _tmp66_];
								_tmp68_ = self->priv->_grid;
								_tmp68__length1 = self->priv->_grid_length1;
								_tmp68__length2 = self->priv->_grid_length2;
								_tmp69_ = match;
								_tmp70_ = _tmp69_.row;
								_tmp71_ = match;
								_tmp72_ = _tmp71_.col;
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
								_tmp74_ = self->priv->_grid;
								_tmp74__length1 = self->priv->_grid_length1;
								_tmp74__length2 = self->priv->_grid_length2;
								_tmp75_ = free;
								_tmp76_ = _tmp75_.row;
								_tmp77_ = free;
								_tmp78_ = _tmp77_.col;
								_tmp79_ = val;
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = _tmp79_ * 2;
								_tmp80_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
								_tmp81_ = val;
								_grid_check_target_value_reached (self, _tmp81_ * 2);
								_tmp82_ = free.row;
								free.row = _tmp82_ + 1;
							} else {
								GridPosition _tmp83_;
								guint _tmp84_;
								_tmp83_ = free;
								_tmp84_ = _tmp83_.row;
								if (_tmp84_ != ((guint) -1)) {
									gchar* _tmp85_;
									gchar* _tmp86_;
									gchar* _tmp87_;
									gchar* _tmp88_;
									gchar* _tmp89_;
									gchar* _tmp90_;
									GridPosition _tmp91_;
									GridPosition _tmp92_;
									TileMovement _tmp93_ = {0};
									TileMovement _tmp94_;
									guint* _tmp95_;
									gint _tmp95__length1;
									gint _tmp95__length2;
									GridPosition _tmp96_;
									guint _tmp97_;
									GridPosition _tmp98_;
									guint _tmp99_;
									guint _tmp100_;
									guint* _tmp101_;
									gint _tmp101__length1;
									gint _tmp101__length2;
									GridPosition _tmp102_;
									guint _tmp103_;
									GridPosition _tmp104_;
									guint _tmp105_;
									guint _tmp106_;
									guint _tmp107_;
									guint _tmp108_;
									_tmp85_ = grid_position_to_string (&cur);
									_tmp86_ = _tmp85_;
									_tmp87_ = grid_position_to_string (&free);
									_tmp88_ = _tmp87_;
									_tmp89_ = g_strconcat ("moving ", _tmp86_, " to ", _tmp88_, NULL);
									_tmp90_ = _tmp89_;
									g_debug ("grid.vala:257: %s", _tmp90_);
									_g_free0 (_tmp90_);
									_g_free0 (_tmp88_);
									_g_free0 (_tmp86_);
									_tmp91_ = cur;
									_tmp92_ = free;
									_tmp93_.from = _tmp91_;
									_tmp93_.to = _tmp92_;
									mov = _tmp93_;
									_tmp94_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) to_move, &_tmp94_);
									_tmp95_ = self->priv->_grid;
									_tmp95__length1 = self->priv->_grid_length1;
									_tmp95__length2 = self->priv->_grid_length2;
									_tmp96_ = cur;
									_tmp97_ = _tmp96_.row;
									_tmp98_ = cur;
									_tmp99_ = _tmp98_.col;
									_tmp95_[(_tmp97_ * _tmp95__length2) + _tmp99_] = (guint) 0;
									_tmp100_ = _tmp95_[(_tmp97_ * _tmp95__length2) + _tmp99_];
									_tmp101_ = self->priv->_grid;
									_tmp101__length1 = self->priv->_grid_length1;
									_tmp101__length2 = self->priv->_grid_length2;
									_tmp102_ = free;
									_tmp103_ = _tmp102_.row;
									_tmp104_ = free;
									_tmp105_ = _tmp104_.col;
									_tmp106_ = val;
									_tmp101_[(_tmp103_ * _tmp101__length2) + _tmp105_] = _tmp106_;
									_tmp107_ = _tmp101_[(_tmp103_ * _tmp101__length2) + _tmp105_];
									_tmp108_ = free.row;
									free.row = _tmp108_ + 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


void
grid_move_left (Grid* self,
                GeeLinkedList* to_move,
                GeeLinkedList* to_hide,
                GeeLinkedList* to_show)
{
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_move);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_hide);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_show);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GridPosition _tmp5_ = {0};
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_.row = (guint) _tmp4_;
				_tmp5_.col = (guint) -1;
				free = _tmp5_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							GridPosition _tmp13_ = {0};
							guint* _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							GridPosition _tmp15_;
							guint _tmp16_;
							GridPosition _tmp17_;
							guint _tmp18_;
							guint _tmp19_;
							guint _tmp20_;
							GridPosition _tmp24_ = {0};
							gboolean _tmp42_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = j;
							_tmp9_ = self->priv->_cols;
							if (!(_tmp8_ < _tmp9_)) {
								break;
							}
							_tmp10_ = j;
							col = _tmp10_;
							_tmp11_ = i;
							_tmp12_ = col;
							_tmp13_.row = (guint) _tmp11_;
							_tmp13_.col = (guint) _tmp12_;
							cur = _tmp13_;
							_tmp14_ = self->priv->_grid;
							_tmp14__length1 = self->priv->_grid_length1;
							_tmp14__length2 = self->priv->_grid_length2;
							_tmp15_ = cur;
							_tmp16_ = _tmp15_.row;
							_tmp17_ = cur;
							_tmp18_ = _tmp17_.col;
							_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
							val = _tmp19_;
							_tmp20_ = val;
							if (_tmp20_ == ((guint) 0)) {
								GridPosition _tmp21_;
								guint _tmp22_;
								_tmp21_ = free;
								_tmp22_ = _tmp21_.col;
								if (_tmp22_ == ((guint) -1)) {
									gint _tmp23_;
									_tmp23_ = col;
									free.col = (guint) _tmp23_;
								}
								continue;
							}
							_tmp24_.row = (guint) 0;
							_tmp24_.col = (guint) 0;
							match = _tmp24_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp25_;
								_tmp25_ = col;
								k = _tmp25_ + 1;
								{
									gboolean _tmp26_ = FALSE;
									_tmp26_ = TRUE;
									while (TRUE) {
										gint _tmp28_;
										gint _tmp29_;
										guint k_val = 0U;
										guint* _tmp30_;
										gint _tmp30__length1;
										gint _tmp30__length2;
										GridPosition _tmp31_;
										guint _tmp32_;
										gint _tmp33_;
										guint _tmp34_;
										guint _tmp35_;
										if (!_tmp26_) {
											gint _tmp27_;
											_tmp27_ = k;
											k = _tmp27_ + 1;
										}
										_tmp26_ = FALSE;
										_tmp28_ = k;
										_tmp29_ = self->priv->_rows;
										if (!(_tmp28_ < _tmp29_)) {
											break;
										}
										_tmp30_ = self->priv->_grid;
										_tmp30__length1 = self->priv->_grid_length1;
										_tmp30__length2 = self->priv->_grid_length2;
										_tmp31_ = cur;
										_tmp32_ = _tmp31_.row;
										_tmp33_ = k;
										_tmp34_ = _tmp30_[(_tmp32_ * _tmp30__length2) + _tmp33_];
										k_val = _tmp34_;
										_tmp35_ = k_val;
										if (_tmp35_ != ((guint) 0)) {
											guint _tmp36_;
											guint _tmp37_;
											_tmp36_ = k_val;
											_tmp37_ = val;
											if (_tmp36_ == _tmp37_) {
												GridPosition _tmp38_;
												guint _tmp39_;
												gint _tmp40_;
												GridPosition _tmp41_ = {0};
												has_match = TRUE;
												_tmp38_ = cur;
												_tmp39_ = _tmp38_.row;
												_tmp40_ = k;
												_tmp41_.row = _tmp39_;
												_tmp41_.col = (guint) _tmp40_;
												match = _tmp41_;
											}
											break;
										}
									}
								}
							}
							_tmp42_ = has_match;
							if (_tmp42_) {
								gchar* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
								gchar* _tmp46_;
								GridPosition _tmp47_;
								guint _tmp48_;
								GridPosition _tmp50_;
								GridPosition _tmp51_;
								TileMovement _tmp52_ = {0};
								TileMovement _tmp53_;
								GridPosition _tmp54_;
								GridPosition _tmp55_;
								TileMovement _tmp56_ = {0};
								TileMovement _tmp57_;
								GridPosition _tmp58_;
								guint _tmp59_;
								Tile _tmp60_ = {0};
								Tile _tmp61_;
								guint* _tmp62_;
								gint _tmp62__length1;
								gint _tmp62__length2;
								GridPosition _tmp63_;
								guint _tmp64_;
								GridPosition _tmp65_;
								guint _tmp66_;
								guint _tmp67_;
								guint* _tmp68_;
								gint _tmp68__length1;
								gint _tmp68__length2;
								GridPosition _tmp69_;
								guint _tmp70_;
								GridPosition _tmp71_;
								guint _tmp72_;
								guint _tmp73_;
								guint* _tmp74_;
								gint _tmp74__length1;
								gint _tmp74__length2;
								GridPosition _tmp75_;
								guint _tmp76_;
								GridPosition _tmp77_;
								guint _tmp78_;
								guint _tmp79_;
								guint _tmp80_;
								guint _tmp81_;
								guint _tmp82_;
								_tmp43_ = grid_position_to_string (&match);
								_tmp44_ = _tmp43_;
								_tmp45_ = g_strconcat ("matching tile found at ", _tmp44_, NULL);
								_tmp46_ = _tmp45_;
								g_debug ("grid.vala:325: %s", _tmp46_);
								_g_free0 (_tmp46_);
								_g_free0 (_tmp44_);
								_tmp47_ = free;
								_tmp48_ = _tmp47_.col;
								if (_tmp48_ == ((guint) -1)) {
									gint _tmp49_;
									_tmp49_ = col;
									free.col = (guint) _tmp49_;
								}
								_tmp50_ = cur;
								_tmp51_ = free;
								_tmp52_.from = _tmp50_;
								_tmp52_.to = _tmp51_;
								mov = _tmp52_;
								_tmp53_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp53_);
								_tmp54_ = match;
								_tmp55_ = free;
								_tmp56_.from = _tmp54_;
								_tmp56_.to = _tmp55_;
								mov = _tmp56_;
								_tmp57_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp57_);
								_tmp58_ = free;
								_tmp59_ = val;
								_tmp60_.pos = _tmp58_;
								_tmp60_.val = _tmp59_ * 2;
								tile = _tmp60_;
								_tmp61_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_show, &_tmp61_);
								_tmp62_ = self->priv->_grid;
								_tmp62__length1 = self->priv->_grid_length1;
								_tmp62__length2 = self->priv->_grid_length2;
								_tmp63_ = cur;
								_tmp64_ = _tmp63_.row;
								_tmp65_ = cur;
								_tmp66_ = _tmp65_.col;
								_tmp62_[(_tmp64_ * _tmp62__length2) + _tmp66_] = (guint) 0;
								_tmp67_ = _tmp62_[(_tmp64_ * _tmp62__length2) + _tmp66_];
								_tmp68_ = self->priv->_grid;
								_tmp68__length1 = self->priv->_grid_length1;
								_tmp68__length2 = self->priv->_grid_length2;
								_tmp69_ = match;
								_tmp70_ = _tmp69_.row;
								_tmp71_ = match;
								_tmp72_ = _tmp71_.col;
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
								_tmp74_ = self->priv->_grid;
								_tmp74__length1 = self->priv->_grid_length1;
								_tmp74__length2 = self->priv->_grid_length2;
								_tmp75_ = free;
								_tmp76_ = _tmp75_.row;
								_tmp77_ = free;
								_tmp78_ = _tmp77_.col;
								_tmp79_ = val;
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = _tmp79_ * 2;
								_tmp80_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
								_tmp81_ = val;
								_grid_check_target_value_reached (self, _tmp81_ * 2);
								_tmp82_ = free.col;
								free.col = _tmp82_ + 1;
							} else {
								GridPosition _tmp83_;
								guint _tmp84_;
								_tmp83_ = free;
								_tmp84_ = _tmp83_.col;
								if (_tmp84_ != ((guint) -1)) {
									gchar* _tmp85_;
									gchar* _tmp86_;
									gchar* _tmp87_;
									gchar* _tmp88_;
									gchar* _tmp89_;
									gchar* _tmp90_;
									GridPosition _tmp91_;
									GridPosition _tmp92_;
									TileMovement _tmp93_ = {0};
									TileMovement _tmp94_;
									guint* _tmp95_;
									gint _tmp95__length1;
									gint _tmp95__length2;
									GridPosition _tmp96_;
									guint _tmp97_;
									GridPosition _tmp98_;
									guint _tmp99_;
									guint _tmp100_;
									guint* _tmp101_;
									gint _tmp101__length1;
									gint _tmp101__length2;
									GridPosition _tmp102_;
									guint _tmp103_;
									GridPosition _tmp104_;
									guint _tmp105_;
									guint _tmp106_;
									guint _tmp107_;
									guint _tmp108_;
									_tmp85_ = grid_position_to_string (&cur);
									_tmp86_ = _tmp85_;
									_tmp87_ = grid_position_to_string (&free);
									_tmp88_ = _tmp87_;
									_tmp89_ = g_strconcat ("moving ", _tmp86_, " to ", _tmp88_, NULL);
									_tmp90_ = _tmp89_;
									g_debug ("grid.vala:347: %s", _tmp90_);
									_g_free0 (_tmp90_);
									_g_free0 (_tmp88_);
									_g_free0 (_tmp86_);
									_tmp91_ = cur;
									_tmp92_ = free;
									_tmp93_.from = _tmp91_;
									_tmp93_.to = _tmp92_;
									mov = _tmp93_;
									_tmp94_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) to_move, &_tmp94_);
									_tmp95_ = self->priv->_grid;
									_tmp95__length1 = self->priv->_grid_length1;
									_tmp95__length2 = self->priv->_grid_length2;
									_tmp96_ = cur;
									_tmp97_ = _tmp96_.row;
									_tmp98_ = cur;
									_tmp99_ = _tmp98_.col;
									_tmp95_[(_tmp97_ * _tmp95__length2) + _tmp99_] = (guint) 0;
									_tmp100_ = _tmp95_[(_tmp97_ * _tmp95__length2) + _tmp99_];
									_tmp101_ = self->priv->_grid;
									_tmp101__length1 = self->priv->_grid_length1;
									_tmp101__length2 = self->priv->_grid_length2;
									_tmp102_ = free;
									_tmp103_ = _tmp102_.row;
									_tmp104_ = free;
									_tmp105_ = _tmp104_.col;
									_tmp106_ = val;
									_tmp101_[(_tmp103_ * _tmp101__length2) + _tmp105_] = _tmp106_;
									_tmp107_ = _tmp101_[(_tmp103_ * _tmp101__length2) + _tmp105_];
									_tmp108_ = free.col;
									free.col = _tmp108_ + 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


void
grid_move_right (Grid* self,
                 GeeLinkedList* to_move,
                 GeeLinkedList* to_hide,
                 GeeLinkedList* to_show)
{
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_move);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_hide);
	gee_abstract_collection_clear ((GeeAbstractCollection*) to_show);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GridPosition _tmp6_ = {0};
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = self->priv->_cols;
				_tmp6_.row = (guint) _tmp4_;
				_tmp6_.col = (guint) _tmp5_;
				free = _tmp6_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							GridPosition _tmp15_ = {0};
							guint* _tmp16_;
							gint _tmp16__length1;
							gint _tmp16__length2;
							GridPosition _tmp17_;
							guint _tmp18_;
							GridPosition _tmp19_;
							guint _tmp20_;
							guint _tmp21_;
							guint _tmp22_;
							GridPosition _tmp27_ = {0};
							gboolean _tmp44_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = j;
							_tmp10_ = self->priv->_cols;
							if (!(_tmp9_ < _tmp10_)) {
								break;
							}
							_tmp11_ = self->priv->_cols;
							_tmp12_ = j;
							col = (_tmp11_ - _tmp12_) - 1;
							_tmp13_ = i;
							_tmp14_ = col;
							_tmp15_.row = (guint) _tmp13_;
							_tmp15_.col = (guint) _tmp14_;
							cur = _tmp15_;
							_tmp16_ = self->priv->_grid;
							_tmp16__length1 = self->priv->_grid_length1;
							_tmp16__length2 = self->priv->_grid_length2;
							_tmp17_ = cur;
							_tmp18_ = _tmp17_.row;
							_tmp19_ = cur;
							_tmp20_ = _tmp19_.col;
							_tmp21_ = _tmp16_[(_tmp18_ * _tmp16__length2) + _tmp20_];
							val = _tmp21_;
							_tmp22_ = val;
							if (_tmp22_ == ((guint) 0)) {
								GridPosition _tmp23_;
								guint _tmp24_;
								gint _tmp25_;
								_tmp23_ = free;
								_tmp24_ = _tmp23_.col;
								_tmp25_ = self->priv->_cols;
								if (_tmp24_ == ((guint) _tmp25_)) {
									gint _tmp26_;
									_tmp26_ = col;
									free.col = (guint) _tmp26_;
								}
								continue;
							}
							_tmp27_.row = (guint) 0;
							_tmp27_.col = (guint) 0;
							match = _tmp27_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp28_;
								_tmp28_ = col;
								k = _tmp28_ - 1;
								{
									gboolean _tmp29_ = FALSE;
									_tmp29_ = TRUE;
									while (TRUE) {
										gint _tmp31_;
										guint k_val = 0U;
										guint* _tmp32_;
										gint _tmp32__length1;
										gint _tmp32__length2;
										GridPosition _tmp33_;
										guint _tmp34_;
										gint _tmp35_;
										guint _tmp36_;
										guint _tmp37_;
										if (!_tmp29_) {
											gint _tmp30_;
											_tmp30_ = k;
											k = _tmp30_ - 1;
										}
										_tmp29_ = FALSE;
										_tmp31_ = k;
										if (!(_tmp31_ >= 0)) {
											break;
										}
										_tmp32_ = self->priv->_grid;
										_tmp32__length1 = self->priv->_grid_length1;
										_tmp32__length2 = self->priv->_grid_length2;
										_tmp33_ = cur;
										_tmp34_ = _tmp33_.row;
										_tmp35_ = k;
										_tmp36_ = _tmp32_[(_tmp34_ * _tmp32__length2) + _tmp35_];
										k_val = _tmp36_;
										_tmp37_ = k_val;
										if (_tmp37_ != ((guint) 0)) {
											guint _tmp38_;
											guint _tmp39_;
											_tmp38_ = k_val;
											_tmp39_ = val;
											if (_tmp38_ == _tmp39_) {
												GridPosition _tmp40_;
												guint _tmp41_;
												gint _tmp42_;
												GridPosition _tmp43_ = {0};
												has_match = TRUE;
												_tmp40_ = cur;
												_tmp41_ = _tmp40_.row;
												_tmp42_ = k;
												_tmp43_.row = _tmp41_;
												_tmp43_.col = (guint) _tmp42_;
												match = _tmp43_;
											}
											break;
										}
									}
								}
							}
							_tmp44_ = has_match;
							if (_tmp44_) {
								gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								GridPosition _tmp49_;
								guint _tmp50_;
								gint _tmp51_;
								GridPosition _tmp53_;
								GridPosition _tmp54_;
								TileMovement _tmp55_ = {0};
								TileMovement _tmp56_;
								GridPosition _tmp57_;
								GridPosition _tmp58_;
								TileMovement _tmp59_ = {0};
								TileMovement _tmp60_;
								GridPosition _tmp61_;
								guint _tmp62_;
								Tile _tmp63_ = {0};
								Tile _tmp64_;
								guint* _tmp65_;
								gint _tmp65__length1;
								gint _tmp65__length2;
								GridPosition _tmp66_;
								guint _tmp67_;
								GridPosition _tmp68_;
								guint _tmp69_;
								guint _tmp70_;
								guint* _tmp71_;
								gint _tmp71__length1;
								gint _tmp71__length2;
								GridPosition _tmp72_;
								guint _tmp73_;
								GridPosition _tmp74_;
								guint _tmp75_;
								guint _tmp76_;
								guint* _tmp77_;
								gint _tmp77__length1;
								gint _tmp77__length2;
								GridPosition _tmp78_;
								guint _tmp79_;
								GridPosition _tmp80_;
								guint _tmp81_;
								guint _tmp82_;
								guint _tmp83_;
								guint _tmp84_;
								guint _tmp85_;
								_tmp45_ = grid_position_to_string (&match);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strconcat ("matching tile found at ", _tmp46_, NULL);
								_tmp48_ = _tmp47_;
								g_debug ("grid.vala:415: %s", _tmp48_);
								_g_free0 (_tmp48_);
								_g_free0 (_tmp46_);
								_tmp49_ = free;
								_tmp50_ = _tmp49_.col;
								_tmp51_ = self->priv->_cols;
								if (_tmp50_ == ((guint) _tmp51_)) {
									gint _tmp52_;
									_tmp52_ = col;
									free.col = (guint) _tmp52_;
								}
								_tmp53_ = cur;
								_tmp54_ = free;
								_tmp55_.from = _tmp53_;
								_tmp55_.to = _tmp54_;
								mov = _tmp55_;
								_tmp56_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp56_);
								_tmp57_ = match;
								_tmp58_ = free;
								_tmp59_.from = _tmp57_;
								_tmp59_.to = _tmp58_;
								mov = _tmp59_;
								_tmp60_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_hide, &_tmp60_);
								_tmp61_ = free;
								_tmp62_ = val;
								_tmp63_.pos = _tmp61_;
								_tmp63_.val = _tmp62_ * 2;
								tile = _tmp63_;
								_tmp64_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) to_show, &_tmp64_);
								_tmp65_ = self->priv->_grid;
								_tmp65__length1 = self->priv->_grid_length1;
								_tmp65__length2 = self->priv->_grid_length2;
								_tmp66_ = cur;
								_tmp67_ = _tmp66_.row;
								_tmp68_ = cur;
								_tmp69_ = _tmp68_.col;
								_tmp65_[(_tmp67_ * _tmp65__length2) + _tmp69_] = (guint) 0;
								_tmp70_ = _tmp65_[(_tmp67_ * _tmp65__length2) + _tmp69_];
								_tmp71_ = self->priv->_grid;
								_tmp71__length1 = self->priv->_grid_length1;
								_tmp71__length2 = self->priv->_grid_length2;
								_tmp72_ = match;
								_tmp73_ = _tmp72_.row;
								_tmp74_ = match;
								_tmp75_ = _tmp74_.col;
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
								_tmp77_ = self->priv->_grid;
								_tmp77__length1 = self->priv->_grid_length1;
								_tmp77__length2 = self->priv->_grid_length2;
								_tmp78_ = free;
								_tmp79_ = _tmp78_.row;
								_tmp80_ = free;
								_tmp81_ = _tmp80_.col;
								_tmp82_ = val;
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = _tmp82_ * 2;
								_tmp83_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
								_tmp84_ = val;
								_grid_check_target_value_reached (self, _tmp84_ * 2);
								_tmp85_ = free.col;
								free.col = _tmp85_ - 1;
							} else {
								GridPosition _tmp86_;
								guint _tmp87_;
								gint _tmp88_;
								_tmp86_ = free;
								_tmp87_ = _tmp86_.col;
								_tmp88_ = self->priv->_cols;
								if (_tmp87_ != ((guint) _tmp88_)) {
									gchar* _tmp89_;
									gchar* _tmp90_;
									gchar* _tmp91_;
									gchar* _tmp92_;
									gchar* _tmp93_;
									gchar* _tmp94_;
									GridPosition _tmp95_;
									GridPosition _tmp96_;
									TileMovement _tmp97_ = {0};
									TileMovement _tmp98_;
									guint* _tmp99_;
									gint _tmp99__length1;
									gint _tmp99__length2;
									GridPosition _tmp100_;
									guint _tmp101_;
									GridPosition _tmp102_;
									guint _tmp103_;
									guint _tmp104_;
									guint* _tmp105_;
									gint _tmp105__length1;
									gint _tmp105__length2;
									GridPosition _tmp106_;
									guint _tmp107_;
									GridPosition _tmp108_;
									guint _tmp109_;
									guint _tmp110_;
									guint _tmp111_;
									guint _tmp112_;
									_tmp89_ = grid_position_to_string (&cur);
									_tmp90_ = _tmp89_;
									_tmp91_ = grid_position_to_string (&free);
									_tmp92_ = _tmp91_;
									_tmp93_ = g_strconcat ("moving ", _tmp90_, " to ", _tmp92_, NULL);
									_tmp94_ = _tmp93_;
									g_debug ("grid.vala:437: %s", _tmp94_);
									_g_free0 (_tmp94_);
									_g_free0 (_tmp92_);
									_g_free0 (_tmp90_);
									_tmp95_ = cur;
									_tmp96_ = free;
									_tmp97_.from = _tmp95_;
									_tmp97_.to = _tmp96_;
									mov = _tmp97_;
									_tmp98_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) to_move, &_tmp98_);
									_tmp99_ = self->priv->_grid;
									_tmp99__length1 = self->priv->_grid_length1;
									_tmp99__length2 = self->priv->_grid_length2;
									_tmp100_ = cur;
									_tmp101_ = _tmp100_.row;
									_tmp102_ = cur;
									_tmp103_ = _tmp102_.col;
									_tmp99_[(_tmp101_ * _tmp99__length2) + _tmp103_] = (guint) 0;
									_tmp104_ = _tmp99_[(_tmp101_ * _tmp99__length2) + _tmp103_];
									_tmp105_ = self->priv->_grid;
									_tmp105__length1 = self->priv->_grid_length1;
									_tmp105__length2 = self->priv->_grid_length2;
									_tmp106_ = free;
									_tmp107_ = _tmp106_.row;
									_tmp108_ = free;
									_tmp109_ = _tmp108_.col;
									_tmp110_ = val;
									_tmp105_[(_tmp107_ * _tmp105__length2) + _tmp109_] = _tmp110_;
									_tmp111_ = _tmp105_[(_tmp107_ * _tmp105__length2) + _tmp109_];
									_tmp112_ = free.col;
									free.col = _tmp112_ - 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


gboolean
grid_is_finished (Grid* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!_grid_grid_is_full (self)) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gint _tmp7_;
							guint val = 0U;
							guint* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							gint _tmp10_;
							guint _tmp11_;
							gboolean _tmp12_ = FALSE;
							gint _tmp13_;
							gint _tmp14_;
							gboolean _tmp20_ = FALSE;
							gint _tmp21_;
							gint _tmp22_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = j;
							_tmp7_ = self->priv->_cols;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = self->priv->_grid;
							_tmp8__length1 = self->priv->_grid_length1;
							_tmp8__length2 = self->priv->_grid_length2;
							_tmp9_ = i;
							_tmp10_ = j;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							val = _tmp11_;
							_tmp13_ = i;
							_tmp14_ = self->priv->_rows;
							if (_tmp13_ < (_tmp14_ - 1)) {
								guint _tmp15_;
								guint* _tmp16_;
								gint _tmp16__length1;
								gint _tmp16__length2;
								gint _tmp17_;
								gint _tmp18_;
								guint _tmp19_;
								_tmp15_ = val;
								_tmp16_ = self->priv->_grid;
								_tmp16__length1 = self->priv->_grid_length1;
								_tmp16__length2 = self->priv->_grid_length2;
								_tmp17_ = i;
								_tmp18_ = j;
								_tmp19_ = _tmp16_[((_tmp17_ + 1) * _tmp16__length2) + _tmp18_];
								_tmp12_ = _tmp15_ == _tmp19_;
							} else {
								_tmp12_ = FALSE;
							}
							if (_tmp12_) {
								result = FALSE;
								return result;
							}
							_tmp21_ = j;
							_tmp22_ = self->priv->_cols;
							if (_tmp21_ < (_tmp22_ - 1)) {
								guint _tmp23_;
								guint* _tmp24_;
								gint _tmp24__length1;
								gint _tmp24__length2;
								gint _tmp25_;
								gint _tmp26_;
								guint _tmp27_;
								_tmp23_ = val;
								_tmp24_ = self->priv->_grid;
								_tmp24__length1 = self->priv->_grid_length1;
								_tmp24__length2 = self->priv->_grid_length2;
								_tmp25_ = i;
								_tmp26_ = j;
								_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + (_tmp26_ + 1)];
								_tmp20_ = _tmp23_ == _tmp27_;
							} else {
								_tmp20_ = FALSE;
							}
							if (_tmp20_) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


guint
grid_get (Grid* self,
          gint row,
          gint col)
{
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	guint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	guint _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = self->priv->_rows;
	if (row >= _tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		_tmp2_ = self->priv->_cols;
		_tmp0_ = col >= _tmp2_;
	}
	if (_tmp0_) {
		result = (guint) 0;
		return result;
	}
	_tmp3_ = self->priv->_grid;
	_tmp3__length1 = self->priv->_grid_length1;
	_tmp3__length2 = self->priv->_grid_length2;
	_tmp4_ = _tmp3_[(row * _tmp3__length2) + col];
	result = _tmp4_;
	return result;
}


gchar*
grid_save (Grid* self)
{
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = self->priv->_rows;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, " ", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp1_, _tmp6_, NULL);
	_g_free0 (ret);
	ret = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp8_ = ret;
	_tmp9_ = self->priv->_cols;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
	_g_free0 (ret);
	ret = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp15_ = ret;
	_tmp16_ = _grid_convert_to_string (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
	_g_free0 (ret);
	ret = _tmp18_;
	_g_free0 (_tmp17_);
	result = ret;
	return result;
}


gboolean
grid_load (Grid* self,
           const gchar* content)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	result = _grid_load_from_string (self, content);
	return result;
}


gchar*
grid_to_string (Grid* self)
{
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = _grid_convert_to_string (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_g_free0 (ret);
	ret = _tmp4_;
	_g_free0 (_tmp3_);
	result = ret;
	return result;
}


static gchar*
_grid_convert_to_string (Grid* self)
{
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint _tmp3_;
				gint _tmp4_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < ((guint) _tmp4_))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							guint _tmp7_;
							gint _tmp8_;
							const gchar* _tmp9_ = NULL;
							guint _tmp10_;
							gint _tmp11_;
							const gchar* _tmp12_;
							guint* _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							guint _tmp14_;
							guint _tmp15_;
							guint _tmp16_;
							gchar* _tmp17_;
							gchar* _tmp18_;
							gchar* _tmp19_;
							if (!_tmp5_) {
								guint _tmp6_;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = j;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < ((guint) _tmp8_))) {
								break;
							}
							_tmp10_ = j;
							_tmp11_ = self->priv->_cols;
							if (_tmp10_ == ((guint) (_tmp11_ - 1))) {
								_tmp9_ = "\n";
							} else {
								_tmp9_ = " ";
							}
							_tmp12_ = ret;
							_tmp13_ = self->priv->_grid;
							_tmp13__length1 = self->priv->_grid_length1;
							_tmp13__length2 = self->priv->_grid_length2;
							_tmp14_ = i;
							_tmp15_ = j;
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
							_tmp17_ = g_strdup_printf ("%u%s", _tmp16_, _tmp9_);
							_tmp18_ = _tmp17_;
							_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
							_g_free0 (ret);
							ret = _tmp19_;
							_g_free0 (_tmp18_);
						}
					}
				}
			}
		}
	}
	result = ret;
	return result;
}


static guint*
_vala_array_dup2 (guint* self,
                  int length)
{
	return g_memdup (self, length * sizeof (guint));
}


static gboolean
_grid_load_from_string (Grid* self,
                        const gchar* contents)
{
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** tokens = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	guint* grid = NULL;
	gint grid_length1 = 0;
	gint grid_length2 = 0;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	guint* _tmp19_;
	gint _tmp42_;
	gint _tmp43_;
	guint* _tmp44_;
	gint _tmp44__length1;
	gint _tmp44__length2;
	guint* _tmp45_;
	gint _tmp45__length1;
	gint _tmp45__length2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	rows = 0;
	cols = 0;
	_tmp1_ = _tmp0_ = g_strsplit (contents, "\n", 0);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = lines_length1;
	_tmp2_ = lines;
	_tmp2__length1 = lines_length1;
	if (_tmp2__length1 < 3) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	_tmp4_ = _tmp3_[0];
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, " ", 0);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	tokens = _tmp6_;
	tokens_length1 = _vala_array_length (_tmp5_);
	_tokens_size_ = tokens_length1;
	_tmp7_ = tokens;
	_tmp7__length1 = tokens_length1;
	if (_tmp7__length1 != 2) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp8_ = tokens;
	_tmp8__length1 = tokens_length1;
	_tmp9_ = _tmp8_[0];
	rows = atoi (_tmp9_);
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	_tmp11_ = _tmp10_[1];
	cols = atoi (_tmp11_);
	_tmp13_ = rows;
	if (_tmp13_ < 2) {
		_tmp12_ = TRUE;
	} else {
		gint _tmp14_;
		_tmp14_ = cols;
		_tmp12_ = _tmp14_ < 2;
	}
	if (_tmp12_) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp15_ = lines;
	_tmp15__length1 = lines_length1;
	_tmp16_ = rows;
	if (_tmp15__length1 < (_tmp16_ + 1)) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp17_ = rows;
	_tmp18_ = cols;
	_tmp19_ = g_new0 (guint, _tmp17_ * _tmp18_);
	grid = (g_free (grid), NULL);
	grid = _tmp19_;
	grid_length1 = _tmp17_;
	grid_length2 = _tmp18_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				gint _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				const gchar* _tmp26_;
				gchar** _tmp27_;
				gchar** _tmp28_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = rows;
				if (!(_tmp22_ < _tmp23_)) {
					break;
				}
				_tmp24_ = lines;
				_tmp24__length1 = lines_length1;
				_tmp25_ = i;
				_tmp26_ = _tmp24_[_tmp25_ + 1];
				_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, " ", 0);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				tokens = _tmp28_;
				tokens_length1 = _vala_array_length (_tmp27_);
				_tokens_size_ = tokens_length1;
				_tmp29_ = tokens;
				_tmp29__length1 = tokens_length1;
				_tmp30_ = cols;
				if (_tmp29__length1 != _tmp30_) {
					result = FALSE;
					grid = (g_free (grid), NULL);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp31_ = FALSE;
						_tmp31_ = TRUE;
						while (TRUE) {
							gint _tmp33_;
							gint _tmp34_;
							guint* _tmp35_;
							gint _tmp35__length1;
							gint _tmp35__length2;
							gint _tmp36_;
							gint _tmp37_;
							gchar** _tmp38_;
							gint _tmp38__length1;
							gint _tmp39_;
							const gchar* _tmp40_;
							guint _tmp41_;
							if (!_tmp31_) {
								gint _tmp32_;
								_tmp32_ = j;
								j = _tmp32_ + 1;
							}
							_tmp31_ = FALSE;
							_tmp33_ = j;
							_tmp34_ = cols;
							if (!(_tmp33_ < _tmp34_)) {
								break;
							}
							_tmp35_ = grid;
							_tmp35__length1 = grid_length1;
							_tmp35__length2 = grid_length2;
							_tmp36_ = i;
							_tmp37_ = j;
							_tmp38_ = tokens;
							_tmp38__length1 = tokens_length1;
							_tmp39_ = j;
							_tmp40_ = _tmp38_[_tmp39_];
							_tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_] = (guint) atoi (_tmp40_);
							_tmp41_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_];
						}
					}
				}
			}
		}
	}
	_tmp42_ = rows;
	self->priv->_rows = _tmp42_;
	_tmp43_ = cols;
	self->priv->_cols = _tmp43_;
	_tmp44_ = grid;
	_tmp44__length1 = grid_length1;
	_tmp44__length2 = grid_length2;
	_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup2 (_tmp44_, _tmp44__length1 * _tmp44__length2) : ((gpointer) _tmp44_);
	_tmp45__length1 = _tmp44__length1;
	_tmp45__length2 = _tmp44__length2;
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
	self->priv->_grid = _tmp45_;
	self->priv->_grid_length1 = _tmp45__length1;
	self->priv->_grid_length2 = _tmp45__length2;
	result = TRUE;
	grid = (g_free (grid), NULL);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean
_grid_grid_is_full (Grid* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < ((guint) _tmp3_))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							guint _tmp6_;
							gint _tmp7_;
							guint* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							guint _tmp9_;
							guint _tmp10_;
							guint _tmp11_;
							if (!_tmp4_) {
								guint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = j;
							_tmp7_ = self->priv->_cols;
							if (!(_tmp6_ < ((guint) _tmp7_))) {
								break;
							}
							_tmp8_ = self->priv->_grid;
							_tmp8__length1 = self->priv->_grid_length1;
							_tmp8__length2 = self->priv->_grid_length2;
							_tmp9_ = i;
							_tmp10_ = j;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							if (_tmp11_ == ((guint) 0)) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void
_grid_random_position (Grid* self,
                       GridPosition* result)
{
	GridPosition ret = {0};
	gint _tmp0_;
	gint _tmp1_;
	GridPosition _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_.row = (guint) g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp0_));
	_tmp2_.col = (guint) g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp1_));
	ret = _tmp2_;
	*result = ret;
	return;
}


static void
_grid_check_target_value_reached (Grid* self,
                                  guint val)
{
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_target_value;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->_target_value;
		_tmp0_ = val == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		grid_set_target_value_reached (self, TRUE);
	}
}


gint
grid_get_rows (Grid* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	result = _tmp0_;
	return result;
}


void
grid_set_rows (Grid* self,
               gint value)
{
	g_return_if_fail (self != NULL);
	if (grid_get_rows (self) != value) {
		self->priv->_rows = value;
		g_object_notify_by_pspec ((GObject *) self, grid_properties[GRID_ROWS_PROPERTY]);
	}
}


gint
grid_get_cols (Grid* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cols;
	result = _tmp0_;
	return result;
}


void
grid_set_cols (Grid* self,
               gint value)
{
	g_return_if_fail (self != NULL);
	if (grid_get_cols (self) != value) {
		self->priv->_cols = value;
		g_object_notify_by_pspec ((GObject *) self, grid_properties[GRID_COLS_PROPERTY]);
	}
}


guint
grid_get_target_value (Grid* self)
{
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_target_value;
	result = _tmp0_;
	return result;
}


void
grid_set_target_value (Grid* self,
                       guint value)
{
	g_return_if_fail (self != NULL);
	if (grid_get_target_value (self) != value) {
		self->priv->_target_value = value;
		g_object_notify_by_pspec ((GObject *) self, grid_properties[GRID_TARGET_VALUE_PROPERTY]);
	}
}


gboolean
grid_get_target_value_reached (Grid* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_target_value_reached;
	result = _tmp0_;
	return result;
}


void
grid_set_target_value_reached (Grid* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	if (grid_get_target_value_reached (self) != value) {
		self->priv->_target_value_reached = value;
		g_object_notify_by_pspec ((GObject *) self, grid_properties[GRID_TARGET_VALUE_REACHED_PROPERTY]);
	}
}


static void
grid_class_init (GridClass * klass)
{
	grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Grid_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_grid_set_property;
	G_OBJECT_CLASS (klass)->finalize = grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_ROWS_PROPERTY, grid_properties[GRID_ROWS_PROPERTY] = g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_COLS_PROPERTY, grid_properties[GRID_COLS_PROPERTY] = g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_PROPERTY, grid_properties[GRID_TARGET_VALUE_PROPERTY] = g_param_spec_uint ("target-value", "target-value", "target-value", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_REACHED_PROPERTY, grid_properties[GRID_TARGET_VALUE_REACHED_PROPERTY] = g_param_spec_boolean ("target-value-reached", "target-value-reached", "target-value-reached", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
grid_instance_init (Grid * self)
{
	self->priv = grid_get_instance_private (self);
}


static void
grid_finalize (GObject * obj)
{
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRID, Grid);
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
	G_OBJECT_CLASS (grid_parent_class)->finalize (obj);
}


GType
grid_get_type (void)
{
	static volatile gsize grid_type_id__volatile = 0;
	if (g_once_init_enter (&grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Grid), 0, (GInstanceInitFunc) grid_instance_init, NULL };
		GType grid_type_id;
		grid_type_id = g_type_register_static (G_TYPE_OBJECT, "Grid", &g_define_type_info, 0);
		Grid_private_offset = g_type_add_instance_private (grid_type_id, sizeof (GridPrivate));
		g_once_init_leave (&grid_type_id__volatile, grid_type_id);
	}
	return grid_type_id__volatile;
}


static void
_vala_grid_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
	switch (property_id) {
		case GRID_ROWS_PROPERTY:
		g_value_set_int (value, grid_get_rows (self));
		break;
		case GRID_COLS_PROPERTY:
		g_value_set_int (value, grid_get_cols (self));
		break;
		case GRID_TARGET_VALUE_PROPERTY:
		g_value_set_uint (value, grid_get_target_value (self));
		break;
		case GRID_TARGET_VALUE_REACHED_PROPERTY:
		g_value_set_boolean (value, grid_get_target_value_reached (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_grid_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
	switch (property_id) {
		case GRID_ROWS_PROPERTY:
		grid_set_rows (self, g_value_get_int (value));
		break;
		case GRID_COLS_PROPERTY:
		grid_set_cols (self, g_value_get_int (value));
		break;
		case GRID_TARGET_VALUE_PROPERTY:
		grid_set_target_value (self, g_value_get_uint (value));
		break;
		case GRID_TARGET_VALUE_REACHED_PROPERTY:
		grid_set_target_value_reached (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gchar*
grid_position_to_string (GridPosition *self)
{
	gchar* result = NULL;
	guint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).row;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (*self).col;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("(", _tmp2_, ",", _tmp5_, ")", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}


GridPosition*
grid_position_dup (const GridPosition* self)
{
	GridPosition* dup;
	dup = g_new0 (GridPosition, 1);
	memcpy (dup, self, sizeof (GridPosition));
	return dup;
}


void
grid_position_free (GridPosition* self)
{
	g_free (self);
}


GType
grid_position_get_type (void)
{
	static volatile gsize grid_position_type_id__volatile = 0;
	if (g_once_init_enter (&grid_position_type_id__volatile)) {
		GType grid_position_type_id;
		grid_position_type_id = g_boxed_type_register_static ("GridPosition", (GBoxedCopyFunc) grid_position_dup, (GBoxedFreeFunc) grid_position_free);
		g_once_init_leave (&grid_position_type_id__volatile, grid_position_type_id);
	}
	return grid_position_type_id__volatile;
}


TileMovement*
tile_movement_dup (const TileMovement* self)
{
	TileMovement* dup;
	dup = g_new0 (TileMovement, 1);
	memcpy (dup, self, sizeof (TileMovement));
	return dup;
}


void
tile_movement_free (TileMovement* self)
{
	g_free (self);
}


GType
tile_movement_get_type (void)
{
	static volatile gsize tile_movement_type_id__volatile = 0;
	if (g_once_init_enter (&tile_movement_type_id__volatile)) {
		GType tile_movement_type_id;
		tile_movement_type_id = g_boxed_type_register_static ("TileMovement", (GBoxedCopyFunc) tile_movement_dup, (GBoxedFreeFunc) tile_movement_free);
		g_once_init_leave (&tile_movement_type_id__volatile, tile_movement_type_id);
	}
	return tile_movement_type_id__volatile;
}


Tile*
tile_dup (const Tile* self)
{
	Tile* dup;
	dup = g_new0 (Tile, 1);
	memcpy (dup, self, sizeof (Tile));
	return dup;
}


void
tile_free (Tile* self)
{
	g_free (self);
}


GType
tile_get_type (void)
{
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		GType tile_type_id;
		tile_type_id = g_boxed_type_register_static ("Tile", (GBoxedCopyFunc) tile_dup, (GBoxedFreeFunc) tile_free);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



