/*
 * EasyChem
 * A program for creating and editing molecular formulas.
 *
 * Copyright (C) 2003, 2004, 2005 François-Xavier Coudert
 * 
 * Distributed under the General Public Licence (GPL).
 * See file COPYING in the source distribution for more details.
 *
 */

#define _XOPEN_SOURCE 600
#include <fcntl.h>

#ifdef UNIX
#include <sys/wait.h>
#endif

#include <unistd.h>
#include <time.h>

#include <stdio.h>
#include <gtk/gtk.h>
#include <stdlib.h>

#include "common.h"
#include "detect.h"


/* This detects whether we can find 'gs', and returns a code
 * corresponding to the situtation (PROGRAM_IN_*, see detect.h) */
int
detect_gs (void)
{
#ifdef UNIX
  int pid, f[2], dum, fd, count;
  char *argv[6] = { "gs", "-q", "-sDEVICE=nullpage", "-dBATCH", "", NULL };
  char *temp;
  FILE *file;

  temp = g_strconcat (g_get_tmp_dir (), "/gs_detect.XXXXXX", NULL);
  fd = mkstemp (temp);
  if (fd == -1)
    return PROGRAM_NOT_FOUND;
  file = fdopen (fd, "w");
  if (file == NULL)
    return PROGRAM_NOT_FOUND;
  fputs ("(125) = quit", file);
  fclose (file);

  if ((pipe (f) == -1) || ((pid = fork ()) < 0))
    return PROGRAM_NOT_FOUND;
  if (pid == 0)
    {
      close (f[0]);
      dup2 (f[1], 1);
      close (f[1]);
      argv[3] = temp;
      if (prop.path_gs != NULL)
	execv(prop.path_gs, argv);
      puts ("42");
      fflush (stdout);
#ifdef GS_PATH
      execv (GS_PATH "/gs", argv);
#endif
      puts ("42");
      fflush (stdout);
      execvp ("gs", argv);
      puts ("42");
      fflush (stdout);
      execv ("/usr/bin/gs", argv);
      puts ("42");
      fflush (stdout);
      execv ("/usr/local/bin/gs", argv);
      puts ("42");
      fflush (stdout);
      execv ("/sw/bin/gs", argv);
      puts ("42");
      fflush (stdout);
      _exit (0);
    }
  close (f[1]);
  wait (NULL);
  count = 0;
  file = fdopen (f[0], "r");
  while (!feof (file))
    {
      fscanf (file, "%d", &dum);
      if (dum == 42)
      {
	dum = 0;
	count++;
      }
    }
  fclose (file);
  unlink (temp);
  g_free (temp);
  if (dum != 125)
    return PROGRAM_NOT_FOUND;
  if (count == 0)
    return PROGRAM_IN_PREF_PATH;
  if (count == 1)
    return PROGRAM_IN_PROVIDED_PATH;
  if (count == 2)
    return PROGRAM_IN_PATH;
  if (count == 3)
    return PROGRAM_IN_USR_BIN;
  if (count == 4)
    return PROGRAM_IN_USR_LOCAL_BIN;
  if (count == 5)
    return PROGRAM_IN_SW_BIN;
#endif

  return PROGRAM_NOT_FOUND;
}


/* This detects whether we can find 'pstoedit', and returns a code
 * corresponding to the situtation (PROGRAM_IN_*, see detect.h) */
int
detect_pstoedit (void)
{
#ifdef UNIX
  int pid, f[2], fd, dum, count;
  char *argv[2] = { "pstoedit", NULL };
  FILE * file;

  if ((pipe (f) == -1) || ((pid = fork ()) < 0))
    return PROGRAM_NOT_FOUND;
  if (pid == 0)
    {
      close (f[0]);
      dup2 (f[1], 1);
      fd = open ("/dev/null", O_APPEND);
      dup2 (fd, 2);
      close (fd);
      close (f[1]);
      if (prop.path_gs != NULL)
	execv(prop.path_pstoedit, argv);
      puts ("42");
      fflush (stdout);
#ifdef PSTOEDIT_PATH
      execv (PSTOEDIT_PATH "/pstoedit", argv);
#endif
      puts ("42");
      fflush (stdout);
      execvp ("pstoedit", argv);
      puts ("42");
      fflush (stdout);
      execv ("/usr/bin/pstoedit", argv);
      puts ("42");
      fflush (stdout);
      execv ("/usr/local/bin/pstoedit", argv);
      puts ("42");
      fflush (stdout);
      execv ("/sw/bin/pstoedit", argv);
      puts ("42");
      fflush (stdout);
      _exit (0);
    }
  close (f[1]);
  wait (NULL);
  count = 0;
  file = fdopen (f[0], "r");
  while (!feof (file))
    {
      dum = 0;
      fscanf (file, "%d", &dum);
      if (dum == 42)
	count++;
    }
  fclose (file);
  if (count == 0)
    return PROGRAM_IN_PREF_PATH;
  if (count == 1)
    return PROGRAM_IN_PROVIDED_PATH;
  if (count == 2)
    return PROGRAM_IN_PATH;
  if (count == 3)
    return PROGRAM_IN_USR_BIN;
  if (count == 4)
    return PROGRAM_IN_USR_LOCAL_BIN;
  if (count == 5)
    return PROGRAM_IN_SW_BIN;
#endif

  return PROGRAM_NOT_FOUND;
}
