#include "main_window.h"
#include "ui_main_window.h"
#include <QDBusError>
#include <QDBusConnection>
#include <QDBusMessage>
#include <QSharedMemory>
#include <QSharedMemory>
#include <unistd.h>
#include <QDBusReply>
#include <QDebug>

static QString read_shared_image(uid_t uid, int purpose)
{
    QDBusMessage msg = QDBusMessage::createMethodCall("com.deepin.dde.preload", "/com/deepin/dde/preload", "com.deepin.dde.preload", "requestSource");
    QList<QVariant> args;
    args.append(int(uid));
    args.append(purpose);
    msg.setArguments(args);
    QString shareKey;
    QDBusMessage ret = QDBusConnection::sessionBus().call(msg);
    if (ret.type() == QDBusMessage::ErrorMessage) {
        qDebug() << ret;
    } else {
        QDBusReply<QString> reply(ret);
        shareKey = reply.value();
    }
    qInfo() << __FILE__ << ", " << Q_FUNC_INFO << " user: " << uid << ", purpose: " << purpose << " share memory key: " << shareKey;
    return shareKey;
}

static int read_work_area_number()
{
    QDBusMessage msg = QDBusMessage::createMethodCall("com.deepin.wm", "/com/deepin/wm", "com.deepin.wm", "GetCurrentWorkspace");
    QDBusMessage ret = QDBusConnection::sessionBus().call(msg);
    if (ret.type() == QDBusMessage::ErrorMessage) {
        qDebug() << ret;
    } else {
        QDBusReply<int> reply(ret);
        return reply.value();
    }
    return 1;
}


Main_Window::Main_Window(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::Main_Window)
{
    ui->setupUi(this);
    ui->vl2->addWidget(&m_image);
    connect(this, SIGNAL(signal_refresh_image(const QString &)), &m_image, SLOT(slot_update_image(const QString &)));
}

Main_Window::~Main_Window()
{
    delete ui;
}

void Main_Window::on_update_greeter_button_clicked()
{
    QString share_key = read_shared_image(getuid(), 1);
    emit signal_refresh_image(share_key);
    ui->current_work_label->setText(u8"");
}

void Main_Window::on_update_work_button_clicked()
{
    int ispace=read_work_area_number();
    QString share_key = read_shared_image(getuid(), ispace+2);
    emit signal_refresh_image(share_key);
    ui->current_work_label->setText(QString::number(ispace));
}

void Main_Window::on_update_launcher_button_clicked()
{
    QString share_key = read_shared_image(getuid(), 2);
    emit signal_refresh_image(share_key);
    ui->current_work_label->setText("");
}
