.TH BABELD 8
.SH NAME
babeld \- ad-hoc network routing daemon
.SH SYNOPSIS
.B babeld
.IR option ...
[
.B \-\-
]
.IR interface ...
.SH DESCRIPTION
Babel is a loop-avoiding distance-vector routing protocol roughly
based on DSDV and AODV, but with provisions for link cost estimation
and redistribution of routes from other routing protocols.

While it is optimised for wireless mesh networks, Babel will also work
efficiently on wired networks.
.SH OPTIONS
.TP
.BI \-V
Display babeld's version and quit.
.TP
.BI \-m " multicast-address"
Specify the link-local multicast address to be used by the protocol.
The default is
.BR ff02:0:0:0:0:0:1:6 .
.TP
.BI \-p " port"
Specify the UDP port number to be used by the protocol.  The default is
.BR 6696 .
.TP
.BI \-S " state-file"
Set the name of the file used for preserving long-term information
between invocations of the
.B babeld
daemon.  If this file is deleted, the daemon will run in passive mode
for 3 minutes when it is next started (see
.B -P
below), and other hosts might initially ignore it.  The default is
.BR /var/lib/babel-state .
.TP
.BI \-h " hello-interval"
Specify the interval in seconds at which scheduled hello packets are
sent on wireless interfaces.  The default is 4 seconds.
.TP
.BI \-H " wired-hello-interval"
Specify the interval in seconds at which scheduled hello packets are
sent on wired interfaces.  The default is 4 seconds.
.TP
.BI \-z " kind" " \fR[\fB," factor "\fR]"
Enable diversity-sensitive routing.  The value
.B kind
defines the diversity algorithm used, and can be one of
.B 0
(no diversity),
.B 1
(per-interface diversity with no memory),
.B 2
(per-channel diversity with no memory),
or
.B 3
(per-channel diversity with memory).
The value
.B factor
specifies by how much the cost of non-interfering routes is multiplied,
in units of 1/256; the default is 128 (i.e. division by 2).
.TP
.BI \-M " half-time"
Specify the half-time in seconds of the exponential decay used for
smoothing metrics for performing route selection; the value 0 disables
smoothing.  The default is 4s.
.TP
.BI \-k " priority"
Specify the priority value used when installing routes into the kernel.
The default is 0.
.TP
.BI \-A " priority"
Allow duplicating external routes when their kernel priority is at least
.IR priority .
Do not use this option unless you know what you are doing, as it can cause
persistent route flapping.
.TP
.B \-l
Use IFF_RUNNING (carrier sense) when determining interface availability.
.TP
.B \-w
Don't optimise wired links, assume all interfaces are wireless unless
explicitly overridden in the configuration file.
.TP
.B \-s
Do not perform split-horizon processing on wired interfaces.
Split-horizon is not performed on wireless interfaces.
.TP
.B \-r
Use a random router-id.  The default is to use persistent router-ids
derived from the MAC address of the first interface, which is easier
to debug and more reliably prevents routing loops but may sometimes
cause a node to be unreachable for 120 seconds just after boot.
.TP
.B \-u
Do not flush unfeasible (useless) routes.  This is useful in order to
announce more information to a front-end (see
.BR \-g ).
.TP
.BI \-d " level"
Debug level.  A value of 1 requests a routing table dump at every
iteration through the daemon's main loop.  A value of 2 additionally
requests tracing every message sent or received.  A value of
3 additionally dumps all interactions with the OS kernel.  The default
is 0.
.TP
.BI \-g " port\fR,\fP" " \-g" " path"
Set up a local configuration server on port
.I port
or at
.I path
in read-only mode.  The protocol is described in the section
.B Local Configuration Protocol
below.
.TP
.BI \-G " port\fR,\fP" " \-G" " path"
Set up a local configuration server on port
.I port
or at
.I path
in read-write mode.  This allows any local user to change
.BR babeld 's
configuration, and may therefore be a security issue.
.TP
.BI \-t " table"
Use the given kernel routing table for routes inserted by
.BR babeld .
.TP
.BI \-T " table"
Export routes from the given kernel routing table. This can be
specified multiple times in order to export routes from more than one
table.
.TP
.BI \-c " filename"
Specify the name of the configuration file.  This flag can be repeated
multiple times.  The default is
.BR /etc/babeld.conf .
.TP
.BI \-C " statement"
Specify a configuration statement directly on the command line.
.TP
.B \-D
Daemonise at startup.
.TP
.BI \-L " logfile"
Specify a file to log random ``how do you do?'' messages to.  This
defaults to standard error if not daemonising, and to
.B /var/log/babeld.log
otherwise.
.TP
.BI \-I " pidfile"
Specify a file to write our process id to, use no pidfile if set to the
empty string.  The default is
.BR /var/run/babeld.pid .
.TP
.IR interface ...
The list of interfaces on which the protocol should operate.
.SH CONFIGURATION FILE FORMAT
The configuration file is a sequence of lines each of which specifies
a global option, an interface specification or a filtering
rule.  Comments are introduced by an octothorp
.RB `` # ''
and terminate at the end of the line.
.SS Global options
.TP
.BI protocol-group " group"
This specifies the link-local multicast address to be used by the
protocol, and is equivalent to the command-line option
.BR \-m .
.TP
.BI protocol-port " port"
This specifies the UDP port number to be used by the protocol, and is equivalent to the command-line option
.BR \-p .
.TP
.BI kernel-priority " priority"
This specifies the priority value used when installing routes into the
kernel, and is equivalent to the command-line option
.BR \-k .
.TP
.BR reflect-kernel-metric " {" true | false }
Reflect route metrics as kernel priorities.  The priority effectively used
is
.B kernel-priority
+
.BR metric .
.TP
.BI allow-duplicates " priority"
This allows duplicating external routes when their kernel priority is
at least
.IR priority .
Do not use this option unless you know what you are doing, as it can
cause persistent route flapping.
.TP
.BR random-id " {" true | false }
This specifies whether to use a random router-id, and is
equivalent to the command-line option
.BR \-r .
.TP
.BR ipv6-subtrees " {" true | false }
This specifies whether to use native source-specific IPv6 forwarding
rather than multiple routing tables.  The default is chosen automatically
depending on the kernel version.
.TP
.BI debug " level"
This specifies the debugging level, and is equivalent to the command-line
option
.BR \-d .
.TP
.BI local-port " port"
This specifies the TCP port on which
.B babeld
will listen for connections from a configuration client in read-only mode,
and is equivalent to the command-line option
.BR \-g .
.TP
.BI local-port-readwrite " port"
This specifies the TCP port on which
.B babeld
will listen for connections from a configuration client in read-write mode,
and is equivalent to the command-line option
.BR \-G .
This allows any local user to change
.BR babeld 's
configuration, and may therefore be a security issue.
.TP
.BI local-path " path"
This specifies the filesystem path to a socket on which
.B babeld
will listen for connections from a configuration client in read-only mode,
and is equivalent to the command-line option
.BR \-g .
.TP
.BI local-path-readwrite " path"
This specifies the filesystem path to a socket on which
.B babeld
will listen for connections from a configuration client in read-write mode,
and is equivalent to the command-line option
.BR \-G .
Any user with write access to that socket will be able to change
.BR babeld 's
configuration.
.TP
.BI export-table " table"
This specifies the kernel routing table to use for routes inserted by
.BR babeld ,
and is equivalent to the command-line option
.BR \-t .
.TP
.BI import-table " table"
This specifies a kernel routing table from which routes are
redistributed by
.BR babeld ,
and can be specified multiple times with a cumulative effect.  This is
equivalent to the command-line option
.BR \-T .
.TP
.BR link-detect " {" true | false }
This specifies whether to use carrier sense for determining interface
availability, and is equivalent to the command-line option
.BR \-l .
.TP
.BR diversity " {" true | false | "\fIkind\fB" }
This specifies the diversity algorithm to use;
.B true
is equivalent to
.I kind
3.  The default is
.B false
(do not use any diversity algorithm).
.TP
.BI diversity-factor " factor"
This specifies by how much the cost of non-interfering routes should
be multiplied, in units of 1/256.  The default is 128 (division by 2).
.TP
.BI smoothing-half-life " seconds"
This specifies the half-life in seconds of the exponential decay used
for smoothing metrics for performing route selection, and is
equivalent to the command-line option
.BR \-M .
.TP
.BR daemonise " {" true | false }
This specifies whether to daemonize at startup, and is equivalent to
the command-line option
.BR \-D .
.TP
.BR skip-kernel-setup " {" true | false }
If this flag is set, no kernel (sysctl) setup is performed on startup. This can
be useful when running in environments where system permissions prevent setting
kernel parameters, for instance inside a Linux container.
.TP
.BI router-id " id"
Specify the router-id explicitly, as a modified EUI-64 or a MAC-48
address.  If two nodes have the same router-id, bad things will happen.
Don't use this option unless you know what you are doing.
.TP
.BI state-file " filename"
This specifies the name of the file used for preserving long-term
information between invocations of the
.B babeld
daemon, and is equivalent to the command-line option
.BR \-S .
.TP
.BI log-file " filename"
This specifies the name of the file used to log random messages to,
and is equivalent to the command-line option
.BR \-L .
.TP
.BI pid-file " filename"
This specifies the name of the file to which
.B babeld
writes out its process id, and is equivalent to the command-line option
.BR \-I .
.TP
.BI first-table-number " table"
This specifies the index of the first routing table to use for
source-specific routes.  The default is 10.
.TP
.BI first-rule-priority " priority"
This specifies smallest (highest) rule priority used with source-specific
routes.  The default is 100.
.SS Interface configuration
An interface is configured by a line with the following format:
.IP
.B interface
.I name
.RI [ parameter ...]
.PP
where
.I name
is the name of the interface (something like
.BR eth0 ).
The default value of an interface parameter can be specified changed
by a line of the form
.IP
.B default
.RI [ parameter ...]
.PP

Each
.I parameter
can be one of:
.TP
.BR type " {" auto | wired | wireless | tunnel }

The default is
.B auto
unless the
.B \-w
command-line flag was specified.
.TP
.BR link\-quality " {" true | false | auto }
This specifies whether link quality estimation should be performed on this
interface.  The default is to perform link quality estimation on wireless
interfaces only.
.TP
.BR split\-horizon " {" true | false | auto }
This specifies whether to perform split-horizon processing on this
interface.  The default is to perform split-horizon processing on
on wired interfaces, unless the
.B \-s
flag was set.
.TP
.BI rxcost " cost"
This defines the cost of receiving frames on the given interface under
ideal conditions (no packet loss); how this relates to the actual cost
used for computing metrics of routes going through this interface depends
on whether link quality estimation is being done.  The default is 256 if
the interface is wireless, and 96 otherwise.
.TP
.BI channel " channel"
Sets the channel for this interface.  The value
.I channel
can be either an integer, or one of the strings
.B interfering
or
.BR noninterfering .
The default is to autodetect the channel number for wireless interfaces,
and
.B noninterfering
for other interfaces.
.TP
.BR faraway " {" true | false }
This specifies whether the network is "far away", in the sense that
networks behind it don't interfere with networks in front of it.  By
default, networks are not far away.
.TP
.BI hello\-interval " interval"
This defines the interval between hello packets sent on this interface.
The default is specified with the
.B \-h
and
.B \-H
command-line flags.
.TP
.BI update\-interval " interval"
This defines the interval between full routing table dumps sent on this
interface; since Babel uses triggered updates and doesn't count to
infinity, this can be set to a fairly large value, unless significant
packet loss is expected.  The default is four times the hello interval.
.TP
.BR enable\-timestamps " {" true | false }
Enable sending timestamps with each Hello and IHU message in order to
compute RTT values.  The default is
.B true
for tunnel interfaces, and
.B false
otherwise.
.TP
.BI rtt\-decay " decay"
This specifies the decay factor for the exponential moving average of
RTT samples, in units of 1/256.  Must be between 1 and 256, inclusive.
Higher values discard old samples faster.  The default is
.BR 42 .
.TP
.BI rtt\-min " rtt"
This specifies the minimum RTT, in milliseconds, starting from which
we increase the cost to a neighbour. The additional cost is linear in
(rtt -
.BR rtt\-min ).
The default is
.B 10
ms.
.TP
.BI rtt\-max " rtt"
This specifies the maximum RTT, in milliseconds, above which we don't
increase the cost to a neighbour. The default is
.B 120
ms.
.TP
.BI max\-rtt\-penalty " cost"
This specifies the maximum cost added to a neighbour because of RTT,
i.e. when the RTT is higher or equal than
.BR rtt\-max .
The default is
.BR 96
if the interface is of type
.B tunnel,
and
.BR 0 
otherwise.
.SS Filtering rules
A filtering rule is defined by a single line with the following format:
.IP
.I filter
.IR selector ...
.I action
.PP
.I Filter
specifies the filter to which this entry will be added, and can be one of
.B in
(applied to routes learned from Babel neighbours),
.B out
(applied to routes announced to Babel neighbours),
.B redistribute
(applied to routes redistributed from the kernel), or
.B install
(applied to routes installed into the kernel).

Each
.I selector
specifies the conditions under which the given statement matches.  It
can be one of
.TP
.BI ip " prefix"
This entry only applies to routes in the given prefix.
.TP
.BI eq " plen"
This entry only applies to routes with a prefix length equal to
.BR plen .
.TP
.BI le " plen"
This entry only applies to routes with a prefix length less or equal to
.BR plen .
.TP
.BI ge " plen"
This entry only applies to routes with a prefix length greater or equal to
.BR plen .
.TP
.BI src-ip " prefix"
This entry only applies to routes with a source prefix in the given prefix.
.TP
.BI src-eq " plen"
This entry only applies to routes with a source prefix length equal to
.BR plen .
.TP
.BI src-le " plen"
This entry only applies to routes with a source prefix length less or
equal to
.BR plen .
.TP
.BI src-ge " plen"
This entry only applies to routes with a source prefix length greater
or equal to
.BR plen .
.TP
.BI neigh " address"
This entry only applies to routes learned from a neighbour with
link-local address
.IR address .
.TP
.BI id " id"
This entry only applies to routes originated by a router with router-id
.IR id .
.TP
.BI proto " p"
This entry only applies to kernel routes with kernel protocol number
.IR p .
If neither
.B proto
nor
.B local
is specified, this entry applies to all non-local kernel routes with
a protocol different from "boot".
.TP
.B local
This entry only applies to local addresses.
.TP
.BI if " interface"
For an input filter, this specifies the interface over which the route
is learned.  For an output filter, this specifies the interface over
which this route is advertised.  For a redistribute statement, this
specifies the interface over which the route forwards packets.
.PP
.I Action
specifies the action to be taken when this entry matches.  It can have
one of the following values:
.TP
.B allow
Allow this route, without changing its metric (or setting its metric
to 0 in case of a redistribute filter).
.TP
.B deny
Ignore this route.
.TP
.BI metric " value"
For an input or output filter, allow this route after increasing its metric by
.IR value .
For a redistribute filter, redistribute this route with metric
.IR value .
.TP
.BI src-prefix " prefix"
For a redistribute filter, set the source prefix of this route to
.IR prefix .
.TP
.BI table " table"
In an
.B install
filter, specify the kernel routing table to use.  For source-specific
routes, this only works reliably for IPv6, and only when
.B ipv6-subtrees
is true.
.PP
If
.I action
is not specified, it defaults to
.BR allow .

By default,
.B babeld
redistributes all local addresses, and no other routes.  In order to
make sure that only the routes you specify are redistributed, you
should include the line
.IP
redistribute local deny
.PP
as the last line in your configuration file.
.SH LOCAL CONFIGURATION INTERFACE
If
.B babeld
is invoked with the flag
.BR \-g ,
it accepts TCP connections from local clients on the given port and address
.B ::1
(the IPv6
.B localhost
address), or on the given UNIX-domain socket path if the argument starts with
\[oq]/\[cq].  When a client connects,
.B babeld
replies with
.B BABEL
followed with the supported version of the local configuration protocol (currently
.BR 1.0 ).
This is followed with a number of informational lines
.RB ( version
etc.), terminated by
.BR ok .
The client can then send requests, one per line.  To each request,
.B babeld
replies with one or more lines of data terminated by one of
.BR ok ,
.BR no ,
or
.BR bad .

The following requests are currently defined:
.IP \(bu 2
any configuration file directive, including
.BR interface ;
.IP \(bu
.BR "flush interface" ;
.IP \(bu
.BR dump ;
.IP \(bu
.B monitor
and
.BR unmonitor ;
.IP \(bu
.BR quit .
.SH EXAMPLES
You can participate in a Babel network by simply running
.IP
# babeld wlan0
.PP
where
.B wlan0
is the name of your wireless interface.

In order to gateway between multiple interfaces, just list them all on
the command line:
.IP
# babeld wlan0 eth0 sit1
.PP
On an access point, you'll probably want to redistribute some external
routes into Babel:
.IP
# babeld \\
    \-C 'redistribute metric 256' \\
    wlan0
.PP
or, if you want to constrain the routes that you redistribute,
.IP
# babeld \\
    \-C 'redistribute proto 11 ip ::/0 le 64 metric 256' \\
    \-C 'redistribute proto 11 ip 0.0.0.0/0 le 24 metric 256' \\
    wlan0
.SS Source-specific routing
.PP
If your want to redistribute kernel routes as source-specific to the network,
with the 2001:DB8:0:1::/64 prefix:
.IP
redistribute src-prefix 2001:DB8:0:1::/64
.PP
For more information about source-specific routing, please see
.IP
Matthieu Boutier and Juliusz Chroboczek.  Source-sensitive routing.  In
Proc. IFIP Networking 2015.  2015.
.PP
available online at
.IP
http://arxiv.org/pdf/1403.0445v4.pdf
.SH FILES
.TP
.B /etc/babeld.conf
The default location of the configuration file.
.TP
.B /var/lib/babel\-state
The default location of the file storing long-term state.
.TP
.B /var/run/babeld.pid
The default location of the pid file.
.TP
.B /var/log/babeld.log
The default location of the log file.
.SH SIGNALS
.TP
.B SIGUSR1
Dump Babel's routing tables to standard output or to the log file.
.TP
.B SIGUSR2
Check interfaces and kernel routes right now, then reopen the log file.
.SH SECURITY
Babel is a completely insecure protocol: any attacker able to inject
IP packets with a link-local source address can disrupt the protocol's
operation.  This is no different from unsecured neighbour discovery or ARP.

Usage of the
.B \-G
flag allows any user logged on the local host to change
.BR babeld 's
configuration.

Since Babel uses link-local IPv6 packets only, there is no need to update
firewalls to allow forwarding of Babel protocol packets.  If local
filtering is being done, UDP datagrams to the port used by the protocol
should be allowed.  As Babel uses unicast packets in some cases, it is not
enough to just allow packets destined to Babel's multicast address.
.SH SEE ALSO
.BR routed (8),
.BR route6d (8),
.BR zebra (8),
.BR ahcpd (8).
.SH AUTHOR
Juliusz Chroboczek.
