// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_3_autogen.cpp:
//   Defines the Desktop GL 3.x entry points.

#include "libGLESv2/entry_points_gl_3_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gl_3_autogen.h"
#include "libANGLE/context_private_call_gl_autogen.h"
#include "libANGLE/context_private_call_gles_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL3_autogen.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {

// GL 3.0
void GL_APIENTRY GL_BeginConditionalRender(GLuint id, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBeginConditionalRender, "context = %d, id = %u, mode = %s", CID(context), id,
          GLenumToString(BigGLEnum::ConditionalRenderMode, mode));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLBeginConditionalRender) &&
              ValidateBeginConditionalRender(context, angle::EntryPoint::GLBeginConditionalRender,
                                             id, mode)));
        if (isCallValid)
        {
            context->beginConditionalRender(id, mode);
        }
        ANGLE_CAPTURE_GL(BeginConditionalRender, isCallValid, context, id, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindFragDataLocation(GLuint program, GLuint color, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFragDataLocation,
          "context = %d, program = %u, color = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          color, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLBindFragDataLocation) &&
              ValidateBindFragDataLocation(context, angle::EntryPoint::GLBindFragDataLocation,
                                           programPacked, color, name)));
        if (isCallValid)
        {
            context->bindFragDataLocation(programPacked, color, name);
        }
        ANGLE_CAPTURE_GL(BindFragDataLocation, isCallValid, context, programPacked, color, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClampColor(GLenum target, GLenum clamp)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClampColor, "context = %d, target = %s, clamp = %s", CID(context),
          GLenumToString(BigGLEnum::AllEnums, target), GLenumToString(BigGLEnum::AllEnums, clamp));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLClampColor) &&
              ValidateClampColor(context, angle::EntryPoint::GLClampColor, target, clamp)));
        if (isCallValid)
        {
            context->clampColor(target, clamp);
        }
        ANGLE_CAPTURE_GL(ClampColor, isCallValid, context, target, clamp);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EndConditionalRender()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndConditionalRender, "context = %d", CID(context));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLEndConditionalRender) &&
              ValidateEndConditionalRender(context, angle::EntryPoint::GLEndConditionalRender)));
        if (isCallValid)
        {
            context->endConditionalRender();
        }
        ANGLE_CAPTURE_GL(EndConditionalRender, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferTexture1D(GLenum target,
                                         GLenum attachment,
                                         GLenum textarget,
                                         GLuint texture,
                                         GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture1D,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
          CID(context), GLenumToString(BigGLEnum::FramebufferTarget, target),
          GLenumToString(BigGLEnum::FramebufferAttachment, attachment),
          GLenumToString(BigGLEnum::TextureTarget, textarget), texture, level);

    if (context)
    {
        TextureTarget textargetPacked = PackParam<TextureTarget>(textarget);
        TextureID texturePacked       = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLFramebufferTexture1D) &&
              ValidateFramebufferTexture1D(context, angle::EntryPoint::GLFramebufferTexture1D,
                                           target, attachment, textargetPacked, texturePacked,
                                           level)));
        if (isCallValid)
        {
            context->framebufferTexture1D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE_GL(FramebufferTexture1D, isCallValid, context, target, attachment,
                         textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferTexture3D(GLenum target,
                                         GLenum attachment,
                                         GLenum textarget,
                                         GLuint texture,
                                         GLint level,
                                         GLint zoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture3D,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "zoffset = %d",
          CID(context), GLenumToString(BigGLEnum::FramebufferTarget, target),
          GLenumToString(BigGLEnum::FramebufferAttachment, attachment),
          GLenumToString(BigGLEnum::TextureTarget, textarget), texture, level, zoffset);

    if (context)
    {
        TextureTarget textargetPacked = PackParam<TextureTarget>(textarget);
        TextureID texturePacked       = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLFramebufferTexture3D) &&
              ValidateFramebufferTexture3D(context, angle::EntryPoint::GLFramebufferTexture3D,
                                           target, attachment, textargetPacked, texturePacked,
                                           level, zoffset)));
        if (isCallValid)
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texturePacked, level,
                                          zoffset);
        }
        ANGLE_CAPTURE_GL(FramebufferTexture3D, isCallValid, context, target, attachment,
                         textargetPacked, texturePacked, level, zoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI1i(GLuint index, GLint x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI1i, "context = %d, index = %u, x = %d", CID(context), index, x);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI1i(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLVertexAttribI1i, index, x));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI1i(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), index, x);
        }
        ANGLE_CAPTURE_GL(VertexAttribI1i, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI1iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI1iv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI1iv(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI1iv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI1iv(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI1iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI1ui(GLuint index, GLuint x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI1ui, "context = %d, index = %u, x = %u", CID(context), index, x);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI1ui(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI1ui, index, x));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI1ui(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, x);
        }
        ANGLE_CAPTURE_GL(VertexAttribI1ui, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI1uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI1uiv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI1uiv(context->getPrivateState(),
                                       context->getMutableErrorSetForValidation(),
                                       angle::EntryPoint::GLVertexAttribI1uiv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI1uiv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI1uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI2i(GLuint index, GLint x, GLint y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI2i, "context = %d, index = %u, x = %d, y = %d", CID(context),
          index, x, y);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI2i(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLVertexAttribI2i, index, x, y));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI2i(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), index, x, y);
        }
        ANGLE_CAPTURE_GL(VertexAttribI2i, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI2iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI2iv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI2iv(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI2iv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI2iv(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI2iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI2ui(GLuint index, GLuint x, GLuint y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI2ui, "context = %d, index = %u, x = %u, y = %u", CID(context),
          index, x, y);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI2ui(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI2ui, index, x, y));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI2ui(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, x, y);
        }
        ANGLE_CAPTURE_GL(VertexAttribI2ui, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI2uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI2uiv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI2uiv(context->getPrivateState(),
                                       context->getMutableErrorSetForValidation(),
                                       angle::EntryPoint::GLVertexAttribI2uiv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI2uiv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI2uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI3i(GLuint index, GLint x, GLint y, GLint z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI3i, "context = %d, index = %u, x = %d, y = %d, z = %d",
          CID(context), index, x, y, z);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI3i(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLVertexAttribI3i, index, x, y, z));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI3i(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), index, x, y, z);
        }
        ANGLE_CAPTURE_GL(VertexAttribI3i, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI3iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI3iv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI3iv(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI3iv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI3iv(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI3iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI3ui, "context = %d, index = %u, x = %u, y = %u, z = %u",
          CID(context), index, x, y, z);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI3ui(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI3ui, index, x, y, z));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI3ui(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, x, y, z);
        }
        ANGLE_CAPTURE_GL(VertexAttribI3ui, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI3uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI3uiv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI3uiv(context->getPrivateState(),
                                       context->getMutableErrorSetForValidation(),
                                       angle::EntryPoint::GLVertexAttribI3uiv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI3uiv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI3uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI4bv(GLuint index, const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI4bv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI4bv(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI4bv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI4bv(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI4bv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI4sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI4sv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI4sv(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLVertexAttribI4sv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI4sv(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI4sv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI4ubv(GLuint index, const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI4ubv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI4ubv(context->getPrivateState(),
                                       context->getMutableErrorSetForValidation(),
                                       angle::EntryPoint::GLVertexAttribI4ubv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI4ubv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI4ubv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribI4usv(GLuint index, const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribI4usv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribI4usv(context->getPrivateState(),
                                       context->getMutableErrorSetForValidation(),
                                       angle::EntryPoint::GLVertexAttribI4usv, index, v));
        if (isCallValid)
        {
            ContextPrivateVertexAttribI4usv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribI4usv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL 3.1
void GL_APIENTRY GL_GetActiveUniformName(GLuint program,
                                         GLuint uniformIndex,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLchar *uniformName)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveUniformName,
          "context = %d, program = %u, uniformIndex = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", uniformName = 0x%016" PRIxPTR "",
          CID(context), program, uniformIndex, bufSize, (uintptr_t)length, (uintptr_t)uniformName);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetActiveUniformName(
                                context, angle::EntryPoint::GLGetActiveUniformName, programPacked,
                                uniformIndex, bufSize, length, uniformName));
        if (isCallValid)
        {
            context->getActiveUniformName(programPacked, uniformIndex, bufSize, length,
                                          uniformName);
        }
        ANGLE_CAPTURE_GL(GetActiveUniformName, isCallValid, context, programPacked, uniformIndex,
                         bufSize, length, uniformName);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PrimitiveRestartIndex(GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPrimitiveRestartIndex, "context = %d, index = %u", CID(context), index);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLPrimitiveRestartIndex) &&
              ValidatePrimitiveRestartIndex(context, angle::EntryPoint::GLPrimitiveRestartIndex,
                                            index)));
        if (isCallValid)
        {
            context->primitiveRestartIndex(index);
        }
        ANGLE_CAPTURE_GL(PrimitiveRestartIndex, isCallValid, context, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL 3.2
void GL_APIENTRY GL_MultiDrawElementsBaseVertex(GLenum mode,
                                                const GLsizei *count,
                                                GLenum type,
                                                const void *const *indices,
                                                GLsizei drawcount,
                                                const GLint *basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsBaseVertex,
          "context = %d, mode = %s, count = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", drawcount = %d, basevertex = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(BigGLEnum::DrawElementsType, type), (uintptr_t)indices, drawcount,
          (uintptr_t)basevertex);

    if (context)
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiDrawElementsBaseVertex) &&
              ValidateMultiDrawElementsBaseVertex(
                  context, angle::EntryPoint::GLMultiDrawElementsBaseVertex, modePacked, count,
                  typePacked, indices, drawcount, basevertex)));
        if (isCallValid)
        {
            context->multiDrawElementsBaseVertex(modePacked, count, typePacked, indices, drawcount,
                                                 basevertex);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsBaseVertex, isCallValid, context, modePacked, count,
                         typePacked, indices, drawcount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProvokingVertex(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProvokingVertex, "context = %d, mode = %s", CID(context),
          GLenumToString(BigGLEnum::VertexProvokingMode, mode));

    if (context)
    {
        ProvokingVertexConvention modePacked = PackParam<ProvokingVertexConvention>(mode);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLProvokingVertex) &&
              ValidateProvokingVertex(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLProvokingVertex, modePacked)));
        if (isCallValid)
        {
            ContextPrivateProvokingVertex(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), modePacked);
        }
        ANGLE_CAPTURE_GL(ProvokingVertex, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexImage2DMultisample(GLenum target,
                                          GLsizei samples,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage2DMultisample,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d, "
          "fixedsamplelocations = %s",
          CID(context), GLenumToString(BigGLEnum::TextureTarget, target), samples,
          GLenumToString(BigGLEnum::InternalFormat, internalformat), width, height,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexImage2DMultisample) &&
              ValidateTexImage2DMultisample(context, angle::EntryPoint::GLTexImage2DMultisample,
                                            target, samples, internalformat, width, height,
                                            fixedsamplelocations)));
        if (isCallValid)
        {
            context->texImage2DMultisample(target, samples, internalformat, width, height,
                                           fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TexImage2DMultisample, isCallValid, context, target, samples,
                         internalformat, width, height, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexImage3DMultisample(GLenum target,
                                          GLsizei samples,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth,
                                          GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage3DMultisample,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, fixedsamplelocations = %s",
          CID(context), GLenumToString(BigGLEnum::TextureTarget, target), samples,
          GLenumToString(BigGLEnum::InternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexImage3DMultisample) &&
              ValidateTexImage3DMultisample(context, angle::EntryPoint::GLTexImage3DMultisample,
                                            target, samples, internalformat, width, height, depth,
                                            fixedsamplelocations)));
        if (isCallValid)
        {
            context->texImage3DMultisample(target, samples, internalformat, width, height, depth,
                                           fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TexImage3DMultisample, isCallValid, context, target, samples,
                         internalformat, width, height, depth, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL 3.3
void GL_APIENTRY GL_BindFragDataLocationIndexed(GLuint program,
                                                GLuint colorNumber,
                                                GLuint index,
                                                const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFragDataLocationIndexed,
          "context = %d, program = %u, colorNumber = %u, index = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLBindFragDataLocationIndexed) &&
              ValidateBindFragDataLocationIndexed(context,
                                                  angle::EntryPoint::GLBindFragDataLocationIndexed,
                                                  programPacked, colorNumber, index, name)));
        if (isCallValid)
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE_GL(BindFragDataLocationIndexed, isCallValid, context, programPacked,
                         colorNumber, index, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorP3ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorP3ui, "context = %d, type = %s, color = %u", CID(context),
          GLenumToString(BigGLEnum::ColorPointerType, type), color);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLColorP3ui) &&
              ValidateColorP3ui(context, angle::EntryPoint::GLColorP3ui, type, color)));
        if (isCallValid)
        {
            context->colorP3ui(type, color);
        }
        ANGLE_CAPTURE_GL(ColorP3ui, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorP3uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorP3uiv, "context = %d, type = %s, color = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLColorP3uiv) &&
              ValidateColorP3uiv(context, angle::EntryPoint::GLColorP3uiv, type, color)));
        if (isCallValid)
        {
            context->colorP3uiv(type, color);
        }
        ANGLE_CAPTURE_GL(ColorP3uiv, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorP4ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorP4ui, "context = %d, type = %s, color = %u", CID(context),
          GLenumToString(BigGLEnum::ColorPointerType, type), color);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLColorP4ui) &&
              ValidateColorP4ui(context, angle::EntryPoint::GLColorP4ui, type, color)));
        if (isCallValid)
        {
            context->colorP4ui(type, color);
        }
        ANGLE_CAPTURE_GL(ColorP4ui, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorP4uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorP4uiv, "context = %d, type = %s, color = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLColorP4uiv) &&
              ValidateColorP4uiv(context, angle::EntryPoint::GLColorP4uiv, type, color)));
        if (isCallValid)
        {
            context->colorP4uiv(type, color);
        }
        ANGLE_CAPTURE_GL(ColorP4uiv, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLint GL_APIENTRY GL_GetFragDataIndex(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFragDataIndex, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetFragDataIndex(context, angle::EntryPoint::GLGetFragDataIndex,
                                                     programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndex, GLint>();
        }
        ANGLE_CAPTURE_GL(GetFragDataIndex, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndex, GLint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjecti64v,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(BigGLEnum::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryObjecti64v(context, angle::EntryPoint::GLGetQueryObjecti64v, idPacked,
                                        pname, params));
        if (isCallValid)
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjecti64v, isCallValid, context, idPacked, pname, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryObjectui64v,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(BigGLEnum::QueryObjectParameterName, pname), (uintptr_t)params);

    if (context)
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryObjectui64v(context, angle::EntryPoint::GLGetQueryObjectui64v,
                                         idPacked, pname, params));
        if (isCallValid)
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectui64v, isCallValid, context, idPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP1ui, "context = %d, texture = %s, type = %s, coords = %u",
          CID(context), GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP1ui) &&
              ValidateMultiTexCoordP1ui(context, angle::EntryPoint::GLMultiTexCoordP1ui, texture,
                                        type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP1ui(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP1ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP1uiv,
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP1uiv) &&
              ValidateMultiTexCoordP1uiv(context, angle::EntryPoint::GLMultiTexCoordP1uiv, texture,
                                         type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP1uiv(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP1uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP2ui, "context = %d, texture = %s, type = %s, coords = %u",
          CID(context), GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP2ui) &&
              ValidateMultiTexCoordP2ui(context, angle::EntryPoint::GLMultiTexCoordP2ui, texture,
                                        type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP2ui(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP2ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP2uiv,
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP2uiv) &&
              ValidateMultiTexCoordP2uiv(context, angle::EntryPoint::GLMultiTexCoordP2uiv, texture,
                                         type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP2uiv(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP2uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP3ui, "context = %d, texture = %s, type = %s, coords = %u",
          CID(context), GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP3ui) &&
              ValidateMultiTexCoordP3ui(context, angle::EntryPoint::GLMultiTexCoordP3ui, texture,
                                        type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP3ui(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP3ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP3uiv,
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP3uiv) &&
              ValidateMultiTexCoordP3uiv(context, angle::EntryPoint::GLMultiTexCoordP3uiv, texture,
                                         type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP3uiv(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP3uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP4ui, "context = %d, texture = %s, type = %s, coords = %u",
          CID(context), GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP4ui) &&
              ValidateMultiTexCoordP4ui(context, angle::EntryPoint::GLMultiTexCoordP4ui, texture,
                                        type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP4ui(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP4ui, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoordP4uiv,
          "context = %d, texture = %s, type = %s, coords = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::TextureUnit, texture),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultiTexCoordP4uiv) &&
              ValidateMultiTexCoordP4uiv(context, angle::EntryPoint::GLMultiTexCoordP4uiv, texture,
                                         type, coords)));
        if (isCallValid)
        {
            context->multiTexCoordP4uiv(texture, type, coords);
        }
        ANGLE_CAPTURE_GL(MultiTexCoordP4uiv, isCallValid, context, texture, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_NormalP3ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormalP3ui, "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(BigGLEnum::NormalPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLNormalP3ui) &&
              ValidateNormalP3ui(context, angle::EntryPoint::GLNormalP3ui, type, coords)));
        if (isCallValid)
        {
            context->normalP3ui(type, coords);
        }
        ANGLE_CAPTURE_GL(NormalP3ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_NormalP3uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormalP3uiv, "context = %d, type = %s, coords = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::NormalPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLNormalP3uiv) &&
              ValidateNormalP3uiv(context, angle::EntryPoint::GLNormalP3uiv, type, coords)));
        if (isCallValid)
        {
            context->normalP3uiv(type, coords);
        }
        ANGLE_CAPTURE_GL(NormalP3uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_QueryCounter(GLuint id, GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLQueryCounter, "context = %d, id = %u, target = %s", CID(context), id,
          GLenumToString(BigGLEnum::QueryCounterTarget, target));

    if (context)
    {
        QueryID idPacked       = PackParam<QueryID>(id);
        QueryType targetPacked = PackParam<QueryType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLQueryCounter) &&
              ValidateQueryCounter(context, angle::EntryPoint::GLQueryCounter, idPacked,
                                   targetPacked)));
        if (isCallValid)
        {
            context->queryCounter(idPacked, targetPacked);
        }
        ANGLE_CAPTURE_GL(QueryCounter, isCallValid, context, idPacked, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SecondaryColorP3ui(GLenum type, GLuint color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColorP3ui, "context = %d, type = %s, color = %u", CID(context),
          GLenumToString(BigGLEnum::ColorPointerType, type), color);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLSecondaryColorP3ui) &&
              ValidateSecondaryColorP3ui(context, angle::EntryPoint::GLSecondaryColorP3ui, type,
                                         color)));
        if (isCallValid)
        {
            context->secondaryColorP3ui(type, color);
        }
        ANGLE_CAPTURE_GL(SecondaryColorP3ui, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SecondaryColorP3uiv(GLenum type, const GLuint *color)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSecondaryColorP3uiv, "context = %d, type = %s, color = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::ColorPointerType, type), (uintptr_t)color);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLSecondaryColorP3uiv) &&
              ValidateSecondaryColorP3uiv(context, angle::EntryPoint::GLSecondaryColorP3uiv, type,
                                          color)));
        if (isCallValid)
        {
            context->secondaryColorP3uiv(type, color);
        }
        ANGLE_CAPTURE_GL(SecondaryColorP3uiv, isCallValid, context, type, color);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP1ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP1ui, "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP1ui) &&
              ValidateTexCoordP1ui(context, angle::EntryPoint::GLTexCoordP1ui, type, coords)));
        if (isCallValid)
        {
            context->texCoordP1ui(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP1ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP1uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP1uiv, "context = %d, type = %s, coords = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP1uiv) &&
              ValidateTexCoordP1uiv(context, angle::EntryPoint::GLTexCoordP1uiv, type, coords)));
        if (isCallValid)
        {
            context->texCoordP1uiv(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP1uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP2ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP2ui, "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP2ui) &&
              ValidateTexCoordP2ui(context, angle::EntryPoint::GLTexCoordP2ui, type, coords)));
        if (isCallValid)
        {
            context->texCoordP2ui(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP2ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP2uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP2uiv, "context = %d, type = %s, coords = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP2uiv) &&
              ValidateTexCoordP2uiv(context, angle::EntryPoint::GLTexCoordP2uiv, type, coords)));
        if (isCallValid)
        {
            context->texCoordP2uiv(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP2uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP3ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP3ui, "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP3ui) &&
              ValidateTexCoordP3ui(context, angle::EntryPoint::GLTexCoordP3ui, type, coords)));
        if (isCallValid)
        {
            context->texCoordP3ui(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP3ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP3uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP3uiv, "context = %d, type = %s, coords = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP3uiv) &&
              ValidateTexCoordP3uiv(context, angle::EntryPoint::GLTexCoordP3uiv, type, coords)));
        if (isCallValid)
        {
            context->texCoordP3uiv(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP3uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP4ui(GLenum type, GLuint coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP4ui, "context = %d, type = %s, coords = %u", CID(context),
          GLenumToString(BigGLEnum::TexCoordPointerType, type), coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP4ui) &&
              ValidateTexCoordP4ui(context, angle::EntryPoint::GLTexCoordP4ui, type, coords)));
        if (isCallValid)
        {
            context->texCoordP4ui(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP4ui, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordP4uiv(GLenum type, const GLuint *coords)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordP4uiv, "context = %d, type = %s, coords = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::TexCoordPointerType, type), (uintptr_t)coords);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLTexCoordP4uiv) &&
              ValidateTexCoordP4uiv(context, angle::EntryPoint::GLTexCoordP4uiv, type, coords)));
        if (isCallValid)
        {
            context->texCoordP4uiv(type, coords);
        }
        ANGLE_CAPTURE_GL(TexCoordP4uiv, isCallValid, context, type, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP1ui,
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(BigGLEnum::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP1ui(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP1ui, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP1ui(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, type,
                                           normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP1ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP1uiv(GLuint index,
                                      GLenum type,
                                      GLboolean normalized,
                                      const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP1uiv,
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(BigGLEnum::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP1uiv(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP1uiv, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP1uiv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, type,
                                            normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP1uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP2ui,
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(BigGLEnum::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP2ui(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP2ui, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP2ui(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, type,
                                           normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP2ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP2uiv(GLuint index,
                                      GLenum type,
                                      GLboolean normalized,
                                      const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP2uiv,
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(BigGLEnum::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP2uiv(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP2uiv, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP2uiv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, type,
                                            normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP2uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP3ui,
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(BigGLEnum::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP3ui(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP3ui, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP3ui(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, type,
                                           normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP3ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP3uiv(GLuint index,
                                      GLenum type,
                                      GLboolean normalized,
                                      const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP3uiv,
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(BigGLEnum::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP3uiv(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP3uiv, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP3uiv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, type,
                                            normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP3uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP4ui,
          "context = %d, index = %u, type = %s, normalized = %s, value = %u", CID(context), index,
          GLenumToString(BigGLEnum::VertexAttribPointerType, type), GLbooleanToString(normalized),
          value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP4ui(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP4ui, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP4ui(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), index, type,
                                           normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP4ui, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribP4uiv(GLuint index,
                                      GLenum type,
                                      GLboolean normalized,
                                      const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribP4uiv,
          "context = %d, index = %u, type = %s, normalized = %s, value = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(BigGLEnum::VertexAttribPointerType, type),
          GLbooleanToString(normalized), (uintptr_t)value);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribP4uiv(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLVertexAttribP4uiv, index, type, normalized, value));
        if (isCallValid)
        {
            ContextPrivateVertexAttribP4uiv(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), index, type,
                                            normalized, value);
        }
        ANGLE_CAPTURE_GL(VertexAttribP4uiv, isCallValid, context, index, type, normalized, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexP2ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexP2ui, "context = %d, type = %s, value = %u", CID(context),
          GLenumToString(BigGLEnum::VertexPointerType, type), value);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLVertexP2ui) &&
              ValidateVertexP2ui(context, angle::EntryPoint::GLVertexP2ui, type, value)));
        if (isCallValid)
        {
            context->vertexP2ui(type, value);
        }
        ANGLE_CAPTURE_GL(VertexP2ui, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexP2uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexP2uiv, "context = %d, type = %s, value = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLVertexP2uiv) &&
              ValidateVertexP2uiv(context, angle::EntryPoint::GLVertexP2uiv, type, value)));
        if (isCallValid)
        {
            context->vertexP2uiv(type, value);
        }
        ANGLE_CAPTURE_GL(VertexP2uiv, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexP3ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexP3ui, "context = %d, type = %s, value = %u", CID(context),
          GLenumToString(BigGLEnum::VertexPointerType, type), value);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLVertexP3ui) &&
              ValidateVertexP3ui(context, angle::EntryPoint::GLVertexP3ui, type, value)));
        if (isCallValid)
        {
            context->vertexP3ui(type, value);
        }
        ANGLE_CAPTURE_GL(VertexP3ui, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexP3uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexP3uiv, "context = %d, type = %s, value = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLVertexP3uiv) &&
              ValidateVertexP3uiv(context, angle::EntryPoint::GLVertexP3uiv, type, value)));
        if (isCallValid)
        {
            context->vertexP3uiv(type, value);
        }
        ANGLE_CAPTURE_GL(VertexP3uiv, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexP4ui(GLenum type, GLuint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexP4ui, "context = %d, type = %s, value = %u", CID(context),
          GLenumToString(BigGLEnum::VertexPointerType, type), value);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLVertexP4ui) &&
              ValidateVertexP4ui(context, angle::EntryPoint::GLVertexP4ui, type, value)));
        if (isCallValid)
        {
            context->vertexP4ui(type, value);
        }
        ANGLE_CAPTURE_GL(VertexP4ui, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexP4uiv(GLenum type, const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexP4uiv, "context = %d, type = %s, value = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::VertexPointerType, type), (uintptr_t)value);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLVertexP4uiv) &&
              ValidateVertexP4uiv(context, angle::EntryPoint::GLVertexP4uiv, type, value)));
        if (isCallValid)
        {
            context->vertexP4uiv(type, value);
        }
        ANGLE_CAPTURE_GL(VertexP4uiv, isCallValid, context, type, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

}  // extern "C"
