#  File src/library/utils/R/MARC.R
#  Part of the R package, http://www.R-project.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  http://www.r-project.org/Licenses/


MARC_relator_db <-
structure(list(term = c("Actor", "Adapter", "Annotator", "Applicant",
"Architect", "Arranger", "Artist", "Assignee", "Associated name",
"Attributed name", "Auctioneer", "Author", "Author in quotations or text extracts",
"Author of afterword, colophon, etc.", "Author of dialog", "Author of introduction, etc.",
"Author of screenplay, etc.", "Bibliographic antecedent", "Binder",
"Binding designer", "Book designer", "Book producer", "Bookjacket designer",
"Bookplate designer", "Bookseller", "Calligrapher", "Cartographer",
"Censor", "Choreographer", "Client", "Collaborator", "Collector",
"Collotyper", "Commentator", "Commentator for written text",
"Compiler", "Complainant", "Complainant-appellant", "Complainant-appellee",
"Composer", "Compositor", "Conceptor", "Conductor", "Consultant",
"Consultant to a project", "Contestant", "Contestant-appellant",
"Contestant-appellee", "Contestee", "Contestee-appellant", "Contestee-appellee",
"Contractor", "Contributor", "Copyright claimant", "Copyright holder",
"Corrector", "Correspondent", "Costume designer", "Creator",
"Curator of an exhibition", "Dancer", "Dedicatee", "Dedicator",
"Defendant", "Defendant-appellant", "Defendant-appellee", "Degree grantor",
"Delineator", "Depositor", "Designer", "Director", "Dissertant",
"Distributor", "Donor", "Draftsman", "Dubious author", "Editor",
"Electrotyper", "Engineer", "Engraver", "Etcher", "Expert", "Facsimilist",
"Film editor", "Forger", "Former owner", "Funder", "Honoree",
"Host", "Illuminator", "Illustrator", "Inscriber", "Instrumentalist",
"Interviewee", "Interviewer", "Inventor", "Landscape architect",
"Lender", "Libelant", "Libelant-appellant", "Libelant-appellee",
"Libelee", "Libelee-appellant", "Libelee-appellee", "Librettist",
"Licensee", "Licensor", "Lithographer", "Lyricist", "Metadata contact",
"Metal-engraver", "Moderator", "Monitor", "Musician", "Narrator",
"Opponent", "Organizer of meeting", "Originator", "Other", "Owner",
"Papermaker", "Patent applicant", "Patent holder", "Patron",
"Performer", "Photographer", "Plaintiff", "Plaintiff-appellant",
"Plaintiff-appellee", "Platemaker", "Printer", "Printer of plates",
"Process contact", "Producer", "Production personnel", "Programmer",
"Proofreader", "Publisher", "Publishing director", "Recipient",
"Recording engineer", "Redactor", "Renderer", "Research team head",
"Research team member", "Researcher", "Respondent", "Respondent-appellant",
"Respondent-appellee", "Reviewer", "Rubricator", "Scenarist",
"Scientific advisor", "Scribe", "Sculptor", "Secretary", "Signer",
"Singer", "Speaker", "Sponsor", "Standards body", "Stereotyper",
"Surveyor", "Thesis advisor", "Transcriber", "Translator", "Type designer",
"Typographer", "Vocalist", "Witness", "Wood-engraver", "Woodcutter",
"Writer of accompanying material"), code = c("act", "adp", "ann",
"app", "arc", "arr", "art", "asg", "asn", "att", "auc", "aut",
"aqt", "aft", "aud", "aui", "aus", "ant", "bnd", "bdd ", "bkd",
"bkp", "bjd", "bpd", "bsl", "cll", "ctg", "cns", "chr", "cli",
"clb", "col", "clt", "cmm", "cwt", "com", "cpl", "cpt", "cpe",
"cmp", "cmt ", "ccp", "cnd", "csl", "csp", "cos", "cot", "coe",
"cts", "ctt", "cte", "ctr", "ctb", "cpc", "cph", "crr", "crp",
"cst", "cre", "cur", "dnc", "dte", "dto", "dfd", "dft", "dfe",
"dgg", "dln", "dpt", "dsr", "drt", "dis", "dst", "dnr", "drm",
"dub", "edt", "elt", "eng", "egr", "etr", "exp", "fac", "flm",
"frg ", "fmo", "fnd", "hnr", "hst", "ilu", "ill", "ins", "itr",
"ive", "ivr", "inv", "lsa", "len", "lil", "lit", "lie", "lel",
"let", "lee", "lbt", "lse", "lso", "ltg", "lyr", "mdc", "mte",
"mod", "mon", "mus", "nrt", "opn", "orm", "org", "oth", "own",
"ppm", "pta", "pth", "pat", "prf", "pht", "ptf", "ptt", "pte",
"plt", "prt", "pop", "prc", "pro", "prd", "prg", "pfr", "pbl",
"pbd", "rcp", "rce", "red", "ren", "rth", "rtm", "res", "rsp",
"rst", "rse", "rev", "rbr", "sce", "sad", "scr", "scl", "sec",
"sgn", "sng", "spk", "spn", "stn", "str", "srv", "ths", "trc",
"trl", "tyd", "tyg", "voc", "wit", "wde", "wdc", "wam"), description = c("Use for a person who principally exhibits acting skills in a musical or dramatic presentation or entertainment.",
"Use for a person who 1) reworks a musical composition, usually for a different medium, or 2) rewrites novels or stories for motion pictures or other audiovisual medium.",
"Use for a person who writes manuscript annotations on a printed item.",
"Appraiser (USE: Expert)", "", "Use for a person who transcribes a musical composition, usually for a different medium from that of the original, in an arrangement the musical substance remains essentially unchanged.",
"Use for a person (e.g., a painter) who conceives, and perhaps also implements, an original graphic design or work of art, if specific codes (e.g., [egr], [etr]) are not desired. For book illustrators, prefer Illustrator [ill]. (UF: Graphic technician)",
"Use for a person or organization to whom a license for printing or publishing has been transferred.",
"Use as a general relator for a name associated with or found in an item or collection, or which cannot be determined to be that of a Former owner [fmo] or other designated relator indicative of provenance.",
"Use to relate an author, artist, etc. to a work for which there is or once was substantial authority for designating that person as author, creator, etc. of the work. (UF: Supposed name)",
"Use for a person or corporate body in change or the estimation and public auctioning of goods, particularly books, artistic works, etc.",
"Use for a person or corporate body chiefly responsible for the intellectual or artistic content of a work, usually printed text. This term may also be used when more than one person or body bears such responsibility. (UF: Joint author)",
"Use for a person whose work is largely quoted or extracted in a works to which he or she did not contribute directly. Such quotations are found particularly in exhibition catalogs, collections of photographs, etc.",
"Use for a person or corporate body responsible for an afterword, postface, colophon, etc. but who is not the chief author of a work.",
"Use for a person or corporate body responsible for the dialog or spoken commentary for a screenplay or sound recording.",
"Use for a person or corporate body responsible for an introduction, preface, foreword, or other critical introductory matter, but who is not the chief author.",
"Use for a person or corporate body responsible for a motion picture screenplay, dialog, spoken commentary, etc.",
"Use for the author responsible for a work upon which the work represented by the catalog record is based. This may be appropriate for adaptations, sequels, continuations, indexes, etc.",
"", "(UF: Designer of binding)", "Use for the person or firm responsible for the entire graphic design of a book, including arrangement of type and illustration, choice of materials, and process used. (UF: Designer of book)",
"Use for the person or firm responsible for the production of books and other print media, if specific codes (e.g., [bkd], [egr], [tyd], [prt]) are not desired. (UF: Producer of book)",
"(UF: Designer of bookjacket)", "(UF: Designer of bookplate)",
"Bowdlerizer (USE: Censor)", "", "", "Use for a censor, bowdlerizer, expurgator, etc., official or private. (UF: Bowdlerizer, Expurgator)",
"Use for a person who composes or arranges dances or other movements (e.g., 'master of swords') for a musical or dramatic presentation or entertainment.",
"Use for a person or organization for whom another person or organization is acting.",
"Use for a person or corporate body that takes a limited part in the elaboration of a work of another person or corporate body that brings complements (e.g., appendices, notes) to the work.",
"Use for a person who has brought together material from various sources, which has been arranged, described, and cataloged as a collection. The collector is neither the creator of the material nor the person to whom manuscripts in the collection may have been addressed.",
"", "Use for a person who provides interpretation, analysis, or a discussion of the subject matter on a recording, motion picture, or other audiovisual medium.",
"Use for a person or corporate body responsible for the commentary or explanatory notes about a text. For the writer of manuscript annotations in a printed book, use Annotator [ann].",
"Use for a person who produces a work or publication by selecting and putting together material from the works of various persons or bodies.",
"Use for the party who applies to the courts for redress, usually in an equity proceeding.",
"Use for a complainant who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding.",
"Use for a complainant against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding.",
"Use for a person who creates a musical work, usually a piece of music in manuscript or printed form.",
"(UF: Typesetter)", "Use for a person or corporate body responsible for the original idea on which a work is based, this includes the scientific author of an audio-visual item and the conceptor of an advertisement.",
"Use for a person who directs a performing group (orchestra, chorus, opera, etc.).",
"Use for the person called upon for professional advice or services in a specialized field of knowledge or training.",
"Use for a person or corporate body engaged specifically to provide an intellectual overview of a strategic or operational task and by analysis, specification, or instruction, to create or propose a cost-effective course of action or solution.",
"Use for the party who opposes, resists, or disputes, in a court of law, a claim, decision, result, etc.",
"Use for a contestant who takes an appeal from one court of law or jurisdiction to another to reverse the judgment.",
"Use for a contestant against whom an appeal is taken from one court of law or jurisdiction to another to reverse the judgment.",
"Use for the party defending a claim, decision, result, etc. being opposed, resisted, or disputed in a court of law.",
"Use for a contestee who takes an appeal from one court or jurisdiction to another to reverse the judgment.",
"Use for a contestee against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment.",
"Use for the person or corporate body who enters into a contract with another person or corporate body to perform a specific task.",
"Use for one whose work has been contributed to a larger work, such as an anthology, serial publication, or other compilation of individual works. Do not use for someone whose sole function in relation to a work is as author, editor, compiler or translator.",
"Use for the person listed as a copyright owner at the time of registration. Copyright can be granted or later transferred to another person or agent, at which time the claimant becomes the copyright holder.",
"", "Use for a corrector of manuscripts, such as the scriptorium official who corrected the work of a scribe. For printed matter, use Proofreader [pfr].",
"Use for a person or organization who was either the writer or recipient of a letter or other communication.",
"Use for a person who designs or makes costumes, fixes hair, etc., for a musical or dramatic presentation or entertainment. // Counterfeiter (USE: Forger)",
"Use for a person or corporate body responsible for the intellectual or artistic content of a work.",
"Use for a person who is responsible for conceiving and organizing an exhibition.",
"Use for a person who principally exhibits dancing skills in a musical or dramatic presentation or entertainment.",
"Use for a person or organization to whom a book, manuscript, etc., is dedicated (not the recipient of a gift).",
"Use for the author of a dedication, which may be a formal statement or in epistolary or verse form.",
"Use for the party defending or denying allegations made in a suit and against whom relief or recovery is sought in the courts, usually in a legal action.",
"Use for a defendant who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in a legal action.",
"Use for a defendant against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in a legal action.",
"Use for the corporate body granting a degree for which the thesis or dissertation described was presented.",
"Use for a person or organization executing technical drawings from others' designs. // Deponent (USE: Witness)",
"Use for a person or organization placing material in the physical custody of a library or repository without transferring the legal title.",
"Use for a person or organization responsible for design if specific codes (e.g., [bkd], [tyd]) are not desired. // Designer of binding (USE: Binding designer) // Designer of book (USE: Book designer) // Designer of bookjacket (USE: Bookjacket designer) // Designer of bookplate (USE: Bookplate designer) // Designer of type (USE: Type designer)",
"Use for a person who is responsible for the general management of a work or who supervises the production of a performance for stage, screen, or sound recording.",
"Use for a person who presents a thesis for a university or higher-level educational degree.",
"Use for an agent or agency that has exclusive or shared marketing rights for an item.",
"Use for the donor of a book, manuscript, etc., to its present owner. Donors to previous owners are designated as Former owner [fmo] or Inscriber [ins].",
"Use for the person who prepares technical or mechanical drawings. (UF: Technical draftsman)",
"Use for a person or corporate body to which authorship has been dubiously or incorrectly ascribed.",
"Use for a person who prepares for publication a work not primarily his/her own, such as by elucidating text, adding introductory or other critical matter, or technically directing an editorial staff.",
"", "Use for a person or organization that is responsible for technical planning and design, particularly with construction.",
"", "", "Use for a person in charge of the description and appraisal of the value of goods, particularly rare items, works of art, etc. (UF: Appraiser) // Eyewitness (USE: Witness) // Expurgator (USE: Censor)",
"Use for the person or body that executed the facsimile. (UF: Copier)",
"Use for an editor of a motion picture film. This term is used regardless of the medium upon which the motion picture is produced or manufactured (e.g., acetate film, video tape). (UF: Motion picture editor)",
"(UF: Copier, Counterfeiter)", "Use for the person or organization who owned an item at any time in the past. Includes those to whom the material was once presented. The person or organization giving the item to the present owner is designated as Donor [dnr]",
"Use for the person or agency that furnished financial support for the production of the work. // Graphic technician (USE: Artist) [Relator term 'Graphic technician' (coded [grt]) used before March 1988 only.]",
"Use for the person in memory or honor of whom a book, manuscript, etc. is donated. (UF: Memorial)",
"Use for the person who is invited or regularly leads a program (often broadcast) that includes other guests, performers, etc. (e.g., talk show host).",
"", "Use for the person who conceives, and perhaps also implements, a design or illustration, usually to accompany a written text. // Imprimatur (USE: Licensor)",
"Use for the person who signs a presentation statement.", "Use for a person who principally plays an instrument in a musical or dramatic presentation or entertainment.",
"", "", "// Investigator (USE: Originator) // Joint author (USE: Author)",
"Use for the person or organization whose work involves coordinating the arrangement of existing and proposed land features and structures. ",
"Use for a person or organization permitting the temporary use of a book, manuscript, etc., such as for photocopying or microfilming.",
"Use for the party who files a libel in an ecclesiastical or admiralty case.",
"Use for a libelant who takes an appeal from one ecclesiastical court or admiralty to another to reverse the judgment.",
"Use for a libelant against whom an appeal is taken from one ecclesiastical court or admiralty to another to reverse the judgment.",
"Use for the party against whom a libel has been filed in an ecclesiastical court or admiralty.",
"Use for a libelee who takes an appeal from one ecclesiastical court or admiralty to another to reverse the judgment.",
"Use for a libelee against whom an appeal is taken from one ecclesiastical court or admiralty to another to reverse the judgment.",
"Use for the writer of the text of an opera, oratorio, etc.",
"Use for the original recipient of the right to print or publish.",
"Use for the signer of the license, imprimatur, etc. (UF: Imprimatur)",
"Use for the person who prepares the stone or plate for lithographic printing, including a graphic artist creating a design directly on the surface from which printing will be done.",
"Use for the writer of the text of a song. // Memorial (USE: Honoree)",
"Use for the person or organization primarily responsible for compiling and maintaining the original description of a metadata set (e.g., geospatial metadata set).",
"", "Use for the person who leads a program (often broadcast) where topics are discussed, usually with participation of experts in fields related to the discussion.",
"Use for a person or organization that supervises compliance with the contract and is responsible for the report and controls its distribution. Sometimes referred to as the grantee, or controlling agency. // Motion picture editor (USE: Film editor)",
"Use for the person who performs music or contributes to the musical content of a work when it is not possible or desirable to identify the function more precisely.",
"Use for the speaker who relates the particulars of an act, occurrence, or course of events. // Observer (USE: Witness) // Onlooker (USE: Witness)",
"Use for the person or corporate body responsible for opposing a thesis or dissertation.",
"Use for the person or corporate body responsible for organizing a meeting for which an item is the report or proceedings.",
"Use for the author or agency performing the work, i.e., the name of a person or organization associated with the intellectual content of the work. This category does not include the publisher or personal affiliation, or sponsor except where it is also the corporate author. Includes a person designated in the work as investigator or principal investigator. (UF: Principal investigator)",
"Use for relator codes from other lists which have no equivalent in the MARC list or for terms which have not been assigned a code.",
"Use for the person or organization that currently owns an item or collection.",
"", "Use for the person or corporate body that applied for a patent.",
"Use for the person or corporate body that was granted the patent referred to by the item. (UF: Patentee) // Patentee (USE: Patent holder)",
"Use for the person responsible for commissioning a work. Usually a patron uses his or her means or influence to support the work of artists, writers, etc. This includes those who commission and pay for individual works.",
"User for a person who exhibits musical or acting skills i a musical or dramatic presentation or entertainment, if specific codes for those functions ([act], [dnc], [itr], [voc], etc.) are not used. If specific codes are used, [prf] is used for a person whose principal skill is not known or specified. // Performer of research (USE: Researcher)",
"Use for the person or organization responsible for taking photographs, whether they are used in their original form or as reproductions.",
"Use for the party who complains or sues in court in a personal action, usually in a legal proceeding.",
"Use for a plaintiff who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in a legal proceeding.",
"Use for a plaintiff against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in a legal proceeding.",
"// Plates, Printer of (USE: Printer of Plates) // Principal investigator (USE: Originator)",
"Use for the person or organization who prints texts, whether from type or plates.",
"Use for the person or organization who prints illustrations from plates. (UF: Plates, Printer of)",
"Use for a person or organization primarily responsible for performing or initiating a process, such as is done with the collection of metadata sets.",
"Use for a person who is responsible for the making of a motion picture, including business aspects, management of the productions, and the commercial success of the work. // Producer of book (USE: Book producer)",
"Use for a person who is associated with the production (props, lighting, special effects, etc.) of a musical or dramatic presentation or entertainment.",
"Use for a person or corporate body responsible for the creation and/or maintenance of computer program design documents, source code, and machine-executable digital files and supporting documentation. // Promoter (USE: Thesis advisor)",
"Use for a person who corrects printed matter. For manuscripts, use Corrector [crr].",
"", "Use for a person who presides over the elaboration of a collective work to ensure its coherence or continuity. This includes editors-in-chief, literary editors, editors of series, etc.",
"Use for the person to whom correspondence is addressed.", "Use for a person who supervises the technical aspects of a sound or video recording session.",
"Use for a person who writes or develops the framework for an item without being intellectually responsible for its content.",
"Use for the draftsman who prepares drawings of architectural designs (i.e., renderings) in accurate, representational perspective to show what the project will look like when completed.",
"Use for the person or corporate body that directed or managed a research project.",
"Use for the person or corporate body that participated in a research project but whose role did not involve direction or management of it.",
"Use for the person or corporate body responsible for performing research. (UF: Performer of research)",
"Use for the party who makes an answer to the courts pursuant to an application for redress, usually in an equity proceeding.",
"Use for a respondent who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding.",
"Use for a respondent against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding.",
"Use for a person or corporate body responsible for the review of book, motion picture, performance, etc.",
"", "Use for the author of a motion picture screenplay.", "Use for a person who brings scientific, pedagogical, or historical competence to the conception and realization on a work, particularly in the case of audio-visual items.",
"Use for an amanuensis and for a writer of manuscripts proper. For a person who makes pen-facsimiles, use Facsimilist [fac].",
"Use when the more general term Artist [art] is not desired.",
"Use for a recorder, redactor, or other person responsible for expressing the views of a corporate body.",
"Use for the person whose signature appears without a presentation or other statement indicative of provenance. When there is a presentation statement, use Inscriber [ins].",
"Use for a person who uses his or her voice with or without instrumental accompaniment to produce music. A singer's performance may or may not include actual words.",
"Use for a person who participates in a program (often broadcast) and makes a formalized contribution or presentation generally prepared in advance.",
"Use for the person or agency that issued a contract or under the auspices of which a work has been written, printed, published, etc.",
"Use for a corporate body or agency responsible for the development or enforcement of a standard.",
"// Supposed name (USE: Attributed name)", "Use for a person or organization who does measurements of tracts of land, etc. to determine location, forms, and boundaries. // Technical draftsman (USE: Draftsman) // Testifier (USE: Witness)",
"Use for the person under whose supervision a degree candidate develops and presents a thesis, memoire, or text of a dissertation. (UF: Promoter)",
"Use for a person who prepares a handwritten or typewritten copy from original material, including from dictated or orally recorded material. For makers of pen-facsimiles, use Facsimilist [fac].",
"Use for a person who renders a text from one language into another, or from an older form of a language into the modern form.",
"Use for the person who designed the type face used in a particular item. (UF: Designer of type) // Typesetter (USE: Compositor)",
"Use for the person primarily responsible for choice and arrangement of type used in an item. If the typographer is also responsible for other aspects of the graphic design of a book (e.g., Book designer [bkd]), codes for both functions may be needed.",
"Use for a person who principally exhibits singing skills in a musical or dramatic presentation or entertainment.",
"Use for a person who verifies the truthfulness of an event or action. (UF: Deponent, Eyewitness, Observer, Onlooker, Testifier)",
"User for a person who makes prints by cutting the image in relief on the end-grain of a wood block.",
"User for a person who makes prints by cutting the image in relief on the plank side of a wood block.",
"Use for a person who writes significant material which accompanies a sound recording or other audiovisual material."
), usage = c("", "", "", "", "", "", "", "", "", "", "", "Use for full authors who have made substantial contributions to the package and should show up in the package citation.",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"", "", "", "", "", "", "", "Use for package maintainers that collected code (potentially in other languages) but did not make further substantial contributions to the package.",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"Use for authors who have made smaller contributions (such as code patches etc.) but should not show up in the package citation.",
"", "Use for all copyright holders.", "", "", "", "Use for the package maintainer.",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
"", "", "", "", "", "", "", "", "If the package is part of a thesis, use for the thesis advisor.",
"", "If the R code is merely a translation from another language (typically S), use for the translator to R.",
"", "", "", "", "", "", "")), .Names = c("term", "code", "description",
"usage"), class = "data.frame", row.names = c(NA, -173L))
MARC_relator_db_codes_used_with_R <-
c("aut", "com", "ctb", "cph", "cre", "ths", "trl")
