// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_COMMERCE_COUPONS_COUPON_SERVICE_FACTORY_H_
#define CHROME_BROWSER_COMMERCE_COUPONS_COUPON_SERVICE_FACTORY_H_

#include "base/no_destructor.h"
#include "components/keyed_service/content/browser_context_keyed_service_factory.h"

class Profile;
class CouponService;

// Factory to create CouponService per profile. CouponService is not supported
// on incognito, and the factory will return nullptr for an incognito profile.
class CouponServiceFactory : public BrowserContextKeyedServiceFactory {
 public:
  // Acquire instance of CouponServiceFactory.
  static CouponServiceFactory* GetInstance();

  // Acquire CouponService - there is one per profile.
  static CouponService* GetForProfile(Profile* profile);

 private:
  friend base::NoDestructor<CouponServiceFactory>;

  CouponServiceFactory();
  ~CouponServiceFactory() override;

  KeyedService* BuildServiceInstanceFor(
      content::BrowserContext* context) const override;
};

#endif  // CHROME_BROWSER_COMMERCE_COUPONS_COUPON_SERVICE_FACTORY_H_
