// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/chromeos/extensions/login_screen/login/cleanup/clipboard_cleanup_handler.h"

#include <utility>

#include "third_party/abseil-cpp/absl/types/optional.h"
#include "ui/base/clipboard/clipboard.h"

namespace chromeos {

ClipboardCleanupHandler::ClipboardCleanupHandler() = default;

ClipboardCleanupHandler::~ClipboardCleanupHandler() = default;

void ClipboardCleanupHandler::Cleanup(CleanupHandlerCallback callback) {
  // ChromeOS only has 1 copy/paste clipboard used on all threads.
  ui::Clipboard::GetForCurrentThread()->Clear(ui::ClipboardBuffer::kCopyPaste);
  std::move(callback).Run(absl::nullopt);
}

}  // namespace chromeos
