// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ASH_WEB_APPLICATIONS_HELP_APP_HELP_APP_NOTIFICATION_CONTROLLER_H_
#define CHROME_BROWSER_ASH_WEB_APPLICATIONS_HELP_APP_HELP_APP_NOTIFICATION_CONTROLLER_H_

#include <memory>

#include "base/memory/weak_ptr.h"

class Profile;
class PrefRegistrySimple;
class PrefService;

namespace ash {

namespace help_app {
namespace prefs {

extern const char kObsoleteReleaseNotesLastShownMilestone[];
extern const char kObsoleteDiscoverTabNotificationLastShownMilestone[];

}  // namespace prefs
}  // namespace help_app

class HelpAppDiscoverTabNotification;
class ReleaseNotesNotification;

// Class to show notifications under the Help App.
class HelpAppNotificationController {
 public:
  // Registers profile prefs.
  static void RegisterProfilePrefs(PrefRegistrySimple* registry);
  static void RegisterObsoletePrefsForMigration(PrefRegistrySimple* registry);
  static void MigrateObsoleteNotificationPrefs(PrefService* pref_service);
  static void ClearObsoleteNotificationPrefs(PrefService* pref_service);

  explicit HelpAppNotificationController(Profile* profile);
  HelpAppNotificationController(const HelpAppNotificationController&) = delete;
  HelpAppNotificationController& operator=(
      const HelpAppNotificationController&) = delete;
  ~HelpAppNotificationController();

  // Determines if the Release Notes notification should be shown to the user
  // and shows it if so. This will not do anything if a Help app notification
  // has already been shown in the current milestone.
  void MaybeShowReleaseNotesNotification();

  // Returns whether the discover notification should be shown to the user.
  bool ShouldShowDiscoverNotification();

  // Determines if the discover notification should be shown to the user and
  // shows it if so. This will not do anything if a Help app notification has
  // already been shown in the current milestone.
  void MaybeShowDiscoverNotification();

 private:
  Profile* const profile_;
  std::unique_ptr<HelpAppDiscoverTabNotification> discover_tab_notification_;
  std::unique_ptr<ReleaseNotesNotification> release_notes_notification_;

  base::WeakPtrFactory<HelpAppNotificationController> weak_ptr_factory_{this};
};

}  // namespace ash

#endif  // CHROME_BROWSER_ASH_WEB_APPLICATIONS_HELP_APP_HELP_APP_NOTIFICATION_CONTROLLER_H_
