// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ASH_WEB_APPLICATIONS_CROSH_UI_H_
#define CHROME_BROWSER_ASH_WEB_APPLICATIONS_CROSH_UI_H_

#include "ui/webui/untrusted_web_ui_controller.h"
#include "ui/webui/webui_config.h"

namespace content {
class WebUI;
}  // namespace content

// Loads DataSource at startup for Crosh (the Chromium OS shell).
class CroshUIConfig : public ui::WebUIConfig {
 public:
  CroshUIConfig();
  ~CroshUIConfig() override;
  bool IsWebUIEnabled(content::BrowserContext* browser_context) override;

  std::unique_ptr<content::WebUIController> CreateWebUIController(
      content::WebUI* web_ui) override;
};

class CroshUI : public ui::UntrustedWebUIController {
 public:
  explicit CroshUI(content::WebUI* web_ui);
  CroshUI(const CroshUI&) = delete;
  CroshUI& operator=(const CroshUI&) = delete;
  ~CroshUI() override;
};

#endif  // CHROME_BROWSER_ASH_WEB_APPLICATIONS_CROSH_UI_H_
