// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ASH_SECURE_CHANNEL_FAKE_NEARBY_CONNECTION_BROKER_H_
#define CHROME_BROWSER_ASH_SECURE_CHANNEL_FAKE_NEARBY_CONNECTION_BROKER_H_

#include "chrome/browser/ash/secure_channel/nearby_connection_broker.h"

namespace ash {
namespace secure_channel {

class FakeNearbyConnectionBroker : public NearbyConnectionBroker {
 public:
  FakeNearbyConnectionBroker(
      const std::vector<uint8_t>& bluetooth_public_address,
      mojo::PendingReceiver<
          chromeos::secure_channel::mojom::NearbyMessageSender>
          message_sender_receiver,
      mojo::PendingReceiver<
          chromeos::secure_channel::mojom::NearbyFilePayloadHandler>
          file_payload_handler_receiver,
      mojo::PendingRemote<
          chromeos::secure_channel::mojom::NearbyMessageReceiver>
          message_receiver_remote,
      base::OnceClosure on_connected_callback,
      base::OnceClosure on_disconnected_callback);
  ~FakeNearbyConnectionBroker() override;

  using NearbyConnectionBroker::bluetooth_public_address;
  using NearbyConnectionBroker::InvokeDisconnectedCallback;
  using NearbyConnectionBroker::NotifyConnected;
  using NearbyConnectionBroker::NotifyMessageReceived;

  void set_should_send_message_succeed(bool should_send_message_succeed) {
    should_send_message_succeed_ = should_send_message_succeed;
  }

  const std::vector<std::string>& sent_messages() const {
    return sent_messages_;
  }

 private:
  // mojom::NearbyMessageSender:
  void SendMessage(const std::string& message,
                   SendMessageCallback callback) override;

  // mojom::NearbyFilePayloadHandler:
  void RegisterPayloadFile(
      int64_t payload_id,
      chromeos::secure_channel::mojom::PayloadFilesPtr payload_files,
      mojo::PendingRemote<chromeos::secure_channel::mojom::FilePayloadListener>
          listener,
      RegisterPayloadFileCallback callback) override {}

  std::vector<std::string> sent_messages_;
  bool should_send_message_succeed_ = true;
};

}  // namespace secure_channel
}  // namespace ash

#endif  // CHROME_BROWSER_ASH_SECURE_CHANNEL_FAKE_NEARBY_CONNECTION_BROKER_H_
