# Smart Dim Model

The Smart Dim Model is an experimental model used to predict whether an upcoming
screen-dim should go ahead or be deferred. The prediction is based on whether
the user is likely to remain inactive or reactivate following a screen-dim. If
the user is likely to reactivate, the model would predict the dim should be
deferred, otherwise, the model would predict the dim should go ahead.

## Model prediction

The input to the model is a list of features that would help predict user
activity after the screen is dimmed. Example features are user related features
(e.g. activity count) and environment features (e.g. time of day). The model
takes in these features and calculates an inactivity-score: the higher the
score, the more likely the user will remain inactive. If this inactivity-score
is higher than or equal to a dim-threshold (set by an experiment), the model
will predict the dim should go ahead; otherwise it will predict the dim should
be deferred.

The features used by the model are those metrics logged to UKM by
`UserActivityUkmLoggerImpl`. These metrics and features do not contain any user
personal data. They are aggregated when training the model.

Using these metrics, we trained a
[DNN](https://en.wikipedia.org/wiki/Deep_learning#Deep_neural_networks) model.
The inferencing code in `tf_native_inference.cc` consists of the model weights
generated by [TensorFlow](https://www.tensorflow.org/) and basic operations to
execute the model over an example.

## Example preprocessing

The `tf_native_inference.cc` generated from a TensorFlow model expects input
features to be represented as a vector of floats. This conversion is handled by
AssistRanker based on the configuration
provided in `example_preprocessor_config.pb`. The feature-to-float conversion
depends on the type of the feature. For example, a numerical feature will be
converted to a corresponding float (possibly normalized). Categorical features
(e.g. enums or bucketized numerical features) will be converted via
[One-hot encoding](https://en.wikipedia.org/wiki/One-hot). Missing features can
also be handled, with configurations specified in the
`example_preprocessor_config.pb`. The configuration can be examined with the
`print_example_preprocessor_config.py` utility:

```shell
./components/assist_ranker/print_example_preprocessor_config.py \
  out/Release \
  chrome/browser/ash/power/ml/smart_dim/example_preprocessor_config.pb
```

## Smart dim model interface

Example processing and inactivity-score calculation are all internal details of
the model. The public interface of the model is `SmartDimModel::ShouldDim()`.
`SmartDimModelImpl::ShouldDim()` provides the actual implementation. It takes
prediction features (`UserActivityEvent::Features`) as input and returns
`UserActivityEvent::ModelPrediction`. The returned prediction contains both
model response (dim, no-dim or model-error) and quantized values of
inactivity-score and dim-threshold. These two values are quantized in the
returned result so that they can be logged when necessary.
