// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ASH_LOGIN_SCREENS_MOCK_DEMO_PREFERENCES_SCREEN_H_
#define CHROME_BROWSER_ASH_LOGIN_SCREENS_MOCK_DEMO_PREFERENCES_SCREEN_H_

#include <string>

#include "chrome/browser/ash/login/screens/demo_preferences_screen.h"
#include "chrome/browser/ui/webui/chromeos/login/demo_preferences_screen_handler.h"
#include "testing/gmock/include/gmock/gmock.h"

namespace ash {

class MockDemoPreferencesScreen : public DemoPreferencesScreen {
 public:
  MockDemoPreferencesScreen(DemoPreferencesScreenView* view,
                            const ScreenExitCallback& exit_callback);

  MockDemoPreferencesScreen(const MockDemoPreferencesScreen&) = delete;
  MockDemoPreferencesScreen& operator=(const MockDemoPreferencesScreen&) =
      delete;

  ~MockDemoPreferencesScreen() override;

  MOCK_METHOD(void, ShowImpl, ());
  MOCK_METHOD(void, HideImpl, ());

  void ExitScreen(Result result);
};

class MockDemoPreferencesScreenView : public DemoPreferencesScreenView {
 public:
  MockDemoPreferencesScreenView();

  MockDemoPreferencesScreenView(const MockDemoPreferencesScreenView&) = delete;
  MockDemoPreferencesScreenView& operator=(
      const MockDemoPreferencesScreenView&) = delete;

  ~MockDemoPreferencesScreenView() override;

  MOCK_METHOD(void, Show, ());
  MOCK_METHOD(void, Hide, ());
  MOCK_METHOD(void, MockBind, (DemoPreferencesScreen * screen));
  MOCK_METHOD(void, SetInputMethodId, (const std::string& input_method));

  void Bind(DemoPreferencesScreen* screen) override;

 private:
  DemoPreferencesScreen* screen_ = nullptr;
};

}  // namespace ash

// TODO(https://crbug.com/1164001): remove after the //chrome/browser/chromeos
// source migration is finished.
namespace chromeos {
using ::ash::MockDemoPreferencesScreen;
using ::ash::MockDemoPreferencesScreenView;
}  // namespace chromeos

#endif  // CHROME_BROWSER_ASH_LOGIN_SCREENS_MOCK_DEMO_PREFERENCES_SCREEN_H_
