// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ASH_DBUS_VM_APPLICATIONS_SERVICE_PROVIDER_H_
#define CHROME_BROWSER_ASH_DBUS_VM_APPLICATIONS_SERVICE_PROVIDER_H_

#include "base/gtest_prod_util.h"
#include "base/memory/weak_ptr.h"
#include "chromeos/dbus/services/cros_dbus_service.h"
#include "dbus/exported_object.h"
#include "ui/shell_dialogs/select_file_dialog.h"

namespace dbus {
class MethodCall;
}  // namespace dbus

namespace ash {

// This class exports D-Bus methods for functions that we want to be available
// to the Crostini container.
class VmApplicationsServiceProvider
    : public CrosDBusService::ServiceProviderInterface,
      public ui::SelectFileDialog::Listener {
 public:
  VmApplicationsServiceProvider();

  VmApplicationsServiceProvider(const VmApplicationsServiceProvider&) = delete;
  VmApplicationsServiceProvider& operator=(
      const VmApplicationsServiceProvider&) = delete;

  ~VmApplicationsServiceProvider() override;

  // CrosDBusService::ServiceProviderInterface overrides:
  void Start(scoped_refptr<dbus::ExportedObject> exported_object) override;

 private:
  FRIEND_TEST_ALL_PREFIXES(VmApplicationsServiceProviderTest,
                           ParseSelectFileDialogFileTypes);

  // Called from ExportedObject when UpdateApplicationList() is exported as a
  // D-Bus method or failed to be exported.
  void OnExported(const std::string& interface_name,
                  const std::string& method_name,
                  bool success);

  // Called on UI thread in response to a D-Bus request.
  void UpdateApplicationList(
      dbus::MethodCall* method_call,
      dbus::ExportedObject::ResponseSender response_sender);
  void LaunchTerminal(dbus::MethodCall* method_call,
                      dbus::ExportedObject::ResponseSender response_sender);
  void UpdateMimeTypes(dbus::MethodCall* method_call,
                       dbus::ExportedObject::ResponseSender response_sender);
  void SelectFile(dbus::MethodCall* method_call,
                  dbus::ExportedObject::ResponseSender response_sender);

  void ParseSelectFileDialogFileTypes(
      const std::string& allowed_extensions,
      ui::SelectFileDialog::FileTypeInfo* file_types,
      int* file_type_index) const;

  // ui::SelectFileDialog::Listener implementation.
  void FileSelected(const base::FilePath& path,
                    int index,
                    void* params) override;
  void MultiFilesSelected(const std::vector<base::FilePath>& files,
                          void* params) override;
  void FileSelectionCanceled(void* params) override;

  base::WeakPtrFactory<VmApplicationsServiceProvider> weak_ptr_factory_{this};
};

}  // namespace ash

// TODO(https://crbug.com/1164001): remove when ChromeOS code migration is done.
namespace chromeos {
using ::ash::VmApplicationsServiceProvider;
}  // namespace chromeos

#endif  // CHROME_BROWSER_ASH_DBUS_VM_APPLICATIONS_SERVICE_PROVIDER_H_
