// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.browser.messages;

import org.chromium.base.annotations.NativeMethods;

/** Helper class to initialize ResourceIdMapper for MessageDispatcherBridge. */
public class MessagesResourceMapperInitializer {
    /** Calls native method to initialize ResourceIdMapper for MessageDispatcherBridge. */
    public static void init() {
        MessagesResourceMapperInitializerJni.get().init();
    }

    @NativeMethods
    interface Natives {
        void init();
    }
}
