// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_SERVICES_QUICK_PAIR_FAST_PAIR_DECRYPTION_H_
#define ASH_SERVICES_QUICK_PAIR_FAST_PAIR_DECRYPTION_H_

#include <array>
#include <string>

#include "ash/services/quick_pair/public/cpp/decrypted_passkey.h"
#include "ash/services/quick_pair/public/cpp/decrypted_response.h"
#include "third_party/abseil-cpp/absl/types/optional.h"

namespace ash {
namespace quick_pair {
namespace fast_pair_decryption {

namespace {
constexpr int kBlockByteSize = 16;
}  // namespace

absl::optional<DecryptedResponse> ParseDecryptedResponse(
    const std::array<uint8_t, 16>& aes_key_bytes,
    const std::array<uint8_t, 16>& encrypted_response_bytes);

absl::optional<DecryptedPasskey> ParseDecryptedPasskey(
    const std::array<uint8_t, 16>& aes_key_bytes,
    const std::array<uint8_t, 16>& encrypted_passkey_bytes);

}  // namespace fast_pair_decryption
}  // namespace quick_pair
}  // namespace ash

#endif  // ASH_SERVICES_QUICK_PAIR_FAST_PAIR_DECRYPTION_H_
