// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_SERVICES_IME_CONSTANTS_H_
#define ASH_SERVICES_IME_CONSTANTS_H_

#include "base/component_export.h"
#include "base/files/file_path.h"

namespace chromeos {
namespace ime {

// The path where ChromeOS default input methods is installed, consisting of
// IME manifest and some bundled language dictionaries.
COMPONENT_EXPORT(ASH_IME_CONSTANTS)
extern const base::FilePath::CharType kBundledInputMethodsDirPath[];

// The path of the active user's own input methods data, including user's
// private dictionary or downloaded language dictionaries.
COMPONENT_EXPORT(ASH_IME_CONSTANTS)
extern const base::FilePath::CharType kUserInputMethodsDirPath[];

// The name of the directory inside the profile where IME data are stored in.
COMPONENT_EXPORT(ASH_IME_CONSTANTS)
extern const base::FilePath::CharType kInputMethodsDirName[];

// The name of the directory inside the input methods directory where language
// dictionaries are downloaded to.
COMPONENT_EXPORT(ASH_IME_CONSTANTS)
extern const base::FilePath::CharType kLanguageDataDirName[];

// The domain of Google Keyboard language dictionary download URL.
COMPONENT_EXPORT(ASH_IME_CONSTANTS)
extern const char kGoogleKeyboardDownloadDomain[];
}  // namespace ime
}  // namespace chromeos

// TODO(https://crbug.com/1164001): remove when moved to ash.
namespace ash {
namespace ime {
using ::chromeos::ime::kBundledInputMethodsDirPath;
}  // namespace ime
}  // namespace ash

#endif  // ASH_SERVICES_IME_CONSTANTS_H_
