// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_CONSTANTS_DEVICETYPE_H_
#define ASH_CONSTANTS_DEVICETYPE_H_

#include <string>

#include "base/component_export.h"

namespace ash {

enum class DeviceType {
  kChromebase,
  kChromebit,
  kChromebook,
  kChromebox,
  kUnknown,  // Unknown fallback device.
};

// Returns the current device type, e.g,, Chromebook, Chromebox.
COMPONENT_EXPORT(ASH_CONSTANTS) DeviceType GetDeviceType();

// Returns the name of current device for Bluetooth. |bluetooth_address| is
// so it can be used (after hashing) to create a more identifiable device name,
// e.g., "Chromebook_1A2B", "Chromebox_F9E8'.
COMPONENT_EXPORT(ASH_CONSTANTS)
std::string GetDeviceBluetoothName(const std::string& bluetooth_address);

// Returns true if the device is Google branded.
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGoogleBrandedDevice();

}  // namespace ash

// TODO(https://crbug.com/1164001): remove after the Chrome OS source code
// directory migration is finished.
namespace chromeos {
using ::ash::DeviceType;
using ::ash::GetDeviceType;
using ::ash::IsGoogleBrandedDevice;
}  // namespace chromeos

#endif  // ASH_CONSTANTS_DEVICETYPE_H_
