// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {ComponentType} from './shimless_rma_types.js';

/**
 * @type {!Object<!ComponentType, string>}
 */
export const ComponentTypeToId = {
  [ComponentType.kAudioCodec]: 'componentAudio',
  [ComponentType.kBattery]: 'componentBattery',
  [ComponentType.kStorage]: 'componentStorage',
  [ComponentType.kVpdCached]: 'componentVpdCached',
  [ComponentType.kNetwork]: 'componentNetwork',
  [ComponentType.kCamera]: 'componentCamera',
  [ComponentType.kStylus]: 'componentStylus',
  [ComponentType.kTouchpad]: 'componentTouchpad',
  [ComponentType.kTouchsreen]: 'componentTouchscreen',
  [ComponentType.kDram]: 'componentDram',
  [ComponentType.kDisplayPanel]: 'componentDisplayPanel',
  [ComponentType.kCellular]: 'componentCellular',
  [ComponentType.kEthernet]: 'componentEthernet',
  [ComponentType.kWireless]: 'componentWireless',
  [ComponentType.kBaseAccelerometer]: 'componentBaseAccelerometer',
  [ComponentType.kLidAccelerometer]: 'componentLidAccelerometer',
  [ComponentType.kBaseGyroscope]: 'componentBaseGyroscope',
  [ComponentType.kLidGyroscope]: 'componentLidGyroscope',
  [ComponentType.kScreen]: 'componentScreen',
  [ComponentType.kKeyboard]: 'componentKeyboard',
  [ComponentType.kPowerButton]: 'componentPowerButton'
};
