// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/deva_phone.h"

#include "base/cxx17_backports.h"

namespace deva_phone {

const char* kId = "deva_phone";
bool kIs102 = false;
const char* kTransforms[] = {
    u8"0",
    u8"\u0966",
    u8"1",
    u8"\u0967",
    u8"2",
    u8"\u0968",
    u8"3",
    u8"\u0969",
    u8"4",
    u8"\u096a",
    u8"5",
    u8"\u096b",
    u8"6",
    u8"\u096c",
    u8"7",
    u8"\u096d",
    u8"8",
    u8"\u096e",
    u8"9",
    u8"\u096f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?au",
    u8"\\1\u094c",
    u8"\u094b\u001d?a",
    u8"\u0949",
    u8"\u094b\u001d?\\.c",
    u8"\u0949",
    u8"\u094b\u001d?o",
    u8"\u094a",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?O",
    u8"\\1\u094b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?o",
    u8"\\1\u094b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ai",
    u8"\\1\u0948",
    u8"\u0947\u001d?e",
    u8"\u0946",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?E",
    u8"\\1\u0947",
    u8"\u0947\u001d?\\.c",
    u8"\u0945",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?e",
    u8"\\1\u0947",
    u8"([\u0915-\u0939\u0958-\u095f])\u094d\u0933\u094d\u0933\u001d?I",
    u8"\\1\u0963",
    u8"([\u0915-\u0939\u0958-\u095f])\u094d\u0933\u001d?\\^I",
    u8"\\1\u0963",
    u8"([\u0915-\u0939\u0958-\u095f])\u094d\u0933\u094d\u0933\u001d?i",
    u8"\\1\u0962",
    u8"([\u0915-\u0939\u0958-\u095f])\u094d\u0933\u001d?\\^i",
    u8"\\1\u0962",
    u8"\u0944\u001d?I",
    u8"\u0944",
    u8"\u0943\u001d?\\^I",
    u8"\u0944",
    u8"\u0943\u001d?R",
    u8"\u0944",
    u8"\u0943\u001d?\\^i",
    u8"\u0943",
    u8"\u0944\u001d?i",
    u8"\u0943",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?R",
    u8"\\1\u0943",
    u8"\u0941\u001d?u",
    u8"\u0942",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?U",
    u8"\\1\u0942",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?u",
    u8"\\1\u0941",
    u8"\u093f\u001d?i",
    u8"\u0940",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?I",
    u8"\\1\u0940",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?i",
    u8"\\1\u093f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?A",
    u8"\\1\u093e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aa",
    u8"\\1\u093e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a",
    u8"\\1",
    u8"\\.a",
    u8"\u093d",
    u8"\\.n",
    u8"\u0902",
    u8"\\.m",
    u8"\u0902",
    u8"\\.N",
    u8"\u0901",
    u8"\\.h",
    u8"\u094d\u200c",
    u8"M",
    u8"\u0902",
    u8"H",
    u8"\u0903",
    u8"\u0906\u090a\u001d?M",
    u8"\u0950",
    u8"\u0913\u001d?M",
    u8"\u0950",
    u8"\u0905\u001d?u",
    u8"\u0914",
    u8"\u0913\u001d?\\.c",
    u8"\u0911",
    u8"\u0913\u001d?o",
    u8"\u0912",
    u8"O",
    u8"\u0913",
    u8"o",
    u8"\u0913",
    u8"\u0905\u001d?i",
    u8"\u0910",
    u8"\u090f\u001d?e",
    u8"\u090e",
    u8"E",
    u8"\u090f",
    u8"\u090f\u001d?\\.c",
    u8"\u090d",
    u8"e",
    u8"\u090f",
    u8"\u0933\u094d\u0933\u001d?I",
    u8"\u0961",
    u8"\u0933\u001d?\\^I",
    u8"\u0961",
    u8"\u0933\u094d\u0933\u001d?i",
    u8"\u090c",
    u8"\u0933\u001d?\\^i",
    u8"\u090c",
    u8"\u0960\u001d?I",
    u8"\u0960",
    u8"\u090b\u001d?\\^I",
    u8"\u0960",
    u8"\u090b\u001d?R",
    u8"\u0960",
    u8"\u0960\u001d?i",
    u8"\u090b",
    u8"\u090b\u001d?\\^i",
    u8"\u090b",
    u8"R",
    u8"\u090b",
    u8"\u0909\u001d?u",
    u8"\u090a",
    u8"U",
    u8"\u090a",
    u8"u",
    u8"\u0909",
    u8"\u0907\u001d?i",
    u8"\u0908",
    u8"I",
    u8"\u0908",
    u8"i",
    u8"\u0907",
    u8"A",
    u8"\u0906",
    u8"\u0905\u001d?a",
    u8"\u0906",
    u8"a",
    u8"\u0905",
    u8"\u0917\u001d?Y",
    u8"\u091c\u094d\u091e",
    u8"\u091c\u001d?n",
    u8"\u091c\u094d\u091e",
    u8"\u0915\u001d?S",
    u8"\u0915\u094d\u0937",
    u8"\u0915\u094d\u0938\u094d\u001d?h",
    u8"\u0915\u094d\u0937",
    u8"x",
    u8"\u0915\u094d\u0937",
    u8"h",
    u8"\u0939",
    u8"\u0937\u001d?h",
    u8"\u0937",
    u8"S",
    u8"\u0937",
    u8"z",
    u8"\u0936",
    u8"\u0938\u001d?h",
    u8"\u0936",
    u8"s",
    u8"\u0938",
    u8"v",
    u8"\u0935",
    u8"w",
    u8"\u0935",
    u8"L",
    u8"\u0933",
    u8"\\.L",
    u8"\u0934",
    u8"l",
    u8"\u0932",
    u8"r",
    u8"\u0930",
    u8"\\.r",
    u8"\u0931",
    u8"Y",
    u8"\u095f",
    u8"\\.y",
    u8"\u095f",
    u8"y",
    u8"\u092f",
    u8"~N",
    u8"\u0919",
    u8"\u0917\u001d?h",
    u8"\u0918",
    u8"G",
    u8"\u0918",
    u8"\\.g",
    u8"\u095a",
    u8"g",
    u8"\u0917",
    u8"K",
    u8"\u0916",
    u8"\\.K",
    u8"\u0959",
    u8"\u0958\u001d?h",
    u8"\u0959",
    u8"\u0915\u001d?h",
    u8"\u0916",
    u8"q",
    u8"\u0958",
    u8"\\.k",
    u8"\u0958",
    u8"k",
    u8"\u0915",
    u8"~n",
    u8"\u091e",
    u8"\u091c\u001d?h",
    u8"\u091d",
    u8"J",
    u8"\u091d",
    u8"\\.j",
    u8"\u095b",
    u8"j",
    u8"\u091c",
    u8"chh",
    u8"\u091b",
    u8"Ch",
    u8"\u091b",
    u8"ch",
    u8"\u091a",
    u8"C",
    u8"\u091b",
    u8"c",
    u8"\u091a",
    u8"N",
    u8"\u0923",
    u8"\u095c\u001d?h",
    u8"\u095d",
    u8"\\.D",
    u8"\u095c",
    u8"\u0921\u001d?h",
    u8"\u0922",
    u8"D",
    u8"\u0921",
    u8"\u091f\u001d?h",
    u8"\u0920",
    u8"T",
    u8"\u091f",
    u8"n",
    u8"\u0928",
    u8"\u0926\u001d?h",
    u8"\u0927",
    u8"d",
    u8"\u0926",
    u8"\u0924\u001d?h",
    u8"\u0925",
    u8"t",
    u8"\u0924",
    u8"m",
    u8"\u092e",
    u8"\u092c\u001d?h",
    u8"\u092d",
    u8"B",
    u8"\u092d",
    u8"b",
    u8"\u092c",
    u8"f",
    u8"\u095e",
    u8"\\.P",
    u8"\u095e",
    u8"\\.\u092a\u001d?h",
    u8"\u095e",
    u8"\u092a\u001d?h",
    u8"\u092b",
    u8"P",
    u8"\u092b",
    u8"p",
    u8"\u092a",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?x",
    u8"\\1\u094d\u0915\u094d\u0937",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?h",
    u8"\\1\u094d\u0939",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?S",
    u8"\\1\u094d\u0937",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?z",
    u8"\\1\u094d\u0936",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?s",
    u8"\\1\u094d\u0938",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?v",
    u8"\\1\u094d\u0935",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?w",
    u8"\\1\u094d\u0935",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?L",
    u8"\\1\u094d\u0933",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?\\.L",
    u8"\\1\u094d\u0934",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?l",
    u8"\\1\u094d\u0932",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?r",
    u8"\\1\u094d\u0930",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?\\.r",
    u8"\\1\u094d\u0931",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?Y",
    u8"\\1\u094d\u095f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?\\.y",
    u8"\\1\u094d\u095f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?y",
    u8"\\1\u094d\u092f",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?~N",
    u8"\\1\u094d\u0919",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?G",
    u8"\\1\u094d\u0918",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?\\.g",
    u8"\\1\u094d\u095a",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?g",
    u8"\\1\u094d\u0917",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?K",
    u8"\\1\u094d\u0916",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?\\.K",
    u8"\\1\u094d\u0959",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?q",
    u8"\\1\u094d\u0958",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?\\.k",
    u8"\\1\u094d\u0958",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?k",
    u8"\\1\u094d\u0915",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?~n",
    u8"\\1\u094d\u091e",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?J",
    u8"\\1\u094d\u091d",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?\\.j",
    u8"\\1\u094d\u095b",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?j",
    u8"\\1\u094d\u091c",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?chh",
    u8"\\1\u094d\u091b",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?Ch",
    u8"\\1\u094d\u091b",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?ch",
    u8"\\1\u094d\u091a",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?C",
    u8"\\1\u094d\u091b",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?c",
    u8"\\1\u094d\u091a",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?N",
    u8"\\1\u094d\u0923",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?\\.D",
    u8"\\1\u094d\u095c",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?D",
    u8"\\1\u094d\u0921",
    u8"([\u0915-\u0927\u0929-\u0939\u0958-\u095f])\u001d?T",
    u8"\\1\u094d\u091f",
    u8"([\u0915-\u091b\u091d-\u0939\u0958-\u095f])\u001d?n",
    u8"\\1\u094d\u0928",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?d",
    u8"\\1\u094d\u0926",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?t",
    u8"\\1\u094d\u0924",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?m",
    u8"\\1\u094d\u092e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?B",
    u8"\\1\u094d\u092d",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?b",
    u8"\\1\u094d\u092c",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?f",
    u8"\\1\u094d\u095e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?\\.P",
    u8"\\1\u094d\u095e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?P",
    u8"\\1\u094d\u092b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?p",
    u8"\\1\u094d\u092a",
    u8"n\\.g",
    u8"\u0919\u094d\u095a",
    u8"ng",
    u8"\u0919\u094d\u0917",
    u8"nG",
    u8"\u0919\u094d\u0918",
    u8"n\\.k",
    u8"\u0919\u094d\u0958",
    u8"nq",
    u8"\u0919\u094d\u0958",
    u8"nK",
    u8"\u0919\u094d\u0916",
    u8"nk",
    u8"\u0919\u094d\u0915",
    u8"n\\.j",
    u8"\u091e\u094d\u095b",
    u8"nJ",
    u8"\u091e\u094d\u091d",
    u8"nj",
    u8"\u091e\u094d\u091c",
    u8"nC",
    u8"\u091e\u094d\u091b",
    u8"nCh",
    u8"\u091e\u094d\u091b",
    u8"nchh",
    u8"\u091e\u094d\u091b",
    u8"nch",
    u8"\u091e\u094d\u091a",
    u8"nc",
    u8"\u091e\u094d\u091a",
    u8"n\\.D",
    u8"\u0923\u094d\u095c",
    u8"nD",
    u8"\u0923\u094d\u0921",
    u8"nT",
    u8"\u0923\u094d\u091f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ax",
    u8"\\1\u0915\u094d\u0937",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ah",
    u8"\\1\u0939",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aS",
    u8"\\1\u0937",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?az",
    u8"\\1\u0936",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?as",
    u8"\\1\u0938",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?av",
    u8"\\1\u0935",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aw",
    u8"\\1\u0935",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aL",
    u8"\\1\u0933",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.L",
    u8"\\1\u0934",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?al",
    u8"\\1\u0932",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ar",
    u8"\\1\u0930",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.r",
    u8"\\1\u0931",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aY",
    u8"\\1\u095f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.y",
    u8"\\1\u095f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ay",
    u8"\\1\u092f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a~N",
    u8"\\1\u0919",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aG",
    u8"\\1\u0918",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.g",
    u8"\\1\u095a",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ag",
    u8"\\1\u0917",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aK",
    u8"\\1\u0916",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.K",
    u8"\\1\u0959",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aq",
    u8"\\1\u0958",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.k",
    u8"\\1\u0958",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ak",
    u8"\\1\u0915",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a~n",
    u8"\\1\u091e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aJ",
    u8"\\1\u091d",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.j",
    u8"\\1\u095b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aj",
    u8"\\1\u091c",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?achh",
    u8"\\1\u091b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aCh",
    u8"\\1\u091b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ach",
    u8"\\1\u091a",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aC",
    u8"\\1\u091b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ac",
    u8"\\1\u091a",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aN",
    u8"\\1\u0923",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.D",
    u8"\\1\u095c",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aD",
    u8"\\1\u0921",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aT",
    u8"\\1\u091f",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?an",
    u8"\\1\u0928",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ad",
    u8"\\1\u0926",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?at",
    u8"\\1\u0924",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?am",
    u8"\\1\u092e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aB",
    u8"\\1\u092d",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ab",
    u8"\\1\u092c",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?af",
    u8"\\1\u095e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?a\\.P",
    u8"\\1\u095e",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?aP",
    u8"\\1\u092b",
    u8"([\u0915-\u0939\u0958-\u095f])\u001d?ap",
    u8"\\1\u092a",
    u8"\\.(\\s)",
    u8"\u0964\\1",
    u8"\\.\\.",
    u8"\u0964",
    u8"\\.,",
    u8"\u0965",
    u8"\\|",
    u8"\u0964",
    u8"\u0964\u001d?\\|",
    u8"\u0965",
    u8"\u0964\u001d?\\.",
    u8"\u2026"};
const unsigned int kTransformsLen = base::size(kTransforms);
const char* kHistoryPrune = "n(\\.)?|c|ch|C|nc|nC|nch|\\.|a";

}  // namespace deva_phone
