// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_BIRCH_BIRCH_CORAL_PROVIDER_H_
#define ASH_BIRCH_BIRCH_CORAL_PROVIDER_H_

#include "ash/ash_export.h"
#include "ash/birch/birch_data_provider.h"
#include "ash/public/cpp/coral_util.h"
#include "ash/public/cpp/tab_cluster/tab_cluster_ui_controller.h"
#include "base/memory/raw_ptr.h"

namespace ash {

class BirchModel;

class ASH_EXPORT BirchCoralProvider : public BirchDataProvider,
                                      public TabClusterUIController::Observer {
 public:
  explicit BirchCoralProvider(BirchModel* birch_model);
  BirchCoralProvider(const BirchCoralProvider&) = delete;
  BirchCoralProvider& operator=(const BirchCoralProvider&) = delete;
  ~BirchCoralProvider() override;

  // TabClusterUIController::Observer:
  void OnTabItemAdded(TabClusterUIItem* tab_item) override;
  void OnTabItemUpdated(TabClusterUIItem* tab_item) override;
  void OnTabItemRemoved(TabClusterUIItem* tab_item) override;

  // Called from birch model to request coral information to be displayed.
  void RequestBirchDataFetch() override;

  const coral_util::CoralRequest& request_for_test() const { return request_; }

 private:
  // Whether we should handle post-login or in-session data.
  bool HasValidPostLoginData() const;

  // Called during session restore. Sends a grouping request with session
  // restore data to the coral backend.
  void HandlePostLoginDataRequest();

  // Called during user session. Sends a grouping request with active tab
  // and app metadata to the coral backend.
  void HandleInSessionDataRequest();

  // Callback passed to the coral backend.
  void HandleCoralResponse(std::unique_ptr<coral_util::CoralResponse> response);

  const raw_ptr<BirchModel> birch_model_;

  // The request sent to the coral backend.
  coral_util::CoralRequest request_;
  // Response generated by the coral backend.
  std::unique_ptr<coral_util::CoralResponse> response_;
};

}  // namespace ash

#endif  // ASH_BIRCH_BIRCH_CORAL_PROVIDER_H_
