// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_LOGIN_UI_AUTH_PANEL_H_
#define ASH_LOGIN_UI_AUTH_PANEL_H_

#include <memory>

#include "ash/login/ui/factor_auth_view.h"
#include "chromeos/ash/components/osauth/public/auth_attempt_consumer.h"
#include "chromeos/ash/components/osauth/public/auth_factor_status_consumer.h"
#include "chromeos/ash/components/osauth/public/common_types.h"

namespace ash {

// Controller class that orchestrates the several `FactorAuthView` objects.
// Responsible for listening for changes in auth factor state, and auth attempt
// results, and propagating them to the respective `FactorAuthView` objects.
// Also responsible for the general layout of the authentication UI, hiding and
// showing UI elements for particular auth factors when their status change.
class AuthPanel : public AuthFactorStatusConsumer {
 public:
  AuthPanel();
  AuthPanel(const AuthPanel&) = delete;
  AuthPanel(AuthPanel&&) = delete;
  AuthPanel& operator=(const AuthPanel&) = delete;
  AuthPanel& operator=(AuthPanel&&) = delete;
  ~AuthPanel() override;

  // AuthFactorStatusConsumer:
  void InitializeUi(AuthFactorsSet factors,
                    AuthHubConnector* connector) override;
  void OnFactorListChanged(FactorsStatusMap factors_with_status) override;
  void OnFactorStatusesChanged(FactorsStatusMap incremental_update) override;
  void OnFactorAuthFailure(AshAuthFactor factor) override;
  void OnFactorAuthSuccess(AshAuthFactor factor) override;
  void OnEndAuthentication() override;

 private:
  base::flat_map<AshAuthFactor, std::unique_ptr<FactorAuthView>> views_;
};

}  // namespace ash

#endif  // ASH_LOGIN_UI_AUTH_PANEL_H_
