// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_CONSTANTS_ASH_FEATURES_H_
#define ASH_CONSTANTS_ASH_FEATURES_H_

#include "base/component_export.h"
#include "base/feature_list.h"
#include "base/metrics/field_trial_params.h"

namespace ash::features {

// All features in alphabetical order. The features should be documented
// alongside the definition of their values in the .cc file. If a feature is
// being rolled out via Finch, add a comment in the .cc file.

COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAdaptiveCharging);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAdaptiveChargingForTesting);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAdjustSplitViewForVK);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAllowAmbientEQ);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAllowEapDefaultCasWithoutSubjectVerification);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAllowRepeatedUpdates);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAllowScrollSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAltClickAndSixPackCustomization);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAlwaysReinstallSystemWebApps);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAmbientModeDevUseProdFeature);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAmbientModePhotoPreviewFeature);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAmbientModeThrottleAnimation);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAmbientModeManagedScreensaver);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kApnRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAppCollectionFolderRefresh);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAppLaunchAutomation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kArcAdbSideloadingFeature);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kArcFuseBoxFileSharing);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kArcInputOverlayBeta);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kArcInputOverlayAlphaV2);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kArcFileTasksUseAppService);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kArcManagedAdbSideloadingSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAssistEmojiEnhanced);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAssistMultiWord);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAssistMultiWordExpanded);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAssistantNativeIcons);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAudioPeripheralVolumeGranularity);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCrasSplitAlsaUsbInternal);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAudioSourceFetcherResampling);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAudioUrl);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutoNightLight);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutoScreenBrightness);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAutocompleteExtendedSuggestions);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutocorrectParamsTuning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutocorrectToggle);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAutocorrectByDefault);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAutozoomNudgeSessionReset);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAvatarsCloudMigration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBluetoothFixA2dpPacketSize);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBluetoothQualityReport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBluetoothWbsDogfood);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kRobustAudioDeviceSelectLogic);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisBigGl);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisDGPU);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisDiskManagement);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisForceBetaClient);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisForceDoubleScale);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisLinuxMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBorealisPermitted);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kBorealisStorageBallooning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCalendarJelly);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCameraAppTimeLapse);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCameraPrivacySwitchNotifications);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCaptivePortalErrorPage);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCaptureModeAudioMixing);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCaptureModeDemoTools);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCaptureModeTour);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCellularBypassESimInstallationConnectivityCheck);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCellularUseSecondEuicc);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCheckPasswordsAgainstCryptohomeHelper);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kClipboardHistoryLongpress);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kClipboardHistoryReorder);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kConsumerAutoUpdateToggleAllowed);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kContextualNudges);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrosPrivacyHub);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrosPrivacyHubV0);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrosPrivacyHubV2);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptauthAttestationSyncing);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDesksTemplates);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDnsOverHttpsWithIdentifiers);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDnsOverHttpsWithIdentifiersReuseOldPolicy);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniDiskResizing);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniGpuSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniResetLxdDb);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniMultiContainer);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniImeSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCrostiniQtImeSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCrostiniVirtualKeyboardSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBruschetta);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kBruschettaAlphaMigrate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptAuthV2AlwaysUseActiveEligibleHosts);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptAuthV2DeviceActivityStatus);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptAuthV2DeviceActivityStatusUseConnectivity);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kCryptAuthV2DedupDeviceLastActivityTime);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCryptAuthV2DeviceSync);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCryptAuthV2Enrollment);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kCryptohomeRecovery);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeprecateOldKeyboardShortcutsAccelerator);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDeskButton);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDeskTemplateSync);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDeviceActiveClient);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClient28DayActiveCheckIn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClient28DayActiveCheckMembership);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientDailyCheckMembership);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientChurnCohortCheckIn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientChurnCohortCheckMembership);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientChurnObservationCheckIn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceActiveClientChurnObservationCheckMembership);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDeviceForceScheduledReboot);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<int> kDeviceForceScheduledRebootMaxDelay;
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInputDeviceSettingsSplit);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDiacriticsOnPhysicalKeyboardLongpress);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDiacriticsOnPhysicalKeyboardLongpressDefaultOn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDiacriticsUseReplaceSurroundingText);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDisableCryptAuthV1DeviceSync);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDisableIdleSocketsCloseOnMemoryPressure);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDisableLacrosTtsSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDisableDnsProxy);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDisplayAlignAssist);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDockedMagnifier);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFs);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFsMirroring);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFsChromeNetworking);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFsBulkPinning);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementDriveFsBulkPinning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kDriveFsShowCSEFiles);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEapGtcWifiAuthentication);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheSWA);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheSWADebugMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheSWAMeasureLatency);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWASendStartSignaling);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWADisableStunServer);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWACheckAndroidNetworkInfo);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheSWAProcessAndroidAccessibilityTree);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kAudioSettingsPage);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableBackgroundBlur);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableExternalKeyboardsInDiagnostics);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableFilesAppCopyImage);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableGetDebugdLogsInParallel);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableHostnameSetting);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableInputInDiagnosticsApp);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDiagnosticsAppJelly);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableKeyboardBacklightToggle);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableLazyLoginWebUILoading);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableLocalSearchService);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableOAuthIpp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableOobeChromeVoxHint);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableKioskEnrollmentInOobe);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableKioskLoginScreen);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableOobeNetworkScreenSkip);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableOobeThemeSelection);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableSamlNotificationOnPasswordChangeSuccess);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableAllSystemWebApps);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnablePerDeskZOrder);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnableRFC8925);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableTouchpadsInDiagnosticsApp);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnableTouchscreensInDiagnosticsApp);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnforceAshExtensionKeeplist);
// TODO(b/271104781): Temporary flag while feature is being implemented. Remove
// this once enrollment nudging policy can be fetched through a DM server API.
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEnrollmentNudgingForTesting);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEolWarningNotifications);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEolIncentive);
enum class EolIncentiveParam { kNoOffer, kOffer, kOfferWithWarning };
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<EolIncentiveParam> kEolIncentiveParam;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEolIncentiveSettings);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoHapticFeedbackSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoLinuxDmabufV3);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoLinuxDmabufV4);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoLinuxDmabufModifiers);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoOrdinalMotion);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoConsumedByImeByFlag);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kExoSurroundingTextOffset);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kExperimentalRgbKeyboardPatterns);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFaceMLApp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFamilyLinkOnSchoolDevice);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPair);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairBleRotation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPairDebugMetadata);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairHandshakeRefactor);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairHID);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairSavedDevicesNicknames);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairPreventNotificationsForRecentlyLostDevice);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<double>
    kFastPairDeviceLostNotificationTimeoutMinutes;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPairLowPower);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEnterpriseReportingUI);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<double> kFastPairLowPowerActiveSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<double> kFastPairLowPowerInactiveSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPairSoftwareScanning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFastPairSavedDevices);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFastPairSavedDevicesStrictOptIn);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagement16Desks);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementBorealis);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementTimeOfDayScreenSaver);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementTimeOfDayWallpaper);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFederatedService);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFederatedServiceScheduleTasks);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFederatedTimezoneCodePhh);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFederatedLauncherQueryAnalyticsTask);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesAppExperimental);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesConflictDialog);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesDriveShortcuts);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesInlineSyncStatus);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFilesInlineSyncStatusProgressEvents);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesSearchV2);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFilesSinglePartitionFormat);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFilesTrashDrive);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFirmwareUpdateJelly);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFirstPartyVietnameseInput);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFloatingWorkspace);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kFloatingWorkspaceMaxTimeAvailableForRestoreAfterLogin;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFloatingWorkspaceV2);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kFloatingWorkspaceV2MaxTimeAvailableForRestoreAfterLogin;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kFloatingWorkspaceV2PeriodicJobIntervalInSeconds;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheLauncher);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kEcheLauncherListView);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheLauncherIconsInMoreAppsButton);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEcheNetworkConnectionState);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kEcheBackgroundConnectionAttemptThrottleTimeout;
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta>
    kEcheConnectionStatusResetTimeout;
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kForceEnableServerSideSpeechRecognitionForDev);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kForceReSyncDrive);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFullscreenAfterUnlockAllowed);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFullscreenAlertBubble);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kFuseBoxDebug);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGalleryAppPdfEditNotification);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<std::string> kGalleryAppPdfEditNotificationText;
// TODO(b/270948434): Remove `kGlanceables`.
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGlanceables);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGlanceablesV2);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGaiaReauthEndpoint);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGameDashboard);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGamepadVibration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGesturePropertiesDBusService);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGifRecording);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kGifRendering);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kGoogleOneOfferFilesBanner);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHandwritingGestureEditing);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHandwritingLegacyRecognition);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHomeButtonWithText);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProductivityLauncherImageSearch);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLauncherItemColorSync);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHandwritingLibraryDlc);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHelpAppAppsDiscovery);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppAutoTriggerInstallDialog);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHelpAppDiscoverTabNotificationAllChannels);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHelpAppLauncherSearch);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHibernate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHiddenNetworkMigration);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHiddenNetworkWarning);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHideArcMediaNotifications);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHideShelfControlsInTabletMode);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHindiInscriptLayout);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHoldingSpaceCameraAppIntegration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHoldingSpaceInProgressDownloadsNotificationSuppression);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kHoldingSpacePredictability);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHoldingSpaceRefresh);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHoldingSpaceSuggestions);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHoldingSpaceTour);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHomeButtonQuickAppAccess);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kHotspot);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVirtualKeyboardNewHeader);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeDownloaderUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeFstDecoderParamsUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeTrayHideVoiceButton);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeOptionsInSettings);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeRuleConfig);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeSystemEmojiPicker);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerClipboard);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerExtension);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerGIFSupport);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImeSystemEmojiPickerSearchExtension);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeStylusHandwriting);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kImeUsEnglishModelUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kImprovedLoginErrorHandling);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kInstantTethering);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInternalServerSideSpeechRecognition);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInternalServerSideSpeechRecognitionControl);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kInternalServerSideSpeechRecognitionByFinch);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kIppClientInfo);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kJapaneseFunctionRow);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kKerberosRememberPasswordByDefault);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kKioskEnableImeButton);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kAutoEnrollmentKioskInOobe);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLacrosOnly);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLacrosPrimary);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLacrosSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLacrosWaylandLogging);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLacrosProfileMigrationForceOff);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLacrosMoveProfileMigration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLacrosProfileBackwardMigration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLanguagePacksInOobe);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLauncherNudgeShortInterval);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLauncherNudgeSessionReset);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLicensePackagedOobeFlow);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLockScreenHideSensitiveNotificationsSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLockScreenInlineReply);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLockScreenNotifications);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kLockScreenMediaControls);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kLoginScreenDeviceTrustConnectorEnabled);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMacAddressRandomization);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMediaAppPdfSignature);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kEducationEnrollmentOobeFlow);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMicMuteNotifications);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kDisableMessagesCrossDeviceIntegration);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMinimumChromeVersion);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMojoDBusRelay);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMultiZoneRgbKeyboard);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMultilingualTyping);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNearbyKeepAliveFix);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kMoreVideoCaptureBuffers);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNewLockScreenReauthLayout);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNightLight);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNotificationExpansionAnimation);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNotificationExperimentalShortTimeouts);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNotificationImageDrag);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kNotificationScrollBar);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kNotificationsInContextMenu);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOnDeviceGrammarCheck);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOnDeviceSpeechRecognition);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOnlyShowNewShortcutsApp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSearchInShortcutsApp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOsFeedback);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeChoobe);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeDrivePinning);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeHidDetectionRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeGaiaInfoScreen);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeJelly);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeLazyLoading);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeSimon);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeSoftwareUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementOobeSimon);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeSkipAssistant);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeQuickStart);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeTouchpadScroll);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOobeDisplaySize);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOsFeedbackJelly);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOsSettingsAppNotificationsPage);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOsSettingsAppBadgingToggle);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kOsSettingsRevampWayfinding);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOsSettingsSearchFeedback);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOsSyncConsentRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOverviewButton);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kOverviewDeskNavigation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPasspointARCSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPasspointSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPcieBillboardNotification);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPerDeskShelf);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPerUserMetrics);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPersonalizationJelly);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPhoneHub);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPhoneHubCameraRoll);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubFeatureSetupErrorHandling);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubAppStreamingBetaBadge);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPhoneHubCallNotification);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubMonochromeNotificationIcons);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPhoneHubNudge);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPhoneHubPingOnBubbleOpen);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<base::TimeDelta> kPhoneHubPingTimeout;
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPolicyProvidedTrustAnchorsAllowedAtLockScreen);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPreferConstantFrameRate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPrinterSettingsPrinterStatus);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPrinterSettingsRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPrintManagementJelly);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kPrintManagementSetupAssistance);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPrivacyIndicators);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProductivityLauncher);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjector);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorManagedUser);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorAppDebug);
COMPONENT_EXPORT(ASH_CONSTANTS)
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorTutorialVideoView);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorCustomThumbnail);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorManagedUserIgnorePolicy);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorShowShortPseudoTranscript);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorUpdateIndexableText);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorUseOAuthForGetVideoInfo);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorLocalPlayback);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorBleedingEdgeExperience);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kProjectorWebReportCrash);
BASE_DECLARE_FEATURE(kProjectorUseApiKeyForTranslation);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorViewerUseSecondaryAccount);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorAccountSwitchNotification);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kProjectorFoldShortGapIntoPreviousTranscript);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kPromiseIcons);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQsRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQuickDim);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmartReader);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQuickAppAccessTestUI);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQuickUnlockFingerprint);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kQuickUnlockPinAutosubmit);
// TODO(crbug.com/1104164) - Remove this once most users have their preferences
// backfilled.
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kQuickUnlockPinAutosubmitBackfill);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kRgbKeyboard);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kReleaseNotesNotificationAllChannels);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kReleaseNotesSuggestionChip);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kRenderArcNotificationsByChrome);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kReverseScrollGestures);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSameAppWindowCycle);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScanningAppJelly);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScreenSaverDuration);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kScreenSaverPreview);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSeamlessRefreshRateSwitching);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSeparateNetworkIcons);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSessionManagerLongKillTimeout);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSessionManagerLivenessCheck);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSettingsAppNotificationSettings);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSettingsAppThemeChangeAnimation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShelfAutoHideSeparation);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShelfLauncherNudge);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShelfParty);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShelfStackedHotseat);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShelfPalmRejectionSwipeOffset);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShimlessRMAOsUpdate);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShimlessRMADiagnosticPage);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShimlessRMADisableDarkMode);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShortcutCustomizationJelly);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShowBluetoothDebugLogToggle);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kShowPlayInDemoMode);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementFeatureAwareDeviceDemoMode);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kShutdownConfirmationBubble);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSideAlignedToasts);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSmartDimExperimentalComponent);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmartLockSignInRemoved);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmartLockUIRevamp);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmdsSupport);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmdsSupportEuiccUpload);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSmdsDbusMigration);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSnapGroup);
COMPONENT_EXPORT(ASH_CONSTANTS)
extern const base::FeatureParam<bool> kAutomaticallyLockGroup;
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSnoopingProtection);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSpeakOnMuteEnabled);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kStylusBatteryStatus);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kStartAssistantAudioDecoderOnDemand);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSystemExtensions);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSystemExtensionsManagedDeviceHealthServices);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSystemJapanesePhysicalTyping);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSystemLiveCaption);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSystemSounds);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kSystemTrayShadow);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kSystemProxyForSystemServices);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTabClusterUI);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTelemetryExtension);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kTerminalAlternativeEmulator);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTerminalDev);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTimeOfDayScreenSaver);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTimeOfDayWallpaper);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTrafficCountersEnabled);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kTrilinearFiltering);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseAuthFactors);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseLoginShelfWidget);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseMessagesStagingUrl);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kUseSearchClickForRightClick);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kUseStorkSmdsServerAddress);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUseWallpaperStagingUrl);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kUserActivityPrediction);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcBackgroundReplace);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcPortraitRelight);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcControlsUiFakeEffects);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcSegmentationModel);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVcLightIntensity);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVideoConference);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kFeatureManagementVideoConference);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVirtualKeyboardBorderedKey);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVirtualKeyboardMultitouch);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kVirtualKeyboardRoundCorners);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kVmPerBootShaderCache);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWakeOnWifiAllowed);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWallpaperFastRefresh);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWallpaperGooglePhotosSharedAlbums);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWallpaperPerDesk);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWebUITabStripTabDragIntegration);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWelcomeTour);
COMPONENT_EXPORT(ASH_CONSTANTS)
BASE_DECLARE_FEATURE(kWifiConnectMacAddressRandomization);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWifiSyncAllowDeletes);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWifiSyncAndroid);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWifiSyncApplyDeletes);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWindowsFollowCursor);
COMPONENT_EXPORT(ASH_CONSTANTS) BASE_DECLARE_FEATURE(kWmMode);

// Keep alphabetized.

COMPONENT_EXPORT(ASH_CONSTANTS) bool AreCaptureModeDemoToolsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreContextualNudgesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreDesksTemplatesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool ArePolicyProvidedTrustAnchorsAllowedAtLockScreen();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ArePromiseIconsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreSideAlignedToastsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreSystemSoundsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAutocompleteExtendedSuggestionsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAutoEnrollmentKioskInOobeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreImprovedScreenCaptureSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool DoWindowsFollowCursor();
COMPONENT_EXPORT(ASH_CONSTANTS) bool Is16DesksEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAdaptiveChargingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAdaptiveChargingForTestingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAdjustSplitViewForVKEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAllowAmbientEQEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsEapDefaultCasWithoutSubjectVerificationAllowed();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAltClickAndSixPackCustomizationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAmbientModeDevUseProdEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAmbientModeManagedScreensaverEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAmbientModePhotoPreviewEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAmbientModeThrottleAnimationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsApnRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAppCollectionFolderRefreshEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAppNotificationsPageEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsArcFuseBoxFileSharingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsArcInputOverlayAlphaV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsArcInputOverlayBetaEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAssistantNativeIconsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAudioSettingsPageEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsAudioPeripheralVolumeGranularityEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsAutoNightLightEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBackgroundBlurEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsBluetoothQualityReportEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCalendarJellyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCaptivePortalErrorPageEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCaptureModeAudioMixingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCaptureModeTourEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsCheckPasswordsAgainstCryptohomeHelperEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsClipboardHistoryLongpressEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsClipboardHistoryReorderEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsConsumerAutoUpdateToggleAllowed();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosPrivacyHubEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosPrivacyHubV0Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosPrivacyHubV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCrosPrivacyHubV1Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsCryptauthAttestationSyncingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsCryptohomeRecoveryEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDeepLinkingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDeskButtonEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDeskTemplateSyncEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInputDeviceSettingsSplitEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsDnsOverHttpsWithIdentifiersReuseOldPolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDnsOverHttpsWithIdentifiersEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDisplayAlignmentAssistanceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDriveFsMirroringEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsDriveFsBulkPinningEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInlineSyncStatusEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInlineSyncStatusOldEventsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInlineSyncStatusProgressEventsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEapGtcWifiAuthenticationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheSWAEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheSWADebugModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheSWAMeasureLatencyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEOLIncentiveEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsExperimentalRgbKeyboardPatternsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsExternalKeyboardInDiagnosticsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFaceMLSwaEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFamilyLinkOnSchoolDeviceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairBleRotationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairDebugMetadataEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairHandshakeRefactorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairHIDEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSavedDevicesNicknamesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairLowPowerEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsFastPairPreventNotificationsForRecentlyLostDeviceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSoftwareScanningEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSavedDevicesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFastPairSavedDevicesStrictOptInEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFederatedServiceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFederatedServiceScheduleTasksEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFileManagerFuseBoxDebugEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFilesConflictDialogEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFilesSearchV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFloatingWorkspaceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFloatingWorkspaceV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool ShouldForceEnableServerSideSpeechRecognitionForDev();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsForceReSyncDriveEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheLauncherEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheLauncherListViewEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsEcheLauncherIconsInMoreAppsButtonEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEcheNetworkConnectionStateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFullscreenAfterUnlockAllowed();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsFullscreenAlertBubbleEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGaiaReauthEndpointEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGalleryAppPdfEditNotificationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGameDashboardEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGifRecordingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsGifRenderingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreGlanceablesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool AreGlanceablesV2Enabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHibernateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHideArcMediaNotificationsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHideShelfControlsInTabletModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsHoldingSpaceCameraAppIntegrationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsHoldingSpaceInProgressDownloadsNotificationSuppressionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHoldingSpacePredictabilityEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHoldingSpaceRefreshEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHoldingSpaceSuggestionsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHoldingSpaceTourEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHomeButtonQuickAppAccessEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHomeButtonWithTextEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHostnameSettingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsHotspotEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInputInDiagnosticsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsInputNoiseCancellationUiEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsInstantTetheringBackgroundAdvertisingSupported();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsInternalServerSideSpeechRecognitionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsInternalServerSideSpeechRecognitionEnabledByFinch();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsInternalServerSideSpeechRecognitionControlEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsIppClientInfoEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsJellyEnabledForDiagnosticsApp();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsJellyEnabledForFirmwareUpdate();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsJellyEnabledForOsFeedback();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsJellyEnabledForPrintManagement();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsJellyEnabledForScanningApp();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsJellyEnabledForShortcutCustomization();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsKerberosRememberPasswordByDefaultEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsKeyboardBacklightToggleEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLanguagePacksEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLauncherNudgeShortIntervalEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLauncherNudgeSessionResetEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLicensePackagedOobeFlowEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsLockScreenHideSensitiveNotificationsSupported();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLockScreenInlineReplyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsLockScreenNotificationsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsLoginScreenDeviceTrustConnectorFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMacAddressRandomizationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMicMuteNotificationsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMinimumChromeVersionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsMultiZoneRgbKeyboardEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNearbyKeepAliveFixEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEducationEnrollmentOobeFlowEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsEnrollmentNudgingForTestingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNewLockScreenReauthLayoutEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationExpansionAnimationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsNotificationExperimentalShortTimeoutsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationImageDragEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationScrollBarEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsNotificationsInContextMenuEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOAuthIppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeChoobeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeDrivePinningEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeLazyLoadingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeChromeVoxHintEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeHidDetectionRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeGaiaInfoScreenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeJellyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeSimonEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeSkipAssistantEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeSoftwareUpdateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsKioskEnrollmentInOobeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsKioskLoginScreenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsDeprecateOldKeyboardShortcutsAcceleratorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeNetworkScreenSkipEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeQuickStartEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeRemoveShutdownButtonEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeThemeSelectionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeTouchpadScrollEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOobeDisplaySizeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOsSettingsAppBadgingToggleEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOsSettingsSearchFeedbackEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOsSyncConsentRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsOverviewDeskNavigationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPasspointARCSupportEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPasspointSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPcieBillboardNotificationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPciguardUiEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPerDeskShelfEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPhoneHubCameraRollEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsPhoneHubFeatureSetupErrorHandlingEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsPhoneHubMonochromeNotificationIconsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPhoneHubNudgeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsPhoneHubPingOnBubbleOpenEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPhoneHubEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPhoneHubCallNotificationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPinAutosubmitBackfillFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPinAutosubmitFeatureEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPrivacyIndicatorsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPrinterSettingsPrinterStatusEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPrinterSettingsRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProductivityLauncherEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProductivityLauncherImageSearchEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorAllUserEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorManagedUserEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorAppDebugMode();

COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorTutorialVideoViewEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorCustomThumbnailEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorLocalPlaybackEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorManagedUserIgnorePolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorShowShortPseudoTranscript();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorUpdateIndexableTextEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorUseOAuthForGetVideoInfoEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorViewerUseSecondaryAccountEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorAccountSwitchNotificationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsProjectorWebReportCrashEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorUseApiKeyForTranslationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsProjectorFoldShortGapIntoPreviousTranscriptEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsQsRevampEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsQuickDimEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPerDeskZOrderEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsPersonalizationJellyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsRenderArcNotificationsByChromeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsReverseScrollGesturesEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsRgbKeyboardEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSameAppWindowCycleEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSamlNotificationOnPasswordChangeSuccessEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScreenSaverDurationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsScreenSaverPreviewEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSeparateNetworkIconsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSettingsAppNotificationSettingsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSettingsAppThemeChangeAnimationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShelfLauncherNudgeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShelfPalmRejectionSwipeOffsetEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShelfStackedHotseatEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShimlessRMADiagnosticPageEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSimLockPolicyEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShimlessRMAOsUpdateEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsShimlessRMADarkModeDisabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSmartReaderEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSmdsSupportEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSmdsSupportEuiccUploadEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSmdsDbusMigrationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSnoopingProtectionEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSnapGroupEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSpeakOnMuteEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsStartAssistantAudioDecoderOnDemandEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsImeTrayHideVoiceButtonEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsSystemTrayShadowEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsStylusBatteryStatusEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTimeOfDayScreenSaverEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTimeOfDayWallpaperEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTabClusterUIEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTouchpadInDiagnosticsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTouchscreenInDiagnosticsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTrafficCountersEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsTrilinearFilteringEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsUseLoginShelfWidgetEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsUseStorkSmdsServerAddressEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsUserEducationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVideoConferenceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcBackgroundReplaceEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcPortraitRelightEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsVcControlsUiFakeEffectsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWallpaperFastRefreshEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsWallpaperGooglePhotosSharedAlbumsEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWallpaperPerDeskEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWebUITabStripTabDragIntegrationEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWelcomeTourEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWifiSyncAndroidEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS) bool IsWmModeEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool ShouldArcFileTasksUseAppService();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldOnlyShowNewShortcutApp();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsSearchInShortcutsAppEnabled();
COMPONENT_EXPORT(ASH_CONSTANTS)
bool IsFeatureAwareDeviceDemoModeEnabled();
// TODO(michaelpg): Remove after M71 branch to re-enable Play Store by default.
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldShowPlayStoreInDemoMode();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldUseV1DeviceSync();
COMPONENT_EXPORT(ASH_CONSTANTS) bool ShouldUseV2DeviceSync();

// Keep alphabetized.

}  // namespace ash::features

#endif  // ASH_CONSTANTS_ASH_FEATURES_H_
