# //chrome/android/java/*.expected files

## Proguard flags

[Proguard](https://www.guardsquare.com/en/products/proguard) is used in the
build to obfuscate and minify Java code.

Proguard flags (also known as configs or rules) are used to specify which parts
of Java code should not be optimized/obfuscated/modified by Proguard.

For example, the following rule specifies that all public classes with a
`public static void main(java.lang.String[])` method should not be modifed.

```
-keepclasseswithmembers public class * {
    public static void main(java.lang.String[]);
}
```

### What are `*.proguard_flags.expected` files?

[monochrome_public_bundle.proguard_flags.expected](monochrome_public_bundle.proguard_flags.expected)
contains all proguard configs used when building MonochromePublic.aab, and is
generated by the `proguard()` build step.

### Why do we care about Proguard flag discrepancies?

Some configs are explicitly added ([ex](proguard.flags)) while others are pulled
in implicitly by GN deps (ex. `aar_prebuilt()` deps, or any target that specifies
`proguard_configs = [...]`).

Since proguard configs are global in nature, it is important that all configs go
through code review. We use these `.expected` files to ensure that they do.

## AndroidManifest.xml

Each Android application has a manifest that contains information about the app
(ex. permissions required, services exposed, etc).

### What are `*.AndroidManifest.expected` files?

They contain the pretty-printed contents of the final merged manifest used when
building their associated targets.

### What are `*.AndroidManifest.diff.expected` files?
For internal targets, we don't want to check that the generated manifest are
identical to a specified expectation file. Instead, we want to ensure that the
differences between the target's AndroidManifest and an expectation file are as
expected. In this case, we specify a `*.AndroidManifest.diff.expected` file to
store the expected differences.

The contents of the `*.AndroidManifest.diff.expected` file are lines that start
with '+'. We use ndiff diff format to diff the 2 manifests, which represents
differences by prepending '+' before new lines,  '-' before deleted lines, and
keeping all common lines. To create a `*.AndroidManifest.diff.expected`,
we filter out all lines that don't start with '+' to avoid irrelevant upstream
changes to break downstream checks.


### Why do we care about AndroidManifest discrepancies?

While most manifest changes are reviewed when the manifest template file
changes, manifest entries that are pulled in via. deps (through manifest
merging) can cause real bugs (permissions issues, security vulnerabilities).

`AndroidManfiest.xml` entries create a contract between Chrome and Android,
and so its important that all changes to this contract go through code review.

## Native Libraries and Assets
Some of our apk and aab files contain native library files (under lib/) and
assets files (under assets/).

### What are `*.native_libs_and_assets.expected` files?
`*.native_libs_and_assets.expected` files store in a text format the list of
native libraries & assets, and their related information (whether it's
compressed, how it's aligned).

### Why do we care about native libraries and assets discrepancies?
When we change build gn files, the native libraries and assets can sometimes
be changed in an unexpected way.

## Build failures caused by `*.expected` files

### What is the build error telling me?

The build error is indicating that your CL has caused a mismatch between the
expected file and the generated file and that either the issue requires
attention or the expected file needs updating.

### Fixing build failures

#### Option A: Copy the expected file generated by the trybot

1. Click on the android-binary-size trybot failure in your CL

2. Click on the stdout link of the compile step

3. Run the command suggested in the error message to copy the contents of the
   generated file to the expected file path

#### Option B: Update expected files with a local build

1. Ensure that your args.gn contain:

   ```
   # For arm32:
   is_debug = false
   enable_chrome_android_internal = false
   android_channel = "stable"

   # For arm64:
   is_debug = false
   enable_chrome_android_internal = false
   ```

2. Run:

   ```
   rm $CHROMIUM_OUTPUT_DIR/failed_expectations/*
   autoninja -C $CHROMIUM_OUTPUT_DIR validate_expectations
   ```

3. Run the command suggested in the error message to copy the contents of the
   generated file to the expected file path

4. Add the updated `.expected` file to your CL

5. Afterwards, you can revert the args.gn changes suggested above and build
   normally

### Trybot failures

The [android-binary-size] trybot fails when expectations do not match. The one
exception is that arm64 native libs and assets expectations are checked by
[android-pie-arm64-rel].

[android-binary-size]: https://ci.chromium.org/p/chromium/builders/luci.chromium.try/android-binary-size
[android-pie-arm64-rel]: https://ci.chromium.org/p/chromium/builders/luci.chromium.try/android-pie-arm64-rel

### Troubleshooting

Trybots fail but you can't reproduce locally

* If a public target is failing, double check to make sure you've set
  `enable_chrome_android_internal=false`

Can't find the file suggested by the error message

* Make sure `is_java_debug=false`

Updating the file doesn't fix the error

* Make sure you're building `monochrome_public_bundle`

Otherwise, please file a bug at [crbug.com/new](https://crbug.com/new) and/or
message clank-build@google.com.
