/* -*- mode:c -*-
 *
 * Copyright 2018 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Declare symbolic names for all the GPIOs that we care about.
 * Note: Those with interrupt handlers must be declared first. */

/* USB PD interrupt handler section */
GPIO_INT(USB_C0_PD_INT_ODL,	PIN(6, 1), GPIO_INT_FALLING | GPIO_PULL_UP,	tcpc_alert_event)
GPIO_INT(USB_C1_PD_INT_ODL,	PIN(F, 5), GPIO_INT_FALLING | GPIO_PULL_UP,	tcpc_alert_event)

/* power seq interrupt handler section */
GPIO_INT(ROP_DSW_PWROK_EC,	PIN(F, 4), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(ROP_EC_RSMRST_L,	PIN(E, 2), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(MECH_PWR_BTN_ODL,	PIN(0, 1), GPIO_INT_BOTH | GPIO_PULL_UP,	power_button_interrupt)
GPIO_INT(SLP_S0_L,		PIN(A, 4), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(SLP_SUS_L_PCH,		PIN(D, 4), GPIO_INT_BOTH,			power_signal_interrupt)
GPIO_INT(ROP_EC_ACOK,		PIN(0, 0), GPIO_INT_BOTH | GPIO_HIB_WAKE_HIGH,	extpower_interrupt)

/* misc interrupt handler section */
GPIO_INT(EC_WP_L,		PIN(A, 1), GPIO_INT_BOTH,			switch_interrupt)
GPIO_INT(LID_OPEN,		PIN(D, 2), GPIO_INT_BOTH | GPIO_HIB_WAKE_HIGH,	lid_interrupt)

/* SoC section */
GPIO(RSMRST_L,			PIN(3, 7), GPIO_OUT_LOW)			/* SOC Resume Reset */
GPIO(EC_PCH_PWR_BTN_L,		PIN(C, 1), GPIO_OUT_HIGH)			/* Power button to SOC */
GPIO(EC_PCH_RTCRST,		PIN(7, 6), GPIO_OUT_LOW)			/* RTC Reset (broken) */
GPIO(EC_PCH_WAKE_L,		PIN(7, 4), GPIO_ODR_HIGH)			/* PCH wake */
GPIO(EC_PROCHOT_ODL,		PIN(3, 4), GPIO_ODR_HIGH | GPIO_SEL_1P8V)	/* SOC PROCHOT# */
GPIO(SYS_RESET_L,		PIN(0, 2), GPIO_ODR_HIGH)			/* SOC reset */
GPIO(USB_C0_DP_HPD,		PIN(C, 5), GPIO_INPUT)				/* C0 Hotplug Detect */
GPIO(USB_C1_DP_HPD,		PIN(C, 6), GPIO_INPUT)				/* C1 Hotplug Detect */

/* power seq section */
GPIO(EC_PCH_ACPRESENT,		PIN(7, 3), GPIO_ODR_LOW)			/* ACOK to SOC */
/* note: SLP_SUS_L_PMIC is an input in the schematics */
GPIO(SLP_SUS_L_PMIC,		PIN(E, 4), GPIO_OUT_LOW)			/* SOC SLP_SUS# */
GPIO(SLP_S4_L,	    		PIN(A, 3), GPIO_INPUT)				/* SOC SLP_S4# */
GPIO(SLP_S3_L,			PIN(A, 6), GPIO_INPUT)				/* SOC SLP_S3# */
GPIO(ROP_INT_L,			PIN(D, 5), GPIO_INPUT | GPIO_PULL_UP)		/* PMIC IRQ (Unused) */

/* USB PD section */
GPIO(EN_USB_C0_5V_OUT,		PIN(6, 7), GPIO_OUT_LOW)			/* C0 5V Enable */
GPIO(EN_USB_C0_CHARGE_L,	PIN(0, 3), GPIO_OUT_LOW)			/* alt fn */
GPIO(EN_USB_C0_3A,		PIN(6, 2), GPIO_OUT_LOW)			/* 1.5/3.0 C0 current limit selection */
GPIO(EN_USB_C1_5V_OUT,		PIN(7, 0), GPIO_OUT_LOW)			/* C1 5V Enable */
GPIO(EN_USB_C1_CHARGE_L,	PIN(0, 4), GPIO_OUT_LOW)			/* alt fn */
GPIO(EN_USB_C1_3A,		PIN(8, 3), GPIO_OUT_LOW)			/* alt fn 1.5/3.0 C1 current limit selection */

GPIO(USB2_VBUSSENSE,		PIN(A, 2), GPIO_OUT_LOW)			/* USB OTG ID */
GPIO(USB2_ID,			PIN(A, 0), GPIO_OUT_LOW)			/* USB OTG VBUS Sense */

GPIO(USB_PD_RST_L,		PIN(F, 1), GPIO_OUT_LOW)			/* C0,C1 PD Reset */

/* misc section */
GPIO(CCD_MODE_ODL,		PIN(E, 3), GPIO_INPUT)				/* Case Closed Debug Mode */
GPIO(EC_BATT_PRES_L,		PIN(E, 5), GPIO_INPUT)				/* Battery Present */
GPIO(EC_ENTERING_RW,		PIN(E, 1), GPIO_OUTPUT)				/* EC Entering RW */
GPIO(EC_BL_DISABLE_L,		PIN(D, 3), GPIO_INPUT)				/* Enable Backlight */
GPIO(EC_BRD_ID1,		PIN(9, 6), GPIO_INPUT)				/* Board ID bit0 */
GPIO(EC_BRD_ID2,		PIN(9, 3), GPIO_INPUT)				/* Board ID bit1 */
GPIO(EC_BRD_ID3,		PIN(F, 0), GPIO_INPUT)				/* Board ID bit2 */
GPIO(KBD_BL_EN,			PIN(7, 5), GPIO_OUT_LOW)			/* KB backlight enable */
GPIO(EC_PLATFORM_RST,		PIN(8, 6), GPIO_OUT_LOW)			/* EC Reset to LDO_EN */

/* I2C pins - these will be reconfigured for alternate function below */

GPIO(EC_I2C1_USB_C0_SCL,	PIN(9, 0), GPIO_INPUT)				/* alt fn I2C1_SCL */
GPIO(EC_I2C1_USB_C0_SDA,	PIN(8, 7), GPIO_INPUT)				/* alt fn I2C1_SDA */
GPIO(EC_I2C2_USB_C1_SCL,	PIN(9, 2), GPIO_INPUT)				/* alt fn I2C2_SCL */
GPIO(EC_I2C2_USB_C1_SDA,	PIN(9, 1), GPIO_INPUT)				/* alt fn I2C2_SDA */
GPIO(EC_I2C5_GYRO_SCL,		PIN(3, 3), GPIO_INPUT)				/* alt fn I2C5_SCL */
GPIO(EC_I2C5_GYRO_SDA,		PIN(3, 6), GPIO_INPUT)				/* alt fn I2C5_SDA */
GPIO(EC_I2C3_SENSOR_3V3_SCL,	PIN(D, 1), GPIO_INPUT)				/* alt fn I2C3_SCL */
GPIO(EC_I2C3_SENSOR_3V3_SDA,	PIN(D, 0), GPIO_INPUT)				/* alt fn I2C3_SDA */
GPIO(EC_I2C0_POWER_SCL,		PIN(B, 5), GPIO_INPUT)				/* alt fn I2C0_SCL */
GPIO(EC_I2C0_POWER_SDA,		PIN(B, 4), GPIO_INPUT)				/* alt fn I2C0_SDA */
GPIO(EC_I2C4_BATTERY_SCL,	PIN(F, 3), GPIO_INPUT)				/* alt fn I2C4_SCL */
GPIO(EC_I2C4_BATTERY_SDA,	PIN(F, 2), GPIO_INPUT)				/* alt fn I2C4_SDA */

/* Not connected */
GPIO(NC_GPIO32,			PIN(3, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO35,			PIN(3, 5), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO40,			PIN(4, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO44,			PIN(4, 4), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO45,			PIN(4, 5), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO50,			PIN(5, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO56,			PIN(5, 6), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO57,			PIN(5, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO63,			PIN(6, 3), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO66,			PIN(6, 6), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO82,			PIN(8, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO95,			PIN(9, 5), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOB1,			PIN(B, 1), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOB2,			PIN(B, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOB3,			PIN(B, 3), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOB6,			PIN(B, 6), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOC7,			PIN(C, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOD6,			PIN(D, 6), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOD7,			PIN(D, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOE0,			PIN(E, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(ACCELGYRO3_INT_L,		PIN(4, 1), GPIO_INPUT | GPIO_PULL_UP)

/* WoV is unused */
GPIO(NC_GPIO94,			PIN(9, 4), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIO97,			PIN(9, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOA5,			PIN(A, 5), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOA7,			PIN(A, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(NC_GPIOB0,			PIN(B, 0), GPIO_INPUT | GPIO_PULL_UP)

/* Power Switch Logic (PSL) inputs */
ALTERNATE(PIN_MASK(0, 0x03), 0, MODULE_PMU, 0)		/* PSL3&GPI01, PSL2&GPI00 */
ALTERNATE(PIN_MASK(D, 0x04), 0, MODULE_PMU, 0)		/* GPIOD2 */

/* gpio alternate functions */
ALTERNATE(PIN_MASK(0, 0x18), 0, MODULE_GPIO, 0)		/* GPIO03,4 */

ALTERNATE(PIN_MASK(8, 0x08), 0, MODULE_GPIO, 0)		/* GPIO83 */

/* GPIOA3,1 are enabled by default even though they are ALT functions */

/* PWM channels */
ALTERNATE(PIN_MASK(6, 0x01), 0, MODULE_PWM, 0)		/* GPIO60 PWM7 CHARGE_LED5 */
ALTERNATE(PIN_MASK(8, 0x01), 0, MODULE_PWM, 0)		/* GPIO80 PWM3 KBD_BL_PWM */
ALTERNATE(PIN_MASK(B, 0x80), 0, MODULE_PWM, 0)		/* GPIOB7 PWM5 CHARGE_LED6 */
ALTERNATE(PIN_MASK(C, 0x1d), 0, MODULE_PWM, 0)		/* GPIOC4,3,2,0 PWM2,0,1,6 CHARGE_LED2,1,4,3 */

/* I2C alternate functions */
ALTERNATE(PIN_MASK(B, 0x30), 0, MODULE_I2C, 0)		/* I2C0_SCL0|I2C0_SDA0 */
ALTERNATE(PIN_MASK(9, 0x01), 0, MODULE_I2C, 0)		/* I2C1_SCL0 */
ALTERNATE(PIN_MASK(8, 0x80), 0, MODULE_I2C, 0)		/* I2C1_SDA0 */
ALTERNATE(PIN_MASK(9, 0x06), 0, MODULE_I2C, 0)		/* I2C2_SCL0|I2C2_SDA0 */
ALTERNATE(PIN_MASK(D, 0x03), 0, MODULE_I2C, 0)		/* I2C3_SCL0|I2C3_SDA0 */
ALTERNATE(PIN_MASK(F, 0x0c), 0, MODULE_I2C, 0)		/* I2C4_SCL1|I2C4_SDA1 */
ALTERNATE(PIN_MASK(3, 0x48), 0, MODULE_I2C, 0)		/* I2C5_SDA0|I2C5_SCL0 */

/* ADC alternate functions */
ALTERNATE(PIN_MASK(4, 0x0c), 0, MODULE_ADC, 0)		/* ADC2-3 */

/* UART alternate functions */
ALTERNATE(PIN_MASK(6, 0x30), 0, MODULE_UART, 0)		/* UART from EC to Servo */

/* keyboard */
#define GPIO_KB_INPUT		(GPIO_INPUT | GPIO_PULL_UP)
#define GPIO_KB_OUTPUT		(GPIO_ODR_HIGH)
#define GPIO_KB_OUTPUT_COL2	(GPIO_OUT_LOW)

/* keyboard alternate functions */
ALTERNATE(PIN_MASK(0, 0xe0), 0, MODULE_KEYBOARD_SCAN, GPIO_KB_OUTPUT)
ALTERNATE(PIN_MASK(1, 0x7f), 0, MODULE_KEYBOARD_SCAN, GPIO_KB_OUTPUT)
ALTERNATE(PIN_MASK(2, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_KB_OUTPUT)
ALTERNATE(PIN_MASK(2, 0xfc), 0, MODULE_KEYBOARD_SCAN, GPIO_KB_INPUT)
ALTERNATE(PIN_MASK(3, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_KB_INPUT)
GPIO(EC_KB_ROW02_INV, PIN(1, 7), GPIO_KB_OUTPUT_COL2)
