/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import java.io.PrintWriter;
import java.util.Arrays;

public class EMSA_PSS
implements Cloneable {
    private static final String NAME = "emsa-pss";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 5;
    private static final PrintWriter err;
    private IMessageDigest hash;
    private int hLen;

    private static void debug(String s) {
        err.println(">>> emsa-pss: " + s);
    }

    private EMSA_PSS(IMessageDigest hash) {
        this.hash = hash;
        this.hLen = hash.hashSize();
    }

    public static EMSA_PSS getInstance(String mdName) {
        IMessageDigest hash = HashFactory.getInstance(mdName);
        return new EMSA_PSS(hash);
    }

    public Object clone() {
        return EMSA_PSS.getInstance(this.hash.name());
    }

    public byte[] encode(byte[] mHash, int emBits, byte[] salt) {
        int sLen = salt.length;
        if (this.hLen != mHash.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (emBits < 8 * this.hLen + 8 * sLen + 9) {
            throw new IllegalArgumentException("encoding error");
        }
        int emLen = (emBits + 7) / 8;
        IMessageDigest iMessageDigest = this.hash;
        synchronized (iMessageDigest) {
            byte[] H;
            int i;
            try {
                for (i = 0; i < 8; ++i) {
                    this.hash.update((byte)0);
                }
                this.hash.update(mHash, 0, this.hLen);
                this.hash.update(salt, 0, sLen);
                H = this.hash.digest();
            }
            finally {
                Object var9_9 = null;
            }
            byte[] DB = new byte[emLen - sLen - this.hLen - 2 + 1 + sLen];
            DB[emLen - sLen - this.hLen - 2] = 1;
            System.arraycopy(salt, 0, DB, emLen - sLen - this.hLen - 1, sLen);
            byte[] dbMask = this.MGF(H, emLen - this.hLen - 1);
            for (i = 0; i < DB.length; ++i) {
                DB[i] = DB[i] ^ dbMask[i];
            }
            DB[0] = DB[0] & (byte)(255 >>> (8 * emLen - emBits & 0x1F));
            byte[] result = new byte[emLen];
            System.arraycopy(DB, 0, result, 0, emLen - this.hLen - 1);
            System.arraycopy(H, 0, result, emLen - this.hLen - 1, this.hLen);
            result[emLen - 1] = -68;
            byte[] byArray = result;
            return byArray;
        }
    }

    public boolean decode(byte[] mHash, byte[] EM, int emBits, int sLen) {
        int i;
        if (sLen < 0) {
            throw new IllegalArgumentException("sLen");
        }
        if (this.hLen != mHash.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (emBits < 8 * this.hLen + 8 * sLen + 9) {
            throw new IllegalArgumentException("decoding error");
        }
        int emLen = (emBits + 7) / 8;
        if ((EM[EM.length - 1] & 0xFF) != 188) {
            return false;
        }
        if ((EM[0] & 255 << (8 - (8 * emLen - emBits) & 0x1F)) != 0) {
            return false;
        }
        byte[] DB = new byte[emLen - this.hLen - 1];
        byte[] H = new byte[this.hLen];
        System.arraycopy(EM, 0, DB, 0, emLen - this.hLen - 1);
        System.arraycopy(EM, emLen - this.hLen - 1, H, 0, this.hLen);
        byte[] dbMask = this.MGF(H, emLen - this.hLen - 1);
        for (i = 0; i < DB.length; ++i) {
            DB[i] = DB[i] ^ dbMask[i];
        }
        DB[0] = DB[0] & (byte)(255 >>> (8 * emLen - emBits & 0x1F));
        for (i = 0; i < emLen - this.hLen - sLen - 2; ++i) {
            if (DB[i] == 0) continue;
            return false;
        }
        if (DB[i] != 1) {
            return false;
        }
        byte[] salt = new byte[sLen];
        System.arraycopy(DB, DB.length - sLen, salt, 0, sLen);
        IMessageDigest iMessageDigest = this.hash;
        synchronized (iMessageDigest) {
            byte[] H0;
            try {
                for (i = 0; i < 8; ++i) {
                    this.hash.update((byte)0);
                }
                this.hash.update(mHash, 0, this.hLen);
                this.hash.update(salt, 0, sLen);
                H0 = this.hash.digest();
            }
            finally {
                Object var13_13 = null;
            }
            boolean bl = Arrays.equals(H, H0);
            return bl;
        }
    }

    private byte[] MGF(byte[] Z, int l) {
        if (l < 1 || ((long)l & 0xFFFFFFFFL) > ((long)this.hLen & 0xFFFFFFFFL) << ((int)((long)32) & 0x3F)) {
            throw new IllegalArgumentException("mask too long");
        }
        byte[] result = new byte[l];
        int limit = (l + this.hLen - 1) / this.hLen - 1;
        IMessageDigest hashZ = null;
        hashZ = (IMessageDigest)this.hash.clone();
        hashZ.digest();
        hashZ.update(Z, 0, Z.length);
        IMessageDigest hashZC = null;
        int sofar = 0;
        for (int i = 0; i < limit; ++i) {
            hashZC = (IMessageDigest)hashZ.clone();
            hashZC.update((byte)(i >>> 24));
            hashZC.update((byte)(i >>> 16));
            hashZC.update((byte)(i >>> 8));
            hashZC.update((byte)i);
            byte[] t = hashZC.digest();
            int length = l - sofar;
            length = length > this.hLen ? this.hLen : length;
            System.arraycopy(t, 0, result, sofar, length);
            sofar += length;
        }
        return result;
    }

    static {
        NAME = NAME;
        err = new PrintWriter(System.out, true);
    }
}

