#
# Makefile for LuaTeX
#
version = 2019

.SUFFIXES:

SHELL = sh
MAKE = make
top_srcdir = .
srcdir = .

CC = cl

WD = setargv.obj

#
# Release
#
# OPTIMIZE = -Ob2 -Oi -Ot -Oy -Gs -favor:blend
OPTIMIZE = -O2

LKDEBUG=

#
# Debug
#
# OPTIMIZE=-Od -Zi
# LKDEBUG=/DEBUG /NODEFAULTLIB:LIBCMTd.lib

# -----------------------------------------------------------------------
#
#
CFLAGS = -nologo $(OPTIMIZE) -MD -I. -I.. -Isynctexdir \
-DLUA_COMPAT_MODULE=1 -DLUA_COMPAT_APIINTCASTS=1 \
-DLUA_BUILD_AS_DLL=1 $(XCFLAGS)

#
# luatex
# not used now
#EXTRA_VERSION=`date +-%Y%m%d%H`
#
XCPPFLAGS = -I$(ZLIBDIR) -I$(LIBPNGDIR) -I$(LIBLUA53DIR) -Ilualibs

CPPFLAGS =  $(XCPPFLAGS)
DEFS = -wd4819 -DHAVE_CONFIG_H=1 -DWIN32=1 \
-D_CRT_SECURE_NO_DEPRECATE=1 \
-D_CRT_NONSTDC_NO_DEPRECATE=1 -D_CRT_OBSOLETE_NO_DEPRECATE=1 \
-D_SECURE_SCL=0 -DNO_KPSE_DLL=1 -DLUATEX_HARFBUZZ_ENABLED=1 $(XDEFS)

LIBTOOL =

#
ALL_CPPFLAGS = $(DEFS) -I. -I$(srcdir) \
-I$(kpathsea_parent) -I$(kpathsea_srcdir_parent) \
$(prog_cflags) $(CPPFLAGS)

ALL_CFLAGS = $(ALL_CPPFLAGS) $(CFLAGS) -c
compile = $(CC) $(ALL_CFLAGS)

.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(compile) $<

#
# Creating hard links (use copy).
#
LN = cp

#
# kpathsea
#
kpathsea_parent = ..
kpathsea_dir = $(kpathsea_parent)/kpathsea
kpathsea_srcdir_parent = $(top_srcdir)/..
kpathsea_srcdir = $(kpathsea_srcdir_parent)/kpathsea
kpathsea = $(kpathsea_dir)/libkpathsea.lib

XLDFLAGS = -link /SUBSYSTEM:CONSOLE /STACK:0x300000
LDFLAGS =  $(XLDFLAGS)

LIBS = wsock32.lib
XLOADLIBES = user32.lib advapi32.lib shell32.lib
#
#
ZZLOADLIBES = gdi32.lib WS2_32.lib

LOADLIBES = $(proglib) $(kpathsea) $(LIBS) $(XLOADLIBES)


CCLD = $(CC)
link_command = $(CCLD) -Fe$@

kpathsea_link = $(link_command)

CXXLD = cl
cxx_link_command = $(CXXLD) -Fe$@
kpathsea_cxx_link = $(cxx_link_command)

x_cppflags = 
x_ldflags = 
x_pre_libs = 
x_extra_libs = 
x_tool_libs = 
x_ext_lib = 
wlibs =

windowlink = $(windowlib) $(x_ldflags) $(x_tool_libs) $(x_pre_libs) \
$(x_ext_lib) $(wlibs) $(x_extra_libs)

socketlibs = 

common_makeargs = $(MFLAGS) CC='$(CC)' CFLAGS='$(CFLAGS)' $(XMAKEARGS)
window_makeargs = x_cppflags='$(x_cppflags)' $(common_makeargs)
install_makeargs = INSTALL='$(INSTALL)' INSTALL_DATA='$(INSTALL_DATA)' \
  INSTALL_PROGRAM='$(INSTALL_PROGRAM)' \
  $(makevars) $(common_makeargs)  

#
# libraries
#
proglib = lib/lib.lib
windowlib = window/window.lib
#

programs = luatexdir/luahbtex.dll

default all: $(programs)

CC = cl
CXXX = cl -TP -GX

ZLIBDIR=../../libs/zlib
ZLIBCPPFLAGS=-I$(ZLIBDIR)
ZLIBSRCDIR=$(srcdir)/$(ZLIBDIR)
LIBPNGDIR=../../libs/libpng
LIBPNGSRCDIR=$(srcdir)/$(LIBPNGDIR)
LIBPNGDEP = $(LIBPNGDIR)/libpng.lib
LDLIBPNG = $(LIBPNGDIR)/libpng.lib
ZLIBDEP = $(ZLIBDIR)/libz.lib
LDZLIB = $(ZLIBDIR)/libz.lib
LIBLUA53DIR = lualibs/lua53

LIBPNGCPPFLAGS = -I$(LIBPNGDIR) -I../../libs/zlib

ALL_CXXFLAGS=$(ALL_CFLAGS)

makecpool=./web2c/makecpool.exe

#
# luatex
#
native = .
luatex = luatex
luatexdir = luatexdir

LIBLUADIR=lualibs/lua53

#
# use static liblua.lib
#
LIBLUADEP=$(LIBLUADIR)/lua53.lib

SLNUNICODEDIR=lualibs/slnunicode
SLNUNICODEDEP=$(SLNUNICODEDIR)/slnunico.obj
SLNUNICODESRC=$(SLNUNICODEDIR)/slnunico.c
# zziplib

ZZIPLIBDIR=../../libs/zziplib
ZZIPLIBSRCDIR=$(srcdir)/$(ZZIPLIBDIR)/zzip
ZZIPLIBDEP = $(ZZIPLIBDIR)/zzip/libzzip.lib

$(ZZIPLIBDEP): $(ZZIPLIBSRCDIR)
	cd $(ZZIPLIBDIR)/zzip && $(MAKE)

# luazip

LUAZIPDIR=lualibs/luazip
LUAZIPSRCDIR=$(srcdir)/$(LUAZIPDIR)
LUAZIPDEP=$(LUAZIPDIR)/src/luazip.obj
 
$(LUAZIPDEP): $(LUAZIPDIR)/src/luazip.c
	cd $(LUAZIPDIR)/src && $(MAKE)

# luafilesystem

LUAFSDIR=lualibs/luafilesystem
LUAFSSRCDIR=$(srcdir)/$(LUAFSDIR)
LUAFSDEP=$(LUAFSDIR)/src/lfs.obj
LUAFSINC=-I../../lua53 -I../../..

# luapeg
LUAPEGDIR=lualibs/luapeg
LUAPEGSRCDIR=$(srcdir)/$(LUAPEGDIR)
LUAPEGDEP=$(LUAPEGDIR)/lpeg.obj
$(LUAPEGDEP): $(LUAPEGDIR)/lpeg.c
	cd $(LUAPEGDIR) && $(CC) -MD $(OPTIMIZE) -I../lua53 -I../.. -Folpeg.obj -c lpeg.c

# luamd5
LUAMDVDIR=lualibs/luamd5
LUAMDVSRCDIR=$(srcdir)/$(LUAMDVDIR)
LUAMDVDEP=$(LUAMDVDIR)/md5lib.obj $(LUAMDVDIR)/md5.obj
$(LUAMDVDEP): $(LUAMDVDIR)/md5lib.c $(LUAMDVDIR)/luamd5.h $(LUAMDVDIR)/md5.c
	cd $(LUAMDVDIR) && $(CC) $(CFLAGS) -DWIN32=1 -I../lua53 -I../.. -Fomd5.obj -c md5.c && $(CC) $(CFLAGS) -I../lua53 -I../.. -Fomd5lib.obj -c md5lib.c

$(LUAFSDEP): $(LUAFSDIR)/src/lfs.c $(LUAFSDIR)/src/lfs.h
	cd $(LUAFSDIR)/src && $(CC) $(CFLAGS) -DWIN32=1 $(LUAFSINC) -Folfs.obj -c lfs.c


# luasocket

LUASOCKETDIR=lualibs/luasocket
LUASOCKETSRCDIR=$(srcdir)/$(LUASOCKETDIR)
LUASOCKETDEP=$(LUASOCKETDIR)/src/socket.lib

$(LUASOCKETDEP): $(LUASOCKETDIR)/src/luasocket.c $(LUASOCKETDIR)/src/luasocket.h
	cd $(LUASOCKETDIR)/src && $(MAKE)

$(SLNUNICODEDEP): $(SLNUNICODESRC)
	cd $(SLNUNICODEDIR) && $(MAKE)

# luaff
LUAFFDIR=lualibs/luafontloader
LUAFFSRCDIR=$(srcdir)/$(LUAFFDIR)
LUAFFDEP=$(LUAFFSRCDIR)/libff.lib
$(LUAFFDEP): $(LUAFFDIR)/src/luafflib.c
	cd $(LUAFFSRCDIR) && $(MAKE)

# luaprof
# (not used in the present luatex)
#LUAPROFDIR=lualibs/luaprofiler
#LUAPROFSRCDIR=$(srcdir)/$(LUAPROFDIR)
#LUAPROFDEP=$(LUAPROFDIR)/libprofiler.lib
#$(LUAPROFDEP): $(LUAPROFDIR)/*.obj
#	cd $(LUAPROFDIR) && $(MAKE))


# luazlib
LUAZLIBDIR=lualibs/luazlib
LUAZLIBSRCDIR=$(srcdir)/$(LUAZLIBDIR)
LUAZLIBDEP=$(LUAZLIBDIR)/lgzip.obj $(LUAZLIBDIR)/lzlib.obj
$(LUAZLIBDEP): $(LUAZLIBDIR)/lgzip.c $(LUAZLIBDIR)/lzlib.c
	cd $(LUAZLIBDIR) && $(MAKE)

MPLIBDIR=mplibdir

LIBMPLIBDEP=$(MPLIBDIR)/lmplib.obj $(MPLIBDIR)/libmplibcore.lib

LDLIBPP=../../libs/pplib/src/libpplib.lib

FFILIBDEP=lualibs/luaffi/ffi-w32.lib

luatexlibs = $(LIBLUADEP) $(LUASOCKETDEP) $(LUAPEGDEP) \
$(LUAMDVDEP) $(LUAFSDEP) $(SLNUNICODEDEP) $(LUAZIPDEP) \
$(luatexdir)/libluahbtex.lib $(LDLIBPNG) $(LDZLIB) $(LDLIBPP) \
$(ZZIPLIBDEP) $(LUAZLIBDEP) $(LUAFFDEP) $(LIBMPLIBDEP) $(FFILIBDEP)

luatexlibsdep = $(luatexlibs)

luatex_bin = luatexdir/luahbtex.dll

# The C sources.
luatex_c = luatexdir/luatex.c
luatexdll_o = luatexdir/luahbtexfirst.obj
luatex_o = $(luatexdll_o) 

$(luatexdll_o): $(luatex_c)
	$(compile) -DHAVE_SYS_TIMEB_H -Iluatexdir -Iw2c -Fo$@ $(luatex_c)
 
# Making luatex
MYADDLIB=shlwapi.lib
HARFBUZZLIB=../../libs/harfbuzz/harfbuzz-src/src/harfbuzz.lib
GRAPHITE2LIB=../../libs/graphite2-src/lib/graphite2.lib

$(luatex_bin): $(luatexdll_o) $(luatexlibsdep)
	cl -LD -Fe$@ $(luatexdll_o) $(luatexlibs) $(socketlibs) \
            $(luatexlibsldextra) $(MYADDLIB) $(LOADLIBES) \
            $(ZZLOADLIBES) $(HARFBUZZLIB) $(GRAPHITE2LIB) \
            $(LDFLAGS) $(LKDEBUG)

luatexdir/libluahbtex.lib: luatexdir/*.c luatexdir/lua/*.c \
luatexdir/font/*.c luatexdir/image/*.c luatexdir/*.h \
luatexdir/font/*.h luatexdir/image/*.h
	echo "luatexdir/libluahbtex.lib is old"

# C file dependencies.

#
# end of luatex
#

$(proglib): $(lib_sources)
	cd lib && $(MAKE) $(common_makeargs)

# No exceptions in this library.
$(LIBPNGDIR)/libpng.lib: $(LIBPNGSRCDIR)/*.c
	cd $(LIBPNGDIR) && $(MAKE) $(common_makeargs) libpng.lib
$(ZLIBDIR)/libz.lib: $(ZLIBSRCDIR)/*.c
	cd $(ZLIBDIR) && $(MAKE) $(common_makeargs) libz.lib
$(LIBTIFFDIR)/libtiff.lib: $(LIBTIFFSRCDIR)/*.c
	cd $(LIBTIFFDIR) && $(MAKE) $(common_makeargs) libtiff.lib

# tkpathsea.mk -- target for remaking kpathsea.
makeargs = $(MFLAGS) CC='$(CC)' CFLAGS='$(CFLAGS)' $(XMAKEARGS)

# This is wrong: the library doesn't depend on kpsewhich.c or
# acconfig.h.  But what to do?
$(kpathsea): $(kpathsea_srcdir)/*.c $(kpathsea_srcdir)/*.h \
	     $(kpathsea_srcdir)/texmf.cnf $(top_srcdir)/../make/paths.mk
	cd $(kpathsea_dir) && $(MAKE) $(makeargs)
# End of tkpathsea.mk.

# Let's stick a rule for TAGS here, just in case someone wants them.
# (We don't put them in the distributions, to keep them smaller.)
TAGS: *.c *.h
	pwd | grep kpathsea >nul && append=../kpathsea/TAGS; \
	  etags $$append *.[ch]

# Prevent GNU make 3.[59,63) from overflowing arg limit on system V.
.NOEXPORT:

INSTDESTA=c:/usr/work/edrive/wk/dist/LUATEX/bin

install: $(luatex_bin)
	cp -p $(luatex_bin) $(INSTDESTA)/

# End:
