---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, sciences, chimie, 
              formule développée, structure chimique, chimie organique
---

# Comment mettre en forme des formules chimiques ?


## Représentation de structures chimiques

### Avec l'extension <ctanpkg:chemfig>

L'extension <ctanpkg:chemfig> permet de représenter 
des **structures chimiques** et des mécanismes réactionnels à l'aide de Ti*k*Z.
Elle est maintenue et semble la plus utilisée. La question 
"[](/4_domaines_specialises/sciences/chimie/representer_des_molecules_avec_chemfig)"
en donne des illustrations. 


### Avec l'extension <ctanpkg:mcf2graph>

De son côté, l'extension <ctanpkg:mcf2graph> utilise 
le *Molecular Coding Format* pour décrire les structures chimiques de façon 
très compacte, puis les dessiner. 


## Représentation de bilans réactionnels

### Avec les extensions <ctanpkg:chemformula> et <ctanpkg:chemmacros>

Les extensions <ctanpkg:chemformula> et <ctanpkg:chemmacros>, 
de Clemens Niederberger, fonctionnent de manière très similaire et permettent 
d’écrire des **formules chimiques** ainsi que des **équations de réactions**.
L'extension <ctanpkg:chemmacros>, plus complète, présente une structure 
en modules qui perment d'ajouter de nombreuses autres possibilités et commandes
fort pratiques comme l’affichage des nombres d’oxydations, des isotopes, 
ou encore de   l’écriture des noms de molécules en respectant 
les recommandations de l’IUPAC. Ces deux extensions sont illustrées à la question
"[](/4_domaines_specialises/sciences/chimie/equation_de_reaction)".
  

### Avec l'extension <ctanpkg:chemarr>

L'extension <ctanpkg:chemarr> permet également d’écrire des équations chimiques
et met l’accent sur la personnalisation des flèches. Elle semble moins riche
que les extensions précédentes et n’a pas été mis à jour depuis 2016.


## Autres extensions

Plusieurs extensions sont listées sur la page du CTAN dédiée au 
[sujet "Chimie"](https://www.ctan.org/topic/chemistry).

:::{todo} Détailler les extensions principales
:::

<!-- - Le package <ctanpkg:ppchtex> permettait d'écrire des formules chimiques. Il -->
<!--   n'est plus distribué. -->
<!--   :::{todo} -->
<!--   Package à ajouter à la page -->
<!--   [](/1_generalites/histoire/liste_des_packages_obsoletes). -->
<!--   ::: -->
<!--  -->
<!-- - Les utilisateurs de Windows peuvent utiliser [MDL Isis Draw](wpfr:ISIS/Draw) qui est -->
<!--   gratuit pour toute utilisation personnelle ou académique. Ce logiciel permet de créer -->
<!--   ses propres structures et de les sauver au format EPS. Il est disponible à: -->
<!--   <http://www.mdli.com/cgi/dynamic/downloadsect_key_key_id_1/>. -->
<!-- - Les utilisateurs de Linux peuvent jeter un coup d'œil à -->
<!--   <http://www.randomfactory.com/lfc/lfc.html>. -->
<!-- - Il existe le package <ctanpkg:chemsym>. -->
<!-- - Le package <ctanpkg:XyMTeX> permet de définir des structures chimiques. -->
<!--     ::::{note} -->
<!--     Commentaire de F. Jacquet -->
<!--  -->
<!--     - <ctanpkg:XyMTeX> est incompatible avec le shareware French Pro de Bernard -->
<!--     Gaulle. Pour utiliser les deux dans un même document, il suffit de repasser en -->
<!--     mode `english` avant la macros puis `french` après. Je ne sais pas comment cela -->
<!--     fonctionne pour les `caption` mais en théorie, cela devrait marcher! -->
<!--         :::{todo} -->
<!--         À verifier pour `babel-french`. -->
<!--         ::: -->
<!--     - <ctanpkg:XyMTeX> possède le gros défaut de ne pas pouvoir faire de longues -->
<!--     chaînes aliphatiques si l'on ne sait pas programmer le nombre de points -->
<!--     entre deux structures. Le plus simple dans ce cas est donc l'emploi de -->
<!--     `Xfig` (ou autre); -->
<!--     - on ne peut pas imbriquer les formules, ce qui gêne considérablement son -->
<!--     utilisation; en revanche, pour les cholestérols l'ensemble est très -->
<!--     puissant! -->
<!--     :::: -->

<!-- Il existe des packages pour écrire : -->
<!-- - les équations de réaction : mhchem, chemmacros (et chemformula) notamment ; -->
<!-- - d'autres pour représenter des structures de molécules (organiques) : chemfig -->
<!--   notamment. Ces packages conviennent pour de petites structures, certainement -->
<!--   moins pour un usage intensif. -->