---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, heure, calcul de l'heure
---

# Comment insérer l'heure dans un document ?

Cette page traite de la question de l'affichage de [l'heure](wpfr:Heure). 
Si vous cherchez l'affichage de la date, 
vous pouvez consulter la question "[](/3_composition/texte/mots/inserer_la_date_dans_un_document)".

Les réponses présentées ci-après distinguent des solutions proposant :
- différentes notations de l'heure ;
- unniquement l'heure dans [le système horaire sur 12 heures](wpfr:Syst%C3%A8me_horaire_sur_12_heures).


## Dans différents formats

### Avec l'extension <ctanpkg:scrtime>

L'extension <ctanpkg:scrtime> (qui appartient à l'ensemble <ctanpkg:KOMA-Script>) 
peut également restituer l'heure. Elle dispose d'une option d'extension 
(`12h` ou `24h`, cette dernière étant la valeur par défaut) pour préciser comme l'afficher. 
La commande `\thistime` affiche l'heure ainsi souhaitée, sachant que :

- dans le cas de l'option `12h`, les mentions "am" et "pm" ne sont pas affichées ;
- cette commande peut d'ailleurs prendre un argument optionnel pour préciser 
  ce qui sépare les heures des minutes. Par défaut, ce sera ":" ;
- sa version étoilée supprime le zéro parfois en trop dans les minutes.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{scrtime}

\begin{document}
Il est \thistime[ heures ] minutes.
\end{document}
```


### Avec l'extension <ctanpkg:datetime2>

L'extension <ctanpkg:datetime2> est une réimplémentation complète de <ctanpkg:datetime>, 
par la même auteure, Nicola Talbot. Cette réécriture a permis de proposer 
un ensemble de commandes complètement développables, 
donc utilisables partout dans votre document,
mais n'a pas conservé les noms des anciennes commandes.

Si vous souhaitez seulement l'heure courante, utilisez `\DTMcurrenttime` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{datetime2}

\begin{document}
Il est \DTMcurrenttime{}.
\end{document}
```

La [documentation](texdoc:datetime2) de <ctanpkg:datetime2> explique comment passer 
de <ctanpkg:datetime> à <ctanpkg:datetime2>.

:::{warning}
L’extension <ctanpkg:datetime> est classée comme 
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). 
Ce qui suit est informatif.

Cette extension définissait trois fonctions pour les heures :

- `\xxivtime` pour le format 24 heures ;
- `\ampmtime` pour le format 12 heures ;
- `\oclock` pour un format texte mais, malgré une prise en compte de <ctanpkg:babel> 
  (à placer avant l'appel à <ctanpkg:datetime>), le résultat n'était clairement pas adapté. 
  Il devait être réservé à la langue anglaise.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{datetime}

\begin{document}
Il est \xxivtime, c'est-à-dire \ampmtime{}
ou \oclock.
\end{document}
```
:::


### Avec les commandes de base

La primitive `\time` contient le nombre de minutes écoulées depuis minuit. 
Avec un peu de programmation, il est possible d'en tirer l'heure. 
Voici un exemple de code permettant cette conversion :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \makeatletter
  \def\timenow{\@tempcnta\time
    \@tempcntb\@tempcnta
    \divide\@tempcntb60
    \ifnum10>\@tempcntb0\fi\number\@tempcntb
    \multiply\@tempcntb60
    \advance\@tempcnta-\@tempcntb
    \string:\ifnum10>\@tempcnta0\fi\number\@tempcnta}
  \makeatother

\begin{document}
Il est \timenow.
\end{document}
```


## Dans le format sur 12 heures

### Avec l'extension <ctanpkg:time>

L'extension <ctanpkg:time> propose une fonction affichant l'heure en notation anglaise.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{time}

\begin{document}
Il est \now.
\end{document}
```


### Avec l'extension <ctanpkg:daytime>

L'extension <ctanpkg:daytime> propose une solution similaire avec une possibilité 
de variante sur l'écriture de l'heure.

L'exemple ici non compilable car cette extension n'est installée par défaut. 

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{daytime}

\begin{document}
Il est \daytime, autrement dit \Daytime.
\end{document}
```


:::{sources}
[Printing the time](faquk:FAQ-time)
:::