---
myst:
  html_meta:
    keywords: LaTeX, composition, langues, document multilingue, 
              support des langues, langues étrangères
---

# Comment utiliser un nouveau langage avec "Babel" ?

L'extension <ctanpkg:babel> est capable de travailler avec un large éventail
de langues. Parfois, un utilisateur souhaite utiliser une langue 
pour laquelle son installation TeX n'est pas configurée. Il insérera 
dans son préambule de document la commande suivante :

```{noedit}
  \usepackage[catalan]{babel}
```

Cette commande va toutefois générer le message suivant :

```text
Package babel Warning: No hyphenation patterns were loaded for
(babel)                the language `Catalan'
(babel)                I will use the patterns loaded for \language=0 instead.
```

Ce qui veut dire "Aucun motif de césure n'a été chargé pour la langue catalane.
J'utiliserai plutôt les modèles chargés pour `\language=0`". De fait, 
votre système TeX ne sait pas comment couper un texte catalan et vous devez 
le lui dire pour que <ctanpkg:babel> puisse faire son travail correctement. 
Pour cela, pour les installations LaTeX, il faut modifier le fichier 
`language.dat` (qui fait partie de l'installation de <ctanpkg:babel>) 
qui contient une ligne :

```{noedit}
%catalan         cahyphen.tex
```

Si vous supprimez la marque de commentaire, cette ligne est censée indiquer 
à LaTeX de charger les modèles de césure catalane lorsque vous lui demandez 
de créer un nouveau format.

Malheureusement, dans certaines versions de <ctanpkg:babel>, la ligne n'est 
parfois pas correcte : vous devez vérifier le nom du fichier 
contenant les motifs que vous allez utiliser. Comme vous pouvez le voir 
dans notre exemple, le nom est ici censé être `cahyphen.tex` 
alors que le fichier réellement présent sur le système s'avère être
`cahyph.tex`. Heureusement, la correction est ici rapide. Si jamais 
vous devez récupérer un nouveau fichier, assurez-vous qu'il est correctement
installé (voir pour cela la question 
"[](/5_fichiers/emplacements/installer_des_fichiers_pour_latex)").

Enfin, vous devez régénérer les formats utilisés.


## Avec teTeX

Il est possible de faire toute l'opération en une seule fois, en utilisant 
la commande `texconfig` :

```bash
texconfig hyphen latex
```

Un éditeur est alors lancé sur le fichier `language.dat`. Une fois édité, 
le format que vous spécifiez (`latex` dans ce cas) est régénéré.

Sinon, pour regénérer tous les formats, indiquez :

```bash
fmtutil --all
```

Des choses plus fines peuvent être faites en sélectionnant une séquence 
de formats et, pour chacun, en exécutant (mais ce n'est pas une méthode pas
pour les *âmes sensibles*) la commande suivante dans laquelle `nom format` 
peut valoir par exemple `latex` :

```bash
fmtutil --byfmt ⟨nom format⟩
```

Un résultat similaire pourra être obtenu avec la commande suivante 
où `fichier césures` est le fichier spécifiant la césure du format 
(généralement `language.dat`) :

```bash
fmtutil --byhyphen ⟨fichier césures⟩
```


## Avec MiKTeX

Sur une distribution <ctanpkg:MiKTeX> antérieure à la v2.0, faites :

- `Démarrer` → `Programmes` → `MiKTeX` → `Maintenance` 
  → `Create all format files`

Vous pouvez aussi ouvrir une fênetre de commandes DOS et lancer :

```bash
initexmf --dump
```

Sur une distribution <ctanpkg:MiKTeX> v2.0 ou ultérieure, toute la procédure
peut être effectuée via l'interface graphique. Pour sélectionner 
la nouvelle langue, faites :

- `Démarrer` → `Programmes` → `MiKTeX 2` → `MiKTeX Options` ;
- puis sélectionner l'onglet `Languages` ;
- sélectionnez votre langue dans la liste, appuyez sur le bouton `Apply`, 
  puis sur le bouton `OK` ;
- sélectionnez ensuite l'onglet `General` et appuyez sur le bouton 
  `Update Now`.

Sinon, éditez le fichier `language.dat` (comme indiqué ci-dessus), 
puis exécutez à l'image de ce qui est fait pour un système pré-v2.0 :

```bash
initexmf --dump
```

Notez qu'il est possible que votre système TeX manque de "mémoire de modèle" 
lors de la génération du nouveau format. La plupart des implémentations de TeX
ont des tableaux de taille fixe pour stocker les détails des modèles de césure,
mais bien que la taille soit ajustable dans la plupart 
des distributions modernes, changer cette taille est en réalité un casse-tête. 
Si vous *constatez* que vous manquez de mémoire, cela peut valoir la peine 
de parcourir la liste des langues dans votre `language.dat` pour voir 
si certaines peuvent raisonnablement être supprimées.


:::{sources}
- [Using a new language with Babel](faquk:FAQ-newlang)
:::