---
myst:
  html_meta:
    keywords: LaTeX, TeX, programmation, commandes, macros, environnements, définition
---

# Commandes et environnements


Cette section détaille le sujet de la [programmation](../start.md) et de la définition des commandes et environnements. Si le sujet vous est inconnu, vous pouvez commencer par lire la question "[](/2_programmation/macros/que_sont_les_macros)".

Les définitions faites avec LaTeX sont regroupées dans une [section dédiée](/2_programmation/macros/definitions_latex/start).


## Définition de commandes avec TeX

- [](/2_programmation/macros/definir_une_macro_a_partir_d_un_argument)
- [](/2_programmation/macros/delimiteurs_speciaux)
- [](/2_programmation/macros/edef_et_protect)
- [](/2_programmation/macros/definir_un_caracteres_comme_une_macro)
- [](/2_programmation/macros/utiliser_des_commandes_plain_en_latex) 


## Problèmes généraux pour les définitions

- [](/2_programmation/macros/cette_commande_est_elle_definie)
- [](/2_programmation/macros/surcharger_une_commande)
- [](/2_programmation/macros/patcher_une_commande_existante)
- [](/2_programmation/macros/definir_une_macro_a_l_interieur_d_une_autre_macro)
- [](/2_programmation/macros/definir_une_macro_a_plus_de_9_arguments)
- [](/2_programmation/macros/macros_a_plusieurs_arguments_optionnels)
- [](/2_programmation/macros/arguments-cle-valeur)
- [](/2_programmation/macros/commande_special)
- [](/2_programmation/macros/caracteres_actifs_dans_les_arguments_d_une_macro)


## Comprendre la définition des commandes

- [](/2_programmation/macros/obtenir_la_definition_des_commandes_latex)
- [](/2_programmation/macros/makeatletter_et_makeatother) (ou :[](/2_programmation/macros/arobase_dans_les_noms_de_macros))
- [](/2_programmation/macros/abreviations_internes_de_latex)
- [](/2_programmation/macros/single_letter_commands)


## Trucs et astuces pour la rédaction de commandes

### Nom d'une commande

- [](/2_programmation/macros/bien_nommer_ses_macros_et_environnements)
- [](/2_programmation/macros/caracteres_non_alphabetiques_dans_les_noms_de_macros)


### Gestion des espaces dans les commandes

- [](/2_programmation/macros/ignorespacesafterend)
- [](/2_programmation/macros/espaces_apres_une_macro)
- [](/2_programmation/macros/espaces_produits_par_les_macros)
- [](/2_programmation/macros/caractere_pourcent_dans_les_macros) (ou : comment bien utiliser le signe `%` pour éviter d'introduire des espaces indésirables dans son document)


### Quelques commandes pratiques

- [](/2_programmation/macros/afficher_les_deux_derniers_chiffres_de_l_annee)
- [](/2_programmation/macros/comparer_une_chaine_a_jobname)
- [](/2_programmation/macros/commande_ensuremath)
- [](/2_programmation/macros/detecter_que_quelque_chose_est_vide)
- [](/2_programmation/macros/execution_a_la_fin_d_une_page)
- [](/2_programmation/macros/l_argument_est_il_un_nombre)


### Autres astuces

- [](/2_programmation/macros/afficher_le_contenu_des_variables)


:::{todo} Indiquer systématiquement les solutions avec `\NewDocumentCommand`.
:::

```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```