---
myst:
  html_meta:
    keywords: LaTeX,conversion de format,import depuis Word,export vers Word,Microsoft,RTF format,fichier docx"
---
# Comment convertir de et vers (La)TeX ?

Cette page recense les logiciels convertissant de et vers LaTeX. Elle est mise
à jour par les bénévoles de l'association GUTenberg.

Cette liste n'est pas exhaustive. Des convertisseurs anciens, toujours
disponibles sur internet malgré leurs performances limitées (par exemple, ne
prendre en charge que l'ancien format `.doc`), ne sont pas recensés.

Par ailleurs, cette liste est établie avec rigueur et neutralité : elle ne contient pas
de recommandations et n'indique pas quel logiciel préférer à tel autre.

Enfin, la page
<project:/6_distributions/conversion/logiciels_de_conversion_de_formats_de_texte.md>
contient des informations répétant ou complétant celles que vous trouverez sur
la présente page.

## Vers LaTeX, depuis...

### troff

`Tr2latex`, disponible sur le CTAN sous le nom de <ctanpkg:tr2latex>, convertit un
document `troff` en LaTeX 2.09.

Il prend en charge les macros `-ms` et `-man` ainsi que la plupart des commandes
commandes du préprocesseur `eqn` (et certaines de `tbl`). Le reste des
opérations de conversion doit hélas être effectué à la main. Deux types de
fichiers sont fournis. Le logiciel possède une page de manuel qui se convertit
très bien en LaTeX. `Tr2latex` est la version améliorée d'un logiciel antérieur,
`troff-to-latex`, qui n'est plus disponible.

### WordPerfect

`wp2latex` est un logiciel open source (GPLv2) au développement très actif, qui est disponible pour
Windows et Linux : <https://sourceforge.net/projects/wp2latex/>

### RTF

`rtf2latex2e`, de Ujwal Sathyam et Scott Prahl, est disponible sur le CTAN : <ctanpkg:rtf2latex2e>

Ce logiciel open source (sous license GPL) convertit des fichiers `.rtf` générés
par Word 2010 ou antérieur. Attention, des fichiers `.rtf` générés par des versions plus
récentes de Word contiennent des marqueurs qui interrompent la conversion !

Le développement de `rtf2latex2e` semble interrompu.

### LibreOffice/OpenOffice

`Writer2LaTeX` : <https://writer2latex.sourceforge.net/>

Le projet est actif. Il fonctionne avec OpenOffice ou LibreOffice, en tant
qu'extension de ces logiciels. Voir
<https://extensions.libreoffice.org/en/extensions/show/writer2latex>. Un
environnement Java Runtime est nécessaire pour que le logiciel fonctionne.

Witer2LaTeX est un logiciel Open source (LGPL).

### Microsoft Word (doc/docx)

- `docx2tex` : <https://github.com/transpect/docx2tex/> Projet actif. Logiciel
  open source (license BSD 2-Clause « Simplified »). Nécessite Java 1.7 à 1.15.
<!-- - `wordtolatex` : <http://www.wordtolatex.com/> (commercial). -->
<!-- - `word2latex` <https://www.word2latex.net/> (commercial). -->
- `Word-to-Latex` <https://www.grindeq.com> (logiciel commercial).
- `https://www.docx2latex.com` (service commercial, inaccessible au 5 janvier 2024).
- `word2tex` <https://www.chikrii.com/products/word2tex/> (logiciel commercial
  fonctionnant sous Windows).

<!-- Je ne comprends pas la section suivante -->
<!-- (il s'agit d'aller vers LaTeX, pas vers Word!) ; -->
<!-- je la commente. [2023-11-23 PB] -->
 <!-- .. -->
<!-- ### PDF -->
<!--  -->
<!-- `Acrobat Reader` (version 5.0 et ultérieures) ou `PDF Exchange Editor` will output rather feeble files that `Word` can read. -->

### Microsoft Excel

`Excel2Latex` convertit une feuille `Excel` en un environnement `tabular` pour
LaTeX, accompagné d'un fichier `.xla` contenant des macros `Excel`. Ne
fonctionne pas avec Libre Office.

Dépôt : <https://github.com/ivankokan/Excel2LaTeX>

Paquet CTAN : <ctanpkg:excel2latex>

LaTeX Project Public License, version 1.3. Dernière version : 3.5.0 (2017-07-15).

Cet outil existe aussi en ligne : <http://excel2latex.com/>.

### runoff

[Runoff](wp:TYPSET_and_RUNOFF) est probablement obsolète.

Le programme de conversion `rnototex`, de Peter Vanroose, est rédigé sur VMS en Pascal. Ses sources sont distribuées avec un exécutable VAX.

### refer/tib

Quelques utilitaires de conversion de données bibliographiques entre les formats
BibTeX et [refer/tib](wp:Refer_(software)) existent. Ils ne sont malheureusement
plus maintenus.

## De LaTeX vers...

### LibreOffice ou Microsoft Word

La méthode usuelle, n'utilisant que des logiciels libres, est en deux temps :

1. convertir un fichier LaTeX au format `OpenOffice`, via l'utilitaire `tex4ht`,
   en spécifiant `oolatex` comme format de sortie (voir un tutoriel
   [ici](https://github.com/michal-h21/helpers4ht/wiki/tex4ht-tutorial) ;
2. ouvrir le fichier converti avec `LibreOffice` ou `OpenOffice` ; il est
   ensuite possible de l'enregistrer sous un format MS-Word.

:::{tip}
Le programme `LibreOffice` lui-même *n'est pas* sur le CTAN ; voir <https://www.libreoffice.org/> ou <http://www.openoffice.org/>, et notons que la plupart des distributions Linux fournissent l'un ou l'autre de ces logiciels via leur propre système de gestion de paquets.
:::

### Microsoft Word (autres méthodes)

- `tex2word` : <https://hunyadi.info.hu/levente/en/tex2word>. Open source, GPL.
- `LaTeXML` : <https://math.nist.gov/~BMiller/LaTeXML/>. Open source, domaine public (compatible GPL).
- `tex2word` : <https://www.chikrii.com/products/tex2word/> (commercial).
- `LaTeX-to-Word` : <https://www.grindeq.com/> (commercial).
- Convertir LaTeX via le format PDF: les logiciels Acrobat Reader (à partir de
  sa version 5.0) ou PDF Exchange Editor peuvent exporter un fichier lisible par
  Word, mais cet export est assez médiocre.

### RTF

L'utilitaire `latex2rtf` ne convertit qu'un nombre limité d'instructions LaTeX ;
le développement de ce logiciel semble interrompu.

Dépôt : <https://latex2rtf.sourceforge.net/>.

Paquet CTAN <ctanpkg:latex2rtf>.

Open source, GPL.

### FrameMaker

`FrameMaker` offre des utilitaires aidant à la conversion translation de formats
allogènes (dont TeX, vraisemblablement) vers le format utilisé par ce
logiciel. Voir également <http://webhome.cs.uvic.ca/~nigelh/fm2latex.html>
(dernière mise à jour en 2015) et
<https://www.cs.stir.ac.uk/~kjt/software/framemaker/> (dernière mise
à jour en 2019).

## Logiciels de conversion prenant plusieurs formats en charge

### SGML

Un groupe de recherche de l'université d'État de l'Ohio (USA) travaille à créer
un format universerl de document basé sur SGML, le but étant de pouvoir
convertir quelque format que ce soit de et vers ce format universel.

:::{todo} Cette information était basée sur la page suivante :
[*Difficulties in parsing SGML*](https://dl.acm.org/doi/10.1145/62506.62520)
il se pourrait que ces informations datent un tantinet.
:::

### Pandoc

<https://pandoc.org/>

Open source, GPL.

Pandoc convertit de nombreux formats de balisage et de traitement de texte,
parmi lesquelles diverses variantes de Markdown, HTML, LaTeX et Word
docx. Pandoc peut également produire des fichiers PDF. La version améliorée de
Markdown de Pandoc comprend une syntaxe pour les tableaux, les listes de
définitions, les blocs de métadonnées, les notes de bas de page, les citations,
les mathématiques (uniquement le nouvel Office Math, mais pas l'éditeur
d'équations MathType) et bien d'autres choses encore - mais pas d'images.

:::{sources}
- [Other conversions to and from (La)TeX](faquk:FAQ-fmtconv),
- [La FAQ de Wilfried Hennings](https://web.archive.org/web/20210423190425/http://www.tug.org/utilities/texconv/index.html)
(page datant du 14 juin 2012, désormais obsolète).
:::
